/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.IFaNRptBaseFacade;
import com.kingdee.eas.fi.fa.manage.client.FaNRptBaseUI;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FaNRptTable
extends KDTable {
    private static final Logger logger = CoreUIObject.getLogger(FaNRptTable.class);
    private static final long serialVersionUID = 3326585547270045264L;
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    private FaNRptBaseUI owner;
    private IFaNRptBaseFacade iFaNRptBaseFacade;
    private FaNRptBaseUI.QueryAfterHandler handler;
    protected Map<String, Object> queryParams;
    private Map<String, Object> queryResult = null;
    private boolean firstLoadData = true;
    private boolean isAsynQuery = true;
    private boolean isReParseTable = true;
    private int rowCount = -1;

    public void init(FaNRptBaseUI owner, IFaNRptBaseFacade iFaNRptBaseFacade, FaNRptBaseUI.QueryAfterHandler handler, boolean isAsynQuery) {
        this.owner = owner;
        this.iFaNRptBaseFacade = iFaNRptBaseFacade;
        this.handler = handler;
        this.isAsynQuery = isAsynQuery;
        this.getDataRequestManager().setDataRequestMode(1);
        this.initListener();
        this.setEditable(false);
    }

    public void initListener() {
        this.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent event) {
                try {
                    FaNRptTable.this.tblMain_doRequestRowSet(event.getFirstRow());
                }
                catch (Exception e) {
                    FaNRptTable.this.setRowCount(0);
                    logger.error((Object)e);
                    FaNRptTable.this.owner.handleError(e);
                }
            }
        });
    }

    protected void tblMain_doRequestRowSet(int start) throws EASBizException, BOSException, IOException {
        if (start == 0 && this.firstLoadData) {
            this.firstLoadData = false;
            this.rowCount = 0;
            this.setRowCount(this.rowCount);
            if (this.queryParams == null) {
                return;
            }
            AsynQuery query = new AsynQuery(start);
            if (this.isAsynQuery) {
                Executors.newSingleThreadExecutor().execute(query);
            } else {
                query.run();
            }
        } else {
            List<List<String>> data = this.getData(start);
            if (data != null) {
                this.fillDataToTable(data, start);
                this.afterFillDataToTable(start, start + data.size());
            }
        }
    }

    public void fillDataToTable(List<List<String>> data, int startRowIndex) {
        List colNames = (List)this.queryResult.get("colNames");
        this.owner.fillDataToTable(colNames, data, startRowIndex);
    }

    private List<List<String>> getData(int start) throws EASBizException, BOSException, IOException {
        return this.getData(start, this.getDataRequestManager().getPageRowCount());
    }

    private synchronized List<List<String>> getData(int start, int rowCount) throws EASBizException, BOSException, IOException {
        int length = rowCount;
        int toRowCount = start + rowCount;
        for (int i = start; i < toRowCount && i < this.getRowCount() && this.getRow2(i) != null; ++i) {
            --length;
            ++start;
        }
        if (length <= 0) {
            return null;
        }
        String queryId = this.getQueryId();
        List data = this.iFaNRptBaseFacade.getData(queryId, start + 1, length);
        return data;
    }

    protected void afterFillDataToTable(int start, int length) {
    }

    public void query(Map<String, Object> queryParams) {
        this.query(queryParams, true);
    }

    public void query(Map<String, Object> queryParams, boolean isReParseTable) {
        this.closeQuery();
        this.firstLoadData = true;
        if (isReParseTable) {
            this.checkParsed();
            this.removeColumns();
        }
        this.isReParseTable = isReParseTable;
        this.queryParams = queryParams;
        this.removeRows();
    }

    public void closeQuery() {
        String queryId = this.getQueryId();
        if (queryId != null) {
            try {
                this.iFaNRptBaseFacade.release(queryId);
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.owner.handleError(e);
            }
        }
    }

    public String getQueryId() {
        if (this.queryResult != null) {
            return (String)this.queryResult.get("queryId");
        }
        return null;
    }

    private void fillData(List<List<String>> data, int start) {
        try {
            if (this.isReParseTable || this.getColumnCount() == 0) {
                this.owner.initTableColumn(this.queryResult);
            }
            this.setRowCount(this.rowCount);
            this.fillDataToTable(data, start);
            this.afterFillDataToTable(start, start + data.size());
            if (this.handler != null) {
                this.handler.handle();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.owner.handleError(e);
        }
    }

    public String getResource(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    private final class AsynQuery
    implements Runnable {
        private int start = 0;

        public AsynQuery(int start) {
            this.start = start;
        }

        @Override
        public void run() {
            List data = null;
            try {
                FaNRptTable.this.owner.info(FaNRptTable.this.getResource("beginQuery"));
                long start = System.currentTimeMillis();
                FaNRptTable.this.queryParams.put("pageSize", FaNRptTable.this.getDataRequestManager().getPageRowCount());
                FaNRptTable.this.queryResult = FaNRptTable.this.iFaNRptBaseFacade.query(FaNRptTable.this.queryParams);
                data = (List)FaNRptTable.this.queryResult.get("rows");
                FaNRptTable.this.rowCount = (Integer)FaNRptTable.this.queryResult.get("rowCount");
                FaNRptTable.this.owner.info(FaNRptTable.this.getResource("endQueryAndCost") + (System.currentTimeMillis() - start) + "ms\n");
            }
            catch (Exception e) {
                logger.error((Object)e);
                FaNRptTable.this.owner.handleError(e);
            }
            if (data == null) {
                return;
            }
            if (FaNRptTable.this.isAsynQuery) {
                final List finalData = data;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FaNRptTable.this.fillData(finalData, AsynQuery.this.start);
                        if (FaNRptTable.this.rowCount > 0) {
                            FaNRptTable.this.getSelectManager().select(0, 0);
                        }
                    }
                });
            } else {
                FaNRptTable.this.fillData(data, this.start);
                if (FaNRptTable.this.rowCount > 0) {
                    FaNRptTable.this.getSelectManager().select(0, 0);
                }
            }
        }
    }
}

