/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arf.client.PasswordUI;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseJobInfo;
import com.kingdee.eas.fi.fa.manage.IFaAccountBalance;
import com.kingdee.eas.fi.fa.manage.IFaPeriodCloseFacade;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaPeriodClosingUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaPeriodClosingUI
extends AbstractFaPeriodClosingUI {
    private static final long serialVersionUID = 8169500603688255630L;
    private static final Logger logger = Logger.getLogger(FaPeriodClosingUI.class);
    public static final String ACTIONKEY_SQL = "SQL";
    protected VoucherEditShortcutListener showSQL = new VoucherEditShortcutListener("SQL");

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"title");
    }

    protected void addHelp() {
        super.addHelp();
        this.addCSHelpforBtn((JButton)this.btnHelp);
    }

    protected void initTableStyle() {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f11 = KeyStroke.getKeyStroke(122, 3);
        imEntry.put(ctrl_shift_f11, ACTIONKEY_SQL);
    }

    public void addCSHelpforBtn(JButton btn) {
        HelpUtils.addCSHelpforBtn((JButton)btn);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.checkMonthEnd();
        PeriodInfo currentPeriod = this.getCurrPeriod();
        if (currentPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDep_CloseAccount_Is_InProcess");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        this.txtInfo.setEditable(false);
        this.txtInfo.setSelectAllOnFocus(false);
        this.btnCheck.setVisible(true);
        this.btnCheck.setEnabled(true);
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((PeriodInfo)currentPeriod);
        if (nextPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDep_NotHas_NextPeriod");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        StringBuffer sb = new StringBuffer();
        Integer currYear = new Integer(currentPeriod.getPeriodYear());
        Integer currMonth = new Integer(currentPeriod.getPeriodNumber());
        Integer nextYear = new Integer(nextPeriod.getPeriodYear());
        Integer nextMonth = new Integer(nextPeriod.getPeriodNumber());
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.currentPeriod") + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), currYear.toString(), currMonth.toString()) + "\n");
        if (nextPeriod != null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.nextPeriod") + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), nextYear.toString(), nextMonth.toString()) + "\n\n");
        }
        sb.append(this.buildSumText(currentPeriod, 2));
        this.txtInfo.setText(this.getDescription() + "\n\n" + sb);
        this.initTableStyle();
        this.enableUndo();
        this.addHelp();
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.detachListeners();
        super.loadFields();
        this.attachListeners();
    }

    protected String getDescription() {
        return this.txtInfo.getText();
    }

    protected void checkMonthEnd() throws Exception {
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        FaClientUtils.checkComp((Component)((Object)this), currCompany);
        FaClientUtils.checkFaInit((Component)((Object)this), currCompany);
    }

    protected void enableUndo() {
        boolean isEnableUndo = FaClientUtils.isEnableUndo(null);
        if (!isEnableUndo) {
            this.rbUndoClose.setVisible(isEnableUndo);
            this.rbUndoClose.setEnabled(isEnableUndo);
        }
    }

    protected PeriodInfo getCurrPeriod() throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompany);
    }

    @Override
    protected void rbClose_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbClose.isSelected()) {
            this.rbUndoClose.setSelected(false);
        } else {
            this.rbUndoClose.setSelected(true);
        }
    }

    @Override
    protected void rbUndoClose_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbUndoClose.isSelected()) {
            this.rbClose.setSelected(false);
        } else {
            this.rbClose.setSelected(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexUuid = Uuid.create();
        String tmp = this.txtInfo.getText();
        boolean hasExeception = false;
        boolean isPeriodClose = false;
        Object tempTableMap = null;
        String errorMessage = "\u5f53\u524d\u671f\u95f4\u5361\u7247\u68c0\u6d4b\u5f02\u5e38";
        IFaPeriodCloseFacade periodClose = FaPeriodCloseFacadeFactory.getRemoteInstance();
        try {
            AbstractButton button = (AbstractButton)e.getSource();
            String mutexActionName = button.getText();
            MutexParameter mutexParam = FaClientUtils.setMutexParameter(mutexUuid, mutexActionName);
            if (FaClientUtils.requestMutex(mutexParam)) {
                String strInfo = "";
                if (this.rbClose.isSelected()) {
                    ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
                    ObjectUuidPK orgPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
                    if (!PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "fa_period_close")) {
                        MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"nofaAcc"), SysContext.getSysContext().getCurrentFIUnit().getName()));
                        this.abort();
                    }
                    isPeriodClose = true;
                    this.txtInfo.setText(FaResUtil.getRes((String)"depassLedgering"));
                    PeriodInfo period = periodClose.carrayForward(SysContext.getSysContext().getCurrentFIUnit());
                    strInfo = strInfo + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forwardSuccessToPeriod"), Integer.toString(period.getPeriodYear()), Integer.toString(period.getPeriodNumber())) + "\n";
                    boolean isUseCalDepNew = FaManageUtils.getFaParamValue(null, "FA_201", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
                    if (isUseCalDepNew) {
                        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((PeriodInfo)period);
                        strInfo = strInfo + this.buildSumTextNew(prePeriod, period, 2);
                    } else {
                        strInfo = strInfo + this.buildSumText(period, 1);
                    }
                } else {
                    this.txtInfo.setText(FaResUtil.getRes((String)"passLedgering"));
                    PeriodInfo period = periodClose.carrayBack(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
                    strInfo = strInfo + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"backSuccess") + "\n";
                    strInfo = strInfo + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"currentPeriod") + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), Integer.toString(period.getPeriodYear()), Integer.toString(period.getPeriodNumber()));
                }
                this.txtInfo.setText(strInfo);
                return;
            }
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"Fa_Mutex_Is_InProcess"));
            this.abort();
            return;
        }
        catch (BOSException be) {
            String tempString = "openParamCheck001";
            StringBuilder messageString = new StringBuilder();
            messageString.append(be.getMessage());
            if (messageString.indexOf(tempString) != -1) {
                messageString.delete(0, tempString.length());
                MsgBox.showDetailAndOK((Component)((Object)this), (String)errorMessage, (String)messageString.toString(), (int)1);
                return;
            }
            hasExeception = true;
            logger.error((Object)be);
            throw be;
        }
        catch (Exception exception) {
            hasExeception = true;
            logger.error((Object)exception);
            String aaa = "";
            throw exception;
        }
        finally {
            FaClientUtils.releaseMutex(mutexUuid);
            if (hasExeception && !tmp.equalsIgnoreCase(this.txtInfo.getText())) {
                this.txtInfo.setText(tmp);
            }
            boolean isLastestPeriod = false;
            PeriodInfo lastestPeriod = null;
            CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
            PeriodInfo[] periods = periodClose.getLastestPeriod(curCompany.getId().toString());
            lastestPeriod = periods[0];
            PeriodInfo period = periods[1];
            if (lastestPeriod.getId().toString().equals(period.getId().toString())) {
                isLastestPeriod = true;
            }
            PeriodInfo curPeriodInfo = this.getCurrPeriod();
            IFaAccountBalance iFaAccBal = FaAccountBalanceFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)curCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)curPeriodInfo.getId().toString()));
            boolean isExists = iFaAccBal.exists(filter);
            if (isPeriodClose && !hasExeception && isLastestPeriod && !isExists) {
                Uuid mutexUuidNew = Uuid.create();
                String mutexActionName = "afterPeriodCloseAction";
                try {
                    MutexParameter mutexParam = FaClientUtils.setMutexParameter(mutexUuidNew, mutexActionName);
                    if (!FaClientUtils.requestMutex(mutexParam)) throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"250_FaPeriodClosingUI"));
                    PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((PeriodInfo)curPeriodInfo);
                    FilterInfo pFilter = new FilterInfo();
                    pFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompany.getId().toString()));
                    pFilter.getFilterItems().add(new FilterItemInfo("faPeriod.id", (Object)prePeriod.getId().toString()));
                    pFilter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0)));
                    pFilter.getFilterItems().add(new FilterItemInfo("srcFunction", (Object)new Integer(1)));
                    FaPeriodCloseJobInfo jobInfo = FaManageUtils.getPeriodCloseJob(null, pFilter);
                    if (jobInfo != null) {
                        HashMap<String, Object> sendMap = new HashMap<String, Object>();
                        sendMap.put("company", curCompany);
                        sendMap.put("T_FA_FAACCOUNTBALANCE", jobInfo.getFaAccountBalance());
                        periodClose.backAfterPeriodClose(sendMap);
                    }
                }
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
                finally {
                    FaClientUtils.releaseMutex(mutexUuidNew);
                }
            }
        }
    }

    protected String buildSumText(PeriodInfo period, int sumType) throws Exception {
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        int scale = FaClientUtils.getCurrencyScale(currCompany.getBaseCurrency().getId());
        StringBuffer sb = new StringBuffer();
        HashMap sumValue = FaPeriodCloseFacadeFactory.getRemoteInstance().getFASum(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), period.getId().toString(), sumType);
        String periodBegin = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.periodBegin");
        String periodEnd = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.periodEnd");
        sb.append((sumType == 1 ? MessageFormat.format(periodBegin, period.getPeriodYear() + "", period.getPeriodNumber() + "") : MessageFormat.format(periodEnd, period.getPeriodYear() + "", period.getPeriodNumber() + "")) + "\n");
        sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.assetValueSum"), FaClientUtils.formatDecimal((BigDecimal)sumValue.get("real"), scale)) + "\n");
        sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.deprValueSum"), FaClientUtils.formatDecimal((BigDecimal)sumValue.get("depr"), scale)) + "\n");
        return sb.toString();
    }

    protected String buildSumTextNew(PeriodInfo prePeriod, PeriodInfo period, int sumType) throws Exception {
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        int scale = FaClientUtils.getCurrencyScale(currCompany.getBaseCurrency().getId());
        StringBuffer sb = new StringBuffer();
        HashMap sumValue = FaPeriodCloseFacadeFactory.getRemoteInstance().getFASum(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), prePeriod.getId().toString(), sumType);
        String periodBegin = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.periodBegin");
        sb.append(MessageFormat.format(periodBegin, Integer.toString(period.getPeriodYear()), period.getPeriodNumber()) + "\n");
        sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.assetValueSum"), FaClientUtils.formatDecimal((BigDecimal)sumValue.get("real"), scale)) + "\n");
        sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.deprValueSum"), FaClientUtils.formatDecimal((BigDecimal)sumValue.get("depr"), scale)) + "\n");
        return sb.toString();
    }

    protected JButton getDefaultButton() {
        return this.btnStart;
    }

    protected void attachListeners() {
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put(ACTIONKEY_SQL, this.showSQL);
    }

    protected void detachListeners() {
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put(ACTIONKEY_SQL, null);
    }

    public void showSQL() {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fm.common.client.FMIsqlUI", this.getUIContext(), null, OprtState.VIEW);
            this.destroyWindow();
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
    }

    public void showCheck() {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.arf.client.PasswordUI", this.getUIContext(), null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
        int value = ((PasswordUI)uiWindow.getUIObject()).getReturnValue();
        if (value == 0) {
            return;
        }
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.fa.basedata.client.FaCardForDeprWrongDataUI", this.getUIContext(), null, OprtState.VIEW);
            this.destroyWindow();
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void actionCheckPeriodClose_actionPerformed(ActionEvent e) throws Exception {
        block4: {
            CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
            IFaPeriodCloseFacade periodClose = FaPeriodCloseFacadeFactory.getRemoteInstance();
            String errorString = "\u5f53\u524d\u671f\u95f4\u5361\u7247\u68c0\u6d4b\u5f02\u5e38";
            try {
                int checkCount = periodClose.checkPeriodClose(currCompany.getId().toString(), this.getCurrPeriod().getId().toString());
                if (checkCount > 0) {
                    String strMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"FaPeriodClose_Check"), checkCount);
                    MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                    SysUtil.abort();
                } else {
                    String strMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"FaPeriodClose_Check"), 0);
                    MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                    SysUtil.abort();
                }
            }
            catch (BOSException exception) {
                String tempString = "openParamCheck001";
                StringBuilder messageString = new StringBuilder();
                messageString.append(exception.getMessage());
                if (messageString.indexOf(tempString) == -1) break block4;
                messageString.delete(0, tempString.length());
                MsgBox.showDetailAndOK((Component)((Object)this), (String)errorString, (String)messageString.toString(), (int)1);
            }
        }
    }

    class VoucherEditShortcutListener
    extends AbstractAction {
        String shortcut;

        VoucherEditShortcutListener(String sc) {
            this.shortcut = sc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (FaPeriodClosingUI.ACTIONKEY_SQL.equals(this.shortcut)) {
                FaPeriodClosingUI.this.showSQL();
            }
        }
    }
}

