/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaTreasuryManageCollection;
import com.kingdee.eas.fi.fa.basedata.FaTreasuryManageFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseException;
import com.kingdee.eas.fi.fa.manage.FaRefundingEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaRefundingEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaRefundingFactory;
import com.kingdee.eas.fi.fa.manage.FaRefundingInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaRefundingEditUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaCardUtil;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaCurCardEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaRefundingEditUI
extends AbstractFaRefundingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaRefundingEditUI.class);
    protected HashMap hmParam;
    private volatile boolean loading = false;
    FaRefundingEntryCollection entryCollection = new FaRefundingEntryCollection();
    private Map person_org = new HashMap();
    private static String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    protected CompanyOrgUnitInfo currentCompany;
    protected Set manageIDs = null;

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    protected HashMap gethmParam() {
        if (this.hmParam != null) {
            return this.hmParam;
        }
        try {
            this.hmParam = FaManageUtils.getFAParameter(this.getCurCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.hmParam;
    }

    private Set getChangeBIllSet(FaRefundingInfo info) {
        if (!CheckedStatusEnum.AUDITED.equals((Object)info.getCheckedStatus())) {
            return null;
        }
        HashSet<FaChangeBillInfo> set = new HashSet<FaChangeBillInfo>();
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            set.add(info.getEntry().get(i).getFaChangebill());
        }
        return set;
    }

    @Override
    public void loadFields() {
        this.loading = true;
        super.loadFields();
        this.refreshTotalValue();
        this.entryCollection.clear();
        this.entryCollection.addCollection(this.editData.getEntry());
        this.loading = false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String[] getEditableColumn() {
        return new String[]{"keeper", "dept", "demo"};
    }

    @Override
    public void actionInsertCard_actionPerformed(ActionEvent e) throws Exception {
        if (CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            return;
        }
        CommonQueryWithResultDialog dialog = this.initDialog();
        if (dialog.show() || dialog.hasKeyValue()) {
            this.setTable(dialog.getSearchResult());
        } else {
            SysUtil.abort();
        }
        this.refreshTotalValue();
    }

    private void refreshTotalValue() {
        int n = this.detailTable.getRowCount();
        if (n == 0) {
            this.txtAmounttotal.setValue(null);
        } else {
            BigDecimal amount = new BigDecimal("0.00");
            for (int i = 0; i < n; ++i) {
                IRow row = this.detailTable.getRow(i);
                Object value = row.getCell("cardValue").getValue();
                if (!(value instanceof BigDecimal)) continue;
                amount = amount.add((BigDecimal)value);
            }
            this.txtAmounttotal.setValue((Object)amount);
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (SysContext.getSysContext().getCurrentUserInfo().getType().getValue() != 20) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource", (String)"FaRefundingBillNotOperate"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
        this.txtReason.setText("");
        this.txtNumber.setText(this.getRuleNumber(this.editData));
        this.pkCreateTime.setValue((Object)new Date());
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        this.prmtAuditor.setValue(null);
        this.pkAuditTime.setValue(null);
        this.txtDescription.setText("");
        this.txtAmounttotal.setValue(null);
        this.prmtUser.setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getPerson());
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            try {
                this.prmtUserDispartment.setValue((Object)this.getPrimaryAdminOrgId(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString()));
            }
            catch (BOSException bOSException) {}
        } else {
            this.prmtUserDispartment.setValue(null);
        }
        try {
            PeriodInfo period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
            if (today.before(DateTimeUtils.truncateDate((Date)period.getBeginDate()))) {
                this.pkBizDate.setValue((Object)period.getBeginDate());
            } else if (today.after(DateTimeUtils.truncateDate((Date)period.getEndDate()))) {
                this.pkBizDate.setValue((Object)period.getEndDate());
            } else {
                this.pkBizDate.setValue((Object)today);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
        this.storeFields();
        this.setDataObject((IObjectValue)this.editData);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.remove((Component)this.btnInsertCard);
        this.kDContainer1.addButton((JButton)this.btnInsertCard);
        this.remove((Component)this.btnRemoveCard);
        this.kDContainer1.addButton((JButton)this.btnRemoveCard);
        this.btnInsertCard.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveCard.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.pkAuditTime.setEnabled(false);
        this.pkCreateTime.setEnabled(false);
        this.prmtAuditor.setEnabled(false);
        this.prmtCreator.setEnabled(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (!OprtState.VIEW.equals(this.getOprtState()) && SysContext.getSysContext().getCurrentUserInfo().getType().getValue() != 20) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource", (String)"FaRefundingBillNotOperate"));
            SysUtil.abort();
        }
        this.prmtUser.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        this.prmtUser.setEnabled(false);
        HashMap map = new HashMap();
        boolean isRange = this.gethmParam().get("FA_040") == null ? false : "true".equals(this.gethmParam().get("FA_040").toString());
        PersonPromptBox personPromtBox = FaClientUtils.getRangePersonF7(isRange, map, (IUIObject)this);
        this.prmtUser.setSelector((KDPromptSelector)personPromtBox);
        this.prmtUser.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
        this.prmtUser.setHasCUDefaultFilter(false);
        this.prmtUser.setDisplayFormat("$name$");
        this.prmtUser.setEditFormat("$number$");
        this.prmtUser.setCommitFormat("$number$");
        this.prmtUser.setHistoryRecordEnabled(false);
        this.prmtUser.setRequired(true);
        this.prmtUserDispartment.setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getDefOrgUnit());
        this.prmtUserDispartment.setEnabled(false);
        this.prmtUserDispartment.setEditable(true);
        this.prmtUserDispartment.setQueryInfo("com.kingdee.eas.sem.mp.app.AdminOrgUnitF7");
        this.prmtUserDispartment.setDisplayFormat("$name$");
        this.prmtUserDispartment.setEditFormat("$number$");
        this.prmtUserDispartment.setCommitFormat("$number$");
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        FaClientUtils.processAdminF7(adminF7, isRange);
        this.prmtUserDispartment.setSelector((KDPromptSelector)adminF7);
        this.prmtUserDispartment.setRequired(true);
        this.actionInsertCard.setEnabled(true);
        this.actionRemoveCard.setEnabled(true);
        this.txtNumber.setRequired(true);
        this.pkBizDate.setRequired(true);
        this.txtNumber.setEditable(false);
        this.txtReason.setRequired(true);
        this.txtAmounttotal.setDataType(1);
        this.txtAmounttotal.setPrecision(this.getCurrencyScale());
        this.txtAmounttotal.setRemoveingZeroInDispaly(false);
        this.txtAmounttotal.setRemoveingZeroInEdit(false);
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        if ("ADDNEW".equals(this.oprtState) || "EDIT".equals(this.oprtState)) {
            this.actionFilterCard.setEnabled(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnInsertCard.setEnabled(false);
            this.btnRemoveCard.setEnabled(false);
            this.actionFilterCard.setEnabled(false);
        }
        this.prmtUser.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (FaRefundingEditUI.this.loading) {
                    return;
                }
                KDBizPromptBox prmtDeptPerson = (KDBizPromptBox)eventObj.getSource();
                if (!(prmtDeptPerson.getData() instanceof PersonInfo)) {
                    return;
                }
                try {
                    AdminOrgUnitInfo org = FaRefundingEditUI.this.getPrimaryAdminOrgId(((PersonInfo)prmtDeptPerson.getData()).getId().toString());
                    if (org != null) {
                        FaRefundingEditUI.this.prmtUserDispartment.setValue((Object)org);
                    }
                }
                catch (BOSException e) {
                    FaRefundingEditUI.this.handUIException(e);
                }
            }
        });
        KDBizPromptBox kDBizPromptBoxOrg = new KDBizPromptBox();
        ObjectValueRender displayNameRender = new ObjectValueRender();
        ObjectValueRender nameRender = new ObjectValueRender();
        kDBizPromptBoxOrg.setEditable(true);
        kDBizPromptBoxOrg.setQueryInfo("com.kingdee.eas.sem.mp.app.AdminOrgUnitF7");
        kDBizPromptBoxOrg.setDisplayFormat("$name$");
        kDBizPromptBoxOrg.setEditFormat("$number$");
        kDBizPromptBoxOrg.setCommitFormat("$number$");
        NewAdminF7 admindepF7 = new NewAdminF7((IUIObject)this);
        FaClientUtils.processAdminF7(admindepF7, isRange);
        kDBizPromptBoxOrg.setSelector((KDPromptSelector)admindepF7);
        this.detailTable.getColumn("dept").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxOrg));
        nameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        displayNameRender.setFormat((IDataFormat)new BizDataFormat("$displayName$"));
        if (this.hmParam != null && this.hmParam.get("FA_025") != null && "true".equals(this.hmParam.get("FA_025"))) {
            this.detailTable.getColumn("dept").setRenderer((IBasicRender)displayNameRender);
        } else {
            this.detailTable.getColumn("dept").setRenderer((IBasicRender)nameRender);
        }
        this.detailTable.getColumn("dept").setWidth(160);
        KDBizPromptBox kDBizPromptBoxUser = new KDBizPromptBox();
        kDBizPromptBoxUser.setEditable(true);
        kDBizPromptBoxUser.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        kDBizPromptBoxUser.setDisplayFormat("$name$");
        kDBizPromptBoxUser.setEditFormat("$number$");
        kDBizPromptBoxUser.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select distinct fmanageid from t_fa_FaTreasuryManage ", CompareType.INNER));
        view.setFilter(filter);
        kDBizPromptBoxUser.setEntityViewInfo(view);
        this.detailTable.getColumn("keeper").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxUser));
        this.detailTable.getColumn("keeper").setRenderer((IBasicRender)nameRender);
        this.detailTable.getColumn("keeper").setWidth(200);
        if (!"VIEW".equals(this.getOprtState())) {
            this.detailTable.setRequired(true);
        }
        this.detailTable.getColumn("dept").setRequired(true);
        this.detailTable.getColumn("keeper").setRequired(true);
        this.detailTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int row = e.getRowIndex();
                int col = e.getColIndex();
                if (!"keeper".equalsIgnoreCase(FaRefundingEditUI.this.detailTable.getColumnKey(col))) {
                    return;
                }
                Object obj = e.getValue();
                if (!(obj instanceof PersonInfo)) {
                    return;
                }
                try {
                    AdminOrgUnitInfo org = FaRefundingEditUI.this.getPrimaryAdminOrgId(((PersonInfo)obj).getId().toString());
                    if (org != null) {
                        FaRefundingEditUI.this.detailTable.getRow(row).getCell("dept").setValue((Object)org);
                    }
                }
                catch (Exception el) {
                    FaRefundingEditUI.this.handUIException(el);
                }
            }
        });
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            this.actionInsertCard.setEnabled(false);
            this.actionRemoveCard.setEnabled(false);
        } else {
            this.actionInsertCard.setEnabled(true);
            this.actionRemoveCard.setEnabled(true);
        }
    }

    protected AdminOrgUnitInfo getPrimaryAdminOrgId(String personID) throws BOSException {
        if (this.person_org.containsKey(personID)) {
            return (AdminOrgUnitInfo)this.person_org.get(personID);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("position.adminOrgUnit.id");
        view.getSelector().add("position.adminOrgUnit.name");
        view.getSelector().add("position.adminOrgUnit.number");
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        f.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        view.setFilter(f);
        PositionMemberCollection cols = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        if (cols != null && cols.size() > 0) {
            AdminOrgUnitInfo org = cols.get(0).getPosition().getAdminOrgUnit();
            this.person_org.put(personID, org);
            return org;
        }
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaRefundingFactory.getRemoteInstance();
    }

    @Override
    protected String getEntryKeyName() {
        return "entry";
    }

    @Override
    protected IObjectValue createNewData() {
        FaRefundingInfo info;
        PeriodInfo period = null;
        try {
            period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        this.editData = info = new FaRefundingInfo();
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        if (today.before(DateTimeUtils.truncateDate((Date)period.getBeginDate()))) {
            info.setBizDate(period.getBeginDate());
        } else if (today.after(DateTimeUtils.truncateDate((Date)period.getEndDate()))) {
            info.setBizDate(period.getEndDate());
        } else {
            info.setBizDate(today);
        }
        info.setUser(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            try {
                info.setUserDispartment(this.getPrimaryAdminOrgId(info.getUser().getId().toString()));
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        info.setReason("");
        return info;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return new FaRefundingEntryInfo();
    }

    private FaCurCardInfo getCurCardInfo(String curCardID) {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        try {
            SelectorItemCollection sic = new FaCurCardEditUI().getSelectors();
            sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
            curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return curCardInfo;
    }

    private String setTable(List list) throws Exception {
        Object sb = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String id = null;
                if (list.get(i) instanceof IRow) {
                    IRow result = (IRow)list.get(i);
                    id = result.getCell("id").getValue().toString();
                } else {
                    id = list.get(i).toString();
                }
                FaRefundingEntryInfo entryInfo = this.getFaRefundingEntryInfo(id);
                IRow row = this.getDetailTable().addRow();
                if (entryInfo != null) {
                    this.loadLineFields(this.getDetailTable(), row, (IObjectValue)entryInfo);
                    row.setUserObject((Object)entryInfo);
                    continue;
                }
                FaCurCardInfo curCard = this.getCurCardInfo(id);
                String str = this.verfyCardISRequisitioned(curCard);
                FaRefundingEntryInfo billInfo = (FaRefundingEntryInfo)this.createNewDetailData(this.getDetailTable());
                billInfo.setFaCurCard(curCard);
                billInfo.setBizCard(FaClientUtils.CurCard2BizCard(curCard));
                this.loadLineFields(this.getDetailTable(), row, (IObjectValue)billInfo);
                row.setUserObject((Object)billInfo);
                this.entryCollection.add(billInfo);
            }
        }
        this.checkCardDup();
        return "";
    }

    private FaRefundingEntryInfo getFaRefundingEntryInfo(String id) {
        for (int i = 0; i < this.entryCollection.size(); ++i) {
            FaRefundingEntryInfo entryInfo = this.entryCollection.get(i);
            if (entryInfo.getFaCurCard() == null || !id.equalsIgnoreCase(entryInfo.getFaCurCard().getId().toString())) continue;
            return entryInfo;
        }
        return null;
    }

    private String verfyCardISRequisitioned(FaCurCardInfo curCard) {
        return null;
    }

    @Override
    public void actionRemoveCard_actionPerformed(ActionEvent e) throws Exception {
        if (CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            return;
        }
        super.actionRemoveLine_actionPerformed(e);
        this.refreshTotalValue();
    }

    @Override
    protected boolean confirmRemove() {
        return true;
    }

    @Override
    protected CompanyOrgUnitInfo getCurCompany() {
        Map uicontext = this.getUIContext();
        if (uicontext == null || uicontext.size() == 0) {
            return SysContext.getSysContext().getCurrentFIUnit();
        }
        if (this.currentCompany == null) {
            this.currentCompany = (CompanyOrgUnitInfo)this.initUiInfo.get("currentCompany");
        }
        return (CompanyOrgUnitInfo)this.currentCompany.clone();
    }

    @Override
    protected MetaDataPK getListUIQuery() {
        return new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaCurCardQuery");
    }

    private CommonQueryWithResultDialog initDialog() throws Exception {
        CommonQueryWithResultDialog dialog = new CommonQueryWithResultDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK((IMetaDataPK)this.getListUIQuery());
        dialog.setTitle(this.getUITitle());
        dialog.setHeight(525);
        dialog.setOpenType(-1);
        dialog.setFilterInfo(this.getCardFilter());
        dialog.setUseDefaultFilter(false);
        HashMap hmParam = this.gethmParam();
        boolean isRange = "true".equals(hmParam.get("FA_040").toString());
        FACommonProcessor processor = new FACommonProcessor();
        processor.setRange(isRange);
        dialog.setProcessor((IProcessor)processor);
        dialog.setSelectMode(10);
        return dialog;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("company.id");
        sic.add("checkedStatus");
        sic.add("deletedStatus");
        sic.add("blockedStatus");
        sic.add("effectedStatus");
        sic.add("entry.faCurCard.bizStatus");
        sic.add("entry.faCurCard.lastBillID");
        sic.add("entry.bizCard.bizStatus");
        sic.add("entry.bizCard.lastBillID");
        sic.add("entry.id");
        sic.add("bizStatus");
        sic.add("entry.faChangebill.id");
        return sic;
    }

    protected Set getCardIDSet() {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            Object obj = this.detailTable.getRow(i).getUserObject();
            if (!(obj instanceof FaRefundingEntryInfo)) continue;
            FaRefundingEntryInfo info = (FaRefundingEntryInfo)obj;
            set.add(info.getFaCurCard().getId().toString());
        }
        return set;
    }

    @Override
    protected FilterInfo getCardFilter() {
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("hasDisabled", (Object)"0", CompareType.EQUALS));
        f.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        f.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("blockedStatus", (Object)new Integer(1)));
        f.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"%99", CompareType.LIKE));
        if (this.getManageIDSet().size() > 0) {
            f.getFilterItems().add(new FilterItemInfo("keeper.id", (Object)this.getManageIDSet(), CompareType.NOTINCLUDE));
            f.getFilterItems().add(new FilterItemInfo("keeper.id", null, CompareType.EQUALS));
        }
        f.getFilterItems().add(new FilterItemInfo("id", (Object)"select fCurcardID from T_FA_FaBorrowingEntry where FIsReturned=0", CompareType.NOTINNER));
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            f.getFilterItems().add(new FilterItemInfo("faCurDepartment.usePerson.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString(), CompareType.EQUALS));
        }
        StringBuffer sb = this.getManageIDSet().size() > 0 ? new StringBuffer("( #0  and  #1 and  #2 and  #3 and  #4 and  #5 and (#6 or #7) and #8 and #9 )") : new StringBuffer("( #0  and  #1 and  #2 and  #3 and  #4 and  #5 and  #6 and  #7 )");
        if (this.editData.getId() != null) {
            f.getFilterItems().add(new FilterItemInfo("id", (Object)("select FCurcardID from T_FA_FaRefundingEntry where FParentID='" + this.editData.getId().toString() + "'"), CompareType.INNER));
            sb.append(" or #").append(f.getFilterItems().size() - 1);
        }
        f.setMaskString(sb.toString());
        if (!this.getCardIDSet().isEmpty()) {
            f.setMaskString("(" + f.getMaskString() + ") and #" + f.getFilterItems().size());
            f.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCardIDSet(), CompareType.NOTINCLUDE));
        }
        return f;
    }

    protected Set getManageIDSet() {
        if (this.manageIDs == null) {
            this.manageIDs = new HashSet();
            try {
                FaTreasuryManageCollection cols = FaTreasuryManageFactory.getRemoteInstance().getFaTreasuryManageCollection();
                if (cols == null) {
                    return this.manageIDs;
                }
                int n = cols.size();
                for (int i = 0; i < n; ++i) {
                    if (cols.get(i).getManage() == null) continue;
                    this.manageIDs.add(cols.get(i).getManage().getId().toString());
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return this.manageIDs;
    }

    protected StringBuffer getManageCardID(Set set) {
        StringBuffer sb = null;
        for (Object userID : set) {
            if (userID == null) continue;
            if (sb == null) {
                sb = new StringBuffer("(");
            } else {
                sb.append(",");
            }
            sb.append("'");
            sb.append(userID.toString());
            sb.append("'");
        }
        sb.append(")");
        return sb;
    }

    protected Set getHasInsertCard() {
        HashSet<String> set = new HashSet<String>();
        int n = this.detailTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.detailTable.getRow(i).getUserObject();
            if (!(obj instanceof FaRefundingInfo)) continue;
            set.add(((FaRefundingInfo)obj).getId().toString());
        }
        return set;
    }

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    @Override
    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        super.verifyBeforeSubmit(e);
        PeriodInfo period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
        Date bizDate = (Date)this.pkBizDate.getValue();
        Timestamp endDate = period.getEndDate();
        endDate.setHours(23);
        endDate.setMinutes(60);
        if (bizDate.before(period.getBeginDate())) {
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("tkDateError"));
            SysUtil.abort();
        }
        if (bizDate.after(period.getEndDate())) {
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("tkDateError"));
            SysUtil.abort();
        }
        if (this.prmtUser.getValue() == null) {
            this.prmtUser.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("tknotnull"));
            SysUtil.abort();
        }
        if (this.prmtUserDispartment.getValue() == null) {
            this.prmtUserDispartment.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("tkdepartNotNull"));
            SysUtil.abort();
        }
        if (this.txtReason.getText() == null || this.txtReason.getText().trim().length() == 0) {
            this.txtReason.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("tkreasonNull"));
            SysUtil.abort();
        }
        if (this.detailTable.getRowCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)new FaPhysicalManageBaseException(FaPhysicalManageBaseException.TKENTRYNULL).getMessage());
            SysUtil.abort();
        }
        this.checkCardDup();
        this.checkdeptorKeeperBank();
    }

    protected void checkCardDup() throws Exception {
        HashMap<String, Integer> cardIDMap = new HashMap<String, Integer>();
        int n = this.detailTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.detailTable.getRow(i).getUserObject();
            if (!(obj instanceof FaRefundingEntryInfo)) continue;
            String id = ((FaRefundingEntryInfo)obj).getFaCurCard().getId().toString();
            if (cardIDMap.containsKey(id)) {
                throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.CARDDUP, new Object[]{cardIDMap.get(id), new Integer(i + 1)});
            }
            cardIDMap.put(id, new Integer(i + 1));
        }
    }

    protected void checkdeptorKeeperBank() throws Exception {
        int n = this.detailTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.detailTable.getRow(i).getCell("keeper").getValue() instanceof PersonInfo)) {
                throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.REFUNDIN_USER_ERROR, new Object[]{new Integer(i + 1)});
            }
            if (this.detailTable.getRow(i).getCell("dept").getValue() instanceof AdminOrgUnitInfo) continue;
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.REFUNDIN_DEPT_ERROR, new Object[]{new Integer(i + 1)});
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaRefundingEditUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaRefundingEditUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    protected String getPrintPath() {
        return "/FI/FA/PhysicalManage/FaRefunding";
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        FaRefundingEntryCollection cols = this.editData.getEntry();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < cols.size(); ++i) {
            if (cols.get(i).getFaChangebill() == null) continue;
            v.add(cols.get(i).getFaChangebill().getId().toString());
        }
        if (this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED && !v.isEmpty()) {
            HashMap<String, Vector<String>> list = new HashMap<String, Vector<String>>();
            list.put(new FaChangeBillInfo().getBOSType().toString(), v);
            this.showTraceUI(list, 0);
        } else {
            MsgBox.showError((String)FaResUtil.getRes((String)"destinationBillIsNull"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnInsertCard.setEnabled(true);
        this.btnRemoveCard.setEnabled(true);
    }

    @Override
    public void actionFilterCard_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryWithResultDialog dialog = this.initDialog();
        if (dialog.show() || dialog.hasKeyValue()) {
            IObjectCollection collection = (IObjectCollection)this.getDetailTable().getUserObject();
            collection.clear();
            this.getDetailTable().removeRows();
            this.setTable(dialog.getSearchResult());
        } else {
            SysUtil.abort();
        }
    }
}

