/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaLessorTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaRentSettlementBillFactory;
import com.kingdee.eas.fi.fa.manage.FaRentSettlementBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaRentSettlementBill;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaRentSettlementBillListUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaRentSettlementBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaRentSettlementBillLinkViewUI
extends CoreUI {
    private static final Logger logger = Logger.getLogger(FaRentSettlementBillLinkViewUI.class);
    private static final String RES_PATH_RS = "com.kingdee.eas.fi.fa.manage.FaRentSettlementBillResource";
    private KDTable table;
    private MetaDataPK mainQueryPK;
    private EntityViewInfo mainQuery;
    private Date changeDate;
    private Date terminatedDate;
    private static final String KEY_ID = "id";
    private static final String KEY_PLANWITHTAXAMT = "entries.planWithTaxAmt";
    private static final String KEY_TAXRATE = "entries.taxRate";
    private static final String KEY_TAXAMT = "entries.taxAmt";
    private static final String KEY_PLANWITHOUTTAXAMT = "entries.planWithoutTaxAmt";
    private static final String KEY_WITHTAXAMT = "entries.withTaxAmt";
    private static final String KEY_TOTALPERIOD = "totalPeriod";
    private static final String KEY_HADPERIOD = "hadPeriod";
    private static final String KEY_SUBPERIOD = "subPeriod";
    private static final String KEY_RENTDIRECTION = "rentDirection";
    private static final String KEY_FIVOUCHERED = "fiVouchered";
    private static final String KEY_VCNUMBER = "vcNumber";
    private static final String KEY_LESSORTYPE = "leaseInBill.lessorType";

    public FaRentSettlementBillLinkViewUI() throws Exception {
        this.initUI();
    }

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaRentSettlementBillQuery");
        this.mainQuery = new EntityViewInfo();
        if (uiContext.get("ID") != null) {
            this.getChangeDate((String)uiContext.get("ID"));
            this.getTerminatedDate((String)uiContext.get("ID"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", uiContext.get("ID")));
            if (this.changeDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("entries.planDate", (Object)this.changeDate, CompareType.LESS));
            }
            if (this.terminatedDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("entries.planDate", (Object)this.terminatedDate, CompareType.LESS));
            }
            filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", uiContext.get("ID")));
            this.mainQuery.setFilter(filter);
        }
        super.onLoad();
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 1013, 629));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 629));
        this.table.setBounds(new Rectangle(10, 10, 996, 580));
        this.add((Component)this.table, new KDLayout.Constraints(10, 10, 996, 580, 325));
    }

    private void initUI() throws Exception {
        final int scale = FaClientUtils.getCurrencyScale();
        this.table = new KDTable();
        this.table.setName("rsTable");
        this.table.setEditable(false);
        ResourceBundleHelper resHelper = new ResourceBundleHelper(AbstractFaRentSettlementBillListUI.class.getName());
        this.table.setFormatXml(resHelper.getString("tblMain.formatXml"));
        this.table.parseFormatXml(resHelper.getString("tblMain.formatXml"));
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            list.add(this.table.getColumn(i).getKey());
        }
        String[] array = new String[list.size()];
        System.arraycopy(list.toArray(), 0, array, 0, list.size());
        this.table.putBindContents("mainQuery", array);
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                FaRentSettlementBillLinkViewUI.this.tblMain_doRequestRowSet(e);
                FaRentSettlementBillLinkViewUI.this.table.getSelectManager().setSelectMode(2);
                String[] numKeys = new String[]{FaRentSettlementBillLinkViewUI.KEY_PLANWITHTAXAMT, FaRentSettlementBillLinkViewUI.KEY_TAXAMT, FaRentSettlementBillLinkViewUI.KEY_WITHTAXAMT, FaRentSettlementBillLinkViewUI.KEY_PLANWITHOUTTAXAMT, FaRentSettlementBillLinkViewUI.KEY_TOTALPERIOD, FaRentSettlementBillLinkViewUI.KEY_HADPERIOD, FaRentSettlementBillLinkViewUI.KEY_SUBPERIOD};
                FaClientUtils.changeTableNumberFormat(FaRentSettlementBillLinkViewUI.this.table, new String[]{FaRentSettlementBillLinkViewUI.KEY_TAXRATE}, FaClientUtils.getDecimalFormat(3));
                FaClientUtils.changeTableNumberFormat(FaRentSettlementBillLinkViewUI.this.table, numKeys, FaClientUtils.getDecimalFormat(scale));
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    FaRentSettlementBillLinkViewUI.this.table_tableClicked(e);
                }
                catch (AbortException aexc) {
                    logger.error((Object)aexc);
                }
                catch (Exception exc) {
                    MsgBox.showError((Component)Util.getWindow((Component)((Object)FaRentSettlementBillLinkViewUI.this)), (String)exc.getClass().getName(), (String)exc.getMessage());
                    logger.error((Object)exc);
                }
            }
        });
        this.table.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (FaRentSettlementBillLinkViewUI.this.table.getRowCount() > 0) {
                    FaRentSettlementBillLinkViewUI.this.table.getSelectManager().select(0, FaRentSettlementBillLinkViewUI.this.table.getRowCount() - 1);
                }
                try {
                    IFaRentSettlementBill iFaRentSettlementBill = FaRentSettlementBillFactory.getRemoteInstance();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(FaRentSettlementBillLinkViewUI.KEY_FIVOUCHERED);
                    selector.add("voucher.number");
                    for (int i = 0; i < FaRentSettlementBillLinkViewUI.this.table.getRowCount(); ++i) {
                        ICell cell = FaRentSettlementBillLinkViewUI.this.table.getRow(i).getCell(FaRentSettlementBillLinkViewUI.KEY_LESSORTYPE);
                        Object value = cell.getValue();
                        if (value != null) {
                            if ((Integer)value == 2) {
                                cell.setValue((Object)FaLessorTypeEnum.CUSTOMER.getAlias());
                            } else if ((Integer)value == 3) {
                                cell.setValue((Object)FaLessorTypeEnum.INNER_COMPAY.getAlias());
                            } else if ((Integer)value == 1) {
                                cell.setValue((Object)FaLessorTypeEnum.SUPPLIER.getAlias());
                            } else {
                                cell.setValue(null);
                            }
                        }
                        ICell cellId = FaRentSettlementBillLinkViewUI.this.table.getRow(i).getCell(FaRentSettlementBillLinkViewUI.KEY_ID);
                        ICell cellVc = FaRentSettlementBillLinkViewUI.this.table.getRow(i).getCell(FaRentSettlementBillLinkViewUI.KEY_FIVOUCHERED);
                        ICell cellVcNum = FaRentSettlementBillLinkViewUI.this.table.getRow(i).getCell(FaRentSettlementBillLinkViewUI.KEY_VCNUMBER);
                        FaRentSettlementBillInfo billInfo = iFaRentSettlementBill.getFaRentSettlementBillInfo((IObjectPK)new ObjectUuidPK((String)cellId.getValue()), selector);
                        cellVc.setValue((Object)billInfo.isFiVouchered());
                        cellVcNum.setValue(billInfo.getVoucher() == null ? null : billInfo.getVoucher().getNumber());
                    }
                }
                catch (Exception ex) {
                    FaRentSettlementBillLinkViewUI.this.handleException(ex);
                }
            }
        });
        FaManageUtils.freezeTable((KDTable)this.table, (int)3);
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        try {
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)this.mainQueryPK, this.mainQuery);
            IRowSet rowSet = exec.executeQuery(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    protected void table_tableClicked(KDTMouseEvent e) throws UIException {
        if (e.getClickCount() == 2) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            uiContext.put((Object)"fromUI", (Object)"FaRentSettlementBillLinkViewUI");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaRentSettlementBillEditUI.class.getName(), (Map)uiContext, null, "FINDVIEW");
            uiWindow.show();
        }
    }

    protected String getSelectedKeyValue() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.table);
        return ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.table, (String)KEY_ID);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        return exec;
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaRentSettlementBillResource.faRentSettlementBillLinkViewUITitle");
    }

    private void getChangeDate(String faLeaseinBillNewId) throws BOSException, SQLException, ParseException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FChangeDate \n");
        sql.append("FROM T_FA_FaNLMChangeAssetItem \n");
        sql.append("WHERE FLEASEINBILLOLDID = '" + faLeaseinBillNewId + "'\n");
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rowSet.next()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.changeDate = sdf.parse(rowSet.getString("FChangeDate"));
        } else {
            this.changeDate = null;
        }
    }

    private void getTerminatedDate(String faLeaseinBillNewId) throws BOSException, SQLException, ParseException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FTerminateDate FROM T_FA_FATERMINATEBILLENTRY tme \n");
        sql.append(" LEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \n");
        sql.append(" WHERE FLEASEINBILLID = '" + faLeaseinBillNewId + "' \n");
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rowSet.next()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.terminatedDate = sdf.parse(rowSet.getString("FTerminateDate"));
        } else {
            this.terminatedDate = null;
        }
    }
}

