/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillFactory;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaRequisitionedBillListUI;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaRequisitionedBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaRequisitionedFilterUI;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaRequisitionedBillListUI
extends AbstractFaRequisitionedBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaRequisitionedBillListUI.class);
    private CompanyOrgUnitInfo currentCompany;

    @Override
    protected String getEditUIName() {
        return FaRequisitionedBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaRequisitionedBillFactory.getRemoteInstance();
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog.addUserPanel((KDPanel)new FaRequisitionedFilterUI());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        try {
            Processor processor = new Processor();
            boolean isRange = "true".equals(this.gethmParamD().get("FA_040").toString());
            processor.setRange(isRange);
            dialog.setProcessor((IProcessor)processor);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        dialog.setWidth(450);
        dialog.setHeight(320);
        return dialog;
    }

    @Override
    public void onLoad() throws Exception {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
            this.setDataObject((IObjectValue)this.mainQuery);
        }
        this.tblMain.checkParsed();
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        FaClientUtils.checkComp((Component)((Object)this), company);
        FaClientUtils.checkFaInit((Component)this.getUIContext().get("Owner"), company);
        FaClientUtils.checkAccountSwap((Component)((Object)this), company);
        super.onLoad();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnaudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.actionRemove.setVisible(true);
        this.actionRemove.setEnabled(true);
        FaClientUtils.fmtDate(this.getMainTable(), new String[]{"bizDate"});
    }

    @Override
    protected String[] getMergeColumns() {
        return new String[]{"id", "number", "bizDate", "usePerson.name", "userDispartment.name", "reason", "checkedStatus", "creator.name", "auditor.name"};
    }

    @Override
    protected String[] getFormatColumns() {
        return new String[]{"faCurCard.assetValue"};
    }

    @Override
    protected String[] getAssetAmtColumns() {
        return new String[]{"faCurCard.assetAmt"};
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currentCompany == null) {
            if (!FaClientUtils.isFromWorkflow(this.getUIContext())) {
                this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            } else {
                String billId = "";
                if (this.getUIContext().get("IDList") instanceof String[]) {
                    String[] idlist = (String[])this.getUIContext().get("IDList");
                    billId = idlist[0];
                } else if (this.getUIContext().get("IDList") instanceof RealModeIDList) {
                    billId = ((RealModeIDList)this.getUIContext().get("IDList")).getFirstID();
                }
                try {
                    this.currentCompany = FaRequisitionedBillFactory.getRemoteInstance().getFaRequisitionedBillInfo("select company.* where id = '" + billId + "'").getCompany();
                }
                catch (Exception e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
            }
        }
        return (CompanyOrgUnitInfo)this.currentCompany.clone();
    }

    @Override
    protected FaBillBaseInfo getBillInfo() {
        return new FaRequisitionedBillInfo();
    }

    protected String[] getLocateNames() {
        return new String[]{"number", "bizDate", "usePerson.name", "userDispartment.name", "reason", "checkedStatus"};
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)CheckedStatusEnum.AUDITED));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("faClearBill.id");
        viewInfo.getSelector().add("Entrys.faChangeBill.id");
        CoreBaseCollection col = this.getBizInterface().getCollection(viewInfo);
        if (col != null && col.size() > 0) {
            FaRequisitionedBillEntryCollection cols = ((FaRequisitionedBillInfo)col.get(0)).getEntrys();
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < cols.size(); ++i) {
                if (cols.get(i).getFaChangebill() == null) continue;
                v.add(cols.get(i).getFaChangebill().getId().toString());
            }
            if (!v.isEmpty()) {
                HashMap<String, Vector<String>> list = new HashMap<String, Vector<String>>();
                list.put(new FaChangeBillInfo().getBOSType().toString(), v);
                this.showTraceUI(list, 0);
            } else {
                MsgBox.showError((String)FaResUtil.getRes((String)"destinationBillIsNull"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showError((String)FaResUtil.getRes((String)"destinationBillIsNull"));
            SysUtil.abort();
        }
    }

    class Processor
    extends FACommonProcessor {
        @Override
        public void process() throws Exception {
            KDBizPromptBox f7;
            super.process();
            String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
            if (fieldProperty == null || fieldProperty.trim().length() == 0) {
                return;
            }
            CoreUI parent = new CoreUI();
            if (this.get("parentDialog") != null) {
                parent = ((CommonQueryDialog)this.get("parentDialog")).getWindow().getUIObject();
            }
            Object editor = this.get("CURRENT_EDITOR");
            if ((fieldProperty.equalsIgnoreCase("creator.name") || fieldProperty.equalsIgnoreCase("auditor.name") || fieldProperty.equalsIgnoreCase("user.name")) && editor instanceof KDBizPromptBox) {
                f7 = (KDBizPromptBox)editor;
                HashMap map = new HashMap();
                PersonPromptBox personPromptBox = FaClientUtils.getRangePersonF7(this.isRange(), map, (IUIObject)parent);
                f7.setSelector((KDPromptSelector)personPromptBox);
                f7.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
                f7.setHasCUDefaultFilter(false);
            }
            if ((fieldProperty.equalsIgnoreCase("userDispartment.name") || fieldProperty.equalsIgnoreCase("userDispartment.name")) && editor instanceof KDBizPromptBox) {
                f7 = (KDBizPromptBox)editor;
                NewAdminF7 admin = new NewAdminF7((IUIObject)parent);
                admin.setContainSealUp(true);
                boolean isRange = "true".equals(FaRequisitionedBillListUI.this.gethmParamD().get("FA_040").toString());
                FaClientUtils.processAdminF7(admin, isRange);
                f7.setSelector((KDPromptSelector)admin);
                f7.setEntityViewInfo(companyViewInfo);
            }
        }
    }
}

