/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaTreasuryManageCollection;
import com.kingdee.eas.fi.fa.basedata.FaTreasuryManageFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseException;
import com.kingdee.eas.fi.fa.manage.FaReturnEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaReturnFactory;
import com.kingdee.eas.fi.fa.manage.FaReturnInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaReturnEditUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaCardUtil;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaCurCardEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.fa.manage.client.FaScanBarCodesEditUI;
import com.kingdee.eas.fi.fa.manage.client.IAfterScanHandle;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaReturnEditUI
extends AbstractFaReturnEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaReturnEditUI.class);
    protected HashMap hmParam;
    private volatile boolean loading = false;
    private Map person_org = new HashMap();
    protected CompanyOrgUnitInfo currentCompany;
    protected Set manageIDs = null;
    private static String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    protected HashMap gethmParam() {
        if (this.hmParam != null) {
            return this.hmParam;
        }
        try {
            this.hmParam = FaManageUtils.getFAParameter(this.getCurCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.hmParam;
    }

    @Override
    public void loadFields() {
        this.loading = true;
        super.loadFields();
        this.refreshTotalValue();
        this.loading = false;
        if (CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            this.actionAddNewLine.setEnabled(false);
            this.actionDeleteNewLine.setEnabled(false);
        } else {
            this.actionAddNewLine.setEnabled(true);
            this.actionDeleteNewLine.setEnabled(true);
        }
    }

    @Override
    protected String[] getEditableColumn() {
        return new String[]{"demo"};
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    private void refreshTotalValue() {
        int n = this.detailTable.getRowCount();
        if (n == 0) {
            this.txtAmounttotal.setValue(null);
        } else {
            BigDecimal amount = new BigDecimal("0.00");
            for (int i = 0; i < n; ++i) {
                IRow row = this.detailTable.getRow(i);
                Object value = row.getCell("cardValue").getValue();
                if (!(value instanceof BigDecimal)) continue;
                amount = amount.add((BigDecimal)value);
            }
            this.txtAmounttotal.setValue((Object)amount);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.remove((Component)this.btnAddNewLine);
        this.kDContainer1.addButton((JButton)this.btnAddNewLine);
        this.remove((Component)this.btnDeleteNewLine);
        this.kDContainer1.addButton((JButton)this.btnDeleteNewLine);
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        HashMap map = new HashMap();
        boolean isRange = this.gethmParam().get("FA_040") == null ? false : "true".equals(this.gethmParam().get("FA_040").toString());
        PersonPromptBox personPromtBox = FaClientUtils.getRangePersonF7(isRange, map, (IUIObject)this);
        this.prmtUser.setSelector((KDPromptSelector)personPromtBox);
        this.prmtUser.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
        this.prmtUser.setHasCUDefaultFilter(false);
        this.prmtUserDispartment.setEditable(true);
        this.prmtUserDispartment.setQueryInfo("com.kingdee.eas.sem.mp.app.AdminOrgUnitF7");
        this.prmtUserDispartment.setDisplayFormat("$name$");
        this.prmtUserDispartment.setEditFormat("$number$");
        this.prmtUserDispartment.setCommitFormat("$number$");
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        FaClientUtils.processAdminF7(adminF7, isRange);
        this.prmtUserDispartment.setSelector((KDPromptSelector)adminF7);
        this.actionAddNewLine.setEnabled(true);
        this.actionDeleteNewLine.setEnabled(true);
        this.txtNumber.setRequired(true);
        this.pkBizDate.setRequired(true);
        this.prmtUser.setRequired(true);
        this.prmtUserDispartment.setRequired(true);
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnAddNewLine.setEnabled(false);
            this.btnDeleteNewLine.setEnabled(false);
        }
        this.btnScanPitch.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
        this.actionScanPitch.setVisible(false);
        this.txtNumber.setEditable(false);
        this.txtReason.setRequired(true);
        this.txtAmounttotal.setDataType(1);
        this.txtAmounttotal.setPrecision(this.getCurrencyScale());
        this.txtAmounttotal.setRemoveingZeroInDispaly(false);
        this.txtAmounttotal.setRemoveingZeroInEdit(false);
        this.prmtUser.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (FaReturnEditUI.this.loading) {
                    return;
                }
                KDBizPromptBox prmtDeptPerson = (KDBizPromptBox)eventObj.getSource();
                if (!(prmtDeptPerson.getData() instanceof PersonInfo)) {
                    return;
                }
                try {
                    AdminOrgUnitInfo org = FaReturnEditUI.this.getPrimaryAdminOrgId(((PersonInfo)prmtDeptPerson.getData()).getId().toString());
                    if (org != null) {
                        FaReturnEditUI.this.prmtUserDispartment.setValue((Object)org);
                    }
                }
                catch (BOSException e) {
                    FaReturnEditUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            this.actionAddNewLine.setEnabled(false);
            this.actionDeleteNewLine.setEnabled(false);
        } else {
            this.actionAddNewLine.setEnabled(true);
            this.actionDeleteNewLine.setEnabled(true);
        }
    }

    protected AdminOrgUnitInfo getPrimaryAdminOrgId(String personID) throws BOSException {
        if (this.person_org.containsKey(personID)) {
            return (AdminOrgUnitInfo)this.person_org.get(personID);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("position.adminOrgUnit.id");
        view.getSelector().add("position.adminOrgUnit.name");
        view.getSelector().add("position.adminOrgUnit.number");
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        f.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        view.setFilter(f);
        PositionMemberCollection cols = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        if (cols != null && cols.size() > 0) {
            AdminOrgUnitInfo org = cols.get(0).getPosition().getAdminOrgUnit();
            this.person_org.put(personID, org);
            return org;
        }
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaReturnFactory.getRemoteInstance();
    }

    @Override
    protected String getEntryKeyName() {
        return "entry";
    }

    @Override
    protected IObjectValue createNewData() {
        FaReturnInfo info;
        this.txtReason.setText("");
        this.txtDescription.setText("");
        PeriodInfo period = null;
        try {
            period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        this.editData = info = new FaReturnInfo();
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        if (today.before(DateTimeUtils.truncateDate((Date)period.getBeginDate()))) {
            info.setBizDate(period.getBeginDate());
        } else if (today.after(DateTimeUtils.truncateDate((Date)period.getEndDate()))) {
            info.setBizDate(period.getEndDate());
        } else {
            info.setBizDate(today);
        }
        info.setUser(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            try {
                info.setUserDispartment(this.getPrimaryAdminOrgId(info.getUser().getId().toString()));
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        info.setReason("");
        return info;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return new FaReturnEntryInfo();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtReason.setText("");
        this.txtNumber.setText(this.getRuleNumber(this.editData));
        this.pkCreateTime.setValue((Object)new Date());
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        this.prmtAuditor.setValue(null);
        this.pkAuditTime.setValue(null);
        this.txtDescription.setText("");
        this.txtAmounttotal.setValue(null);
        this.prmtUser.setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getPerson());
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            try {
                this.prmtUserDispartment.setValue((Object)this.getPrimaryAdminOrgId(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString()));
            }
            catch (BOSException bOSException) {}
        } else {
            this.prmtUserDispartment.setValue(null);
        }
        try {
            PeriodInfo period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
            if (today.before(DateTimeUtils.truncateDate((Date)period.getBeginDate()))) {
                this.pkBizDate.setValue((Object)period.getBeginDate());
            } else if (today.after(DateTimeUtils.truncateDate((Date)period.getEndDate()))) {
                this.pkBizDate.setValue((Object)period.getEndDate());
            } else {
                this.pkBizDate.setValue((Object)today);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
        this.storeFields();
        this.setDataObject((IObjectValue)this.editData);
    }

    private FaCurCardInfo getCurCardInfo(String curCardID) {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        try {
            SelectorItemCollection sic = new FaCurCardEditUI().getSelectors();
            sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
            curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return curCardInfo;
    }

    private void setTable(List list) throws Exception {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String id = null;
                if (list.get(i) instanceof IRow) {
                    IRow result = (IRow)list.get(i);
                    id = result.getCell("id").getValue().toString();
                } else {
                    id = list.get(i).toString();
                }
                FaCurCardInfo curCard = this.getCurCardInfo(id);
                String str = this.verfyCardISBorrowed(curCard);
                IRow row = this.getDetailTable().addRow();
                FaReturnEntryInfo billInfo = (FaReturnEntryInfo)this.createNewDetailData(this.getDetailTable());
                billInfo.setFaCurCard(curCard);
                billInfo.setBizCard(FaClientUtils.CurCard2BizCard(curCard));
                this.loadLineFields(this.getDetailTable(), row, (IObjectValue)billInfo);
                row.setUserObject((Object)billInfo);
            }
        }
        if (this.getDetailTable().getRowCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaCombinBillEditUI_NoCardCanCombin"));
            SysUtil.abort();
        }
        this.checkCardDup();
    }

    private String verfyCardISBorrowed(FaCurCardInfo curCard) {
        return null;
    }

    @Override
    protected CompanyOrgUnitInfo getCurCompany() {
        Map uicontext = this.getUIContext();
        if (uicontext == null || uicontext.size() == 0) {
            return SysContext.getSysContext().getCurrentFIUnit();
        }
        if (this.currentCompany == null) {
            this.currentCompany = (CompanyOrgUnitInfo)this.initUiInfo.get("currentCompany");
        }
        return (CompanyOrgUnitInfo)this.currentCompany.clone();
    }

    @Override
    protected MetaDataPK getListUIQuery() {
        return new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaCurCardQuery");
    }

    private CommonQueryWithResultDialog initDialog() throws Exception {
        CommonQueryWithResultDialog dialog = new CommonQueryWithResultDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK((IMetaDataPK)this.getListUIQuery());
        dialog.setTitle(this.getUITitle());
        dialog.setHeight(525);
        dialog.setOpenType(-1);
        dialog.setFilterInfo(this.getCardFilter());
        dialog.setUseDefaultFilter(false);
        HashMap hmParam = this.gethmParam();
        boolean isRange = "true".equals(hmParam.get("FA_040").toString());
        FACommonProcessor processor = new FACommonProcessor();
        processor.setRange(isRange);
        dialog.setProcessor((IProcessor)processor);
        dialog.setSelectMode(10);
        return dialog;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("company.id");
        sic.add("checkedStatus");
        sic.add("deletedStatus");
        sic.add("blockedStatus");
        sic.add("effectedStatus");
        sic.add("entry.faBizCard.bizStatus");
        sic.add("entry.faBizCard.lastBillID");
        sic.add("entry.id");
        sic.add("bizStatus");
        return sic;
    }

    protected Set getCardIDSet() {
        HashSet<String> set = new HashSet<String>();
        int n = this.detailTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.detailTable.getRow(i).getUserObject();
            if (!(obj instanceof FaReturnEntryInfo)) continue;
            FaReturnEntryInfo info = (FaReturnEntryInfo)obj;
            set.add(info.getFaCurCard().getId().toString());
        }
        return set;
    }

    @Override
    protected FilterInfo getCardFilter() {
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("hasDisabled", (Object)"0", CompareType.EQUALS));
        f.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        f.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("blockedStatus", (Object)new Integer(1)));
        f.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"%99", CompareType.LIKE));
        if (this.getManageIDSet().size() <= 0) {
            f.getFilterItems().add(new FilterItemInfo("keeper.id", (Object)"0", CompareType.INCLUDE));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource", (String)"FaBorrowingBillNotQuery"));
            SysUtil.abort();
        } else {
            f.getFilterItems().add(new FilterItemInfo("keeper.id", (Object)this.getManageIDSet(), CompareType.INCLUDE));
        }
        f.getFilterItems().add(new FilterItemInfo("id", (Object)"select distinct fcurcardid from t_fa_faborrowingentry where FIsReturned=0", CompareType.INNER));
        StringBuffer sb = new StringBuffer("( #0 ");
        int n = f.getFilterItems().size();
        for (int i = 1; i < n; ++i) {
            sb.append(" and  #").append(i);
        }
        sb.append(" )");
        if (this.editData.getId() != null) {
            f.getFilterItems().add(new FilterItemInfo("id", (Object)("select FCurcardID from T_FA_FaReturnEntry where FParentID='" + this.editData.getId().toString() + "'"), CompareType.INNER));
            sb.append(" or #").append(f.getFilterItems().size() - 1);
        }
        f.setMaskString(sb.toString());
        if (!this.getCardIDSet().isEmpty()) {
            f.setMaskString("(" + f.getMaskString() + ") and #" + f.getFilterItems().size());
            f.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCardIDSet(), CompareType.NOTINCLUDE));
        }
        logger.info((Object)f.toSql());
        return f;
    }

    protected Set getManageIDSet() {
        if (this.manageIDs == null) {
            this.manageIDs = new HashSet();
            try {
                FaTreasuryManageCollection cols = FaTreasuryManageFactory.getRemoteInstance().getFaTreasuryManageCollection();
                if (cols == null) {
                    return this.manageIDs;
                }
                int n = cols.size();
                for (int i = 0; i < n; ++i) {
                    if (cols.get(i).getManage() == null) continue;
                    this.manageIDs.add(cols.get(i).getManage().getId().toString());
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return this.manageIDs;
    }

    protected Set getHasInsertCard() {
        HashSet<String> set = new HashSet<String>();
        int n = this.detailTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.detailTable.getRow(i).getUserObject();
            if (!(obj instanceof FaReturnInfo)) continue;
            set.add(((FaReturnInfo)obj).getId().toString());
        }
        return set;
    }

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    @Override
    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        super.verifyBeforeSubmit(e);
        PeriodInfo period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
        Date bizDate = (Date)this.pkBizDate.getValue();
        if (bizDate.before(period.getBeginDate())) {
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("returnDateError"));
            SysUtil.abort();
        }
        if (bizDate.after(period.getEndDate())) {
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("returnDateError"));
            SysUtil.abort();
        }
        if (this.prmtUser.getValue() == null) {
            this.prmtUser.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("returnNotNull"));
            SysUtil.abort();
        }
        if (this.prmtUserDispartment.getValue() == null) {
            this.prmtUserDispartment.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("returnDepartNotNull"));
            SysUtil.abort();
        }
        if (this.txtReason.getText() == null || this.txtReason.getText().trim().length() == 0) {
            this.txtReason.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)FaCardUtil.getPhysicalResource("returnReasonNotNull"));
            SysUtil.abort();
        }
        if (this.detailTable.getRowCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)new FaPhysicalManageBaseException(FaPhysicalManageBaseException.ENTRY_RETURN_NULL).getMessage());
            SysUtil.abort();
        }
        this.checkCardDup();
    }

    protected void checkCardDup() throws Exception {
        HashMap<String, Integer> cardIDMap = new HashMap<String, Integer>();
        int n = this.detailTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.detailTable.getRow(i).getUserObject();
            if (!(obj instanceof FaReturnEntryInfo)) continue;
            String id = ((FaReturnEntryInfo)obj).getFaCurCard().getId().toString();
            if (cardIDMap.containsKey(id)) {
                throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.CARDDUP, new Object[]{cardIDMap.get(id), new Integer(i + 1)});
            }
            cardIDMap.put(id, new Integer(i + 1));
        }
    }

    @Override
    public void actionAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        if (CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            return;
        }
        CommonQueryWithResultDialog dialog = this.initDialog();
        if (dialog.show() || dialog.hasKeyValue()) {
            this.setTable(dialog.getSearchResult());
        } else {
            SysUtil.abort();
        }
        this.refreshTotalValue();
    }

    @Override
    public void actionDeleteNewLine_actionPerformed(ActionEvent e) throws Exception {
        if (CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            return;
        }
        super.actionRemoveLine_actionPerformed(e);
        this.refreshTotalValue();
    }

    @Override
    public void actionScanPitch_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"handle", (Object)new IAfterScanHandle(){

            @Override
            public void afterScan(CoreUI ui, FaCurCardInfo cardInfo) throws Exception {
                if (cardInfo.isIsBorrowing()) {
                    MsgBox.showInfo((Component)ui, (String)new FaPhysicalManageBaseException(FaPhysicalManageBaseException.ENTRY_BORROW_HASBORROWED, new Object[]{cardInfo.getNumber()}).getMessage());
                    SysUtil.abort();
                }
                if (cardInfo.isIsRequisitioned()) {
                    MsgBox.showInfo((Component)ui, (String)new FaPhysicalManageBaseException(FaPhysicalManageBaseException.ENTRY_BORROW_HASREQUISITIONED, new Object[]{cardInfo.getNumber()}).getMessage());
                    SysUtil.abort();
                }
                if (cardInfo.getCheckedStatus().getValue() != 2) {
                    MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"10_FaRequisitionedBillEditUI"));
                    SysUtil.abort();
                }
            }
        });
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = factory.create(FaScanBarCodesEditUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
        uiWindow.getUIObject().getUIContext().get("keys");
        Set keys = new HashSet();
        keys = (Set)uiWindow.getUIObject().getUIContext().get("keys");
        if (keys == null) {
            return;
        }
        if (keys.size() <= 0) {
            return;
        }
        List<Object> al = Arrays.asList(keys.toArray());
        this.setTable(al);
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    @Override
    protected String getPrintPath() {
        return "/FI/FA/PhysicalManage/FaReturn";
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaReturnEditUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaReturnEditUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnAddNewLine.setEnabled(true);
        this.btnDeleteNewLine.setEnabled(true);
    }
}

