/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlCommonConstant;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaScanBarCodesEditUI;
import com.kingdee.eas.fi.fa.manage.client.IAfterScanHandle;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaScanBarCodesEditUI
extends AbstractFaScanBarCodesEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaScanBarCodesEditUI.class);
    public Set selKeys = new HashSet();
    private IAfterScanHandle afterhandle;

    public IAfterScanHandle getHandle() {
        return this.afterhandle;
    }

    public void setHandle(IAfterScanHandle handle) {
        this.afterhandle = handle;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"29_FaScanBarCodesEditUI"));
        if (this.getUIContext().get("handle") != null) {
            this.setHandle((IAfterScanHandle)this.getUIContext().get("handle"));
        }
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtScanCheck, (KeyStroke)CtrlCommonConstant.KEYSTROKE_ENTER);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRemoveRow.setEnabled(true);
        this.actionRemoveRow.setVisible(true);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    protected void txtScanCheck_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            String strOne = String.valueOf(this.getUIContext().get("oneRecord"));
            if ("true".equals(strOne)) {
                this.tblMain.removeRows();
            }
            String barCode = this.txtScanCheck.getText();
            if ((barCode = barCode.trim()).equals("")) {
                return;
            }
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                ICell cell = row.getCell("barcode");
                String strBarCode = String.valueOf(cell.getValue());
                if (!barCode.equals(strBarCode)) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBarCordResource.barCodeExists");
                MsgBox.showWarning((Component)((Object)this), (String)msg);
                return;
            }
            FaCurCardInfo faCurCardInfo = null;
            IFaCurCard ifcc = FaCurCardFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("hasDisabled"));
            sic.add(new SelectorItemInfo("checkedStatus"));
            sic.add(new SelectorItemInfo("deletedStatus"));
            sic.add(new SelectorItemInfo("effectedStatus"));
            sic.add(new SelectorItemInfo("blockedStatus"));
            sic.add(new SelectorItemInfo("assetName"));
            sic.add(new SelectorItemInfo("bizStatus"));
            sic.add(new SelectorItemInfo("keeper.id"));
            sic.add(new SelectorItemInfo("dept.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.*"));
            sic.add(new SelectorItemInfo("isBorrowing"));
            sic.add(new SelectorItemInfo("isRequisitioned"));
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("barCode", (Object)barCode, CompareType.EQUALS));
            fic.add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            FaCurCardCollection fccCol = ifcc.getFaCurCardCollection(view);
            if (fccCol != null && fccCol.size() > 0) {
                faCurCardInfo = fccCol.get(0);
                if (this.getHandle() != null) {
                    this.getHandle().afterScan(this, faCurCardInfo);
                }
                if (faCurCardInfo.getBizStatus().getValue().toString().indexOf("99") >= 0) {
                    IRow row = this.tblMain.addRow();
                    row.getCell("id").setValue((Object)faCurCardInfo.getId().toString());
                    row.getCell("barcode").setValue((Object)barCode);
                    row.getCell("name").setValue((Object)faCurCardInfo.getAssetName());
                    row.getCell("number").setValue((Object)faCurCardInfo.getNumber());
                } else {
                    String cardStatus = "";
                    Iterator iter = FaBizStatusEnum.iterator();
                    while (iter.hasNext()) {
                        FaBizStatusEnum faBS = (FaBizStatusEnum)((Object)iter.next());
                        if (!faBS.getValue().equals(faCurCardInfo.getBizStatus().getValue().toString())) continue;
                        cardStatus = faBS.getAlias();
                        break;
                    }
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBarCordResource.barCodeNotStatus");
                    msg = MessageFormat.format(msg, barCode, cardStatus);
                    MsgBox.showWarning((Component)((Object)this), (String)msg);
                }
            } else {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBarCordResource.barCodeNotFind");
                msg = MessageFormat.format(msg, barCode);
                MsgBox.showWarning((Component)((Object)this), (String)msg);
            }
            this.txtScanCheck.setText("");
        }
    }

    @Override
    public void actionRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        int selRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (selRow > -1) {
            this.tblMain.removeRow(selRow);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        if ("exit".equals(e.getActionCommand())) {
            this.tblMain.removeRows();
        }
        this.getScanBarcode();
        this.getUIContext().put("keys", this.selKeys);
        this.uiWindow.close();
    }

    protected void getScanBarcode() {
        this.selKeys.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell cell = row.getCell("id");
            Object keyValue = cell.getValue();
            this.selKeys.add(keyValue);
        }
    }
}

