/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeCollection;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeFactory;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.IFaSimulateDeprScheme;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaSimulateDeprConditionUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaSimulateDeprConditionUI
extends AbstractFaSimulateDeprConditionUI {
    private static final long serialVersionUID = 8725960542910534544L;
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDepreciationResource";
    protected CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
    private PeriodInfo startPeriod = null;

    public FaSimulateDeprConditionUI() throws Exception {
        this.init();
    }

    public void onLoad() throws Exception {
        FaClientUtils.checkComp((Component)((Object)this), SysContext.getSysContext().getCurrentFIUnit());
        super.onLoad();
    }

    protected void init() throws Exception {
        this.tblMain.checkParsed();
        this.addListener();
        Integer maxPeriodYear = new Integer(PeriodUtils.getMaxOrMinPeriodYear(null, (String)this.currCompany.getId().toString(), (boolean)true));
        Integer minPeriodYear = new Integer(PeriodUtils.getMaxOrMinPeriodYear(null, (String)this.currCompany.getId().toString(), (boolean)false));
        SpinnerNumberModel startYearSpModel = new SpinnerNumberModel();
        startYearSpModel.setMinimum(minPeriodYear);
        startYearSpModel.setMaximum(maxPeriodYear);
        this.spnStartYear.setModel((SpinnerModel)startYearSpModel);
        SpinnerNumberModel endYearSpModel = new SpinnerNumberModel();
        endYearSpModel.setMinimum(minPeriodYear);
        endYearSpModel.setMaximum(maxPeriodYear);
        this.spnEndYear.setModel((SpinnerModel)endYearSpModel);
        this.tblMain.getColumn("simultSchem").getStyleAttributes().setLocked(true);
        this.setDefaultData();
        this.tblMain.getRow(0).getCell("difCal").getStyleAttributes().setBackground(this.getBackground());
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 400, 300));
        this.kDContainer1.setBounds(new Rectangle(10, 54, 379, 220));
        this.add((Component)this.kDContainer1, new KDLayout.Constraints(10, 54, 379, 220, 15));
        this.kDContainer1.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.kDContainer1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(10, 54, 379, 188));
    }

    protected void addListener() {
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSimulateDeprConditionUI.this.fireYearChange(e);
                FaSimulateDeprConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSimulateDeprConditionUI.this.fireYearChange(e);
                FaSimulateDeprConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnStartNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSimulateDeprConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnEndNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSimulateDeprConditionUI.this.firePeriodChange(e);
            }
        });
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if (colIndex == FaSimulateDeprConditionUI.this.tblMain.getColumnIndex("select") && Boolean.FALSE.equals(e.getValue())) {
                    FaSimulateDeprConditionUI.this.tblMain.getCell(rowIndex, "difCal").setValue((Object)Boolean.FALSE);
                } else if (colIndex == FaSimulateDeprConditionUI.this.tblMain.getColumnIndex("difCal") && Boolean.TRUE.equals(e.getValue())) {
                    FaSimulateDeprConditionUI.this.tblMain.getCell(rowIndex, "select").setValue((Object)Boolean.TRUE);
                }
            }
        });
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo unAuditFilterInfo;
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        FilterItemCollection items = filterInfo.getFilterItems();
        int i = items.size();
        if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            items.add(companyFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.spnEndNumber.getValue() != null) {
            FilterItemInfo greaterStartYear = new FilterItemInfo("period.periodYear", (Object)new Integer(this.spnEndYear.getValue().toString()), CompareType.LESS);
            items.add(greaterStartYear);
            FilterItemInfo equalsStartYear = new FilterItemInfo("period.periodYear", (Object)new Integer(this.spnEndYear.getValue().toString()), CompareType.EQUALS);
            items.add(equalsStartYear);
            FilterItemInfo startPeriod = new FilterItemInfo("period.periodNumber", (Object)new Integer(this.spnEndNumber.getValue().toString()), CompareType.LESS_EQUALS);
            items.add(startPeriod);
            sbFormula.append(" and (#" + i++ + " or ( #" + i++ + " and #" + i++ + "))");
        }
        if (!this.ckbUnAuditCanDper.isSelected()) {
            unAuditFilterInfo = new FilterItemInfo("checkedStatus", (Object)new Integer(2));
            items.add(unAuditFilterInfo);
            sbFormula.append(" and #" + i++);
        }
        if (!this.ckbHasClrCanDepr.isSelected()) {
            unAuditFilterInfo = new FilterItemInfo("deletedStatus", (Object)new Integer(1));
            items.add(unAuditFilterInfo);
            sbFormula.append(" and #" + i++);
        }
        FilterItemInfo effectilterInfo = new FilterItemInfo("effectedStatus", (Object)new Integer(2));
        items.add(effectilterInfo);
        sbFormula.append(" and #" + i++);
        filterInfo.setMaskString(sbFormula.toString());
        this.setCustomerParams(this.getCustParams());
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.getCustomerParams();
        if (params == null) {
            return;
        }
        this.spnStartYear.setValue((Object)new Integer(params.getInt("startYear")));
        this.spnStartNumber.setValue((Object)new Integer(params.getInt("startNumber")));
        this.spnEndYear.setValue((Object)new Integer(params.getInt("endYear")));
        this.spnEndNumber.setValue((Object)new Integer(params.getInt("endNumber")));
        this.ckbUnAuditCanDper.setSelected(params.getBoolean("displayUnAudit"));
        this.ckbHasClrCanDepr.setSelected(params.getBoolean("displayHasClear"));
        if (params.getMe("row1") != null) {
            CustomerParams row1 = params.getMe("row1");
            this.tblMain.getRow(0).getCell("select").setValue((Object)row1.getBoolean("select"));
        }
        if (params.getMe("row2") != null) {
            CustomerParams row2 = params.getMe("row2");
            this.tblMain.getRow(1).getCell("select").setValue((Object)row2.getBoolean("select"));
            this.tblMain.getRow(1).getCell("difCal").setValue((Object)row2.getBoolean("difCal"));
        }
        if (params.getMe("row3") != null) {
            CustomerParams row3 = params.getMe("row3");
            this.tblMain.getRow(2).getCell("select").setValue((Object)row3.getBoolean("select"));
            this.tblMain.getRow(2).getCell("difCal").setValue((Object)row3.getBoolean("difCal"));
        }
        for (int i = 3; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("difCal").setValue((Object)Boolean.FALSE);
            FaSimulateDeprSchemeInfo SDSInfo = (FaSimulateDeprSchemeInfo)row.getCell("simultSchem").getValue();
            CustomerParams scheme = params.getMe(SDSInfo.getId().toString());
            if (scheme == null) continue;
            row.getCell("select").setValue((Object)Boolean.TRUE);
            row.getCell("difCal").setValue((Object)scheme.getBoolean("isDiff"));
        }
    }

    private FaSimulateDeprSchemeCollection getSDSchemeCollection() {
        FaSimulateDeprSchemeCollection SDSColl = new FaSimulateDeprSchemeCollection();
        try {
            IFaSimulateDeprScheme iScheme = FaSimulateDeprSchemeFactory.getRemoteInstance();
            for (int i = 1; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                Boolean select = (Boolean)row.getCell("select").getValue();
                if (!select.booleanValue()) continue;
                FaSimulateDeprSchemeInfo SDSInfo = null;
                if (i < 3) {
                    SDSInfo = new FaSimulateDeprSchemeInfo();
                    SDSInfo.put("IS_FOR_TAX", (Object)(i == 2 ? Boolean.TRUE : Boolean.FALSE));
                    SDSInfo.setNumber(i == 2 ? "TAX" : "NORMAL");
                    SDSInfo.setName(i == 2 ? EASResource.getString((String)RES_PATH, (String)"taxCalcMode") : EASResource.getString((String)RES_PATH, (String)"norCalcMode"));
                } else {
                    SDSInfo = iScheme.getFaSimulateDeprSchemeInfo("select *,deprMode.*,deprPolicy.* where id='" + ((FaSimulateDeprSchemeInfo)row.getCell("simultSchem").getValue()).getId() + "'");
                }
                SDSInfo.put("isDiff", row.getCell("difCal").getValue());
                SDSColl.add(SDSInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return SDSColl;
    }

    private CustomerParams getCustParams() {
        CustomerParams params = new CustomerParams();
        params.putInt("startYear", this.spnStartYear.getIntegerVlaue().intValue());
        params.putInt("startNumber", this.spnStartNumber.getIntegerVlaue().intValue());
        params.putInt("endYear", this.spnEndYear.getIntegerVlaue().intValue());
        params.putInt("endNumber", this.spnEndNumber.getIntegerVlaue().intValue());
        params.putBoolean("displayUnAudit", this.ckbUnAuditCanDper.isSelected());
        params.putBoolean("displayHasClear", this.ckbHasClrCanDepr.isSelected());
        this.spnEndYear.setValue((Object)new Integer(params.getInt("endYear")));
        this.spnEndNumber.setValue((Object)new Integer(params.getInt("endNumber")));
        this.ckbUnAuditCanDper.setSelected(params.getBoolean("displayUnAudit"));
        this.ckbHasClrCanDepr.setSelected(params.getBoolean("displayHasClear"));
        CustomerParams row1 = new CustomerParams();
        row1.putBoolean("select", ((Boolean)this.tblMain.getRow(0).getCell("select").getValue()).booleanValue());
        params.putMe("row1", row1);
        CustomerParams row2 = new CustomerParams();
        row2.putBoolean("select", ((Boolean)this.tblMain.getRow(1).getCell("select").getValue()).booleanValue());
        row2.putBoolean("difCal", ((Boolean)this.tblMain.getRow(1).getCell("difCal").getValue()).booleanValue());
        params.putMe("row2", row2);
        CustomerParams row3 = new CustomerParams();
        row3.putBoolean("select", ((Boolean)this.tblMain.getRow(2).getCell("select").getValue()).booleanValue());
        row3.putBoolean("difCal", ((Boolean)this.tblMain.getRow(2).getCell("difCal").getValue()).booleanValue());
        params.putMe("row3", row3);
        for (int i = 3; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean select = (Boolean)row.getCell("select").getValue();
            if (!select.booleanValue()) continue;
            FaSimulateDeprSchemeInfo SDSInfo = (FaSimulateDeprSchemeInfo)row.getCell("simultSchem").getValue();
            CustomerParams scheme = new CustomerParams();
            scheme.putBoolean("isDiff", ((Boolean)row.getCell("difCal").getValue()).booleanValue());
            params.putMe(SDSInfo.getId().toString(), scheme);
        }
        return params;
    }

    private void fireYearChange(ChangeEvent e) {
        int periodYear = e.getSource() == this.spnStartYear ? this.spnStartYear.getIntegerVlaue().intValue() : this.spnEndYear.getIntegerVlaue().intValue();
        try {
            Integer minPeriodNumber = new Integer(PeriodUtils.getMinPeriodNumber(null, (int)periodYear, (String)this.currCompany.getId().toString()));
            Integer maxPeriodNumber = new Integer(PeriodUtils.getMaxPeriodNumber(null, (int)periodYear, (String)this.currCompany.getId().toString()));
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            periodSpinnerNumberModel.setMinimum(minPeriodNumber);
            periodSpinnerNumberModel.setMaximum(maxPeriodNumber);
            if (periodYear == this.getStartPeriod().getPeriodYear()) {
                minPeriodNumber = new Integer(this.getStartPeriod().getPeriodNumber());
                periodSpinnerNumberModel.setMinimum(minPeriodNumber);
            }
            if (e.getSource() == this.spnStartYear) {
                this.spnStartNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
                this.spnStartNumber.setValue((Object)minPeriodNumber);
                if (this.spnEndYear.getIntegerVlaue() - periodYear > 0) {
                    this.spnEndYear.setValue((Object)new Integer(periodYear));
                    if (this.isNeedToSetSpnNumber()) {
                        this.spnEndNumber.setValue((Object)maxPeriodNumber);
                    }
                }
            } else {
                this.spnEndNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
                this.spnEndNumber.setValue((Object)minPeriodNumber);
                if (periodYear - this.spnStartYear.getIntegerVlaue() > 0) {
                    this.spnStartYear.setValue((Object)new Integer(periodYear - 1));
                    if (this.isNeedToSetSpnNumber()) {
                        this.spnStartNumber.setValue((Object)new Integer(minPeriodNumber + 1));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartNumber) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndNumber.setValue(this.spnStartNumber.getValue());
            } else {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartNumber.setValue(this.spnEndNumber.getValue());
            }
        }
        try {
            if (e.getSource() == this.spnStartNumber && this.spnStartYear.getIntegerVlaue() < this.spnEndYear.getIntegerVlaue()) {
                if (this.spnStartNumber.getIntegerVlaue() - 1 > 0) {
                    if (this.isNeedToSetSpnNumber()) {
                        this.spnEndNumber.setValue((Object)new Integer(this.spnStartNumber.getIntegerVlaue() - 1));
                    }
                } else {
                    int periodYear = this.spnStartYear.getIntegerVlaue();
                    Integer maxPeriodNumber = new Integer(PeriodUtils.getMaxPeriodNumber(null, (int)periodYear, (String)this.currCompany.getId().toString()));
                    this.spnEndYear.setValue(this.spnStartYear.getValue());
                    this.spnEndNumber.setValue((Object)maxPeriodNumber);
                }
            } else if (e.getSource() == this.spnEndNumber && this.spnStartYear.getIntegerVlaue() < this.spnEndYear.getIntegerVlaue()) {
                int periodYear = this.spnStartYear.getIntegerVlaue();
                Integer maxPeriodNumber = new Integer(PeriodUtils.getMaxPeriodNumber(null, (int)periodYear, (String)this.currCompany.getId().toString()));
                if (this.spnStartNumber.getIntegerVlaue() + 1 <= maxPeriodNumber) {
                    if (this.isNeedToSetSpnNumber()) {
                        this.spnStartNumber.setValue((Object)new Integer(this.spnEndNumber.getIntegerVlaue() + 1));
                    }
                } else {
                    periodYear = this.spnEndYear.getIntegerVlaue();
                    Integer minPeriodNumber = new Integer(PeriodUtils.getMinPeriodNumber(null, (int)periodYear, (String)this.currCompany.getId().toString()));
                    this.spnStartYear.setValue(this.spnEndYear.getValue());
                    this.spnStartNumber.setValue((Object)minPeriodNumber);
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private boolean isNeedToSetSpnNumber() throws Exception {
        int totalPeriod = 0;
        int startYear = this.spnStartYear.getIntegerVlaue();
        int startNumber = this.spnStartNumber.getIntegerVlaue();
        PeriodInfo startPeriodInfo = PeriodUtils.getPeriodInfo((int)startYear, (int)startNumber, (CompanyOrgUnitInfo)this.currCompany);
        int endYear = this.spnEndYear.getIntegerVlaue();
        int endNumber = this.spnEndNumber.getIntegerVlaue();
        PeriodInfo endPeriodInfo = PeriodUtils.getPeriodInfo((int)endYear, (int)endNumber, (CompanyOrgUnitInfo)this.currCompany);
        PeriodCollection periodCollection = PeriodUtils.getPeriodc((PeriodInfo)startPeriodInfo, (PeriodInfo)endPeriodInfo, (CompanyOrgUnitInfo)this.currCompany);
        for (int i = 0; i < periodCollection.size(); ++i) {
            PeriodInfo periodInfo = periodCollection.get(i);
            if (periodInfo.isIsAdjustPeriod()) continue;
            ++totalPeriod;
        }
        return totalPeriod > 12;
    }

    private void setDefaultData() {
        try {
            this.ckbUnAuditCanDper.setSelected(false);
            this.ckbHasClrCanDepr.setSelected(false);
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
            this.spnStartYear.setValue((Object)defaultYear);
            this.spnStartNumber.setValue((Object)defaultNumber);
            this.spnEndYear.setValue((Object)defaultYear);
            this.spnEndNumber.setValue((Object)defaultNumber);
            this.setDefaultTableData();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setDefaultTableData() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        view.setFilter(filterInfo);
        FaSimulateDeprSchemeCollection coll = FaSimulateDeprSchemeFactory.getRemoteInstance().getFaSimulateDeprSchemeCollection(view);
        this.tblMain.removeRows();
        IRow row1 = this.tblMain.addRow();
        row1.getCell("select").setValue((Object)Boolean.FALSE);
        row1.getCell("difCal").setValue((Object)Boolean.FALSE);
        row1.getCell("difCal").getStyleAttributes().setLocked(true);
        row1.getCell("simultSchem").setValue((Object)EASResource.getString((String)RES_PATH, (String)"assetValue"));
        row1.getCell("simultSchem").getStyleAttributes().setLocked(true);
        IRow row2 = this.tblMain.addRow();
        row2.getCell("select").setValue((Object)Boolean.FALSE);
        row2.getCell("difCal").setValue((Object)Boolean.FALSE);
        row2.getCell("simultSchem").setValue((Object)EASResource.getString((String)RES_PATH, (String)"norCalcMode"));
        row2.getCell("simultSchem").getStyleAttributes().setLocked(true);
        IRow row3 = this.tblMain.addRow();
        row3.getCell("select").setValue((Object)Boolean.FALSE);
        row3.getCell("difCal").setValue((Object)Boolean.FALSE);
        row3.getCell("simultSchem").setValue((Object)EASResource.getString((String)RES_PATH, (String)"taxCalcMode"));
        row3.getCell("simultSchem").getStyleAttributes().setLocked(true);
        for (int i = 0; i < coll.size(); ++i) {
            FaSimulateDeprSchemeInfo info = coll.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("difCal").setValue((Object)Boolean.FALSE);
            row.getCell("simultSchem").setValue((Object)info);
        }
    }

    public Map getQueryParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startYear", this.spnStartYear.getValue());
        params.put("endYear", this.spnEndYear.getValue());
        params.put("startNumber", this.spnStartNumber.getValue());
        params.put("endNumber", this.spnEndNumber.getValue());
        params.put("scheme", this.getSDSchemeCollection());
        params.put("showOriAccuDepr", (Boolean)this.tblMain.getRow(0).getCell("select").getValue());
        return params;
    }

    public boolean verify() {
        int num = 0;
        int selectNum = 0;
        for (int i = 1; i < this.tblMain.getRowCount(); ++i) {
            if (Boolean.TRUE.equals(this.tblMain.getCell(i, "difCal").getValue())) {
                ++num;
            }
            if (!Boolean.TRUE.equals(this.tblMain.getCell(i, "select").getValue())) continue;
            ++selectNum;
        }
        if (selectNum == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"SelectScheme"));
            return false;
        }
        if (num == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"LessThan2Scheme"));
            return false;
        }
        if (num > 2) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"MoreThan2Scheme"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    public void clear() {
        super.clear();
        this.setDefaultData();
    }

    public PeriodInfo getStartPeriod() throws EASBizException, BOSException {
        if (this.startPeriod == null) {
            this.startPeriod = FaClientUtils.getFAStartPeriod();
        }
        return this.startPeriod;
    }
}

