/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeCollection;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeFactory;
import com.kingdee.eas.fi.fa.basedata.FaSimulateDeprSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.IFaSimulateDeprScheme;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaSimulateDeprUI;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaSimulateDeprConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public class FaSimulateDeprUI
extends AbstractFaSimulateDeprUI {
    private static final long serialVersionUID = 443243412458107981L;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog dialog;
    private EntityViewInfo ev;
    private FaSimulateDeprConditionUI conditionPanel;
    private CompanyOrgUnitInfo company;
    private int baseScale = 4;
    private String periodDeprStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"SimulateDeprPeriodDepr");
    private String accuDeprStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"SimulateDeprAccuDepr");
    private String totalUpStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"TotalUp");
    private String partTotalUp = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"partTotalUp");

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        super.onLoad();
        FaClientUtils.checkComp((Component)((Object)this), SysContext.getSysContext().getCurrentFIUnit());
        this.baseScale = FaClientUtils.getCurrencyScale(this.company.getBaseCurrency().getId());
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.tblMain.getGroupManager().setGroup(true);
        String[] groupName = new String[]{"assetNum", "assetName", "assetCat"};
        int size = groupName.length;
        for (int i = 0; i < size; ++i) {
            this.tblMain.getColumn(groupName[i]).setGroup(true);
            this.tblMain.getColumn(groupName[i]).setMergeable(true);
        }
        FaClientUtils.changeTableNumberFormat(this.tblMain, new String[]{"accuTTerm", "accuDepr"}, FaClientUtils.getDecimalFormat(this.baseScale));
        this.isFirstDefaultQuery = true;
        this.actionQuery_actionPerformed(null);
        this.enableExportExcel(this.tblMain);
        FaClientUtils.freezeTable((KDTable)this.tblMain, (int)5);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected boolean isCanCopyPaste() {
        return false;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.popFilterDialog();
    }

    protected void popFilterDialog() throws Exception {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (this.dialog == null) {
            this.initCommonQueryDialog();
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = "com.kingdee.eas.fi.fa.manage.FaSimuDeprQuery";
        String currUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName, company.getId().toString(), currUserID)) {
            QuerySolutionInfo solution;
            this.isFirstDefaultQuery = false;
            this.ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(((Object)((Object)this)).getClass().getName(), queryName, company.getId().toString(), currUserID);
            if (this.ev == null) {
                this.ev = new EntityViewInfo();
            }
            if (this.ev.getFilter() == null) {
                this.ev.setFilter(new FilterInfo());
            }
            if ((solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName, company.getId().toString(), currUserID)) == null) {
                if (this.isFirstDefaultQuery) {
                    this.isFirstDefaultQuery = false;
                }
                if (this.dialog.show()) {
                    this.ev = null;
                    this.refreshList();
                } else {
                    SysUtil.abort();
                }
            } else if (solution.getName().equals(FaResUtil.getRes((String)"defaultSolution"))) {
                this.conditionPanel.onLoad();
                this.conditionPanel.loadData(this.ev);
                if (!this.conditionPanel.verify()) {
                    if (this.dialog.show()) {
                        this.refreshList();
                    } else {
                        SysUtil.abort();
                    }
                }
            } else {
                QueryPanelCollection queryPanels = solution.getQueryPanelInfo();
                QueryPanelInfo queryPanel = queryPanels.get(0);
                int size = queryPanels.size();
                for (int i = 0; i < size; ++i) {
                    if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                    queryPanel = queryPanels.get(i);
                    break;
                }
                if (queryPanel.getCustomerParams() == null) {
                    if (this.dialog.show()) {
                        this.refreshList();
                    } else {
                        SysUtil.abort();
                    }
                } else {
                    CustomerParams param = XMLBean.TransStrToCustParams((String)queryPanel.getCustomerParams());
                    this.conditionPanel.setCustomerParams(param);
                    this.conditionPanel.onLoad();
                    this.conditionPanel.loadData(this.ev);
                    if (!this.conditionPanel.verify()) {
                        if (this.dialog.show()) {
                            this.refreshList();
                        } else {
                            SysUtil.abort();
                        }
                    } else {
                        this.refreshList();
                    }
                }
            }
        } else {
            if (this.isFirstDefaultQuery) {
                this.isFirstDefaultQuery = false;
            }
            if (this.dialog.show()) {
                this.ev = null;
                this.refreshList();
            } else {
                SysUtil.abort();
            }
        }
    }

    private void refreshList() throws BOSException, EASBizException {
        int lastIndex;
        if (this.ev == null || this.ev.getFilter() == null || this.ev.getFilter().getFilterItems().size() == 0) {
            this.ev = this.dialog.getEntityViewInfoResult();
        }
        if (this.ev == null || this.ev.getFilter() == null || this.ev.getFilter().getFilterItems().size() == 0) {
            return;
        }
        this.ev.put("params", (Object)this.conditionPanel.getQueryParams());
        int startDynIdx = this.tblMain.getColumnIndex("accuDepr") + 1;
        for (int i = lastIndex = this.tblMain.getColumnCount() - 1; i >= startDynIdx; --i) {
            this.tblMain.removeColumn(i);
        }
        this.tblMain.removeRows();
        FaSimulateDeprSchemeCollection schemes = this.getSchemes();
        for (int i = 0; i < schemes.size(); ++i) {
            String keyNumber = schemes.get(i).getNumber();
            String keyName = schemes.get(i).getName();
            IColumn column = this.tblMain.addColumn();
            column.setKey(keyNumber + "1");
            int idx1 = column.getColumnIndex();
            column = this.tblMain.addColumn();
            column.setKey(keyNumber + "2");
            int idx2 = column.getColumnIndex();
            this.tblMain.getHeadMergeManager().mergeBlock(0, idx1, 0, idx2);
            this.tblMain.getHeadRow(0).getCell(idx1).setValue((Object)keyName);
            this.tblMain.getHeadRow(1).getCell(idx1).setValue((Object)this.periodDeprStr);
            this.tblMain.getHeadRow(1).getCell(idx2).setValue((Object)this.accuDeprStr);
            FaClientUtils.changeTableNumberFormat(this.tblMain, new String[]{keyNumber + "1", keyNumber + "2"}, FaClientUtils.getDecimalFormat(this.baseScale));
        }
        Map inParam = this.conditionPanel.getQueryParams();
        boolean showOriAccuDepr = (Boolean)inParam.get("showOriAccuDepr");
        this.tblMain.getColumn("accuTTerm").getStyleAttributes().setHided(!showOriAccuDepr);
        this.tblMain.getColumn("accuDepr").getStyleAttributes().setHided(!showOriAccuDepr);
        IFaDepCalFacade iFaDep = FaDepCalFacadeFactory.getRemoteInstance();
        List result = iFaDep.emuRangeCalDep(this.ev);
        if (result.size() == 0) {
            return;
        }
        int startYear = (Integer)inParam.get("startYear");
        int endYear = (Integer)inParam.get("endYear");
        int startNumber = (Integer)inParam.get("startNumber");
        int endNumber = (Integer)inParam.get("endNumber");
        FaSimulateDeprSchemeCollection allSchemes = (FaSimulateDeprSchemeCollection)inParam.get("scheme");
        IFaSimulateDeprScheme iScheme = FaSimulateDeprSchemeFactory.getRemoteInstance();
        String[] diffCalNum = new String[2];
        String[] diffCalName = new String[2];
        for (int i = 0; i < allSchemes.size(); ++i) {
            if (allSchemes.get(i).get("isdiff") == null || !((Boolean)allSchemes.get(i).get("isdiff")).booleanValue()) continue;
            FaSimulateDeprSchemeInfo schemeInfo = null;
            schemeInfo = allSchemes.get(i).get("IS_FOR_TAX") != null ? allSchemes.get(i) : iScheme.getFaSimulateDeprSchemeInfo("select name,number where id='" + allSchemes.get(i).getId() + "'");
            if (diffCalNum[0] == null) {
                diffCalNum[0] = schemeInfo.getNumber();
                diffCalName[0] = schemeInfo.getName();
                continue;
            }
            diffCalNum[1] = schemeInfo.getNumber();
            diffCalName[1] = schemeInfo.getName();
            break;
        }
        PeriodInfo startPeriod = PeriodUtils.getPeriodInfo(null, (int)startYear, (int)startNumber, (CompanyOrgUnitInfo)this.company);
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo(null, (int)endYear, (int)endNumber, (CompanyOrgUnitInfo)this.company);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.truncateDate((Date)endPeriod.getEndDate()));
        cal.add(5, 1);
        EntityViewInfo periodView = new EntityViewInfo();
        FilterInfo periodFilter = new FilterInfo();
        periodView.setFilter(periodFilter);
        periodFilter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE));
        periodFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateTimeUtils.truncateDate((Date)startPeriod.getBeginDate()), CompareType.GREATER_EQUALS));
        periodFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)cal.getTime(), CompareType.LESS_EQUALS));
        periodFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)startPeriod.getPeriodType().getId().toString()));
        PeriodCollection periods = PeriodFactory.getRemoteInstance().getPeriodCollection(periodView);
        if (periods.size() == 0) {
            return;
        }
        Object[] periodArray = periods.toArray();
        Arrays.sort(periodArray, new Comparator(){

            public int compare(Object _p1, Object _p2) {
                PeriodInfo p1 = (PeriodInfo)_p1;
                PeriodInfo p2 = (PeriodInfo)_p2;
                return p1.getPeriodYear() * 1000 + p1.getPeriodNumber() - p2.getPeriodYear() * 1000 - p2.getPeriodNumber();
            }
        });
        for (int i = 0; i < result.size(); ++i) {
            HashMap cardData = (HashMap)result.get(i);
            ArrayList lineDatas = (ArrayList)cardData.get("collection");
            for (int j = 0; j < lineDatas.size(); ++j) {
                HashMap lineMap = (HashMap)lineDatas.get(j);
                IRow row = this.tblMain.addRow();
                row.getCell("card.id").setValue(cardData.get("id"));
                row.getCell("assetCat").setValue(cardData.get("assetCat"));
                row.getCell("assetNum").setValue(cardData.get("assetNumber"));
                row.getCell("assetName").setValue(cardData.get("assetName"));
                row.getCell("period").setValue(lineMap.get("period"));
                row.getCell("accuTTerm").setValue(lineMap.get("deprTTerm"));
                row.getCell("accuDepr").setValue(lineMap.get("accuDepr"));
                int periodYear = (Integer)lineMap.get("periodyear");
                int periodNumber = (Integer)lineMap.get("periodnum");
                List schemeDatas = (List)cardData.get("period" + periodYear + periodNumber);
                for (int k = startDynIdx; k < schemeDatas.size() + startDynIdx; ++k) {
                    BigDecimal val = (BigDecimal)schemeDatas.get(k - startDynIdx);
                    row.getCell(k).setValue((Object)(val == null ? ZERO : val));
                }
            }
        }
        int rowCount = this.tblMain.getRowCount();
        this.insertTotalUp(result, periodArray, 0, rowCount - 1, true, null);
        HashSet subResult = new HashSet();
        String lastAssetName = null;
        for (int i = rowCount - 1; i >= 0; --i) {
            String assetName = this.tblMain.getRow(i).getCell("assetCat").getValue().toString();
            if (subResult.size() == 0) {
                subResult.add(result.get(i / periodArray.length));
                lastAssetName = assetName;
                continue;
            }
            if (lastAssetName.equals(assetName)) {
                subResult.add(result.get(i / periodArray.length));
                continue;
            }
            this.insertTotalUp(subResult, periodArray, i + 1, i + subResult.size() * periodArray.length, false, lastAssetName);
            subResult.clear();
            subResult.add(result.get(i / periodArray.length));
            lastAssetName = assetName;
        }
        this.insertTotalUp(subResult, periodArray, 0, subResult.size() * periodArray.length - 1, false, lastAssetName);
        if (diffCalNum[0] != null && diffCalNum[1] != null) {
            String diffStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"SimulateDeprDiff");
            IColumn column = this.tblMain.addColumn();
            column.setKey(diffCalNum[0] + "3");
            int idx1 = column.getColumnIndex();
            column = this.tblMain.addColumn();
            column.setKey(diffCalNum[1] + "4");
            int idx2 = column.getColumnIndex();
            this.tblMain.getHeadMergeManager().mergeBlock(0, idx1, 0, idx2);
            this.tblMain.getHeadRow(0).getCell(idx1).setValue((Object)(diffStr + "(" + diffCalName[0] + " vs " + diffCalName[1] + ")"));
            this.tblMain.getHeadRow(1).getCell(idx1).setValue((Object)this.periodDeprStr);
            this.tblMain.getHeadRow(1).getCell(idx2).setValue((Object)this.accuDeprStr);
            FaClientUtils.changeTableNumberFormat(this.tblMain, new String[]{diffCalNum[0] + "3", diffCalNum[1] + "4"}, FaClientUtils.getDecimalFormat(this.baseScale));
            int fromIdx = this.tblMain.getColumnIndex(diffCalNum[0] + "1");
            int toIdx = this.tblMain.getColumnIndex(diffCalNum[1] + "1");
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                BigDecimal from1 = (BigDecimal)row.getCell(fromIdx).getValue();
                BigDecimal from2 = (BigDecimal)row.getCell(toIdx).getValue();
                BigDecimal to1 = (BigDecimal)row.getCell(fromIdx + 1).getValue();
                BigDecimal to2 = (BigDecimal)row.getCell(toIdx + 1).getValue();
                row.getCell(idx1).setValue((Object)from2.subtract(from1));
                row.getCell(idx2).setValue((Object)to2.subtract(to1));
            }
        }
        this.tblMain.getGroupManager().group();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            boolean isTotalUpRow;
            boolean bl = isTotalUpRow = this.tblMain.getRow(i).getCell("card.id").getValue() == null;
            if (!isTotalUpRow) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
        }
    }

    private void insertTotalUp(Collection result, Object[] periodArray, int fromIdx, int toIdx, boolean isTotal, String assetName) {
        int i;
        int startCalcIndex = this.tblMain.getColumnIndex("accuTTerm");
        BigDecimal[] total = new BigDecimal[this.tblMain.getColumnCount() - startCalcIndex];
        for (i = 0; i < total.length; ++i) {
            total[i] = new BigDecimal("0");
        }
        for (i = 0; i < periodArray.length; ++i) {
            int j;
            IRow row = this.tblMain.addRow(toIdx + i + 1);
            for (j = fromIdx; j <= toIdx; j += periodArray.length) {
                for (int k = startCalcIndex; k < this.tblMain.getColumnCount(); ++k) {
                    BigDecimal cellVal = new BigDecimal(this.tblMain.getRow(i + j).getCell(k).getValue().toString());
                    total[k - startCalcIndex] = total[k - startCalcIndex].add(cellVal);
                }
            }
            for (j = 0; j < total.length; ++j) {
                row.getCell(startCalcIndex + j).setValue((Object)total[j]);
                total[j] = new BigDecimal("0");
            }
            if (isTotal) {
                row.getCell("assetCat").setValue((Object)this.totalUpStr);
            } else {
                row.getCell("assetCat").setValue((Object)assetName);
                row.getCell("assetNum").setValue((Object)this.partTotalUp);
            }
            row.getCell("period").setValue((Object)(((PeriodInfo)periodArray[i]).getPeriodYear() + "-" + ((PeriodInfo)periodArray[i]).getPeriodNumber()));
            row.getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
        }
    }

    private FaSimulateDeprSchemeCollection getSchemes() throws BOSException, EASBizException {
        FaSimulateDeprSchemeCollection schemes = (FaSimulateDeprSchemeCollection)((Map)this.ev.get("params")).get("scheme");
        if (schemes == null) {
            return new FaSimulateDeprSchemeCollection();
        }
        return schemes;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    protected void initCommonQueryDialog() throws Exception {
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.dialog.setShowSorter(false);
        this.dialog.setShowToolbar(true);
        this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource.FaSimuDepr_QueryTitle"));
        this.dialog.setFilterPanelName(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource.FaSimuDepr_FilterPanelTitle"));
        MetaDataPK queryFaCurCardQueryPK = new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaSimuDeprQuery");
        this.dialog.setQueryObjectPK((IMetaDataPK)queryFaCurCardQueryPK);
        this.conditionPanel = new FaSimulateDeprConditionUI();
        this.dialog.addUserPanel((KDPanel)this.conditionPanel);
        FACommonProcessor process = new FACommonProcessor();
        process.set("parentDialog", this.dialog);
        this.dialog.setProcessor((IProcessor)process);
        this.dialog.setHeight(300);
        this.dialog.setWidth(400);
        this.dialog.setShowFieldCompare(false);
    }
}

