/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTextFieldUI;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AddressCollection;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaStockDataImportUI;
import com.kingdee.eas.fi.fa.manage.excelUtils.Excel2003Util;
import com.kingdee.eas.fi.fa.manage.excelUtils.Excel2007Util;
import com.kingdee.eas.fi.fa.manage.excelUtils.ExcelUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.TextUI;
import org.apache.log4j.Logger;

public class FaStockDataImportUI
extends AbstractFaStockDataImportUI {
    private static final Logger logger = CoreUIObject.getLogger(FaStockDataImportUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaStocktakingResource";
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource";
    private static final String EXCEL2003 = "excel97-2003(.xls)";
    private static final String EXCEL2007 = "excel2007(.xlsx)";
    private static final String EXCEL2003_SUFFIX = ".xls";
    private static final String EXCEL2007_SUFFIX = ".xlsx";
    private KDFileChooser chooser = new KDFileChooser();

    public FaStockDataImportUI() throws Exception {
        this.chooser.setFileFilter((FileFilter)new FileNameExtensionFilter(EXCEL2007, "xlsx"));
        this.chooser.setFileFilter((FileFilter)new FileNameExtensionFilter(EXCEL2003, "xls"));
        this.chooser.setAcceptAllFileFilterUsed(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        KingdeeTextFieldUI ui = new KingdeeTextFieldUI((JComponent)this.txtFilePath){

            protected void paintBackground(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.tf.getWidth(), this.tf.getHeight());
            }
        };
        this.txtFilePath.setUI((TextUI)ui);
        this.txtFilePath.setEditable(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOpenFile.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.btnConfirm.setEnabled(true);
        this.btnCancle.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionFileOpen.setEnabled(true);
    }

    @Override
    public void actionFileOpen_actionPerformed(ActionEvent e) throws Exception {
        int rVal = this.chooser.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            this.txtFilePath.setText(this.chooser.getSelectedFile().toString());
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilePath.getText();
        if (path == null || path.trim().length() == 0) {
            this.txtFilePath.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"select_file_first"));
            return;
        }
        if (!new File(path).exists()) {
            this.txtFilePath.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"file_not_found"));
            return;
        }
        this.checkFile(path);
        this.disposeUIWindow();
    }

    private boolean isCN(char ch, boolean withPreCN) {
        boolean b;
        boolean bl = b = ch >= '\u4e00' && ch <= '\u9fa5' || "\uff01\uff0c\u3002\uff1f\uff1a\u201c\u201d\u2018\u2019\uff0b\uff0d\u00d7\u00f7\u3001\u3010\u3011\u300e\u300f\uff5e".indexOf(ch) != -1;
        if (!b && withPreCN) {
            return ",.:;!?-_ \u3000".indexOf(ch) != -1;
        }
        return b;
    }

    private boolean verifyImport(String[] temps) {
        String message = null;
        if (EASResource.getString((String)RES_PATH, (String)"141_FaStockDataExportUI").equals(temps[1])) {
            return true;
        }
        if (temps[0] == null || temps[0].equals("")) {
            message = EASResource.getString((String)RESOURCE_PATH, (String)"file_barcode_not_null");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return false;
        }
        if (temps.length == 11) {
            if (temps[1] == null || temps[1].equals("")) {
                message = EASResource.getString((String)RESOURCE_PATH, (String)"file_number_not_null");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
        } else if (temps.length != 11) {
            message = EASResource.getString((String)RESOURCE_PATH, (String)"file_format_iserror");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return false;
        }
        char[] numberChr = temps[0].toCharArray();
        char[] tempChr = temps[1].toCharArray();
        for (int i = 0; i < numberChr.length; ++i) {
            if (!this.isCN(numberChr[i], false)) continue;
            message = EASResource.getString((String)RESOURCE_PATH, (String)"numberNoChanese");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return false;
        }
        for (int j = 0; j < tempChr.length; ++j) {
            if (!this.isCN(tempChr[j], false)) continue;
            message = EASResource.getString((String)RESOURCE_PATH, (String)"countNoChanese");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return false;
        }
        if (temps[1].indexOf("-") != -1) {
            message = EASResource.getString((String)RESOURCE_PATH, (String)"countNoNagitive");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return false;
        }
        return true;
    }

    private void checkFile(String path) {
        try {
            ExcelUtils excelUtils = null;
            if (path.endsWith(EXCEL2003_SUFFIX)) {
                excelUtils = new Excel2003Util(path, null);
            } else if (path.endsWith(EXCEL2007_SUFFIX)) {
                excelUtils = new Excel2007Util(path, null);
            } else {
                String message = EASResource.getString((String)RESOURCE_PATH, (String)"onlyOpenExcelFile");
                throw new Exception(message);
            }
            ArrayList<String> importBarCodeList = new ArrayList<String>();
            HashMap<String, Integer> numMap = new HashMap<String, Integer>();
            for (int i = 1; i < excelUtils.getRowCount(); ++i) {
                String[] temps = new String[excelUtils.getColCount()];
                for (int j = 0; j < excelUtils.getColCount(); ++j) {
                    String value;
                    temps[j] = value = excelUtils.getCellData(i, j);
                }
                if (!this.verifyImport(temps)) {
                    SysUtil.abort();
                }
                this.importData(temps, importBarCodeList, numMap);
                numMap.put(temps[0], numMap.get(temps[0]) == null ? 1 : (Integer)numMap.get(temps[0]) + 1);
                importBarCodeList.add(temps[0]);
            }
            int cboSelectIndex = this.cboNewAddOrOverImport.getSelectedIndex();
            if (cboSelectIndex == 0) {
                this.clearZeroNoImportBarCode(importBarCodeList);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private void clearZeroNoImportBarCode(List<String> importBarCodeList) {
        KDTable kdtEntries = (KDTable)this.getUIContext().get("kdtEntries");
        BigDecimal zero = new BigDecimal("0");
        int n = kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = kdtEntries.getRow(i);
            String barCode = String.valueOf(row.getCell("barCode").getValue());
            if (importBarCodeList.indexOf(barCode) != -1) continue;
            row.getCell("stocktakingAmt").setValue((Object)zero);
            BigDecimal assetAmt = (BigDecimal)row.getCell("assetAmt").getValue();
            row.getCell("profitAmt").setValue((Object)zero.subtract(assetAmt));
        }
    }

    private void importData(String[] temps, List<String> importBarCodeList, Map<String, Integer> numMap) {
        if (EASResource.getString((String)RES_PATH, (String)"141_FaStockDataExportUI").equals(temps[1])) {
            return;
        }
        KDTable kdtEntries = (KDTable)this.getUIContext().get("kdtEntries");
        int rows = kdtEntries.getRowCount();
        boolean isExists = false;
        int cboSelectIndex = this.cboNewAddOrOverImport.getSelectedIndex();
        for (int i = 0; i < rows; ++i) {
            int times = numMap.get(temps[0]) == null ? 0 : numMap.get(temps[0]);
            IRow row = kdtEntries.getRow(i);
            if (row.getCell("barCode").getValue() == null) continue;
            String barCode = row.getCell("barCode").getValue().toString();
            if (barCode.equals(temps[0])) {
                row = kdtEntries.getRow(i + times);
                isExists = true;
                BigDecimal assetAmt = (BigDecimal)row.getCell("assetAmt").getValue();
                BigDecimal stocktakingAmt = (BigDecimal)row.getCell("stocktakingAmt").getValue();
                if (cboSelectIndex == 0 && importBarCodeList.indexOf(barCode) == -1) {
                    stocktakingAmt = new BigDecimal(0);
                }
                stocktakingAmt = stocktakingAmt.add(new BigDecimal(temps[1]));
                row.getCell("stocktakingAmt").setValue((Object)stocktakingAmt);
                BigDecimal profitAmt = stocktakingAmt.subtract(assetAmt);
                row.getCell("profitAmt").setValue((Object)profitAmt);
                this.setRowAnyOthersValue(row, temps);
                kdtEntries.getSelectManager().setSelectMode(2);
                kdtEntries.getSelectManager().select(row.getRowIndex(), 0);
            } else {
                isExists = false;
            }
            if (isExists) break;
        }
        if (!isExists) {
            kdtEntries.addRow();
            IRow newRow = kdtEntries.getRow(kdtEntries.getRowCount() - 1);
            BigDecimal amount = new BigDecimal(String.valueOf(0.0));
            if (temps.length > 1) {
                amount = new BigDecimal(temps[1]);
            }
            newRow.getCell("barCode").setValue((Object)temps[0]);
            newRow.getCell("assetAmt").setValue((Object)new BigDecimal("0"));
            newRow.getCell("stocktakingAmt").setValue((Object)amount);
            newRow.getCell("profitAmt").setValue((Object)amount);
            this.setRowAnyOthersValue(newRow, temps);
            kdtEntries.getSelectManager().setSelectMode(2);
            kdtEntries.getSelectManager().select(newRow.getRowIndex(), 0);
            this.setEditableRow(this.getOprtState());
        }
    }

    private void setRowAnyOthersValue(IRow row, String[] temps) {
        int useDeptInt;
        int usePersonInt;
        int adminDeptInt;
        int keepInt;
        int addInt;
        String address = "";
        if (null != row.getCell("address").getValue()) {
            address = row.getCell("address").getValue().toString();
        }
        int n = addInt = temps[9].indexOf("-") < 0 ? temps[9].length() : temps[9].indexOf("-");
        if (temps[9] == null || "".equals(temps[9])) {
            row.getCell("address").setValue(null);
        } else if (!address.equals(temps[9].substring(0, addInt))) {
            String addressNum = temps[9].indexOf("-") < 0 ? "" : temps[9].substring(addInt + 1);
            String addr = temps[9].indexOf("-") < 0 ? temps[9] : temps[9].substring(0, addInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (addressNum != null && !"".equals(addressNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)addressNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)addr, CompareType.EQUALS));
            }
            AddressCollection addCol = new AddressCollection();
            try {
                addCol = AddressFactory.getRemoteInstance().getAddressCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (addCol != null && addCol.size() > 0) {
                AddressInfo addrInfo = addCol.get(0);
                row.getCell("address").setValue((Object)addrInfo);
            } else {
                row.getCell("address").setValue(null);
            }
        }
        String keeper = "";
        if (null != row.getCell("keeper").getValue()) {
            keeper = row.getCell("keeper").getValue().toString();
        }
        int n2 = keepInt = temps[5].indexOf("-") < 0 ? temps[5].length() : temps[5].indexOf("-");
        if (temps[5] == null || "".equals(temps[5])) {
            row.getCell("keeper").setValue(null);
        } else if (!keeper.equals(temps[5].substring(0, keepInt))) {
            String keeperNum = temps[5].indexOf("-") < 0 ? "" : temps[5].substring(keepInt + 1);
            String keep = temps[5].indexOf("-") < 0 ? temps[5] : temps[5].substring(0, keepInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (keeperNum != null && !"".equals(keeperNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)keeperNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)keep, CompareType.EQUALS));
            }
            PersonCollection personCollection = new PersonCollection();
            try {
                personCollection = PersonFactory.getRemoteInstance().getPersonCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (personCollection != null && personCollection.size() > 0) {
                PersonInfo adminInfo = personCollection.get(0);
                row.getCell("keeper").setValue((Object)adminInfo);
            } else {
                row.getCell("keeper").setValue(null);
            }
        }
        String adminDept = "";
        if (null != row.getCell("adminDept").getValue()) {
            adminDept = row.getCell("adminDept").getValue().toString();
        }
        int n3 = adminDeptInt = temps[6].indexOf("-") < 0 ? temps[6].length() : temps[6].indexOf("-");
        if (temps[6] == null || "".equals(temps[6])) {
            row.getCell("adminDept").setValue(null);
        } else if (!adminDept.equals(temps[6].substring(0, adminDeptInt))) {
            String adminNum = temps[6].indexOf("-") < 0 ? "" : temps[6].substring(adminDeptInt + 1);
            String admin = temps[6].indexOf("-") < 0 ? temps[6] : temps[6].substring(0, adminDeptInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (adminNum != null && !"".equals(adminNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)adminNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)admin, CompareType.EQUALS));
            }
            AdminOrgUnitCollection adminCollection = new AdminOrgUnitCollection();
            try {
                adminCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (adminCollection != null && adminCollection.size() > 0) {
                AdminOrgUnitInfo adminInfo = adminCollection.get(0);
                row.getCell("adminDept").setValue((Object)adminInfo);
            } else {
                row.getCell("adminDept").setValue(null);
            }
        }
        String usePerson = "";
        if (null != row.getCell("usePerson").getValue()) {
            usePerson = row.getCell("usePerson").getValue().toString();
        }
        int n4 = usePersonInt = temps[7].indexOf("-") < 0 ? temps[7].length() : temps[7].indexOf("-");
        if (temps[7] == null || "".equals(temps[7])) {
            row.getCell("usePerson").setValue(null);
        } else if (!usePerson.equals(temps[7].substring(0, usePersonInt))) {
            String usePersonNum = temps[7].indexOf("-") < 0 ? "" : temps[7].substring(usePersonInt + 1);
            String use = temps[7].indexOf("-") < 0 ? temps[7] : temps[7].substring(0, usePersonInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (usePersonNum != null && !"".equals(usePersonNum) && !"null".equals(usePersonNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)usePersonNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)use, CompareType.EQUALS));
            }
            PersonCollection personCollection = new PersonCollection();
            try {
                personCollection = PersonFactory.getRemoteInstance().getPersonCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (personCollection != null && personCollection.size() > 0) {
                PersonInfo usePersonInfo = personCollection.get(0);
                row.getCell("usePerson").setValue((Object)usePersonInfo);
            } else {
                row.getCell("usePerson").setValue(null);
            }
        }
        String useDept = "";
        if (null != row.getCell("useDept").getValue()) {
            useDept = row.getCell("useDept").getValue().toString();
        }
        int n5 = useDeptInt = temps[8].lastIndexOf("-") < 0 ? temps[8].length() : temps[8].lastIndexOf("-");
        if (temps[8] == null || "".equals(temps[8])) {
            row.getCell("useDept").setValue(null);
        } else if (!useDept.equals(temps[8].substring(0, useDeptInt))) {
            String useDeptNum = temps[8].lastIndexOf("-") < 0 ? "" : temps[8].substring(useDeptInt + 1);
            String uDept = temps[8].lastIndexOf("-") < 0 ? temps[8] : temps[8].substring(0, useDeptInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (useDeptNum != null && !"".equals(useDeptNum) && !"null".equals(useDeptNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)useDeptNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)uDept, CompareType.EQUALS));
            }
            AdminOrgUnitCollection adminCollection = new AdminOrgUnitCollection();
            try {
                adminCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (adminCollection != null && adminCollection.size() > 0) {
                AdminOrgUnitInfo useDeptInfo = adminCollection.get(0);
                row.getCell("useDept").setValue((Object)useDeptInfo);
            } else {
                row.getCell("useDept").setValue(null);
            }
        }
    }

    private void setEditableRow(String oprtState) {
        KDTable kdtEntries = (KDTable)this.getUIContext().get("kdtEntries");
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            int profitIndex = kdtEntries.getColumnIndex("profitAmt");
            int assetNumIndex = kdtEntries.getColumnIndex("assetNum");
            int stocktakingAmtIndex = kdtEntries.getColumnIndex("assetAmt");
            for (int i = 0; i < kdtEntries.getRowCount(); ++i) {
                IRow row = kdtEntries.getRow(i);
                if (row.getCell("facurcard.id").getValue() != null && row.getCell("facurcard.id").getValue().toString().trim().length() != 0) continue;
                for (int j = 0; j < kdtEntries.getColumnCount(); ++j) {
                    if (profitIndex == j || assetNumIndex == j || stocktakingAmtIndex == j) continue;
                    row.getCell(j).getStyleAttributes().setLocked(false);
                }
            }
        } else {
            kdtEntries.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setVisible(false);
        this.disposeUIWindow();
    }
}

