/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.basedata.client.FaAlterModePromptBox;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingActionEnum;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaStocktakingRptEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FaStocktakingRptEditUI
extends AbstractFaStocktakingRptEditUI {
    private static final long serialVersionUID = -3977909604655024381L;
    private static final BigDecimal ZERO = new BigDecimal("0");
    protected String id = null;
    private int currencyScale = 2;

    public FaStocktakingRptEditUI() throws Exception {
        this.pkAdjustDate.setSupportedEmpty(false);
        this.kdtEntries.checkParsed();
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.currencyScale = FaClientUtils.getCurrencyScale(company.getBaseCurrency().getId());
        super.onLoad();
        this.initCtrlComponent();
        this.btnAttachment.setVisible(false);
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    @Override
    public void storeFields() {
        super.storeFields();
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            FaStocktakingReportBillEntryInfo entry = (FaStocktakingReportBillEntryInfo)row.getUserObject();
            entry.setAlterMode((FaAlterModeInfo)row.getCell("alterMode").getValue());
            entry.setAdjustAsset((Boolean)row.getCell("adjustAsset").getValue());
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        this.kdtEntries.checkParsed();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FaStocktakingReportBillInfo rptInfo = new FaStocktakingReportBillInfo();
        rptInfo.setStocktakingStatus(FaStocktakingStatusEnum.UNAUDITED);
        FaStocktakingBillInfo billInfo = (FaStocktakingBillInfo)this.getUIContext().get("BILL_INFO");
        FaStocktakingTaskBillInfo taskInfo = (FaStocktakingTaskBillInfo)this.getUIContext().get("TASK_INFO");
        rptInfo.setTaskBill(taskInfo);
        rptInfo.setBill(billInfo);
        rptInfo.setCompany(company);
        try {
            PeriodInfo period = FaClientUtils.getFACurrentPeriod(company);
            rptInfo.setAdjustDate(period.getEndDate());
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        FaStocktakingReportBillEntryCollection rptEntries = new FaStocktakingReportBillEntryCollection();
        rptInfo.put("entries", (Object)rptEntries);
        FaStocktakingBillEntryCollection entries = billInfo.getEntries();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < entries.size(); ++i) {
            IRow row = this.kdtEntries.addRow();
            FaStocktakingReportBillEntryInfo rptEntry = new FaStocktakingReportBillEntryInfo();
            FaStocktakingBillEntryInfo billEntry = entries.get(i);
            if (billEntry.getFaCurCard() != null && !list.contains(billEntry.getFaCurCard().getId().toString())) {
                list.add(billEntry.getFaCurCard().getId().toString());
            } else if (billEntry.getFaCurCard() != null && billEntry.getFaCurCard().getId() != null) continue;
            rptEntry.setAdjustAsset(false);
            rptEntry.setReportBill(rptInfo);
            rptEntry.setBillEntry(entries.get(i));
            BigDecimal assetAmt = billEntry.getAssetAmt() == null ? ZERO : billEntry.getAssetAmt();
            BigDecimal profitAmt = billEntry.getStocktakingAmt();
            if (profitAmt.compareTo(assetAmt) > 0) {
                rptEntry.setProfitAmt(profitAmt.subtract(assetAmt));
            } else if (profitAmt.compareTo(assetAmt) < 0) {
                rptEntry.setLossAmt(assetAmt.subtract(profitAmt));
            }
            this.loadLineFields(this.kdtEntries, row, (IObjectValue)rptEntry);
            rptEntries.add(rptEntry);
        }
        return rptInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaStocktakingReportBillFactory.getRemoteInstance();
    }

    protected void initCtrlComponent() throws Exception {
        FaUtils.freezeTable((KDTable)this.kdtEntries, (int)4);
        KDBizPromptBox prmtAlterMode = new KDBizPromptBox();
        FaAlterModePromptBox aFaAlterModePromptBox = new FaAlterModePromptBox((CoreUIObject)this, true);
        prmtAlterMode.setSelector((KDPromptSelector)aFaAlterModePromptBox);
        prmtAlterMode.setEntityViewInfo(FaClientUtils.getAlterModeOrgSplitViewInfo(true));
        prmtAlterMode.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaAlterModeQuery");
        prmtAlterMode.setCommitFormat("$number$");
        prmtAlterMode.setEditFormat("$number$");
        prmtAlterMode.setDisplayFormat("$number$");
        prmtAlterMode.setEditable(true);
        this.kdtEntries.getColumn("alterMode").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAlterMode));
        KDComboBox operTypes = new KDComboBox();
        Object[] objs = FaStocktakingActionEnum.getEnumList().toArray();
        operTypes.addItems(objs);
        operTypes.setSelectedIndex(0);
        operTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaStocktakingActionEnum item = (FaStocktakingActionEnum)((Object)e.getItem());
                if (item != null) {
                    int line = FaStocktakingRptEditUI.this.kdtEntries.getSelectManager().getActiveRowIndex();
                    BigDecimal assetValue = (BigDecimal)FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("assetValue").getValue();
                    BigDecimal assetAmt = (BigDecimal)FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("bizAssetAmt").getValue();
                    BigDecimal lossAmt = (BigDecimal)FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("lossAmt").getValue();
                    BigDecimal profitAmt = (BigDecimal)FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("profitAmt").getValue();
                    if (item.getValue() == 3) {
                        FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("lossValue").getStyleAttributes().setLocked(true);
                        if (lossAmt != null && assetAmt != null && assetValue != null) {
                            BigDecimal clearAmt = assetAmt.compareTo(ZERO) == 0 ? ZERO : assetValue.multiply(lossAmt).divide(assetAmt, 4).setScale(FaStocktakingRptEditUI.this.currencyScale, 4);
                            FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("lossValue").setValue((Object)clearAmt);
                        }
                    } else {
                        BigDecimal profitValue;
                        if (item.getValue() == 1) {
                            FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("lossValue").getStyleAttributes().setLocked(true);
                        } else {
                            FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("lossValue").getStyleAttributes().setLocked(false);
                        }
                        if (item.getValue() != 0 && (profitValue = (BigDecimal)FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("profitValue").getValue()) == null && profitAmt != null && assetAmt != null && assetValue != null) {
                            BigDecimal calcAmt = assetAmt.compareTo(ZERO) == 0 ? ZERO : assetValue.multiply(profitAmt).divide(assetAmt, 4).setScale(FaStocktakingRptEditUI.this.currencyScale, 4);
                            FaStocktakingRptEditUI.this.kdtEntries.getRow(line).getCell("profitValue").setValue((Object)calcAmt);
                        }
                    }
                }
            }
        });
        this.kdtEntries.getColumn("operType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)operTypes));
        KDTextField textField = new KDTextField();
        textField.setMaxLength(255);
        this.kdtEntries.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        String qScale = (String)FaClientUtils.getFAParameter(company.getId()).get("FA_008");
        int quantityScale = qScale == null ? 0 : Integer.parseInt(qScale);
        FaClientUtils.changeTableNumberFormat(this.kdtEntries, new String[]{"profitValue", "lossValue"}, FaClientUtils.getDecimalFormat(this.currencyScale));
        FaClientUtils.changeTableNumberFormat(this.kdtEntries, new String[]{"assetAmt", "bizAssetAmt", "profitAmt", "lossAmt"}, FaClientUtils.getDecimalFormat(quantityScale));
        KDFormattedTextField amtEditor = new KDFormattedTextField(1);
        amtEditor.setPrecision(quantityScale);
        amtEditor.setNegatived(false);
        amtEditor.setHorizontalAlignment(4);
        this.kdtEntries.getColumn("assetAmt").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)amtEditor));
        this.kdtEntries.getColumn("bizAssetAmt").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)amtEditor));
        this.kdtEntries.getColumn("profitAmt").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)amtEditor));
        this.kdtEntries.getColumn("lossAmt").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)amtEditor));
        KDFormattedTextField valueEditor = new KDFormattedTextField(1);
        valueEditor.setPrecision(this.currencyScale);
        valueEditor.setNegatived(false);
        valueEditor.setHorizontalAlignment(4);
        this.kdtEntries.getColumn("profitValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)valueEditor));
        this.kdtEntries.getColumn("lossValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)valueEditor));
        EventListener[] listeners = this.kdtEntries.getListeners(KDTSelectListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            this.kdtEntries.removeKDTSelectListener((KDTSelectListener)listeners[i]);
        }
        KDCheckBox checkBox = new KDCheckBox();
        checkBox.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                int line = FaStocktakingRptEditUI.this.kdtEntries.getSelectManager().getActiveRowIndex();
                IRow row = FaStocktakingRptEditUI.this.kdtEntries.getRow(line);
                if (row == null || row.getCell("adjustAsset") == null) {
                    return;
                }
                if (isSelected) {
                    BigDecimal assetAmt = row.getCell("bizAssetAmt").getValue() == null ? ZERO : row.getCell("bizAssetAmt").getValue();
                    BigDecimal profitAmt = (BigDecimal)row.getCell("assetAmt").getValue();
                    if (profitAmt.compareTo(assetAmt) > 0) {
                        row.getCell("profitValue").getStyleAttributes().setLocked(false);
                    } else if (profitAmt.compareTo(assetAmt) < 0) {
                        row.getCell("lossValue").getStyleAttributes().setLocked(false);
                    } else {
                        row.getCell("profitValue").getStyleAttributes().setLocked(false);
                        row.getCell("lossValue").getStyleAttributes().setLocked(false);
                    }
                    row.getCell("operType").getStyleAttributes().setLocked(false);
                    row.getCell("alterMode").getStyleAttributes().setLocked(false);
                } else {
                    row.getCell("operType").setValue((Object)FaStocktakingActionEnum.NONE);
                    row.getCell("profitValue").setValue(null);
                    row.getCell("lossValue").setValue(null);
                    row.getCell("alterMode").setValue(null);
                    row.getCell("operType").getStyleAttributes().setLocked(true);
                    row.getCell("alterMode").getStyleAttributes().setLocked(true);
                    row.getCell("profitValue").getStyleAttributes().setLocked(true);
                    row.getCell("lossValue").getStyleAttributes().setLocked(true);
                }
            }
        });
        this.kdtEntries.getColumn("adjustAsset").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBox));
        this.menuItemViewSubmitProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.menuItemViewDoProccess.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.menuItemAuditResult.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemNextPerson.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            FaStocktakingReportBillEntryInfo entry = (FaStocktakingReportBillEntryInfo)row.getUserObject();
            row.getCell("alterMode").setValue((Object)entry.getAlterMode());
        }
        this.setTableEditable(this.getOprtState());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entries.alterMode.number"));
        sic.add(new SelectorItemInfo("entries.alterMode.name"));
        sic.add(new SelectorItemInfo("taskBill.beginDate"));
        sic.add(new SelectorItemInfo("taskBill.endDate"));
        sic.add(new SelectorItemInfo("taskBill.lastUpdateTime"));
        sic.add(new SelectorItemInfo("taskBill.stocktakingStatus"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnProfit.setIcon(EASResource.getIcon((String)"imgTbtn_checkadjust"));
        this.menuItemProfit.setIcon(EASResource.getIcon((String)"imgTbtn_checkadjust"));
        this.btnCancelProfit.setIcon(EASResource.getIcon((String)"imgTbtn_checklose"));
        this.menuItemCancelProfit.setIcon(EASResource.getIcon((String)"imgTbtn_checklose"));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionTraceDown.setEnabled(true);
        this.actionTraceUp.setEnabled(true);
        if (this.editData != null && this.editData.getStocktakingStatus().getValue() == 6) {
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        String msgTxt = FaResUtil.getRes((String)"noDestinationBill");
        if (this.getOprtState() == OprtState.ADDNEW || this.editData.getId() == null) {
            MsgBox.showInfo((String)msgTxt);
            SysUtil.abort();
        }
        HashMap idList = new HashMap();
        Vector<String> cardIds = new Vector<String>();
        Vector<String> changeIds = new Vector<String>();
        Vector<String> clearIds = new Vector<String>();
        for (int i = 0; i < this.editData.getEntries().size(); ++i) {
            FaStocktakingReportBillEntryInfo entry = this.editData.getEntries().get(i);
            if (entry.getNewCard() != null) {
                cardIds.add(entry.getNewCard().getId().toString());
            }
            if (entry.getChangeBill() != null) {
                changeIds.add(entry.getChangeBill().getId().toString());
            }
            if (entry.getClearBill() == null) continue;
            clearIds.add(entry.getClearBill().getId().toString());
        }
        if (cardIds.size() > 0) {
            idList.put(new FaCurCardInfo().getBOSType().toString(), cardIds);
        }
        if (changeIds.size() > 0) {
            idList.put(new FaChangeBillInfo().getBOSType().toString(), changeIds);
        }
        if (clearIds.size() > 0) {
            idList.put(new FaClearBillInfo().getBOSType().toString(), clearIds);
        }
        if (idList.size() == 0) {
            MsgBox.showInfo((String)msgTxt);
        } else {
            FaClientUtils.showTraceUI((CoreUI)this, idList, 0);
        }
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        HashMap idList = new HashMap();
        Vector<String> v1 = new Vector<String>();
        FaStocktakingTaskBillInfo taskInfo = this.editData.getTaskBill();
        v1.add(taskInfo.getId().toString());
        idList.put(taskInfo.getBOSType().toString(), v1);
        FaStocktakingBillInfo billInfo = this.editData.getBill();
        Vector<String> v2 = new Vector<String>();
        v2.add(billInfo.getId().toString());
        idList.put(billInfo.getBOSType().toString(), v2);
        FaClientUtils.showTraceUI((CoreUI)this, idList, 1);
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK pk = super.runSubmit();
        this.setOprtState(OprtState.EDIT);
        return pk;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        int modeIndex = this.kdtEntries.getColumnIndex("alterMode");
        int operTypeIndex = this.kdtEntries.getColumnIndex("operType");
        if (e != null && this.getActionFromActionEvent(e).equals(this.actionSubmit)) {
            PeriodInfo period = FaClientUtils.getFACurrentPeriod();
            Date bizDate = DateTimeUtils.truncateDate((Date)((Date)this.pkAdjustDate.getValue()));
            if (bizDate.before(DateTimeUtils.truncateDate((Date)period.getBeginDate())) || bizDate.after(DateTimeUtils.truncateDate((Date)period.getEndDate()))) {
                this.abort((JComponent)this.pkAdjustDate, "adjustDateInvalid");
            }
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            String originZero = (String)FaClientUtils.getFAParameter(company.getId()).get("FA_017");
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                IRow row = this.kdtEntries.getRow(i);
                FaAlterModeInfo modeInfo = (FaAlterModeInfo)row.getCell("alterMode").getValue();
                int operType = ((FaStocktakingActionEnum)((Object)row.getCell("operType").getValue())).getValue();
                boolean isAdjust = (Boolean)row.getCell("adjustAsset").getValue();
                if (isAdjust && operType == 0) {
                    this.abortEntry("operTypeRequired", i, operTypeIndex);
                }
                BigDecimal profitAmt = (BigDecimal)row.getCell("profitAmt").getValue();
                BigDecimal lossAmt = (BigDecimal)row.getCell("lossAmt").getValue();
                BigDecimal profitValue = (BigDecimal)row.getCell("profitValue").getValue();
                BigDecimal lossValue = (BigDecimal)row.getCell("lossValue").getValue();
                BigDecimal bizAssetAmt = (BigDecimal)row.getCell("bizAssetAmt").getValue();
                if (profitAmt != null && isAdjust) {
                    if (profitValue == null || profitValue.compareTo(ZERO) < 0) {
                        this.abortEntry("profitValueInvalid", i, this.kdtEntries.getColumnIndex("profitValue"));
                    }
                    if (operType == 3) {
                        this.abortEntry("profitCannotClear", i, operTypeIndex);
                    }
                    if (profitValue.compareTo(ZERO) == 0 && operType != 2 && (originZero == null || "".equals(originZero) || !"true".equals(originZero))) {
                        this.abortEntry("operTypeMustChangeForAmt", i, operTypeIndex);
                    }
                    if ((bizAssetAmt == null || bizAssetAmt.compareTo(ZERO) == 0) && operType != 1) {
                        this.abortEntry("operTypeMustAddNew", i, operTypeIndex);
                    }
                } else if (lossAmt != null && isAdjust) {
                    boolean isZeroAsset;
                    if (operType == 1) {
                        this.abortEntry("lossCannotAddnew", i, operTypeIndex);
                    }
                    if (lossValue == null || lossValue.compareTo(ZERO) < 0) {
                        this.abortEntry("lossValueInvalid", i, this.kdtEntries.getColumnIndex("lossValue"));
                    }
                    boolean bl = row.getCell("assetValue").getValue() == null ? false : (isZeroAsset = ((BigDecimal)row.getCell("assetValue").getValue()).compareTo(ZERO) == 0);
                    if (isZeroAsset) {
                        if (operType != 2 || lossValue.compareTo(ZERO) != 0) {
                            this.abortEntry("operTypeMustChangeForZEROAmt", i, operTypeIndex);
                        }
                    } else {
                        if (lossAmt.compareTo(bizAssetAmt) >= 0 && operType == 2) {
                            this.abortEntry("operTypeMustClearForAmt", i, operTypeIndex);
                        }
                        if (lossValue.compareTo(ZERO) == 0 && operType != 2) {
                            this.abortEntry("operTypeMustChangeForAmt", i, operTypeIndex);
                        }
                    }
                } else if (isAdjust) {
                    if (profitValue != null && lossValue != null) {
                        this.abortEntry("onlyOneAmtRequired", i, this.kdtEntries.getColumnIndex("profitValue"));
                    }
                    if (profitValue != null && profitValue.compareTo(ZERO) < 0) {
                        this.abortEntry("profitValueInvalid", i, this.kdtEntries.getColumnIndex("profitValue"));
                    }
                    if (lossValue != null && lossValue.compareTo(ZERO) < 0) {
                        this.abortEntry("lossValueInvalid", i, this.kdtEntries.getColumnIndex("lossValue"));
                    }
                    if (profitValue != null || lossValue != null) {
                        if (operType != 2) {
                            this.abortEntry("operTypeMustChangeForValue", i, operTypeIndex);
                        }
                    } else {
                        this.abortEntry("operTypeMustNone", i, operTypeIndex);
                    }
                }
                if (isAdjust && modeInfo == null) {
                    this.abortEntry("alterModeRequired", i, modeIndex);
                }
                if (!isAdjust || !modeInfo.getNumber().equals("000") || operType != 1 && operType != 3) continue;
                this.abortEntry("cannotSelectInitChangeMode", i, modeIndex);
            }
        }
    }

    private void abort(JComponent target, String resource) {
        target.requestFocus();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)resource));
        SysUtil.abort();
    }

    private void abortEntry(String resource, int line, int column) {
        this.kdtEntries.requestFocus();
        this.kdtEntries.getSelectManager().select(line, column, line, column);
        this.kdtEntries.scrollToVisible(line, column);
        MsgBox.showInfo((Component)((Object)this), (String)(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"rptLine"), line + 1) + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)resource)));
        SysUtil.abort();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.setTableEditable(oprtType);
    }

    private void setTableEditable(String oprtType) {
        int i;
        for (i = 0; i < this.kdtEntries.getColumnCount(); ++i) {
            this.kdtEntries.getColumn(i).getStyleAttributes().setLocked(true);
        }
        if (oprtType.equals(OprtState.EDIT) || oprtType.equals(OprtState.ADDNEW)) {
            this.kdtEntries.getColumn("description").getStyleAttributes().setLocked(false);
            this.kdtEntries.getColumn("adjustAsset").getStyleAttributes().setLocked(false);
            for (i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                IRow row = this.kdtEntries.getRow(i);
                boolean isSelected = (Boolean)row.getCell("adjustAsset").getValue();
                if (!isSelected) continue;
                if (row.getCell("profitAmt").getValue() != null) {
                    row.getCell("profitValue").getStyleAttributes().setLocked(false);
                } else if (row.getCell("lossAmt").getValue() != null) {
                    if (row.getCell("operType") != null && ((FaStocktakingActionEnum)((Object)row.getCell("operType").getValue())).getValue() == 3) {
                        row.getCell("lossValue").getStyleAttributes().setLocked(true);
                    } else {
                        row.getCell("lossValue").getStyleAttributes().setLocked(false);
                    }
                } else {
                    row.getCell("profitValue").getStyleAttributes().setLocked(false);
                    row.getCell("lossValue").getStyleAttributes().setLocked(false);
                }
                row.getCell("operType").getStyleAttributes().setLocked(false);
                row.getCell("alterMode").getStyleAttributes().setLocked(false);
            }
        }
    }

    @Override
    public void actionCancelProfit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        if (OprtState.ADDNEW.equals(this.getOprtState()) || this.editData.getId() == null) {
            this.abort((JComponent)this.btnSubmit, "stockRptNotSaved");
        }
        if (this.editData.getStocktakingStatus().getValue() < 6) {
            this.abort((JComponent)this.kdtEntries, "rptNotProfited");
        }
        FaStocktakingReportBillFactory.getRemoteInstance().cancel((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBaseInfo)this.editData);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"cancelProfitSuccess"));
        this.editData = (FaStocktakingReportBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.actionEdit.setEnabled(true);
    }

    @Override
    public void actionProfit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        if (OprtState.ADDNEW.equals(this.getOprtState()) || this.editData.getId() == null) {
            this.abort((JComponent)this.btnSubmit, "stockRptNotSaved");
        }
        if (this.editData.getTaskBill().getStocktakingStatus().getValue() == 6) {
            this.abort((JComponent)this.kdtEntries, "rptHadProfited");
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && this.editData.getId() != null && this.isModify() && MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"saveThenProfit")))) {
            ActionEvent evt = new ActionEvent(this.btnSubmit, 0, "Submit");
            this.beforeStoreFields(evt);
            this.runSubmit();
        }
        boolean hasProfitItem = true;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            boolean adjustAsset = (Boolean)row.getCell("adjustAsset").getValue();
            if (!adjustAsset) continue;
            hasProfitItem = true;
            break;
        }
        if (hasProfitItem) {
            FaStocktakingReportBillFactory.getRemoteInstance().profitLoss(this.editData.getId());
        } else {
            this.abort((JComponent)this.kdtEntries, "noNeedProfit");
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"profitSuccess"));
        this.editData = (FaStocktakingReportBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.checkSelected();
        if (this.editData.getStocktakingStatus().getValue() == 6) {
            this.abort((JComponent)this.kdtEntries, "rptCantEdit");
        }
        super.actionEdit_actionPerformed(e);
    }

    protected void addLine(KDTable table) {
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunc(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunc(e, false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        if (this.editData.getStocktakingStatus().getValue() == 6) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"hasProfittedBefore"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaStockingRptEditUI((IObjectCollection)billCol, tables);
        if (noPreview) {
            appHlp.print("/FI/FA/FaCheck/FaCheckDiff", (Object)data, (Component)((Object)this));
        } else {
            appHlp.printPreview("/FI/FA/FaCheck/FaCheckDiff", (Object)data, (Component)((Object)this));
        }
    }

    public Object parseEnumValue(IRowSet rowSet, String statusEnum, String statusEnumValue, String adjustAsset, String adjustAssetValue, String operType, String operTypeValue, String strStocktakingAmt, String strStocktakingAmtAmount, String strAssetAmt, String strAssetAmtAmount, String strProfitAmt, String strProfitAmtAmount, String strLossAmt, String strLossAmtAmount, String strProfitValue, String strProfitValueCurreny, String strLossValue, String StrlossValueCurreny, List listStatus, List listAction) throws SQLException {
        if (rowSet == null) {
            return rowSet;
        }
        if (!rowSet.next()) {
            return rowSet;
        }
        Iterator iteStockEnum = null;
        Iterator iteOperType = null;
        FaStocktakingStatusEnum enumStatus2 = null;
        FaStocktakingActionEnum enumAction2 = null;
        String strstockEnumValue = null;
        String strAdjustAsset = null;
        String stroperType = null;
        String strFlag = "";
        int iStatusEnum = 0;
        int iStatusEnumValue = 0;
        int iOperTypeEnum = 0;
        int iOperTypeEnumValue = 0;
        BigDecimal bigstocktakingAmt = null;
        int istocktakingAmtAmount = 0;
        BigDecimal biassetAmt = null;
        int iassetAmtAmount = 0;
        BigDecimal bigprofitAmt = null;
        int iprofitAmtAmount = 0;
        BigDecimal biglossAmt = null;
        int ilossAmtAmount = 0;
        BigDecimal bigprofitValue = null;
        int iprofitValueCurreny = 0;
        BigDecimal biglossValue = null;
        int ilossValueCurreny = 0;
        rowSet.previous();
        while (rowSet.next()) {
            iStatusEnum = rowSet.getInt(statusEnum);
            iStatusEnumValue = rowSet.findColumn(statusEnumValue);
            for (FaStocktakingStatusEnum enumStatus2 : listStatus) {
                if (iStatusEnum != enumStatus2.getValue()) continue;
                strstockEnumValue = enumStatus2.getAlias();
            }
            rowSet.updateString(iStatusEnumValue, strstockEnumValue);
            strAdjustAsset = rowSet.getString(adjustAsset).toString();
            if (strAdjustAsset.equalsIgnoreCase("false")) {
                rowSet.updateString(adjustAssetValue, EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"lblCancel"));
            } else {
                rowSet.updateString(adjustAssetValue, EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"lblOk"));
            }
            iOperTypeEnum = rowSet.getInt(operType);
            iOperTypeEnumValue = rowSet.findColumn(operTypeValue);
            for (FaStocktakingActionEnum enumAction2 : listAction) {
                if (iOperTypeEnum != enumAction2.getValue()) continue;
                stroperType = enumAction2.getAlias();
            }
            rowSet.updateString(iOperTypeEnumValue, stroperType);
            istocktakingAmtAmount = rowSet.findColumn(strStocktakingAmtAmount);
            if (rowSet.getBigDecimal(strStocktakingAmt) != null) {
                bigstocktakingAmt = rowSet.getBigDecimal(strStocktakingAmt);
                rowSet.updateString(istocktakingAmtAmount, FaClientUtils.formatDecimal(bigstocktakingAmt));
            } else {
                rowSet.updateString(istocktakingAmtAmount, strFlag);
            }
            iassetAmtAmount = rowSet.findColumn(strAssetAmtAmount);
            if (rowSet.getBigDecimal(strAssetAmt) != null) {
                biassetAmt = rowSet.getBigDecimal(strAssetAmt);
                rowSet.updateString(iassetAmtAmount, FaClientUtils.formatDecimal(biassetAmt));
            } else {
                rowSet.updateString(iassetAmtAmount, strFlag);
            }
            iprofitAmtAmount = rowSet.findColumn(strProfitAmtAmount);
            if (rowSet.getBigDecimal(strProfitAmt) != null) {
                bigprofitAmt = rowSet.getBigDecimal(strProfitAmt);
                rowSet.updateString(iprofitAmtAmount, FaClientUtils.formatDecimal(bigprofitAmt));
            } else {
                rowSet.updateString(iprofitAmtAmount, strFlag);
            }
            ilossAmtAmount = rowSet.findColumn(strLossAmtAmount);
            if (rowSet.getBigDecimal(strLossAmt) != null) {
                biglossAmt = rowSet.getBigDecimal(strLossAmt);
                rowSet.updateString(ilossAmtAmount, FaClientUtils.formatDecimal(biglossAmt));
            } else {
                rowSet.updateString(ilossAmtAmount, strFlag);
            }
            iprofitValueCurreny = rowSet.findColumn(strProfitValueCurreny);
            if (rowSet.getBigDecimal(strProfitValue) != null) {
                bigprofitValue = rowSet.getBigDecimal(strProfitValue);
                rowSet.updateString(iprofitValueCurreny, FaClientUtils.formatDecimal(bigprofitValue));
            } else {
                rowSet.updateString(iprofitValueCurreny, strFlag);
            }
            ilossValueCurreny = rowSet.findColumn(StrlossValueCurreny);
            if (rowSet.getBigDecimal(strLossValue) != null) {
                biglossValue = rowSet.getBigDecimal(strLossValue);
                rowSet.updateString(ilossValueCurreny, FaClientUtils.formatDecimal(biglossValue));
                continue;
            }
            rowSet.updateString(ilossValueCurreny, strFlag);
        }
        rowSet.beforeFirst();
        return rowSet;
    }
}

