/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaBasedataTypeEnum;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaEconomicPurpPromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaUseStatusPromptBox;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaStocktakingStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaStocktakingTaskBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaStocktakingTaskBillEditTaoda;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class FaStocktakingTaskBillEditUI
extends AbstractFaStocktakingTaskBillEditUI {
    private static final long serialVersionUID = 8794468473494638254L;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.chkBlockCard.setEnabled(false);
        this.chkMenuItemSubmitAndPrint.setVisible(false);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaStocktakingTaskBillFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    protected IObjectValue createNewData() {
        PeriodInfo period = null;
        try {
            period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        FaStocktakingTaskBillInfo info = new FaStocktakingTaskBillInfo();
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        if (today.before(DateTimeUtils.truncateDate((Date)period.getBeginDate()))) {
            info.setBizDate(period.getBeginDate());
        } else if (today.after(DateTimeUtils.truncateDate((Date)period.getEndDate()))) {
            info.setBizDate(period.getEndDate());
        } else {
            info.setBizDate(today);
        }
        info.setStocktakingStatus(FaStocktakingStatusEnum.UNAUDITED);
        info.setBlockCard(true);
        info.setAllowZeroAssetNum(true);
        info.setBeginDate(today);
        info.setEndDate(today);
        info.setPlanDate(today);
        return info;
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    @Override
    protected void initCtrlComponent() throws Exception {
        super.initCtrlComponent();
        FaCatPromptBox aFaCatPromptBox = new FaCatPromptBox((CoreUIObject)this);
        this.prmtAssetCatFrom.setSelector((KDPromptSelector)aFaCatPromptBox);
        this.prmtAssetCatFrom.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.CAT));
        this.prmtAssetCatTo.setSelector((KDPromptSelector)aFaCatPromptBox);
        this.prmtAssetCatTo.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.CAT));
        FaUseStatusPromptBox aFaUseStatusPromptBox = new FaUseStatusPromptBox((CoreUIObject)this);
        this.prmtUseStatusFrom.setSelector((KDPromptSelector)aFaUseStatusPromptBox);
        this.prmtUseStatusFrom.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.USESTATUS));
        this.prmtUseStatusTo.setSelector((KDPromptSelector)aFaUseStatusPromptBox);
        this.prmtUseStatusTo.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.USESTATUS));
        FaEconomicPurpPromptBox aFaEconomicPurpPromptBox = new FaEconomicPurpPromptBox((CoreUIObject)this);
        this.prmtEconomicPurpFrom.setSelector((KDPromptSelector)aFaEconomicPurpPromptBox);
        this.prmtEconomicPurpFrom.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.ECONOMICPURP));
        this.prmtEconomicPurpTo.setSelector((KDPromptSelector)aFaEconomicPurpPromptBox);
        this.prmtEconomicPurpTo.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.ECONOMICPURP));
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        boolean isOrgRange = "true".equals(this.gethmParam().get("FA_040").toString());
        FaClientUtils.processAdminF7(adminF7, isOrgRange);
        this.prmtUseDeptFrom.setSelector((KDPromptSelector)adminF7);
        this.prmtUseDeptTo.setSelector((KDPromptSelector)adminF7);
        this.prmtAdminDeptFrom.setSelector((KDPromptSelector)adminF7);
        this.prmtAdminDeptTo.setSelector((KDPromptSelector)adminF7);
    }

    public HashMap gethmParam() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    private CompanyOrgUnitInfo getCurrentCompany() throws Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String companyId = null;
        companyId = FaClientUtils.isFromLink((CoreUIObject)this) ? (String)this.getUIContext().get("COMPANY_ID") : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), sic);
        return companyOrgUnitInfo;
    }

    @Override
    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        PeriodInfo period;
        Date bizDate = (Date)this.pkBizDate.getValue();
        if (bizDate == null) {
            this.abort((JComponent)this.pkBizDate, "bizDateRequired");
        }
        if (bizDate.before(DateTimeUtils.truncateDate((Date)(period = FaClientUtils.getFACurrentPeriod(this.getCurCompany())).getBeginDate())) || bizDate.after(DateTimeUtils.truncateDate((Date)period.getEndDate()))) {
            this.abort((JComponent)this.pkBizDate, "bizDateInvalid");
        }
        if (this.pkPlanDate.getValue() == null) {
            this.abort((JComponent)this.pkPlanDate, "planDateRequired");
        }
        if (this.pkBeginDate.getValue() != null && this.pkEndDate.getValue() != null && DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue())))) {
            this.abort((JComponent)this.pkBeginDate, "beginEndDateInvalid");
        }
    }

    public void abort(JComponent target, String resource) {
        target.requestFocus();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)resource));
        SysUtil.abort();
    }

    @Override
    protected String getEntryKeyName() {
        return "";
    }

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setAllowZeroAssetNum(this.chkAllowZeroAssetNum.isSelected());
        this.editData.setBlockCard(this.chkBlockCard.isSelected());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.chkAllowZeroAssetNum.setSelected(this.editData.isAllowZeroAssetNum());
        this.chkBlockCard.setSelected(this.editData.isBlockCard());
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        ((FaStocktakingTaskBillInfo)newData).setStocktakingStatus(FaStocktakingStatusEnum.UNAUDITED);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        if (this.editData.getStocktakingStatus().getValue() != 2) {
            this.abort((JComponent)this.txtNumber, "cannotUnAuditTaskBill");
        }
        super.actionUnAudit_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunc(e, true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunc(e, false);
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        Map mapValues = this.getSelectedValues();
        KDNoteHelper appHlp = new KDNoteHelper();
        FaStocktakingTaskBillEditTaoda rsprv = new FaStocktakingTaskBillEditTaoda(mapValues);
        if (noPreview) {
            appHlp.print("/FI/FA/FaCheck/FaStocktakingTaskBillEdit", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/FI/FA/FaCheck/FaStocktakingTaskBillEdit", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    private Map getSelectedValues() {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        mapValues.put("txtNumber", this.txtNumber.getStringValue());
        mapValues.put("pkBizDate", this.pkBizDate.getText());
        mapValues.put("pkPlanDate", this.pkPlanDate.getText());
        mapValues.put("comboStocktakingStatus", this.comboStocktakingStatus.getSelectedItem().toString());
        mapValues.put("pkBeginDate", this.pkBeginDate.getText());
        mapValues.put("pkEndDate", this.pkEndDate.getText());
        mapValues.put("txtDescription", this.txtDescription.getText());
        mapValues.put("txtAssetNumFrom", this.txtAssetNumFrom.getText());
        mapValues.put("txtAssetNumTo", this.txtAssetNumTo.getText());
        mapValues.put("prmtAssetCatFrom", this.prmtAssetCatFrom.getText());
        mapValues.put("prmtAssetCatTo", this.prmtAssetCatTo.getText());
        mapValues.put("prmtAddressFrom", this.prmtAddressFrom.getText());
        mapValues.put("prmtAddressTo", this.prmtAddressTo.getText());
        mapValues.put("prmtUseStatusFrom", this.prmtUseStatusFrom.getText());
        mapValues.put("prmtUseStatusTo", this.prmtUseStatusTo.getText());
        mapValues.put("prmtEconomicPurpFrom", this.prmtEconomicPurpFrom.getText());
        mapValues.put("prmtEconomicPurpTo", this.prmtEconomicPurpTo.getText());
        mapValues.put("prmtUseDeptFrom", this.prmtUseDeptFrom.getText());
        mapValues.put("prmtUseDeptTo", this.prmtUseDeptTo.getText());
        mapValues.put("prmtAdminDeptFrom", this.prmtAdminDeptFrom.getText());
        mapValues.put("prmtAdminDeptTo", this.prmtAdminDeptTo.getText());
        if (this.chkBlockCard.isSelected()) {
            mapValues.put("chkBlockCard", EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"lblOk"));
        } else {
            mapValues.put("chkBlockCard", EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"lblCancel"));
        }
        if (this.chkAllowZeroAssetNum.isSelected()) {
            mapValues.put("chkAllowZeroAssetNum", EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"lblOk"));
        } else {
            mapValues.put("chkAllowZeroAssetNum", EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"lblCancel"));
        }
        mapValues.put("prmtCreator", this.prmtCreator.getText());
        mapValues.put("pkCreateTime", this.pkCreateTime.getText());
        mapValues.put("prmtAuditor", this.prmtAuditor.getText());
        mapValues.put("pkAuditTime", this.pkAuditTime.getText());
        return mapValues;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (dataObject != null) {
            if (this.getOprtState().equals("ADDNEW")) {
                this.txtNumber.setText(null);
                this.txtDescription.setText(null);
                this.txtAssetNumFrom.setText(null);
                this.txtAssetNumTo.setText(null);
                this.prmtAssetCatFrom.setValue(null);
                this.prmtAssetCatTo.setValue(null);
                this.prmtAddressFrom.setValue(null);
                this.prmtAddressTo.setValue(null);
                this.prmtUseStatusFrom.setValue(null);
                this.prmtUseStatusTo.setValue(null);
                this.prmtEconomicPurpFrom.setValue(null);
                this.prmtEconomicPurpTo.setValue(null);
                this.prmtUseDeptFrom.setValue(null);
                this.prmtUseDeptTo.setValue(null);
                this.prmtAdminDeptFrom.setValue(null);
                this.prmtAdminDeptTo.setValue(null);
            }
            this.initOldData(dataObject);
            this.initScrollButtons();
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionCopy_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAudit_actionPerformed(e);
    }
}

