/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaTraceBookCardUI;
import com.kingdee.eas.fi.fa.manage.client.FaBillTraceUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FaTraceBookCardUI
extends AbstractFaTraceBookCardUI {
    private static final long serialVersionUID = 2875162787492880940L;
    private CompanyOrgUnitInfo bookCompany;
    private CompanyOrgUnitInfo company;
    private HashMap selectId = null;
    private String cardId = null;
    private final BOSObjectType CARDTYPE = new FaCurCardInfo().getBOSType();
    private final BOSObjectType MonCurcardType = new FaMonCardInfo().getBOSType();
    private String cardType = null;

    public FaTraceBookCardUI() throws Exception {
        this.toolBar.setVisible(false);
        this.menuBar.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("select") != null) {
            this.selectId = (HashMap)this.getUIContext().get("select");
        }
        if (this.selectId.get("selectId") != null) {
            this.cardId = (String)this.selectId.get("selectId");
        }
        if (this.selectId.get("type") != null) {
            this.cardType = (String)this.selectId.get("type");
        }
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.btnQueryCard.setEnabled(true);
        this.btnQueryCard.setLimitedSize(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionQueryCard_actionPerformed(ActionEvent e) throws Exception {
        String destBookScheme;
        AcountSchemeInfo destBook = (AcountSchemeInfo)this.kDBizPromptBox1.getData();
        if (destBook == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.PleaseSelectBook");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        if ((destBookScheme = destBook.getId().toString()) == null) {
            return;
        }
        this.bookCompany = null;
        this.bookCompany = this.getDestBookCompany(destBookScheme);
        if (this.bookCompany == null) {
            return;
        }
        if (this.cardType.equals("curCard")) {
            FaCurCardInfo curCardInfo = this.checkHasTransfered(this.bookCompany);
            if (curCardInfo == null) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.HasNotCreateCard");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
            HashMap map = new HashMap();
            Vector<String> cardVector = new Vector<String>();
            cardVector.add(curCardInfo.getId().toString());
            if (cardVector.size() > 0) {
                map.put(this.CARDTYPE.toString(), cardVector);
            }
            if (map == null || map.size() <= 0) throw new BTPException(BTPException.DESTBILLNULL);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"IDList", map);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"isFromBook", (Object)"Y");
            uiContext.put((Object)"BTPNAVCTX", (Object)this.getUIContext());
            uiContext.put((Object)"findType", (Object)new Integer(1));
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow newWindow = uiFactory.create(FaBillTraceUI.class.getName(), (Map)uiContext, null);
            newWindow.show();
            return;
        } else {
            if (!this.cardType.equals("monCard")) return;
            if (this.checkMoncardHasTransfered(this.bookCompany) == null) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.HasNotCreateCard");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
            FaMonCardInfo curCardInfo = this.checkMoncardHasTransfered(this.bookCompany);
            HashMap map = new HashMap();
            Vector<String> cardVector = new Vector<String>();
            cardVector.add(curCardInfo.getId().toString());
            if (cardVector.size() > 0) {
                map.put(this.MonCurcardType.toString(), cardVector);
            }
            if (map == null || map.size() <= 0) throw new BTPException(BTPException.DESTBILLNULL);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"IDList", map);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"isFromBook", (Object)"Y");
            uiContext.put((Object)"BTPNAVCTX", (Object)this.getUIContext());
            uiContext.put((Object)"findType", (Object)new Integer(1));
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow newWindow = uiFactory.create(FaBillTraceUI.class.getName(), (Map)uiContext, null);
            newWindow.show();
        }
    }

    public FaMonCardInfo checkMoncardHasTransfered(CompanyOrgUnitInfo destOrgInfo) throws BOSException {
        BOTRelationCollection relationCol = this._getBotRelation(this.cardId, this.MonCurcardType);
        Set idSet = this.getAllTargetCardID(relationCol);
        if (idSet == null || idSet.size() <= 0) {
            return null;
        }
        EntityViewInfo viewInfo = this.getHasTransResultView(idSet);
        FilterInfo f2 = new FilterInfo();
        f2.getFilterItems().add(new FilterItemInfo("company.id", (Object)destOrgInfo.getId().toString(), CompareType.EQUALS));
        f2.setMaskString("#0");
        viewInfo.getFilter().mergeFilter(f2, "AND");
        FaMonCardCollection collection = FaMonCardFactory.getRemoteInstance().getFaMonCardCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public FaCurCardInfo checkHasTransfered(CompanyOrgUnitInfo destOrgInfo) throws BOSException {
        BOTRelationCollection relationCol = this._getBotRelation(this.cardId, this.CARDTYPE);
        Set idSet = this.getAllTargetCardID(relationCol);
        if (idSet == null || idSet.size() <= 0) {
            return null;
        }
        EntityViewInfo viewInfo = this.getHasTransResultView(idSet);
        FilterInfo f2 = new FilterInfo();
        f2.getFilterItems().add(new FilterItemInfo("company.id", (Object)destOrgInfo.getId().toString(), CompareType.EQUALS));
        f2.setMaskString("#0");
        viewInfo.getFilter().mergeFilter(f2, "AND");
        FaCurCardCollection collection = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public Set getAllTargetCardID(BOTRelationCollection relationCollection) {
        HashSet<String> targetCardIDS = new HashSet<String>();
        if (relationCollection != null) {
            BOTRelationInfo bot = null;
            for (int i = 0; i < relationCollection.size(); ++i) {
                bot = relationCollection.get(i);
                targetCardIDS.add(bot.getDestObjectID());
            }
        }
        return targetCardIDS;
    }

    public BOTRelationCollection _getBotRelation(String destVchId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)destVchId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getRemoteInstance().getCollection(view);
        return col;
    }

    private EntityViewInfo getHasTransResultView(Set ids) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.put("selector", (Object)sic);
        return view;
    }

    private CompanyOrgUnitInfo getDestBookCompany(String id) {
        if (this.bookCompany == null) {
            try {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("accountPeriodType.*"));
                viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)this.company.getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)id));
                viewInfo.setFilter(filterInfo);
                CompanyOrgUnitCollection orgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(viewInfo);
                if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
                    this.bookCompany = orgUnitCollection.get(0);
                }
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
        }
        return this.bookCompany;
    }
}

