/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaInfo;
import com.kingdee.eas.fi.fa.manage.IFaWorkArea;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaWorkAreaEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FaWorkAreaEditUI
extends AbstractFaWorkAreaEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaWorkAreaEditUI.class);
    protected HashMap hmParam;
    private CompanyOrgUnitInfo currCompany;
    private Map person_org = new HashMap();
    private ObjectValueRender nameRender = new ObjectValueRender();
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaBarCordResource";
    private KDBizPromptBox kDBizPromptBoxUser = new KDBizPromptBox();

    public FaWorkAreaEditUI() throws Exception {
        this.nameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
    }

    protected HashMap gethmParam() {
        if (this.hmParam == null) {
            try {
                this.hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
            }
            catch (EASBizException e) {
                this.hmParam = new HashMap();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.hmParam;
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            try {
                BOSUuid id = SysContext.getSysContext().getCurrentFIUnit().getId();
                this.currCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return this.currCompany;
    }

    public void onLoad() throws Exception {
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.kdtEntry.getSelectManager().setSelectMode(10);
        this.showBotton();
        this.setEditableRow(this.getOprtState());
        this.initConrtol();
        this.initPerson();
    }

    private void initPerson() throws Exception {
        HashMap map = new HashMap();
        boolean isRange = this.gethmParam().get("FA_040") == null ? false : "true".equals(this.gethmParam().get("FA_040").toString());
        PersonPromptBox personPromtBox = FaClientUtils.getRangePersonF7(isRange, map, (IUIObject)this);
        KDTextField txtMNumber = new KDTextField();
        this.txtNumber.setMaxLength(80);
        this.kdtEntry.getColumn("user.number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtMNumber));
        txtMNumber.setEnabled(false);
        KDTextField txtMDept = new KDTextField();
        this.kdtEntry.getColumn("dept").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtMNumber));
        txtMDept.setEnabled(false);
        KDTextField txtMHeadship = new KDTextField();
        this.kdtEntry.getColumn("job").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtMNumber));
        txtMHeadship.setEnabled(false);
        this.kDBizPromptBoxUser.setEditable(true);
        this.kDBizPromptBoxUser.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.kDBizPromptBoxUser.setDisplayFormat("$number$");
        this.kDBizPromptBoxUser.setEditFormat("$number$");
        this.kDBizPromptBoxUser.setCommitFormat("$number$");
        this.kDBizPromptBoxUser.setSelector((KDPromptSelector)personPromtBox);
        this.kDBizPromptBoxUser.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
        this.kDBizPromptBoxUser.setHasCUDefaultFilter(false);
        this.kdtEntry.getColumn("user.name").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxUser));
        this.kdtEntry.getColumn("user.name").setRenderer((IBasicRender)this.nameRender);
        this.kdtEntry.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int row = e.getRowIndex();
                int col = e.getColIndex();
                if (FaWorkAreaEditUI.this.kdtEntry.getColumnKey(col).equalsIgnoreCase("user.name") && e.getValue() instanceof PersonInfo) {
                    FaWorkAreaEditUI.this.kdtEntry.getRow(row).getCell(col).setValue((Object)e.getValue().toString());
                    String name = e.getValue().toString();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name));
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    viewInfo.setFilter(filterInfo);
                    try {
                        PersonCollection cols = PersonFactory.getRemoteInstance().getPersonCollection(viewInfo);
                        if (FaWorkAreaEditUI.this.getEntryExistUser().containsKey(cols.get(0).getName())) {
                            if (0 == MsgBox.showConfirm2((String)EASResource.getString((String)FaWorkAreaEditUI.RESOURCE_PATH, (String)"userSame"))) {
                                FaWorkAreaEditUI.this.kdtEntry.removeRow(row);
                            }
                        } else if (cols != null && cols.size() > 0) {
                            FaWorkAreaEditUI.this.kdtEntry.getRow(row).getCell("user.number").setValue((Object)cols.get(0).getNumber());
                            FaWorkAreaEditUI.this.kdtEntry.getRow(row).getCell("user.name").setValue((Object)cols.get(0).getName());
                            FaWorkAreaEditUI.this.kdtEntry.getRow(row).getCell("dept").setValue((Object)FaWorkAreaEditUI.this.getPrimaryAdminOrgId(cols.get(0).getId().toString()).getAdminOrgUnit());
                            FaWorkAreaEditUI.this.kdtEntry.getRow(row).getCell("job").setValue((Object)FaWorkAreaEditUI.this.getPrimaryAdminOrgId(cols.get(0).getId().toString()));
                        }
                    }
                    catch (BOSException ex) {
                        FaWorkAreaEditUI.this.handUIException(ex);
                    }
                }
            }
        });
        KDTPropertyChangeListener listener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue")) {
                    int rowIndex = evt.getRowIndex();
                    int colIndex = evt.getColIndex();
                    if (FaWorkAreaEditUI.this.kdtEntry.getColumnKey(colIndex).equalsIgnoreCase("user.name") && FaWorkAreaEditUI.this.kdtEntry.getRow(rowIndex).getCell("user.name").getValue() == null) {
                        FaWorkAreaEditUI.this.kdtEntry.getRow(rowIndex).getCell("user.number").setValue(null);
                        FaWorkAreaEditUI.this.kdtEntry.getRow(rowIndex).getCell("dept").setValue(null);
                        FaWorkAreaEditUI.this.kdtEntry.getRow(rowIndex).getCell("job").setValue(null);
                    }
                }
            }
        };
        this.kdtEntry.addKDTPropertyChangeListener(listener);
        KDTextField txtMRemark = new KDTextField();
        this.txtRemark.setMaxLength(255);
        this.kdtEntry.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtMRemark));
        if (!"VIEW".equals(this.getOprtState())) {
            this.kdtEntry.getColumn("user.name").getStyleAttributes().setBackground(this.kdtEntry.getRequiredColor());
            this.kDBizPromptBoxUser.setRequired(true);
        }
        this.enableAutoAddLineDownArrow(this.kdtEntry);
    }

    public Map getExistUser() {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("entry.user.number");
        view.getSelector().add("entry.user.name");
        view.getSelector().add("id");
        try {
            CoreBaseCollection cols = this.getBizInterface().getCollection(view);
            for (int i = 0; cols != null && i < cols.size(); ++i) {
                FaWorkAreaInfo info = (FaWorkAreaInfo)cols.get(i);
                if (info == null || info.getEntry().size() == 0) continue;
                String number = "";
                String name = "";
                for (int j = 0; j < info.getEntry().size(); ++j) {
                    if (info.getEntry().get(j).getUser() == null) continue;
                    number = info.getEntry().get(j).getUser().getNumber();
                    name = info.getEntry().get(j).getUser().getName();
                    map.put(number, name);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return map;
    }

    public Map getEntryExistUser() {
        HashMap<String, String> map = new HashMap<String, String>();
        int size = this.kdtEntry.getRowCount();
        if (size > 1) {
            for (int i = 0; i < size - 1; ++i) {
                IRow row = this.kdtEntry.getRow(i);
                String number = "";
                String name = "";
                if (row.getCell("user.number").getValue() == null || row.getCell("user.name").getValue() == null) continue;
                number = row.getCell("user.number").getValue().toString();
                name = row.getCell("user.name").getValue().toString();
                map.put(name, number);
            }
        }
        return map;
    }

    private PositionInfo getPrimaryAdminOrgId(String personID) throws BOSException {
        if (this.person_org.containsKey(personID)) {
            return (PositionInfo)this.person_org.get(personID);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("position.adminOrgUnit.id");
        view.getSelector().add("position.adminOrgUnit.name");
        view.getSelector().add("position.adminOrgUnit.number");
        view.getSelector().add("position.name");
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        f.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        view.setFilter(f);
        PositionMemberCollection cols = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        if (cols != null && cols.size() > 0) {
            PositionInfo positionInfo = cols.get(0).getPosition();
            this.person_org.put(personID, positionInfo);
            return positionInfo;
        }
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.setPerson();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void setPerson() {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            IRow row = this.kdtEntry.getRow(i);
            FaWorkAreaEntryInfo entry = (FaWorkAreaEntryInfo)row.getUserObject();
            String name = "";
            if (row.getCell("user.number").getValue() != null) {
                name = row.getCell("user.name").getValue().toString();
            }
            String number = "";
            if (row.getCell("user.number").getValue() != null) {
                number = row.getCell("user.number").getValue().toString();
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            try {
                PersonCollection cols = PersonFactory.getRemoteInstance().getPersonCollection(viewInfo);
                if (cols.get(0) != null) {
                    entry.setUser(cols.get(0));
                    entry.setUseDept(this.getPrimaryAdminOrgId(cols.get(0).getId().toString()).getAdminOrgUnit());
                    entry.setJob(this.getPrimaryAdminOrgId(cols.get(0).getId().toString()));
                } else {
                    entry.setUser(null);
                    entry.setUseDept(null);
                    entry.setJob(null);
                }
                entry.setDescription(row.getCell("description").getValue() == null ? "" : row.getCell("description").getValue().toString());
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void showBotton() {
        this.contFaUser.removeButton((JButton)this.btnInsertUser);
        this.contFaUser.removeButton((JButton)this.btnRemoveUser);
        this.contFaUser.addButton((JButton)this.btnInsertUser);
        this.contFaUser.addButton((JButton)this.btnRemoveUser);
        this.btnInsertUser.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initConrtol() throws Exception {
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnSave.setVisible(false);
        this.txtNumber.setRequired(true);
        this.txtArea.setRequired(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    protected IObjectValue createNewData() {
        FaWorkAreaInfo info = new FaWorkAreaInfo();
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable arg0) {
        return new FaWorkAreaEntryInfo();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaWorkAreaFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionInsertUser_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kdtEntry.addRow();
        this.setEditableRow(this.getOprtState());
    }

    private void setEditableRow(String oprtState) {
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.kdtEntry.getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntry.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionRemoveUser_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.tableDelLine(this.kdtEntry);
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        IFaWorkArea factory = FaWorkAreaFactory.getRemoteInstance();
        String strTemp = "";
        KDTextField focusComp = this.txtNumber;
        StringBuffer sb = new StringBuffer();
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().length() == 0) {
            strTemp = EASResource.getString((String)RESOURCE_PATH, (String)"strNumberIsNull");
            sb.append(strTemp);
        }
        if (this.editData.getName() == null || this.editData.getName().trim().length() == 0) {
            strTemp = EASResource.getString((String)RESOURCE_PATH, (String)"strNameIsNull");
            if (sb.toString().length() == 0) {
                sb.append(strTemp);
                focusComp = this.txtArea;
            } else {
                sb.append(";");
                sb.append(strTemp);
            }
        } else {
            boolean isfileName = StringUtils.isFileName((String)this.editData.getName());
            if (!isfileName) {
                strTemp = EASResource.getString((String)RESOURCE_PATH, (String)"strIllegalName");
                if (sb.toString().length() == 0) {
                    sb.append(strTemp);
                    focusComp = this.txtArea;
                } else {
                    sb.append(";");
                    sb.append(strTemp);
                }
            } else {
                try {
                    factory.checkNameDup(this.editData);
                }
                catch (EASBizException e1) {
                    this.txtArea.requestFocus();
                    throw e1;
                }
            }
        }
        if (this.editData.getEntry().size() == 0) {
            strTemp = EASResource.getString((String)RESOURCE_PATH, (String)"includeCardZero");
            if (sb.toString().length() == 0) {
                sb.append(strTemp);
                focusComp = this.btnInsertUser;
            } else {
                sb.append(";");
                sb.append(strTemp);
            }
        }
        if (this.editData.getEntry().size() > 0) {
            FaWorkAreaEntryCollection colls = this.editData.getEntry();
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getUser() != null) continue;
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"userisnotnull"));
                SysUtil.abort();
            }
        }
        if (sb.toString().length() > 0) {
            focusComp.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            SysUtil.abort();
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.oprtState)) {
            this.btnCopy.setEnabled(false);
        } else {
            this.btnCopy.setEnabled(true);
        }
        if ("EDIT".equals(this.oprtState) || "ADDNEW".equals(this.oprtState)) {
            this.btnInsertUser.setEnabled(true);
            this.btnRemoveUser.setEnabled(true);
        } else {
            this.btnInsertUser.setEnabled(false);
            this.btnRemoveUser.setEnabled(false);
        }
    }
}

