/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaWorkAreaListUI;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaWorkAreaEditUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.F7Render;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Dimension;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaWorkAreaListUI
extends AbstractFaWorkAreaListUI
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger(FaWorkAreaListUI.class);
    private CoreUI coreUI;
    private String title;
    private boolean isF7Use = false;
    private F7Render f7Delegate;

    public FaWorkAreaListUI() throws Exception {
        this.menuItemImportData.setEnabled(false);
        this.menuItemImportData.setVisible(false);
    }

    public FaWorkAreaListUI(CoreUI coreUI, String title) throws Exception {
        this.coreUI = coreUI;
        this.title = title;
        this.isF7Use = true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    public Map getUserName() {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("entry.user.name");
        view.getSelector().add("id");
        try {
            CoreBaseCollection cols = this.getBizInterface().getCollection(view);
            for (int i = 0; cols != null && i < cols.size(); ++i) {
                FaWorkAreaInfo info = (FaWorkAreaInfo)cols.get(i);
                if (info == null || info.getEntry().size() == 0) continue;
                String str = "";
                for (int j = 0; j < info.getEntry().size(); ++j) {
                    if (info.getEntry().get(j).getUser() == null || info.getEntry().size() >= 10 && j >= 10) continue;
                    if (j != 0) {
                        str = str + ";";
                    }
                    str = str + info.getEntry().get(j).getUser().getName();
                }
                map.put(info.getId().toString(), str);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return map;
    }

    public void onGetRowSet(IRowSet rs) {
        super.onGetRowSet(rs);
        Map map = this.getUserName();
        try {
            String columnIndex = "user.number";
            while (rs.next()) {
                String strEvaItems = map.get(rs.getString("id")) == null ? "" : map.get(rs.getString("id")).toString();
                rs.updateString(columnIndex, strEvaItems);
            }
            rs.beforeFirst();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(ev);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaWorkAreaFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return FaWorkAreaEditUI.class.getName();
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    protected String getQueryFieldName() {
        return "number";
    }

    protected String[] getLocateNames() {
        return new String[]{"number", "name"};
    }

    public HashMap gethmParamD() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(SysContext.getSysContext().getCurrentFIUnit().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            Processor processor = new Processor();
            boolean isRange = "true".equals(this.gethmParamD().get("FA_040").toString());
            processor.setRange(isRange);
            dialog.setProcessor((IProcessor)processor);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        dialog.setWidth(450);
        dialog.setHeight(320);
        return dialog;
    }

    public Object getData() {
        return this.f7Delegate.getF7Data();
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    public void setF7Use(boolean isF7Use, Map ctx) throws Exception {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            this.setPreferredSize(new Dimension(450, 300));
            if (ctx == null) {
                ctx = new HashMap();
            }
            this.setUITitle(this.title);
            this.f7Delegate = new F7Render((ListUI)this, ctx);
            this.f7Delegate.init();
            this.initLayout();
        } else {
            SysUtil.abort();
        }
    }

    public void show() {
        if (this.isF7Use) {
            this.lockAction();
            if (this.f7Delegate == null) {
                UIContext ctx = new UIContext((Object)this.coreUI);
                try {
                    this.setF7Use(true, (Map)ctx);
                }
                catch (Exception e) {
                    this.f7Delegate = null;
                    SysUtil.abort();
                }
            }
            this.f7Delegate.show();
        } else {
            super.show();
        }
    }

    protected void lockAction() {
        if (this.isF7Use) {
            this.toolBar.setVisible(false);
            this.menuBar.setVisible(false);
        } else {
            super.lockAction();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isF7Use && e.getClickCount() == 2) {
            this.f7Delegate.actionConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    class Processor
    extends FACommonProcessor {
        @Override
        public void process() throws Exception {
            super.process();
            String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
            if (fieldProperty == null || fieldProperty.trim().length() == 0) {
                return;
            }
            CoreUI parent = new CoreUI();
            if (this.get("parentDialog") != null) {
                parent = ((CommonQueryDialog)this.get("parentDialog")).getWindow().getUIObject();
            }
            Object editor = this.get("CURRENT_EDITOR");
            if (fieldProperty.equalsIgnoreCase("user.name") && editor instanceof KDBizPromptBox) {
                KDBizPromptBox f7 = (KDBizPromptBox)editor;
                HashMap map = new HashMap();
                PersonPromptBox personPromptBox = FaClientUtils.getRangePersonF7(this.isRange(), map, (IUIObject)parent);
                f7.setSelector((KDPromptSelector)personPromptBox);
                f7.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
                f7.setHasCUDefaultFilter(false);
            }
        }
    }
}

