/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.IFaWorkLoad;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaWorkLoadEditUI;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FAWorkLoadBatchChangeUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.PeriodFilterPanel;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mobile.SendMsgMananger;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FaWorkLoadEditUI
extends AbstractFaWorkLoadEditUI {
    private CommonQueryDialog dialog = null;
    CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
    FaWorkLoadCollection workLoadCollection = null;
    int amountScale = 2;
    private static String CURRENTWORKLOAD = "correntWorkLoad";
    private static String TOTALWORKLOAD = "totalWorkLoad";
    private static String SUMWORKLOAD = "sumWorkLoad";
    private static String LEAVEWORKLOAD = "lastWorkLoad";
    EntityViewInfo view = null;
    private PeriodInfo currentPeriod;
    PeriodFilterPanel workLoadFilter = new PeriodFilterPanel();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return new FaWorkLoadInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaWorkLoadFactory.getRemoteInstance();
    }

    protected void inOnload() throws Exception {
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWorkLoadResource", (String)"MNT_Title");
    }

    public IObjectPK runSubmit() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        this.aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        super.onLoad();
        FaClientUtils.checkComp((Component)((Object)this), this.aCompanyOrgUnitInfo);
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        list.add(this.aCompanyOrgUnitInfo);
        HashMap zipData = FaDepreciationFactory.getRemoteInstance().getZipDataForRPC(list);
        this.currentPeriod = (PeriodInfo)zipData.get("currPeriod");
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.enableExportExcel(this.getDetailTable());
        this.initBtn();
        this.initTable();
        this.handleQuery(null);
        this.editData = new FaWorkLoadInfo();
        this.getDetailTable().getSelectManager().setSelectMode(10);
    }

    private void initBtn() {
        this.btnReturn.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnBatchChange.setIcon(EASResource.getIcon((String)"imgTbtn_editbatch"));
        this.btnBatchChange.setEnabled(true);
        this.menuItemReturn.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    private void initTable() {
        this.getDetailTable().checkParsed();
        this.getDetailTable().getStyleAttributes().setLocked(true);
        IColumn col_CurrentAmount = this.getDetailTable().getColumn(CURRENTWORKLOAD);
        col_CurrentAmount.getStyleAttributes().setLocked(false);
        KDFormattedTextField fTxtFieldFacAmount = new KDFormattedTextField(1);
        fTxtFieldFacAmount.setPrecision(this.amountScale);
        fTxtFieldFacAmount.setNegatived(false);
        fTxtFieldFacAmount.setHorizontalAlignment(4);
        this.getDetailTable().getColumn(CURRENTWORKLOAD).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)fTxtFieldFacAmount));
        this.getDetailTable().getColumn(CURRENTWORKLOAD).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getDetailTable().getColumn(CURRENTWORKLOAD).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.getDetailTable().getColumn(TOTALWORKLOAD).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getDetailTable().getColumn(TOTALWORKLOAD).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.getDetailTable().getColumn(SUMWORKLOAD).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getDetailTable().getColumn(SUMWORKLOAD).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.getDetailTable().getColumn(LEAVEWORKLOAD).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getDetailTable().getColumn(LEAVEWORKLOAD).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        KDTPropertyChangeListener l = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue")) {
                    int colIndex = evt.getColIndex();
                    if (CURRENTWORKLOAD.equals(FaWorkLoadEditUI.this.getDetailTable().getColumnKey(colIndex)) && evt.getOldValue() != null) {
                        FaWorkLoadEditUI.this.amountChanged(evt);
                    }
                }
            }
        };
        this.getDetailTable().addKDTPropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (!this.currentPeriod.getId().toString().equals(FaClientUtils.getFACurrentPeriod().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWorkLoadResource", (String)"MNT_PeriodError"));
                SysUtil.abort();
            }
            this.verifyInput(e);
            FaWorkLoadCollection c = this.fieldsStore();
            if (c.size() == 0) {
                this.showNotNeedSubmit();
                return;
            }
            IFaWorkLoad workLoad = FaWorkLoadFactory.getRemoteInstance();
            workLoad.batchUpdate((IObjectCollection)c);
            this.showSubmitSuccess();
            if (this.view == null) {
                return;
            }
            this.getData(this.view);
            this.showData();
            this.validateAction();
        }
        finally {
            if (this.view != null) {
                this.getData(this.view);
                this.showData();
                this.validateAction();
            }
        }
    }

    private void showNotNeedSubmit() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_NotNeedSubmit"));
        this.showMessage();
    }

    private FaWorkLoadCollection fieldsStore() throws EASBizException, BOSException {
        int i;
        FaWorkLoadCollection entryCollection = new FaWorkLoadCollection();
        HashSet<String> set = new HashSet<String>();
        int rowCount = this.getDetailTable().getRowCount();
        for (i = 0; i < rowCount; ++i) {
            String cardId = (String)this.getDetailTable().getRow(i).getCell("cardId").getValue();
            if (cardId == null) continue;
            set.add(cardId);
        }
        for (i = 0; i < rowCount; ++i) {
            FaWorkLoadInfo info = this.fieldsStoreLine(i);
            if (info == null) continue;
            entryCollection.add(info);
        }
        return entryCollection;
    }

    private FaWorkLoadInfo fieldsStoreLine(int i) {
        IRow row = this.getDetailTable().getRow(i);
        FaWorkLoadInfo info = (FaWorkLoadInfo)row.getUserObject();
        BigDecimal workLoadValue = (BigDecimal)row.getCell(CURRENTWORKLOAD).getValue();
        if (workLoadValue == null) {
            workLoadValue = new BigDecimal("0");
        }
        BigDecimal sumWorkLoad = (BigDecimal)row.getCell(SUMWORKLOAD).getValue();
        BigDecimal leaveWorkLoad = (BigDecimal)row.getCell(LEAVEWORKLOAD).getValue();
        if (info.getCurrentWorkLoad().compareTo(workLoadValue) == 0) {
            return null;
        }
        info.setCurrentWorkLoad(workLoadValue);
        info.setLastWorkLoad(leaveWorkLoad);
        info.setSumWorkLoad(sumWorkLoad);
        return info;
    }

    protected KDTable getDetailTable() {
        return this.tblWorkLoad;
    }

    private CommonQueryDialog getDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            HashMap hmParam = this.gethmParam();
            boolean isRange = "true".equals(hmParam.get("FA_040").toString());
            FACommonProcessor processor = new FACommonProcessor(this.currentPeriod);
            processor.setRange(isRange);
            this.dialog.setProcessor((IProcessor)processor);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setEntityViewInfo(new EntityViewInfo());
            this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaWorkLoadQuery"));
            this.dialog.addUserPanel((KDPanel)this.workLoadFilter);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.dialog.setShowToolbar(true);
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWorkLoadResource", (String)"Find_Title"));
            this.dialog.setDisVisiableDefaultView(true);
            this.dialog.setShowFieldCompare(false);
            this.dialog.setHeight(300);
            this.dialog.setWidth(400);
            EntityViewInfo defaultQuery = new EntityViewInfo();
            defaultQuery.getSorter().add(new SorterItemInfo("number"));
            this.dialog.setDefalutEntityViewInfo(defaultQuery);
        }
        return this.dialog;
    }

    public HashMap gethmParam() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.aCompanyOrgUnitInfo.getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    private void handleQuery(ActionEvent e) throws Exception {
        this.view = this.showFilter(e);
        if (this.view == null) {
            return;
        }
        this.getData(this.view);
        this.showData();
        this.validateAction();
    }

    private EntityViewInfo showFilter(ActionEvent e) throws Exception {
        EntityViewInfo view = null;
        if (this.getDialog().show()) {
            view = this.dialog.getEntityViewInfoResult();
        } else if (e == null) {
            SysUtil.abort();
        }
        return view;
    }

    private void getData(EntityViewInfo view) throws Exception {
        if (view == null) {
            return;
        }
        IFaWorkLoad workLoad = FaWorkLoadFactory.getRemoteInstance();
        FilterInfo workFilter = this.workLoadFilter.getWorkFilterInfo();
        this.workLoadCollection = workLoad.findWorkLoad(view, workFilter);
    }

    private void showData() throws Exception {
        this.getDetailTable().removeRows();
        String s = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"accountPeriod");
        s = s + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), this.workLoadFilter.getPeriodYear().toString(), this.workLoadFilter.getPeriodNumber().toString());
        this.lblPeriod.setText(s);
        if (this.workLoadCollection == null || this.workLoadCollection.size() == 0) {
            return;
        }
        boolean refresh = this.getDetailTable().isRefresh();
        this.getDetailTable().setRefresh(false);
        for (int i = 0; i < this.workLoadCollection.size(); ++i) {
            FaWorkLoadInfo workLoadInfo = this.workLoadCollection.get(i);
            this.addOneRow(this.getDetailTable(), workLoadInfo);
        }
        this.getDetailTable().setRefresh(refresh);
        this.getDetailTable().repaint();
    }

    private void addOneRow(KDTable table, FaWorkLoadInfo workLoadInfo) throws Exception {
        IRow row = table.addRow();
        row.getCell("id").setValue((Object)workLoadInfo.getId());
        row.getCell("cardCat").setValue((Object)workLoadInfo.getCurCard().getAssetCat().getName());
        row.getCell("number").setValue((Object)workLoadInfo.getCurCard().getNumber());
        row.getCell("name").setValue((Object)workLoadInfo.getCurCard().getAssetName());
        row.getCell(CURRENTWORKLOAD).setValue((Object)workLoadInfo.getCurrentWorkLoad());
        row.getCell(TOTALWORKLOAD).setValue((Object)workLoadInfo.getTotalWorkLoad());
        row.getCell(SUMWORKLOAD).setValue((Object)workLoadInfo.getSumWorkLoad());
        row.getCell(LEAVEWORKLOAD).setValue((Object)workLoadInfo.getLastWorkLoad());
        row.getCell("cardId").setValue((Object)workLoadInfo.getCurCard().getId().toString());
        row.setUserObject((Object)workLoadInfo);
    }

    private void validateAction() {
        boolean isCurrPeriod = this.workLoadFilter.isCurrentPeriod();
        IColumn col_CurrentAmount = this.getDetailTable().getColumn(CURRENTWORKLOAD);
        col_CurrentAmount.getStyleAttributes().setLocked(!isCurrPeriod);
        this.actionSave.setEnabled(isCurrPeriod);
        this.actionSubmit.setEnabled(isCurrPeriod);
        this.actionRedo.setEnabled(isCurrPeriod);
    }

    @Override
    public void actionRedo_actionPerformed(ActionEvent e) throws Exception {
        this.showData();
        this.validateAction();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        this.handleQuery(e);
        this.currentPeriod = FaClientUtils.getFACurrentPeriod();
    }

    @Override
    public void actionBatchChange_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblWorkLoad);
        if (selectRows.length == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        String uiClassName = "com.kingdee.eas.fi.fa.manage.client.FAWorkLoadBatchChangeUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        String workLoadStr = ((FAWorkLoadBatchChangeUI)uiWindow.getUIObject()).getWorkLoad();
        if (workLoadStr != null) {
            BigDecimal workLoad = new BigDecimal(workLoadStr);
            for (int i = 0; i < selectRows.length; ++i) {
                int rowNum = selectRows[i];
                this.tblWorkLoad.getRow(rowNum).getCell(CURRENTWORKLOAD).setValue((Object)workLoad);
            }
        }
    }

    protected void amountChanged(KDTPropertyChangeEvent evt) {
        int rowIndex = evt.getRowIndex();
        BigDecimal newValue = (BigDecimal)evt.getNewValue();
        BigDecimal oldValue = (BigDecimal)evt.getOldValue();
        if (newValue == null) {
            newValue = new BigDecimal("0");
        }
        if (oldValue == null) {
            oldValue = new BigDecimal("0");
        }
        BigDecimal sum = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(SUMWORKLOAD).getValue();
        sum = sum.subtract(oldValue).add(newValue);
        this.getDetailTable().getRow(rowIndex).getCell(SUMWORKLOAD).setValue((Object)sum);
        BigDecimal leave = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(LEAVEWORKLOAD).getValue();
        leave = leave.add(oldValue).subtract(newValue);
        this.getDetailTable().getRow(rowIndex).getCell(LEAVEWORKLOAD).setValue((Object)leave);
    }

    protected void tblDetail_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected void showSubmitSuccess() {
        this.setMessageText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK_New"), this.getClassAlise()));
        this.showMessage();
    }

    protected String getClassAlise() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)new FaWorkLoadInfo());
        return className;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.getDetailTable().getRow(i);
            BigDecimal sum = (BigDecimal)row.getCell(SUMWORKLOAD).getValue();
            BigDecimal total = (BigDecimal)row.getCell(TOTALWORKLOAD).getValue();
            BigDecimal workLoad = (BigDecimal)row.getCell(CURRENTWORKLOAD).getValue();
            if (workLoad != null && workLoad.compareTo(new BigDecimal(0)) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWorkLoadResource", (String)"MNT_WorkLoad"));
                SysUtil.abort();
            }
            if (sum.compareTo(total) <= 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWorkLoadResource", (String)"MNT_SUM"));
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        boolean flag = false;
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.getDetailTable().getRow(i);
            FaWorkLoadInfo info = (FaWorkLoadInfo)row.getUserObject();
            BigDecimal workLoadValue = (BigDecimal)row.getCell(CURRENTWORKLOAD).getValue();
            if (workLoadValue == null) {
                workLoadValue = new BigDecimal("0");
            }
            if (info.getCurrentWorkLoad().compareTo(workLoadValue) == 0) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit_actionPerformed(event);
                    return true;
                }
                catch (Exception exc) {
                    this.handUIException(exc);
                    return false;
                }
            }
            return result == 1;
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().getPrintManager().printPreview();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnReturn);
        this.setButtonDefaultStyl(this.btnFilter);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState() == OprtState.ADDNEW) {
            super.actionSendMessage_actionPerformed(e);
        } else {
            new SendMsgMananger((Component)((Object)this), (CoreBaseInfo)this.editData);
        }
    }
}

