/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FlPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFlPeriodCloseFacade;
import com.kingdee.eas.fi.fa.manage.client.AbstractFlPeriodCloseUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class FlPeriodCloseUI
extends AbstractFlPeriodCloseUI {
    private static final Logger logger = CoreUIObject.getLogger(FlPeriodCloseUI.class);
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FlPeriodCloseResource";
    private CompanyOrgUnitInfo curCompany;
    private String infoText;

    public void onLoad() throws Exception {
        super.onLoad();
        this.checkMonthEnd();
        this.rbUndoClose.setVisible(true);
        this.rbUndoClose.setEnabled(true);
        this.infoText = this.txtInfo.getText();
        this.updatePeriodText();
    }

    protected void checkMonthEnd() throws Exception {
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.checkComp((Component)((Object)this), currCompany);
        this.checkFaInit((Component)((Object)this), currCompany);
    }

    private void updatePeriodText() throws EASBizException, BOSException {
        PeriodInfo curPeriod = this.getCurPeriod();
        PeriodInfo nextPeriod = this.getNextPeriod();
        String text = this.infoText + "\n\n";
        String strCurrentPeriod = EASResource.getString((String)RES_PATH, (String)"currentPeriod");
        String strNextPeriod = EASResource.getString((String)RES_PATH, (String)"nextPeriod");
        String strTheYear = EASResource.getString((String)RES_PATH, (String)"theYear");
        String strThePeriod = EASResource.getString((String)RES_PATH, (String)"thePeriod");
        text = text + strCurrentPeriod + curPeriod.getPeriodYear() + strTheYear + curPeriod.getPeriodNumber() + strThePeriod + "\n";
        text = nextPeriod != null ? text + strNextPeriod + nextPeriod.getPeriodYear() + strTheYear + nextPeriod.getPeriodNumber() + strThePeriod + "\n" : text + strNextPeriod + "\n";
        this.txtInfo.setText(text);
    }

    private void checkFaInit(Component component, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws Exception {
        boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (!isInitEnd) {
            String strMsg = EASResource.getString((String)RES_PATH, (String)"notEndInit");
            MsgBox.showInfo((Component)component, (String)strMsg);
            SysUtil.abort();
        }
    }

    private void checkComp(Component comp, CompanyOrgUnitInfo aCompanyOrgUnitInfo) {
        if (aCompanyOrgUnitInfo != null) {
            String strMsg;
            if (aCompanyOrgUnitInfo.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)aCompanyOrgUnitInfo.getInvalidDate(), (Date)new Date())) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled");
                MsgBox.showInfo((Component)comp, (String)strMsg);
                SysUtil.abort();
            }
            if (!aCompanyOrgUnitInfo.isIsBizUnit()) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun");
                MsgBox.showInfo((Component)comp, (String)strMsg);
                SysUtil.abort();
            }
        } else {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null");
            MsgBox.showInfo((Component)comp, (String)strMsg);
            SysUtil.abort();
        }
        this.checkPeriod(comp, aCompanyOrgUnitInfo);
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
    }

    private void checkPeriod(Component comp, CompanyOrgUnitInfo company) {
        PeriodInfo aPeriodInfo = null;
        try {
            aPeriodInfo = this.getCurPeriod();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)comp, (String)e.toString());
            SysUtil.abort();
        }
        if (aPeriodInfo == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod");
            MsgBox.showInfo((Component)comp, (String)strMsg);
            SysUtil.abort();
        }
    }

    private PeriodInfo getCurPeriod() throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.getCurCompany());
    }

    private PeriodInfo getNextPeriod() throws EASBizException, BOSException {
        return PeriodUtils.getNextPeriodInfo((PeriodInfo)this.getCurPeriod());
    }

    private CompanyOrgUnitInfo getCurCompany() {
        if (this.curCompany == null) {
            this.curCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        return this.curCompany;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void rbClose_actionPerformed(ActionEvent e) throws Exception {
        super.rbClose_actionPerformed(e);
    }

    @Override
    protected void rbUndoClose_actionPerformed(ActionEvent e) throws Exception {
        super.rbUndoClose_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexUuid = Uuid.create();
        String mutexActionName = "financeLeasePeriodClose";
        try {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            MutexParameter mutexParam = FaClientUtils.setMutexParameter(mutexUuid, mutexActionName);
            if (FaClientUtils.requestMutex(mutexParam)) {
                IFlPeriodCloseFacade periodClose = FlPeriodCloseFacadeFactory.getRemoteInstance();
                if (this.rbClose.isSelected()) {
                    periodClose.carrayForward(company);
                } else {
                    periodClose.carrayBack(company.getId().toString());
                }
                this.updatePeriodText();
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"Fa_Mutex_Is_InProcess"));
                this.abort();
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            throw exception;
        }
        finally {
            FaClientUtils.releaseMutex(mutexUuid);
        }
    }

    @Override
    public void actionSelectedClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectedClose_actionPerformed(e);
    }

    @Override
    public void actionSelectedUndo_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectedUndo_actionPerformed(e);
    }
}

