/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FlContrastSolutionInfo;
import com.kingdee.eas.fi.fa.manage.NLMReconciliationAnalysisFacadeFactory;
import com.kingdee.eas.fi.fa.manage.client.AbstractNLMReconciliationAnalysisUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseInNewEditUI;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NLMReconciliationAnalysisUI
extends AbstractNLMReconciliationAnalysisUI {
    private static final Logger logger = CoreUIObject.getLogger(NLMReconciliationAnalysisUI.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final Color YELLOW = new Color(255, 255, 200);
    private static final Color GRAY = new Color(222, 222, 222, 255);
    private Map queryCriteria;
    private boolean isIncludeUnposted;
    private Map parseQueryCriteria;
    private boolean isShowAll = false;
    private CompanyOrgUnitInfo curCompany;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPreferredSize(new Dimension(1800, 650));
        this.btnRefresh.setEnabled(true);
        this.btnShowAllDetail.setEnabled(true);
        this.btnShowAllDiff.setVisible(false);
        this.btnShowAllDiff.setEnabled(true);
        this.btnLinkLeaseInBill.setEnabled(true);
        this.btnLinkVoucher.setEnabled(true);
        this.queryCriteria = (Map)this.getUIContext().get("queryCriteria");
        this.isIncludeUnposted = (Boolean)this.getUIContext().get("isIncludeUnposted");
        this.parseQueryCriteria = this.parseQueryCriteria(this.queryCriteria);
        this.parseQueryCriteria.put("isIncludeUnposted", this.isIncludeUnposted);
        this.bizPromptCurCompany.setEnabled(false);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("baseCurrency.precision");
        this.curCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.queryCriteria.get("orgId").toString()), selectorItemCollection);
        this.bizPromptCurCompany.setValue((Object)this.curCompany);
        this.initAnalysisTable();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        List queryData = NLMReconciliationAnalysisFacadeFactory.getRemoteInstance().getReconciliationAnalysisData(this.parseQueryCriteria, this.isShowAll);
        this.fillTableData(queryData);
    }

    @Override
    public void actionLinkLeaseInBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.analysisTable.getSelectManager().getActiveRowIndex() == -1) {
            return;
        }
        String nlmBillNumber = (String)this.analysisTable.getRow2(this.analysisTable.getSelectManager().getActiveRowIndex()).getCell("nlmBillNumber").getValue();
        if (nlmBillNumber == null || "".equals(nlmBillNumber)) {
            return;
        }
        String linkLeaseInBillId = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo("where company.id = '" + this.queryCriteria.get("orgId") + "' and number = '" + nlmBillNumber + "'").getId().toString();
        Map uiContext = this.getUIContext();
        uiContext.put("ID", linkLeaseInBillId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaLeaseInNewEditUI.class.getName(), uiContext, null, "FINDVIEW");
        uiWindow.show();
    }

    @Override
    public void actionLinkVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (this.analysisTable.getSelectManager().getActiveRowIndex() == -1) {
            return;
        }
        String linkVoucherId = (String)this.analysisTable.getRow2(this.analysisTable.getSelectManager().getActiveRowIndex()).getCell("glVoucherID").getValue();
        if (linkVoucherId == null || "".equals(linkVoucherId)) {
            return;
        }
        Map uiContext = this.getUIContext();
        uiContext.put("ID", linkVoucherId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(VoucherEditUI.class.getName(), uiContext, null, "FINDVIEW");
        uiWindow.show();
    }

    @Override
    public void actionShowAllDetail_actionPerformed(ActionEvent e) throws Exception {
        this.btnShowAllDiff.setVisible(true);
        this.btnShowAllDetail.setVisible(false);
        this.isShowAll = true;
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionShowAllDiff_actionPerformed(ActionEvent e) throws Exception {
        this.btnShowAllDiff.setVisible(false);
        this.btnShowAllDetail.setVisible(true);
        this.isShowAll = false;
        this.actionRefresh_actionPerformed(e);
    }

    private void fillTableData(List<Map<String, String>> queryData) {
        this.analysisTable.removeRows();
        int j = queryData.size();
        for (int i = 0; i < j; ++i) {
            IRow curRow = this.analysisTable.getRow2(i);
            if (curRow == null) {
                curRow = this.analysisTable.addRow(i);
            }
            Map<String, String> queryDataSingle = queryData.get(i);
            for (String key : queryDataSingle.keySet()) {
                curRow.getCell(key).setValue((Object)queryDataSingle.get(key));
                if (!"".equals(queryDataSingle.get(key)) || "diffType".equals(key)) continue;
                curRow.getCell(key).getStyleAttributes().setBackground(GRAY);
            }
            if (i == 0) continue;
            IRow lastRow = this.analysisTable.getRow2(i - 1);
            this.doMergeTable(lastRow, curRow);
        }
        if (!this.isShowAll) {
            this.doRemoveFlatRecordValue();
        }
        this.doTotalProcessingData();
        int lastRowIndex = this.analysisTable.getRowCount() - 1;
        this.analysisTable.getMergeManager().mergeBlock(0, 0, lastRowIndex, 3, 1);
    }

    private void doTotalProcessingData() {
        int totalRowIndex = this.analysisTable.getRowCount();
        IRow curRow = this.analysisTable.addRow(totalRowIndex);
        curRow.getStyleAttributes().setBackground(YELLOW);
        int basePrecision = this.curCompany.getBaseCurrency().getPrecision();
        BigDecimal one = BigDecimal.ZERO;
        BigDecimal two = BigDecimal.ZERO;
        BigDecimal three = BigDecimal.ZERO;
        BigDecimal four = BigDecimal.ZERO;
        BigDecimal five = BigDecimal.ZERO;
        BigDecimal six = BigDecimal.ZERO;
        for (int i = 0; i < totalRowIndex; ++i) {
            IRow tmpRow = this.analysisTable.getRow2(i);
            if (tmpRow.getCell("glDebitBaseCurrency").getMergeBlock() != null) {
                if (tmpRow.getCell("glDebitBaseCurrency").getMergeBlock().getTop() == tmpRow.getCell("glDebitBaseCurrency").getRowIndex()) {
                    one = one.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("glDebitBaseCurrency").getValue())));
                }
            } else {
                one = one.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("glDebitBaseCurrency").getValue())));
            }
            if (tmpRow.getCell("glCreditBaseCurrency").getMergeBlock() != null) {
                if (tmpRow.getCell("glCreditBaseCurrency").getMergeBlock().getTop() == tmpRow.getCell("glCreditBaseCurrency").getRowIndex()) {
                    two = two.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("glCreditBaseCurrency").getValue())));
                }
            } else {
                two = two.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("glCreditBaseCurrency").getValue())));
            }
            if (tmpRow.getCell("nlmDebitBaseCurrency").getMergeBlock() != null) {
                if (tmpRow.getCell("nlmDebitBaseCurrency").getMergeBlock().getTop() == tmpRow.getCell("nlmDebitBaseCurrency").getRowIndex()) {
                    three = three.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("nlmDebitBaseCurrency").getValue())));
                }
            } else {
                three = three.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("nlmDebitBaseCurrency").getValue())));
            }
            if (tmpRow.getCell("nlmCreditBaseCurrency").getMergeBlock() != null) {
                if (tmpRow.getCell("nlmCreditBaseCurrency").getMergeBlock().getTop() == tmpRow.getCell("nlmCreditBaseCurrency").getRowIndex()) {
                    four = four.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("nlmCreditBaseCurrency").getValue())));
                }
            } else {
                four = four.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("nlmCreditBaseCurrency").getValue())));
            }
            if (tmpRow.getCell("diffDebitBaseCurrency").getMergeBlock() != null) {
                if (tmpRow.getCell("diffDebitBaseCurrency").getMergeBlock().getTop() == tmpRow.getCell("diffDebitBaseCurrency").getRowIndex()) {
                    five = five.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("diffDebitBaseCurrency").getValue())));
                }
            } else {
                five = five.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("diffDebitBaseCurrency").getValue())));
            }
            if (tmpRow.getCell("diffCreditBaseCurrency").getMergeBlock() != null) {
                if (tmpRow.getCell("diffCreditBaseCurrency").getMergeBlock().getTop() != tmpRow.getCell("diffCreditBaseCurrency").getRowIndex()) continue;
                six = six.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("diffCreditBaseCurrency").getValue())));
                continue;
            }
            six = six.add(new BigDecimal(this.getStringOrZero(tmpRow.getCell("diffCreditBaseCurrency").getValue())));
        }
        one = one.setScale(basePrecision, 4);
        two = two.setScale(basePrecision, 4);
        three = three.setScale(basePrecision, 4);
        four = four.setScale(basePrecision, 4);
        five = five.setScale(basePrecision, 4);
        six = six.setScale(basePrecision, 4);
        curRow.getCell("glDebitBaseCurrency").setValue((Object)one);
        curRow.getCell("glCreditBaseCurrency").setValue((Object)two);
        curRow.getCell("nlmDebitBaseCurrency").setValue((Object)three);
        curRow.getCell("nlmCreditBaseCurrency").setValue((Object)four);
        curRow.getCell("diffDebitBaseCurrency").setValue((Object)five);
        curRow.getCell("diffCreditBaseCurrency").setValue((Object)six);
    }

    private String getStringOrZero(Object changeValue) {
        if ("".equals(changeValue.toString())) {
            return ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString();
        }
        return changeValue.toString();
    }

    private void doRemoveFlatRecordValue() {
        int rowCount = this.analysisTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.analysisTable.getRow2(i);
            if (iRow == null || ZERO.compareTo(new BigDecimal(iRow.getCell("diffDebitBaseCurrency").getValue().toString())) != 0 || ZERO.compareTo(new BigDecimal(iRow.getCell("diffCreditBaseCurrency").getValue().toString())) != 0) continue;
            this.analysisTable.removeRow(i--);
        }
    }

    private void doMergeTable(IRow lastRow, IRow curRow) {
        if (this.isCellValueEquals(lastRow, curRow, "accountNumber")) {
            int i;
            BigDecimal nlmCreditBaseCurrency;
            BigDecimal nlmDebitBaseCurrency;
            BigDecimal glCreditBaseCurrency;
            BigDecimal glDebitBaseCurrency;
            int lastRowIndex;
            int startRowIndex;
            if (this.isCellValueEquals(lastRow, curRow, "glVoucherNumber") && !this.isCellValueNull(curRow, "glVoucherNumber")) {
                startRowIndex = this.analysisTable.getMergeManager().getMergeBlockOfCell(lastRow.getRowIndex(), 6) == null ? lastRow.getRowIndex() : this.analysisTable.getMergeManager().getMergeBlockOfCell(lastRow.getRowIndex(), 6).getTop();
                lastRowIndex = curRow.getRowIndex();
                this.analysisTable.getMergeManager().mergeBlock(startRowIndex, 5, lastRowIndex, 9, 1);
                glDebitBaseCurrency = new BigDecimal(curRow.getCell("glDebitBaseCurrency").getValue().toString());
                glCreditBaseCurrency = new BigDecimal(curRow.getCell("glCreditBaseCurrency").getValue().toString());
                nlmDebitBaseCurrency = this.getNlmBaseCurrency(startRowIndex, lastRowIndex, "nlmDebitBaseCurrency");
                nlmCreditBaseCurrency = this.getNlmBaseCurrency(startRowIndex, lastRowIndex, "nlmCreditBaseCurrency");
                for (i = startRowIndex; i <= lastRowIndex; ++i) {
                    this.analysisTable.getRow2(i).getCell("diffDebitBaseCurrency").setValue((Object)(glDebitBaseCurrency.subtract(nlmDebitBaseCurrency).compareTo(BigDecimal.ZERO) == 0 ? ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString() : glDebitBaseCurrency.subtract(nlmDebitBaseCurrency).toString()));
                    this.analysisTable.getRow2(i).getCell("diffCreditBaseCurrency").setValue((Object)(glCreditBaseCurrency.subtract(nlmCreditBaseCurrency).compareTo(BigDecimal.ZERO) == 0 ? ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString() : glCreditBaseCurrency.subtract(nlmCreditBaseCurrency).toString()));
                    this.analysisTable.getRow2(i).getCell("diffType").setValue((Object)"");
                    if (ZERO.compareTo(new BigDecimal(this.analysisTable.getRow2(i).getCell("diffDebitBaseCurrency").getValue().toString())) == 0 && ZERO.compareTo(new BigDecimal(this.analysisTable.getRow2(i).getCell("diffCreditBaseCurrency").getValue().toString())) == 0) continue;
                    if ("".equals(this.analysisTable.getRow2(i).getCell("glVoucherID").getValue())) {
                        // empty if block
                    }
                    if (!"".equals(this.analysisTable.getRow2(i).getCell("nlmID").getValue())) continue;
                }
                this.analysisTable.getMergeManager().mergeBlock(startRowIndex, 20, lastRowIndex, 22, 1);
            }
            if (this.isCellValueEquals(lastRow, curRow, "nlmBillNumber") && this.isCellValueEquals(lastRow, curRow, "nlmBillType") && !this.isCellValueNull(curRow, "nlmBillNumber")) {
                startRowIndex = this.analysisTable.getMergeManager().getMergeBlockOfCell(lastRow.getRowIndex(), 12) == null ? lastRow.getRowIndex() : this.analysisTable.getMergeManager().getMergeBlockOfCell(lastRow.getRowIndex(), 12).getTop();
                lastRowIndex = curRow.getRowIndex();
                this.analysisTable.getMergeManager().mergeBlock(startRowIndex, 12, lastRowIndex, 14, 1);
                glDebitBaseCurrency = new BigDecimal("".equals(curRow.getCell("glDebitBaseCurrency").getValue()) ? ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString() : curRow.getCell("glDebitBaseCurrency").getValue().toString());
                glCreditBaseCurrency = new BigDecimal("".equals(curRow.getCell("glCreditBaseCurrency").getValue()) ? ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString() : curRow.getCell("glCreditBaseCurrency").getValue().toString());
                nlmDebitBaseCurrency = this.getNlmBaseCurrency(startRowIndex, lastRowIndex, "nlmDebitBaseCurrency");
                nlmCreditBaseCurrency = this.getNlmBaseCurrency(startRowIndex, lastRowIndex, "nlmCreditBaseCurrency");
                for (i = startRowIndex; i <= lastRowIndex; ++i) {
                    this.analysisTable.getRow2(i).getCell("diffDebitBaseCurrency").setValue((Object)(glDebitBaseCurrency.subtract(nlmDebitBaseCurrency).compareTo(BigDecimal.ZERO) == 0 ? ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString() : glDebitBaseCurrency.subtract(nlmDebitBaseCurrency).toString()));
                    this.analysisTable.getRow2(i).getCell("diffCreditBaseCurrency").setValue((Object)(glCreditBaseCurrency.subtract(nlmCreditBaseCurrency).compareTo(BigDecimal.ZERO) == 0 ? ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString() : glCreditBaseCurrency.subtract(nlmCreditBaseCurrency).toString()));
                    this.analysisTable.getRow2(i).getCell("diffType").setValue((Object)"");
                    if (ZERO.compareTo(new BigDecimal(this.analysisTable.getRow2(i).getCell("diffDebitBaseCurrency").getValue().toString())) == 0 && ZERO.compareTo(new BigDecimal(this.analysisTable.getRow2(i).getCell("diffCreditBaseCurrency").getValue().toString())) == 0) continue;
                    if ("".equals(this.analysisTable.getRow2(i).getCell("glVoucherID").getValue())) {
                        // empty if block
                    }
                    if (!"".equals(this.analysisTable.getRow2(i).getCell("nlmID").getValue())) continue;
                }
                this.analysisTable.getMergeManager().mergeBlock(startRowIndex, 20, lastRowIndex, 22, 1);
            }
        }
    }

    private BigDecimal getNlmBaseCurrency(int startRowIndex, int lastRowIndex, String nlmDebitBaseCurrency) {
        BigDecimal nlmBaseCurrency = BigDecimal.ZERO;
        for (int i = startRowIndex; i <= lastRowIndex; ++i) {
            IRow curRow = this.analysisTable.getRow2(i);
            nlmBaseCurrency = nlmBaseCurrency.add(new BigDecimal("".equals(curRow.getCell(nlmDebitBaseCurrency).getValue()) ? ZERO.setScale(this.curCompany.getBaseCurrency().getPrecision(), 4).toString() : curRow.getCell(nlmDebitBaseCurrency).getValue().toString()));
        }
        return nlmBaseCurrency;
    }

    private boolean isCellValueEquals(IRow lastRow, IRow curRow, String cellName) {
        ICell lastRowCell = lastRow.getCell(cellName);
        ICell curRowCell = curRow.getCell(cellName);
        if (lastRowCell == null && curRowCell == null) {
            return true;
        }
        if (lastRowCell == null || curRowCell == null) {
            return false;
        }
        return lastRowCell.getValue().equals(curRowCell.getValue());
    }

    private boolean isCellValueNull(IRow curRow, String cellName) {
        ICell curRowCell = curRow.getCell(cellName);
        if (curRowCell == null) {
            return true;
        }
        return "".equals(curRowCell.getValue());
    }

    private Map parseQueryCriteria(Map queryCriteria) {
        HashMap parseQueryCriteria = new HashMap();
        HashMap accounts = new HashMap();
        if (queryCriteria.size() > 0 && queryCriteria.get("solution") != null) {
            try {
                CustomerParams cp = XMLBean.TransStrToCustParams((String)((FlContrastSolutionInfo)queryCriteria.get("solution")).getParams());
                CustomerParams accountMap = cp.getMe("AccountMap");
                HashMap assets = new HashMap();
                assets.putAll(accountMap.getMe("ASSET").getCustomerParamsHashMap());
                accounts.put("ASSET", assets);
                HashMap depres = new HashMap();
                depres.putAll(accountMap.getMe("DEPRE").getCustomerParamsHashMap());
                accounts.put("DEPRE", depres);
                HashMap decvalues = new HashMap();
                decvalues.putAll(accountMap.getMe("DECVALUE").getCustomerParamsHashMap());
                accounts.put("DECVALUE", decvalues);
                parseQueryCriteria.put("accounts", accounts);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (queryCriteria.size() > 0 && queryCriteria.get("orgId") != null) {
            parseQueryCriteria.put("orgId", queryCriteria.get("orgId"));
        }
        if (queryCriteria.size() > 0 && queryCriteria.get("periodYear") != null) {
            parseQueryCriteria.put("periodYear", queryCriteria.get("periodYear"));
        }
        if (queryCriteria.size() > 0 && queryCriteria.get("periodNumber") != null) {
            parseQueryCriteria.put("periodNumber", queryCriteria.get("periodNumber"));
        }
        return parseQueryCriteria;
    }

    private void initAnalysisTable() throws BOSException, EASBizException {
        this.analysisTable.checkParsed(true);
        this.analysisTable.getStyleAttributes().setLocked(true);
        this.analysisTable.getColumn("accountNumber").getStyleAttributes().setBackground(YELLOW);
        this.analysisTable.getColumn("accountName").getStyleAttributes().setBackground(YELLOW);
        this.analysisTable.getSelectManager().setSelectMode(2);
        this.analysisTable.getColumn("glDebitBaseCurrency").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.curCompany.getBaseCurrency().getPrecision()));
        this.analysisTable.getColumn("glCreditBaseCurrency").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.curCompany.getBaseCurrency().getPrecision()));
        this.analysisTable.getColumn("nlmDebitBaseCurrency").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.curCompany.getBaseCurrency().getPrecision()));
        this.analysisTable.getColumn("nlmCreditBaseCurrency").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.curCompany.getBaseCurrency().getPrecision()));
        this.analysisTable.getColumn("diffDebitBaseCurrency").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.curCompany.getBaseCurrency().getPrecision()));
        this.analysisTable.getColumn("diffCreditBaseCurrency").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.curCompany.getBaseCurrency().getPrecision()));
        List queryData = NLMReconciliationAnalysisFacadeFactory.getRemoteInstance().getReconciliationAnalysisData(this.parseQueryCriteria, this.isShowAll);
        this.fillTableData(queryData);
    }
}

