/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.calctree.CalcTree;
import com.kingdee.eas.fi.fa.manage.client.AbstractNLMTerminateCalculationProcessUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.awt.Color;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NLMTerminateCalculationProcessUI
extends AbstractNLMTerminateCalculationProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(NLMTerminateCalculationProcessUI.class);
    private static final Color GRAY = new Color(222, 222, 222, 255);
    private FaLeaseInBillNewInfo billNewInfo;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPreferredSize(new Dimension(1500, 520));
        this.pnlResultColor.setBackground(this.detailValueTable.getRequiredColor());
        this.pnlCondColor.setBackground(GRAY);
        this.pnlCalcColor.setBackground(this.detailValueTable.getBackground());
        this.billNewInfo = (FaLeaseInBillNewInfo)this.getUIContext().get("billNewInfo");
        this.initCalcTree();
        this.initDetailValueTable();
    }

    protected void initListener() {
        super.initListener();
        this.calcTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath = e.getNewLeadSelectionPath();
                KDTreeNode kdTreeNode = (KDTreeNode)treePath.getLastPathComponent();
                if (kdTreeNode.getChildCount() == 0) {
                    try {
                        NLMTerminateCalculationProcessUI.this.calcDetailValueTable(kdTreeNode);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
            }
        });
    }

    private void calcDetailValueTable(KDTreeNode kdTreeNode) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this.detailValueTable.checkParsed();
        this.detailValueTable.removeRows();
        HashMap hashMap = (HashMap)kdTreeNode.getUserObject();
        String calcMethod = (String)hashMap.get("queryMethod");
        Class<?> implClass = Class.forName("com.kingdee.eas.fi.fa.manage.calctree.view.NLMTerminateCalcDetailTable");
        Method implMethod = implClass.getMethod(calcMethod, Map.class, Map.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("detailValueTable", this.detailValueTable);
        params.put("calcType", hashMap.get("calcType"));
        params.put("calcValue", this.getUIContext().get(hashMap.get("calcType")));
        params.put("conditionValue", this.billNewInfo);
        implMethod.invoke(implClass.newInstance(), params, null);
    }

    private void initCalcTree() throws Exception {
        String[] flCalcTreeCalcTypeList;
        KDTreeNode rootNode = new KDTreeNode((Object)"");
        ((DefaultTreeModel)this.calcTree.getModel()).setRoot((TreeNode)rootNode);
        for (String flCalcTreeCalcType : flCalcTreeCalcTypeList = new String[]{"CALC_PAID_RENT_AMT", "CALC_INIT_AMOUNT", "CALC_DEC_VALUE", "CALC_ACUM_DEPRE_AMT", "CALC_ACUM_INTEREST_EXPE", "CALC_RETR_PAID_RENT_AMT", "CALC_RETR_ACUM_DEPRE_AMT", "CALC_RETR_ACUM_INTEREST_EXPE", "CALC_ASSET_DISPOSAL_GAIN"}) {
            this.billNewInfo.put("calcType", flCalcTreeCalcType);
            HashMap<String, Object> calcMessage = new HashMap<String, Object>();
            CalcTree.getCalcMessage(null, this.billNewInfo, null, calcMessage);
            ArrayList queryPathList = (ArrayList)calcMessage.get("queryPathList");
            KDTreeNode parentNode = new KDTreeNode(calcMessage);
            parentNode.setText((String)queryPathList.get(1));
            this.calcTree.addNodeInto((MutableTreeNode)parentNode, (MutableTreeNode)rootNode);
            KDTreeNode childNode = new KDTreeNode(calcMessage);
            childNode.setText((String)queryPathList.get(queryPathList.size() - 1));
            this.calcTree.addNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parentNode);
        }
        this.calcTree.setCollapsePathDisabled(true);
    }

    private void initDetailValueTable() {
        this.detailValueTable.getSelectManager().setSelectMode(2);
        this.detailValueTable.getStyleAttributes().setLocked(true);
        this.detailValueTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                NLMTerminateCalculationProcessUI.this.calcSelectRowTotalValue(e);
            }
        });
    }

    private void calcSelectRowTotalValue(KDTSelectEvent e) {
        KDTSelectBlock kdtSelectBlock = e.getSelectBlock();
        int top = kdtSelectBlock.getBeginRow();
        int bottom = kdtSelectBlock.getEndRow();
        BigDecimal totalValue = BigDecimal.ZERO;
        for (int i = top; i <= bottom; ++i) {
            if (!(this.detailValueTable.getRow(i).getCell("value").getValue() instanceof BigDecimal)) continue;
            totalValue = totalValue.add((BigDecimal)this.detailValueTable.getRow(i).getCell("value").getValue());
        }
        this.calculatorTotalValue.setValue(totalValue);
    }
}

