/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlCommonConstant;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractScanCheckEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ScanCheckEditUI
extends AbstractScanCheckEditUI {
    private static final long serialVersionUID = -3308593253454811855L;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setEnabled(false);
        this.toolBar.setVisible(false);
        this.toolBar.setFocusable(false);
        this.toolBar.setOpaque(false);
        this.toolBar.setBorderPainted(false);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtScanCheck, (KeyStroke)CtrlCommonConstant.KEYSTROKE_ENTER);
    }

    private boolean isCN(char ch, boolean withPreCN) {
        boolean b;
        boolean bl = b = ch >= '\u4e00' && ch <= '\u9fa5' || "\uff01\uff0c\u3002\uff1f\uff1a\u201c\u201d\u2018\u2019\uff0b\uff0d\u00d7\u00f7\u3001\u3010\u3011\u300e\u300f\uff5e".indexOf(ch) != -1;
        if (!b && withPreCN) {
            return ",.:;!?-_ \u3000".indexOf(ch) != -1;
        }
        return b;
    }

    @Override
    protected void txtScanCheck_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.scanCheck_keyPressed(true);
        }
    }

    private void scanCheck_keyPressed(boolean flag) throws Exception {
        if (flag) {
            String productCode = this.txtScanCheck.getText();
            if (productCode.equals("")) {
                return;
            }
            char[] codeChr = productCode.toCharArray();
            String message = null;
            for (int i = 0; i < codeChr.length; ++i) {
                if (!this.isCN(codeChr[i], false)) continue;
                message = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"numberNoChanese");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
            KDTable kdtEntries = (KDTable)this.getUIContext().get("kdtEntries");
            int rows = kdtEntries.getRowCount();
            boolean isExists = false;
            for (int i = 0; i < rows; ++i) {
                String barCode;
                IRow row = kdtEntries.getRow(i);
                if (row.getCell("barCode").getValue() == null) continue;
                String string = barCode = row.getCell("barCode").getValue() == null ? null : row.getCell("barCode").getValue().toString();
                if (barCode != null && barCode.equals(productCode)) {
                    isExists = true;
                    BigDecimal assetAmt = (BigDecimal)row.getCell("assetAmt").getValue();
                    BigDecimal stocktakingAmt = (BigDecimal)row.getCell("stocktakingAmt").getValue();
                    stocktakingAmt = stocktakingAmt.add(new BigDecimal(1));
                    row.getCell("stocktakingAmt").setValue((Object)stocktakingAmt);
                    BigDecimal profitAmt = stocktakingAmt.subtract(assetAmt);
                    row.getCell("profitAmt").setValue((Object)profitAmt);
                    kdtEntries.getSelectManager().setSelectMode(2);
                    kdtEntries.getSelectManager().select(row.getRowIndex(), 0);
                } else {
                    isExists = false;
                }
                if (isExists) break;
            }
            if (!isExists) {
                boolean findIt = false;
                FaCurCardInfo card = null;
                try {
                    card = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo(" select id, number, assetName, assetAmt, oldNumber, groupNumber, barCode, specs, remark, lastUpdateTime,         assetCat.id, assetCat.name, assetCat.number,         measureUnit.id, measureUnit.name, measureUnit.number,         useStatus.id, useStatus.name, useStatus.number,         economicPurp.id, economicPurp.name, economicPurp.number,         storeCity.id, storeCity.name, storeCity.number,         dept.id, dept.name, dept.number,         keeper.id, keeper.name, keeper.number,         faCurDepartment.useDepartment.id, faCurDepartment.useDepartment.name, faCurDepartment.useDepartment.number,         faCurDepartment.usePerson.id, faCurDepartment.usePerson.name, faCurDepartment.usePerson.number  where barCode = '" + productCode.trim() + "'  and company = '" + SysContext.getSysContext().getCurrentFIUnit().getId().toString() + "' ");
                }
                catch (Exception e1) {
                    findIt = false;
                }
                if (card != null) {
                    findIt = true;
                }
                FaStocktakingBillInfo bill = (FaStocktakingBillInfo)this.getUIContext().get("stockBillInfo");
                kdtEntries.addRow();
                IRow newRow = kdtEntries.getRow(kdtEntries.getRowCount() - 1);
                FaStocktakingBillEntryInfo entry = new FaStocktakingBillEntryInfo();
                if (findIt) {
                    entry.setAssetCat(card.getAssetCat());
                    entry.setAssetNum(card.getNumber());
                    entry.setOldNumber(card.getOldNumber());
                    entry.setAssetName(card.getAssetName());
                    entry.setGroupNumber(card.getGroupNumber());
                    entry.setBarCode(card.getBarCode());
                    entry.setSpecs(card.getSpecs());
                    entry.setMeasureUnit(card.getMeasureUnit());
                    entry.setAddress(card.getStoreCity());
                    entry.setUseStatus(card.getUseStatus());
                    entry.setEconomicPurp(card.getEconomicPurp());
                    entry.setAdminDept(card.getDept());
                    entry.setKeeper(card.getKeeper());
                    if (card.getFaCurDepartment() != null && card.getFaCurDepartment().size() > 0) {
                        entry.setUseDept(card.getFaCurDepartment().get(0).getUseDepartment());
                        entry.setUsePerson(card.getFaCurDepartment().get(0).getUsePerson());
                    }
                    entry.setDescription(card.getDescription());
                    entry.setAssetAmt(card.getAssetAmt());
                    entry.setStocktakingAmt(card.getAssetAmt());
                    entry.setFaCurCard(card);
                }
                entry.setBill(bill);
                newRow.setUserObject((Object)entry);
                newRow.getCell("cat").setValue((Object)entry.getAssetCat());
                newRow.getCell("assetNum").setValue((Object)entry.getAssetNum());
                newRow.getCell("oldNumber").setValue((Object)entry.getOldNumber());
                newRow.getCell("assetName").setValue((Object)entry.getAssetName());
                newRow.getCell("groupNumber").setValue((Object)entry.getGroupNumber());
                newRow.getCell("barCode").setValue((Object)entry.getBarCode());
                newRow.getCell("measureUnit").setValue((Object)entry.getMeasureUnit());
                newRow.getCell("address").setValue((Object)entry.getAddress());
                newRow.getCell("useStatus").setValue((Object)entry.getUseStatus());
                newRow.getCell("economicPurp").setValue((Object)entry.getEconomicPurp());
                newRow.getCell("adminDept").setValue((Object)entry.getAdminDept());
                newRow.getCell("useDept").setValue((Object)entry.getUseDept());
                newRow.getCell("keeper").setValue((Object)entry.getKeeper());
                newRow.getCell("usePerson").setValue((Object)entry.getUsePerson());
                newRow.getCell("assetAmt").setValue((Object)entry.getAssetAmt());
                newRow.getCell("stocktakingAmt").setValue((Object)entry.getStocktakingAmt());
                if (entry.getStocktakingAmt() != null && entry.getAssetAmt() != null) {
                    newRow.getCell("profitAmt").setValue((Object)entry.getStocktakingAmt().subtract(entry.getAssetAmt()));
                }
                newRow.getCell("facurcard.id").setValue(entry.getFaCurCard() == null ? null : entry.getFaCurCard().getId().toString());
                kdtEntries.getSelectManager().setSelectMode(2);
                kdtEntries.getSelectManager().select(newRow.getRowIndex(), 0);
                this.setEditableRow(this.getOprtState());
            }
            this.txtScanCheck.setText("");
            this.txtScanCheck.requestFocus();
        }
    }

    private void setEditableRow(String oprtState) {
        KDTable kdtEntries = (KDTable)this.getUIContext().get("kdtEntries");
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            int profitIndex = kdtEntries.getColumnIndex("profitAmt");
            int assetNumIndex = kdtEntries.getColumnIndex("assetNum");
            int stocktakingAmtIndex = kdtEntries.getColumnIndex("assetAmt");
            for (int i = 0; i < kdtEntries.getRowCount(); ++i) {
                IRow row = kdtEntries.getRow(i);
                if (row.getCell("facurcard.id").getValue() != null && row.getCell("facurcard.id").getValue().toString().trim().length() != 0) continue;
                for (int j = 0; j < kdtEntries.getColumnCount(); ++j) {
                    if (profitIndex == j || assetNumIndex == j || stocktakingAmtIndex == j) continue;
                    row.getCell(j).getStyleAttributes().setLocked(false);
                }
            }
        } else {
            kdtEntries.getStyleAttributes().setLocked(true);
        }
    }

    protected IObjectValue createNewData() {
        FaStocktakingBillInfo vo = new FaStocktakingBillInfo();
        return vo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaCurCardFactory.getRemoteInstance();
    }

    @Override
    public void actionScanCheckConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.scanCheck_keyPressed(true);
    }
}

