/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.client.AddressPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.FaBasedataTypeEnum;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaEconomicPurpPromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaUseStatusPromptBox;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractTransCardToBookUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.constant.Constable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TransCardToBookUI
extends AbstractTransCardToBookUI {
    private CompanyOrgUnitInfo bookCompany;
    private CompanyOrgUnitInfo company;
    private static final long serialVersionUID = 6695827054925773062L;

    public TransCardToBookUI() throws Exception {
        this.initCtrlComponent();
        this.toolBar.setVisible(false);
        this.menuBar.setVisible(false);
        this.btnActionTrans.setEnabled(true);
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        CompanyOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        HashMap paramMap = FaManageUtils.getFAParameter(orgUnitInfo.getId());
        String isTrandBatch = (String)paramMap.get("FA_077");
        if (isTrandBatch != null && "false".equals(isTrandBatch)) {
            this.btnActionTranCard.setEnabled(false);
            this.btnActionTranCard.setVisible(false);
        } else {
            this.btnActionTranCard.setEnabled(true);
            this.btnActionTranCard.setVisible(true);
        }
    }

    protected void initCtrlComponent() throws Exception {
        FaCatPromptBox aFaCatPromptBox = new FaCatPromptBox((CoreUIObject)this);
        this.prompFaCatFrom.setSelector((KDPromptSelector)aFaCatPromptBox);
        this.prompFaCatFrom.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.CAT));
        this.prompFaCatTo.setSelector((KDPromptSelector)aFaCatPromptBox);
        this.prompFaCatTo.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.CAT));
        FaUseStatusPromptBox aFaUseStatusPromptBox = new FaUseStatusPromptBox((CoreUIObject)this);
        this.promptFaUseStatuFrom.setSelector((KDPromptSelector)aFaUseStatusPromptBox);
        this.promptFaUseStatuFrom.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.USESTATUS));
        this.promptFaUseStatuTo.setSelector((KDPromptSelector)aFaUseStatusPromptBox);
        this.promptFaUseStatuTo.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.USESTATUS));
        FaEconomicPurpPromptBox aFaEconomicPurpPromptBox = new FaEconomicPurpPromptBox((CoreUIObject)this);
        this.promptEconomicFrom.setSelector((KDPromptSelector)aFaEconomicPurpPromptBox);
        this.promptEconomicFrom.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.ECONOMICPURP));
        this.promptEconomicTo.setSelector((KDPromptSelector)aFaEconomicPurpPromptBox);
        this.promptEconomicTo.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.ECONOMICPURP));
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        adminF7.setNeedAddOrgRange(false);
        this.promptUseDepartmentFrom.setSelector((KDPromptSelector)adminF7);
        this.promptUseDepartmentTo.setSelector((KDPromptSelector)adminF7);
        this.promptManageDepartmentFrom.setSelector((KDPromptSelector)adminF7);
        this.promptManageDepartmentTo.setSelector((KDPromptSelector)adminF7);
        AddressPromptBox addrF7Dlg = new AddressPromptBox((IUIObject)this);
        this.promptFaLocationFrom.setSelector((KDPromptSelector)addrF7Dlg);
        this.promptFaLocationTo.setSelector((KDPromptSelector)addrF7Dlg);
    }

    private Map getSelectedValues() {
        HashMap<String, Object> mapValues = new HashMap<String, Object>();
        mapValues.put("promptDestBook", this.promptDestBook.getData());
        mapValues.put("textNumberFrom", this.textNumberFrom.getText());
        mapValues.put("textNumberTo", this.textNumberTo.getText());
        mapValues.put("prompFaCatFrom", this.prompFaCatFrom.getData());
        mapValues.put("prompFaCatTo", this.prompFaCatTo.getData());
        mapValues.put("promptFaLocationFrom", this.promptFaLocationFrom.getData());
        mapValues.put("promptFaLocationTo", this.promptFaLocationTo.getData());
        mapValues.put("promptFaUseStatuFrom", this.promptFaUseStatuFrom.getData());
        mapValues.put("promptFaUseStatuTo", this.promptFaUseStatuTo.getData());
        mapValues.put("promptUseDepartmentFrom", this.promptUseDepartmentFrom.getData());
        mapValues.put("promptUseDepartmentTo", this.promptUseDepartmentTo.getData());
        mapValues.put("promptEconomicFrom", this.promptEconomicFrom.getData());
        mapValues.put("promptEconomicTo", this.promptEconomicTo.getData());
        mapValues.put("promptManageDepartmentFrom", this.promptManageDepartmentFrom.getData());
        mapValues.put("promptManageDepartmentTo", this.promptManageDepartmentTo.getData());
        return mapValues;
    }

    private int checkPeriodForDifferentPeriodType(PeriodInfo periodInfo, PeriodInfo bookperiodInfo) throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(this.company == null ? SysContext.getSysContext().getCurrentFIUnit() : this.company));
        boolean p1 = periodInfo.getPeriodYear() * 100 + periodInfo.getPeriodNumber() <= bookperiodInfo.getPeriodYear() * 100 + bookperiodInfo.getPeriodNumber();
        boolean p2 = bookperiodInfo.getPeriodYear() * 100 + bookperiodInfo.getPeriodNumber() <= periodInfo.getPeriodYear() * 100 + periodInfo.getPeriodNumber();
        boolean p3 = startPeriod.getPeriodYear() * 100 + startPeriod.getPeriodNumber() <= bookperiodInfo.getPeriodYear() * 100 + bookperiodInfo.getPeriodNumber();
        return 0;
    }

    public HashMap _transferCard() throws Exception {
        if (this.bookCompany == null) {
            return null;
        }
        String bookCompanyID = this.bookCompany.getId().toString();
        TransCardToBookUI.checkBook((Component)((Object)this), this.bookCompany);
        TransCardToBookUI.checkPeriod((Component)((Object)this), this.bookCompany);
        boolean isInit = TransCardToBookUI.checkFaBookInit((Component)((Object)this), this.bookCompany);
        if (!isInit) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.FANotEndInit");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        return this.transCardInfo();
    }

    private int checkPeriod(PeriodInfo periodInfo, PeriodInfo bookperiodInfo) throws EASBizException, BOSException {
        String strMsg;
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(this.company == null ? SysContext.getSysContext().getCurrentFIUnit() : this.company));
        if (this.periodCompare(startPeriod, bookperiodInfo) > 0) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource", (String)"SUBBOOK_AFTER_MAINSTARTPI");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        if (this.periodCompare(periodInfo, bookperiodInfo) < 0) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource", (String)"SUBBOOK_BEFORE_MAINCURPI");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        if (this.periodCompare(periodInfo, bookperiodInfo) == 0) {
            return 0;
        }
        return -1;
    }

    private int periodCompare(PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) {
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return 1;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            if (sourceperiodInfo.getPeriodNumber() > targetperiodInfo.getPeriodNumber()) {
                return 1;
            }
            if (sourceperiodInfo.getPeriodNumber() == targetperiodInfo.getPeriodNumber()) {
                return 0;
            }
        } else {
            return -1;
        }
        return -1;
    }

    private static String _changePeriod(FaCardInfo cardInfo, CompanyOrgUnitInfo mainOrg, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        if (mainOrg.getAccountPeriodType().getId().toString().equals(transferOrg.getAccountPeriodType().getId().toString())) {
            return null;
        }
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo(null, (Date)cardInfo.getAccountDate(), (CompanyOrgUnitInfo)transferOrg, (SystemEnum)SystemEnum.FIXEDASSETS);
        if (periodInfo == null) {
            return "6001";
        }
        cardInfo.setPeriod(periodInfo);
        return null;
    }

    protected HashMap transInitInfo(int cardType, PeriodInfo periodInfo, boolean isPeriodTypeSame) throws BOSException, Exception {
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("type", new Integer(cardType));
        params.put("periodInfo", (Constable)periodInfo);
        params.put("periodType", Boolean.valueOf(isPeriodTypeSame));
        return (HashMap)FaMonCardFactory.getRemoteInstance().transToDestBook(params, this.getSelectedValues(), this.bookCompany);
    }

    protected HashMap transCardInfo() throws BOSException, Exception {
        HashMap params = new HashMap();
        return (HashMap)FaMonCardFactory.getRemoteInstance().transferCardBatch(params, this.getSelectedValues(), this.bookCompany);
    }

    public static boolean checkFaBookInit(Component component, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws Exception {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
    }

    private FaMonCardInfo trans2Init(FaCurCardInfo curCardInfo) {
        if (curCardInfo == null) {
            return null;
        }
        FaMonCardInfo faMonCardInfo = new FaMonCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(curCardInfo, faMonCardInfo, true);
        }
        catch (Exception e) {
            return null;
        }
        return faMonCardInfo;
    }

    @Override
    public void actionTrans_actionPerformed(ActionEvent e) throws Exception {
        String destBookScheme;
        Map valueMap = this.getSelectedValues();
        AcountSchemeInfo destBook = (AcountSchemeInfo)valueMap.get("promptDestBook");
        if (destBook == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.PleaseSelectBook");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        if ((destBookScheme = destBook.getId().toString()) == null) {
            return;
        }
        this.bookCompany = null;
        this.getDestBookCompany(destBookScheme);
        HashMap result = this._transfer();
        if (result != null) {
            IUIWindow uiWindow = null;
            Map uiContext = this.getUIContext();
            uiContext.put("result", result);
            int winStyle = 32;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.fa.manage.client.TransCardResultUI", uiContext, null, OprtState.VIEW, winStyle);
            uiWindow.show();
        }
    }

    @Override
    public void actionTranCard_actionPerformed(ActionEvent e) throws Exception {
        String destBookScheme;
        Map valueMap = this.getSelectedValues();
        AcountSchemeInfo destBook = (AcountSchemeInfo)valueMap.get("promptDestBook");
        if (destBook == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.PleaseSelectBook");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        if ((destBookScheme = destBook.getId().toString()) == null) {
            return;
        }
        this.bookCompany = null;
        this.getDestBookCompany(destBookScheme);
        HashMap result = this._transferCard();
        if (result != null) {
            result.put("from", "tranCardBatch");
            IUIWindow uiWindow = null;
            Map uiContext = this.getUIContext();
            uiContext.put("result", result);
            int winStyle = 32;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.fa.manage.client.TransCardResultUI", uiContext, null, OprtState.VIEW, winStyle);
            uiWindow.show();
        }
    }

    private CompanyOrgUnitInfo getDestBookCompany(String id) {
        if (this.bookCompany == null) {
            try {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("accountPeriodType.*"));
                viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)this.company.getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)id));
                viewInfo.setFilter(filterInfo);
                CompanyOrgUnitCollection orgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(viewInfo);
                if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
                    this.bookCompany = orgUnitCollection.get(0);
                }
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
        }
        return this.bookCompany;
    }

    public HashMap _transfer() throws Exception {
        if (this.bookCompany == null) {
            return null;
        }
        String bookCompanyID = this.bookCompany.getId().toString();
        TransCardToBookUI.checkPeriod((Component)((Object)this), this.bookCompany);
        boolean isInit = TransCardToBookUI.checkFaBookInit((Component)((Object)this), this.bookCompany);
        if (isInit) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.FaCurCardEditUI_FANotEndInit");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        PeriodInfo bookPeriodInfo = FaClientUtils.getCurrentPeriod(bookCompanyID);
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo(null, (PeriodInfo)bookPeriodInfo);
        CompanyOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (orgUnitInfo == null) {
            return null;
        }
        String currentCompanyID = orgUnitInfo.getId().toString();
        PeriodInfo curentPeriod = FaClientUtils.getCurrentPeriod(currentCompanyID);
        if (this.bookCompany.getAccountPeriodType().getId().equals((Object)orgUnitInfo.getAccountPeriodType().getId())) {
            int i = this.checkPeriod(curentPeriod, bookPeriodInfo);
            PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(this.company == null ? SysContext.getSysContext().getCurrentFIUnit() : this.company));
            if (bookPeriodInfo.getId().equals((Object)aPeriodInfo.getId())) {
                prePeriodInfo = bookPeriodInfo;
            }
            return this.transInitInfo(1, prePeriodInfo, true);
        }
        PeriodCollection periodCollection = PeriodUtils.getPeriodCollection(null, (Date)bookPeriodInfo.getBeginDate(), (Date)bookPeriodInfo.getEndDate(), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
        if (periodCollection != null) {
            return this.transInitInfo(1, prePeriodInfo, false);
        }
        String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.NotBetweenBeginAndCurrent");
        MsgBox.showInfo((Component)((Object)this), (String)strMsg);
        SysUtil.abort();
        return null;
    }

    public static void checkPeriod(Component comp, CompanyOrgUnitInfo company) {
        PeriodInfo aPeriodInfo = null;
        try {
            aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(company == null ? SysContext.getSysContext().getCurrentFIUnit() : company));
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)comp, (String)e.toString());
            SysUtil.abort();
        }
        if (aPeriodInfo == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.notConfigStartPeriod");
            MsgBox.showInfo((Component)comp, (String)strMsg);
            SysUtil.abort();
        }
    }

    public static void checkBook(Component comp, CompanyOrgUnitInfo company) {
        if (company.getAccountScheme() == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.AccountSchemeIsNull");
            MsgBox.showInfo((Component)comp, (String)strMsg);
            SysUtil.abort();
        }
        try {
            AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(company.getAccountScheme().getId()));
            boolean IsSyncCard = book.isIsSyncCard();
            if (!IsSyncCard) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.NotSyncCard");
                MsgBox.showInfo((Component)comp, (String)strMsg);
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

