/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client.flenum;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaNLMChangeAssetItemFactory;
import com.kingdee.eas.fi.fa.manage.FaNLMChangeAssetItemInfo;
import com.kingdee.eas.fi.fa.manage.FaPayFrequencyEnum;
import com.kingdee.eas.fi.fa.manage.NLMChangeAssetType;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public enum NLMForAssetAdjustment {
    RETROACTIVE_ADJUSTMENT;

    public static final String RES_PATH_LEASENEW = "com.kingdee.eas.fi.fa.manage.FaLeaseNewResource";
    private Component component;
    private PeriodInfo curPeriod;

    public void verifyAssetAdjustment(ArrayList<String> idList) throws EASBizException, BOSException {
        FaLeaseInBillNewInfo info;
        if (idList.size() != 1) {
            MsgBox.showError((String)EASResource.getString((String)RES_PATH_LEASENEW, (String)"VerifyAssetChange_Tips_One"));
            SysUtil.abort();
        }
        if ((info = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(idList.get(0)))).getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE || info.getLeaseType() == FaLeaseTypeEnum.GL_BALANCE_ENTRY || info.getPayFrequency() == FaPayFrequencyEnum.PAY_IN_ADVANCE) {
            SysUtil.abort();
        }
        if (info.getBizStatus() == FaLeaseBizStatusEnum.ADJUSTMENT || info.getBizStatus() == FaLeaseBizStatusEnum.HAVE_ADJUSTMENT) {
            SysUtil.abort();
        }
        if (info.getBizStatus() == FaLeaseBizStatusEnum.RETROACTIVE_ADJUSTMENT || info.getBizStatus() == FaLeaseBizStatusEnum.HAVE_RETROACTIVE_ADJUSTMENT) {
            SysUtil.abort();
        }
        if (info.getBizStatus() == FaLeaseBizStatusEnum.TERMINATING || info.getBizStatus() == FaLeaseBizStatusEnum.HAVE_TERMINATED) {
            SysUtil.abort();
        }
        if (info.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
            SysUtil.abort();
        }
        String checkFlVcSQL = "SELECT t.FID FROM T_FA_FaDepreAndAmort t left join T_BD_Period period on t.FPERIODID = period.FID WHERE t.FLEASEINBILLID = '" + idList.get(0) + "' and period.FNumber >= " + this.curPeriod.getNumber() + " and t.FIVOUCHERED = 1 ";
        IRowSet vcFlRs = SQLExecutorFactory.getRemoteInstance((String)checkFlVcSQL).executeSQL();
        try {
            if (vcFlRs != null && vcFlRs.next()) {
                SysUtil.abort();
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("005", e.getMessage()));
        }
        String periodDate = "{d '" + this.curPeriod.getPeriodYear() + "-" + this.curPeriod.getPeriodNumber() + "-1'}";
        String checkVcSQL = "SELECT bill.FId FROM T_Fa_FaRentSettlementBill bill left join T_Fa_FaRentSettlementBillEntry entry ON bill.FId = entry.FBillID WHERE entry.FPLANDATE >= " + periodDate + " AND bill.FFiVouchered = 1 AND bill.FVoucherID IS NOT NULL AND bill.FLeaseInBillID = '" + idList.get(0) + "'";
        IRowSet vcRs = SQLExecutorFactory.getRemoteInstance((String)checkVcSQL).executeSQL();
        try {
            if (vcRs != null && vcRs.next()) {
                SysUtil.abort();
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("005", e.getMessage()));
        }
        String traceDownSQL = "SELECT FID FROM T_BOT_Relation WHERE FSRCOBJECTID IN (SELECT bill.FId FROM T_Fa_FaRentSettlementBill bill left join T_Fa_FaRentSettlementBillEntry entry ON bill.FId = entry.FBillID  WHERE entry.FPLANDATE >= " + periodDate + " AND bill.FLeaseInBillID = '" + idList.get(0) + "')";
        IRowSet tdRs = SQLExecutorFactory.getRemoteInstance((String)traceDownSQL).executeSQL();
        try {
            if (tdRs != null && tdRs.next()) {
                SysUtil.abort();
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("007", e.getMessage()));
        }
    }

    public void verifyAssetAdjustmentCancel(FaLeaseInBillNewInfo infoOld, FaLeaseInBillNewInfo infoNew) throws EASBizException, BOSException {
        if (infoOld.getBizStatus() != FaLeaseBizStatusEnum.HAVE_RETROACTIVE_ADJUSTMENT && infoOld.getBizStatus() != FaLeaseBizStatusEnum.RETROACTIVE_ADJUSTMENT) {
            SysUtil.abort();
        }
        if (infoNew.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            SysUtil.abort();
        }
    }

    public String doAssetAdjustment(ArrayList<String> idList) throws EASBizException, BOSException {
        BOSUuid faLeaseInBillIdOld = BOSUuid.read((String)idList.get(0));
        FaLeaseInBillNewInfo infoNew = this.getLeaseInBill(faLeaseInBillIdOld);
        FaLeaseInBillNewFactory.getRemoteInstance().saveSelf(infoNew);
        FaLeaseInBillNewInfo infoOld = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillIdOld));
        FaLeaseBizStatusEnum oldBizType = infoOld.getBizStatus();
        infoOld.setBizStatus(FaLeaseBizStatusEnum.RETROACTIVE_ADJUSTMENT);
        FaLeaseInBillNewFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(faLeaseInBillIdOld), (CoreBaseInfo)infoOld);
        FaNLMChangeAssetItemInfo faNLMChangeAssetItemInfo = new FaNLMChangeAssetItemInfo();
        faNLMChangeAssetItemInfo.setChangeDate(this.curPeriod.getBeginDate());
        faNLMChangeAssetItemInfo.setLeaseInBillNew(infoNew);
        faNLMChangeAssetItemInfo.setLeaseInBillOld(infoOld);
        faNLMChangeAssetItemInfo.setOldLeaseBillbizStatus(oldBizType);
        faNLMChangeAssetItemInfo.setNlmChangeAssetType(NLMChangeAssetType.RETROACTIVE_ADJUSTMENT);
        faNLMChangeAssetItemInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        faNLMChangeAssetItemInfo.setCompany(FaClientUtils.getCurrentCompany());
        faNLMChangeAssetItemInfo.setBizDate(new Date());
        FaNLMChangeAssetItemFactory.getRemoteInstance().save((CoreBaseInfo)faNLMChangeAssetItemInfo);
        if (infoNew.getId() == null) {
            return null;
        }
        return infoNew.getId().toString();
    }

    private FaLeaseInBillNewInfo getLeaseInBill(BOSUuid faLeaseInBillIdOld) throws BOSException, EASBizException {
        FaLeaseInBillNewInfo infoNew = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillIdOld));
        infoNew.setId(BOSUuid.create((BOSObjectType)infoNew.getBOSType()));
        infoNew.setNumber(null);
        infoNew.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        infoNew.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        infoNew.setBizStatus(FaLeaseBizStatusEnum.ADDING);
        infoNew.setSourceType(FaLeaseSourceTypeEnum.RETROACTIVE_ADJUSTMENT_CREAT);
        infoNew.setIsHistory(false);
        infoNew.setFiVouchered(false);
        try {
            this.setNewNumber(infoNew);
        }
        catch (Exception ignored) {
            SysUtil.abort();
        }
        Calendar currentPeriodDate = Calendar.getInstance();
        currentPeriodDate.set(this.curPeriod.getPeriodYear(), this.curPeriod.getPeriodNumber() - 1, 1);
        infoNew.setFiAccountDate(this.getDateWithoutHour(currentPeriodDate.getTime()));
        infoNew.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        infoNew.setRentWithoutTax(new BigDecimal("0"));
        infoNew.setRentWithTaxNew(new BigDecimal("0"));
        infoNew.setRentWithoutTaxNew(new BigDecimal("0"));
        infoNew.setInitialAsset(BigDecimal.ZERO);
        infoNew.setInitialLiability(BigDecimal.ZERO);
        infoNew.setUnrecognizedFinanceFee(BigDecimal.ZERO);
        infoNew.setAccDepOfAsset(BigDecimal.ZERO);
        infoNew.setAccUnrFinExpenses(BigDecimal.ZERO);
        infoNew.setRecoveryCostNPV(BigDecimal.ZERO);
        infoNew.setInitAccDepreciation(BigDecimal.ZERO);
        infoNew.setAdjustmentLiability(BigDecimal.ZERO);
        infoNew.setAdjustmentUnFncFee(BigDecimal.ZERO);
        infoNew.setAdjustmentAsset(BigDecimal.ZERO);
        infoNew.setRemainingLiability(BigDecimal.ZERO);
        infoNew.setEstimatedLiability(BigDecimal.ZERO);
        infoNew.setWholeProcessAsset(BigDecimal.ZERO);
        infoNew.setWholeProcessLiability(BigDecimal.ZERO);
        infoNew.setWholeProcessUFF(BigDecimal.ZERO);
        infoNew.setAdjustAccDepAsset(BigDecimal.ZERO);
        infoNew.setAdjustDecAsset(BigDecimal.ZERO);
        infoNew.setAdjustInterestPayment(BigDecimal.ZERO);
        infoNew.setInitialAssetDecValue(BigDecimal.ZERO);
        infoNew.setAccDeprAdjustment(BigDecimal.ZERO);
        infoNew.setAccInterestAdjustment(BigDecimal.ZERO);
        if (infoNew.getFaLeaseDepCostSharingEntry() != null) {
            int j = infoNew.getFaLeaseDepCostSharingEntry().size();
            for (int i = 0; i < j; ++i) {
                BOSUuid id = BOSUuid.create((BOSObjectType)infoNew.getFaLeaseDepCostSharingEntry().get(i).getBOSType());
                infoNew.getFaLeaseDepCostSharingEntry().get(i).setId(id);
            }
        }
        infoNew.setInitialAssetDecValue(new BigDecimal("0"));
        infoNew.setLeaseType(FaLeaseTypeEnum.OPERATING_LEASE);
        infoNew.setPeriod(FaClientUtils.getFLCurrentPeriod(infoNew.getCompany()));
        try {
            FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getRemoteInstance().getEnabledNewLeasePolicy(infoNew.getCompany().getId().toString());
            infoNew.setDepreciationMethod(newLeasePolicy.getDepreciationMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (infoNew.getPaymentEntry() != null) {
            infoNew.getPaymentEntry().clear();
        }
        return infoNew;
    }

    private void setNewNumber(FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
            billInfo.setCompany(aCompanyOrgUnitInfo);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber((IObjectValue)billInfo)) {
            this.setNewNumber(billInfo);
        }
    }

    private boolean existNumber(IObjectValue model) throws BOSException {
        FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FALEASEINBILLNEW WHERE FNUMBER = '");
        sql.append(billInfo.getNumber()).append("'");
        sql.append(" AND FCOMPANYID = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID != '").append(billInfo.getId().toString()).append("'");
        }
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Date getDateWithoutHour(Date date) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.set(5, 1);
        cld.set(11, 0);
        cld.set(12, 0);
        cld.set(13, 0);
        return cld.getTime();
    }

    public NLMForAssetAdjustment buildComponent(Component component) {
        this.component = component;
        return this;
    }

    public NLMForAssetAdjustment buildCurPeriod(PeriodInfo curPeriod) {
        this.curPeriod = curPeriod;
        return this;
    }
}

