/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rt.common;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.rt.common.util.common.IOUtils;
import com.kingdee.eas.util.client.EASResource;
import com.sun.java.help.impl.XmlReader;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class FaBarcodePrinter {
    private static final Logger logger = Logger.getLogger(FaBarcodePrinter.class);
    private static String barcodePrintDir = System.getProperty("EAS_HOME") + File.separator + "client" + File.separator + "BarcodePrint";
    private Document document;
    private String barcodePrintModelFilePath;
    private String barcodeDataSourceFilePath;
    private String barcodeTempPrintDataFilePath;

    public String getBarcodeTempPrintDataFilePath() {
        return this.barcodeTempPrintDataFilePath;
    }

    public void setBarcodeTempPrintDataFilePath(String barcodeTempPrintDataFilePath) {
        this.barcodeTempPrintDataFilePath = barcodeTempPrintDataFilePath;
    }

    public static void main(String[] args) {
        barcodePrintDir = "W:/BarcodePrint";
        logger.info((Object)barcodePrintDir);
        try {
            FaBarcodePrinter barcodePrinter = new FaBarcodePrinter();
            barcodePrinter.printBarcode("W:\\BarcodePrint\\TestKBC.kbc", "W:\\BarcodePrint\\tempPrintData.xml", "-1");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void barCodeDllReg() throws IOException {
        FileInputStream fosfrom = null;
        FileOutputStream fosto = null;
        try {
            boolean isLoad = this.getDispatch();
            logger.info((Object)isLoad);
            File dataFile = new File(barcodePrintDir + File.separator + "tempPrintData.xml");
            if (dataFile.length() <= 10L) {
                int c;
                File fileFrom = new File(barcodePrintDir + File.separator + "tempPrintData-1.xml");
                fosfrom = new FileInputStream(fileFrom);
                fosto = new FileOutputStream(dataFile);
                byte[] bt = new byte[1024];
                while ((c = fosfrom.read(bt)) > 0) {
                    fosto.write(bt, 0, c);
                }
                fosfrom.close();
                fosto.close();
            }
            this.safeClose(fosfrom);
            this.safeClose(fosto);
        }
        catch (Exception e) {
            Runtime rn = Runtime.getRuntime();
            Process p = null;
            p = rn.exec(barcodePrintDir + File.separator + "regjcob.bat");
            File dir = new File(barcodePrintDir);
            p = rn.exec(barcodePrintDir + File.separator + "regdll.bat", null, dir);
            String[] cmd = new String[]{"cmd", "/C", "copy " + dir + "jacob.dll %windir%\\system32\\jacob.dll"};
            Process proc = Runtime.getRuntime().exec(cmd);
            p = rn.exec("regsvr32 -s " + dir + "KDBarCode.ocx");
            p = rn.exec("regsvr32 -s " + dir + "KDBarCodeRuntime.dll");
            this.safeClose(fosfrom);
            this.safeClose(fosto);
        }
        catch (NoClassDefFoundError e2) {
            String dir2 = barcodePrintDir + File.separator;
            Runtime rn2 = Runtime.getRuntime();
            Process p2 = null;
            String[] cmd = new String[]{"cmd", "/C", "copy " + dir2 + "jacob.dll %windir%\\system32\\jacob.dll"};
            Process proc = Runtime.getRuntime().exec(cmd);
            p2 = rn2.exec("regsvr32 -s " + dir2 + "KDBarCode.ocx");
            p2 = rn2.exec("regsvr32 -s " + dir2 + "KDBarCodeRuntime.dll");
            this.safeClose(fosfrom);
            this.safeClose(fosto);
            {
                catch (Throwable throwable) {
                    this.safeClose(fosfrom);
                    this.safeClose(fosto);
                    throw throwable;
                }
            }
        }
    }

    public boolean getDispatch() {
        ActiveXComponent dllSayHello = new ActiveXComponent("KDBarCodeRuntime.CKBPrint");
        Dispatch o = dllSayHello.getObject();
        return o != null;
    }

    public FaBarcodePrinter() throws JDOMException, IOException {
        FileInputStream fileInputStream = null;
        try {
            barcodePrintDir = Pattern.compile("\\/").matcher(barcodePrintDir).replaceAll("\\\\");
            this.barcodePrintModelFilePath = barcodePrintDir + File.separator + "kdBarcodeModels.xml";
            this.barcodeDataSourceFilePath = barcodePrintDir + File.separator + "kdbldds.xml";
            this.barcodeTempPrintDataFilePath = barcodePrintDir + File.separator + "tempPrintData.xml";
            fileInputStream = new FileInputStream(this.barcodePrintModelFilePath);
            this.document = XMLParser.parseXML((Reader)XmlReader.createReader((InputStream)fileInputStream));
            this.safeClose(fileInputStream);
        }
        catch (Throwable throwable) {
            this.safeClose(fileInputStream);
            throw throwable;
        }
    }

    public String getBarcodePrintDir() {
        return barcodePrintDir;
    }

    public static void setBarcodePrintDir(String barcodePrintD) {
        barcodePrintDir = barcodePrintD;
    }

    public void executeBarCodeDesigner() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(barcodePrintDir);
        stringBuffer.append("/KDBarCodeDesigner.exe");
        Runtime rn = Runtime.getRuntime();
        Process p = null;
        p = rn.exec(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDataFieldByDS(String barcodeModelPath) throws JDOMException, IOException {
        FileInputStream fileInputStream = new FileInputStream(this.barcodeDataSourceFilePath);
        try {
            Document modelDsDoc = XMLParser.parseXML((Reader)XmlReader.createReader((InputStream)fileInputStream));
            String dataSourceID = this.getDataSourceID(barcodeModelPath);
            Element dsElement = this.getModelElementByAttr(modelDsDoc.getRootElement(), "id", dataSourceID);
            ArrayList<String> fieldList = new ArrayList<String>();
            if (dsElement != null) {
                List fieldElementList = dsElement.getChildren("field");
                for (int i = 0; i < fieldElementList.size(); ++i) {
                    fieldList.add(((Element)fieldElementList.get(i)).getAttribute("name").getValue());
                }
            }
            ArrayList<String> arrayList = fieldList;
            return arrayList;
        }
        finally {
            this.safeClose(fileInputStream);
        }
    }

    public void safeClose(FileInputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public File selectPrintModeFile(Component parent) {
        File file = null;
        JFileChooser fDialog = new JFileChooser();
        int result = fDialog.showOpenDialog(parent);
        if (result == 0) {
            file = fDialog.getSelectedFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preparePrintData(KDTable printTable, String printModelFieldPath) throws JDOMException, IOException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)printTable);
        try (FileInputStream fileInputStream = new FileInputStream(this.barcodeTempPrintDataFilePath);){
            Document printDataDoc = XMLParser.parseXML((Reader)XmlReader.createReader((InputStream)fileInputStream));
            Element rootElement = printDataDoc.getRootElement();
            if (rootElement == null) {
                return;
            }
            Element dataElement = rootElement.getChild("Data");
            List recordElementList = dataElement.getChildren("Record");
            while (recordElementList.size() > 0) {
                dataElement.removeContent((Content)((Element)recordElementList.get(0)));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.barcodeTempPrintDataFilePath);
            XmlUtils.output((Document)printDataDoc, (OutputStream)fileOutputStream, (boolean)true);
            fileOutputStream.close();
            fileInputStream.close();
            try {
                fileInputStream = new FileInputStream(this.barcodeTempPrintDataFilePath);
                printDataDoc = XMLParser.parseXML((Reader)XmlReader.createReader((InputStream)fileInputStream));
                rootElement = printDataDoc.getRootElement();
                fileOutputStream = new FileOutputStream(this.barcodeTempPrintDataFilePath);
                if (rootElement == null) {
                    return;
                }
                dataElement = rootElement.getChild("Data");
                List fieldList = this.getDataFieldByDS(printModelFieldPath);
                for (int i = 0; i < selectRows.length; ++i) {
                    IRow curRow = printTable.getRow(selectRows[i]);
                    int printCout = 1;
                    Element curRecordElement = new Element("Record");
                    String curValue = "";
                    for (int j = 0; j < fieldList.size(); ++j) {
                        ICell curCell;
                        if (fieldList.get(j) == null || (curCell = curRow.getCell("number")) == null) continue;
                        Element curFieldElement = new Element("Field");
                        if ("assetCatName".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("assetCat.name") != null) {
                                curValue = String.valueOf(curRow.getCell("assetCat.name").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "assetCatName");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "assetCatName");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("number".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("number") != null) {
                                curValue = String.valueOf(curRow.getCell("number").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "number");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "number");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("assetName".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("assetName") != null) {
                                curValue = String.valueOf(curRow.getCell("assetName").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "assetName");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "assetName");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("specs".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("specs") != null) {
                                curValue = String.valueOf(curRow.getCell("specs").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "specs");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "specs");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("deptName".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("dept.name") != null) {
                                curValue = String.valueOf(curRow.getCell("dept.name").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "deptName");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "deptName");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("useDepart".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("useDepart") != null) {
                                curValue = String.valueOf(curRow.getCell("useDepart").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "useDepart");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "useDepart");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("usePerson".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("usePerson") != null) {
                                curValue = String.valueOf(curRow.getCell("usePerson").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "usePerson");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "usePerson");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("keeperName".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("keeper.name") != null) {
                                curValue = String.valueOf(curRow.getCell("keeper.name").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "keeperName");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "keeperName");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("storeCityName".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("storeCity.name") != null) {
                                curValue = String.valueOf(curRow.getCell("storeCity.name").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "storeCityName");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "storeCityName");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("accountDate".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("accountDate") != null) {
                                curValue = String.valueOf(curRow.getCell("accountDate").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "accountDate");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "accountDate");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("wrtyPeriod".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("wrtyPeriod") != null) {
                                curValue = String.valueOf(curRow.getCell("wrtyPeriod").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "wrtyPeriod");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "wrtyPeriod");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("wrtyNumber".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("wrtyNumber") != null) {
                                curValue = String.valueOf(curRow.getCell("wrtyNumber").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "wrtyNumber");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "wrtyNumber");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if ("barCode".equals(fieldList.get(j).toString())) {
                            if (curRow.getCell("barCode") != null) {
                                curValue = String.valueOf(curRow.getCell("barCode").getValue());
                                curValue = this.convertNullToBlank(curValue);
                                curFieldElement.setAttribute("name", "barCode");
                                curFieldElement.setAttribute("data", curValue);
                                curRecordElement.addContent((Content)curFieldElement);
                            } else {
                                curFieldElement.setAttribute("name", "barCode");
                                curFieldElement.setAttribute("data", "");
                                curRecordElement.addContent((Content)curFieldElement);
                            }
                        }
                        if (!"company.name".equals(fieldList.get(j).toString())) continue;
                        if (curRow.getCell("company.name") != null) {
                            curValue = String.valueOf(curRow.getCell("company.name").getValue());
                            curValue = this.convertNullToBlank(curValue);
                            curFieldElement.setAttribute("name", "company.name");
                            curFieldElement.setAttribute("data", curValue);
                            curRecordElement.addContent((Content)curFieldElement);
                            continue;
                        }
                        curFieldElement.setAttribute("name", "company.name");
                        curFieldElement.setAttribute("data", "");
                        curRecordElement.addContent((Content)curFieldElement);
                    }
                    for (int k = 0; k < printCout; ++k) {
                        dataElement.addContent((Content)curRecordElement.clone());
                    }
                }
                XmlUtils.output((Document)printDataDoc, (OutputStream)fileOutputStream, (boolean)true);
            }
            catch (Exception e) {
                fileOutputStream.close();
            }
            finally {
                fileOutputStream.close();
            }
        }
    }

    private String convertNullToBlank(String value) {
        String newValue = "";
        if ("null".equals(value)) {
            return newValue;
        }
        return value;
    }

    public void savePrintModeFile(Component parent, String srcFilePath) throws Exception {
        JFileChooser fDialog = new JFileChooser();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().endsWith(".kbc");
            }

            @Override
            public String getDescription() {
                return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"0_FaBarcodePrinter");
            }
        };
        fDialog.setFileFilter(filter);
        int result = fDialog.showSaveDialog(parent);
        if (result == 0) {
            File selectFile = fDialog.getSelectedFile();
            if (selectFile.exists() && (result = JOptionPane.showConfirmDialog(parent, EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"1_FaBarcodePrinter"))) != 0) {
                return;
            }
            String newFilePath = "";
            if (!StringUtil.isEmpty((String)selectFile.getPath())) {
                newFilePath = !selectFile.getName().endsWith(".kbc") ? selectFile.getPath().concat(".kbc") : selectFile.getPath();
            } else {
                return;
            }
            IOUtils.copyFile(srcFilePath, newFilePath);
        }
    }

    public List getPrintModels() throws ETLXMLException, IOException, JDOMException {
        List nodeList = this.document.getRootElement().getChildren();
        return nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintModel(String name, String filePath) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        try {
            Element element = new Element("model");
            element.setAttribute("name", name);
            element.setAttribute("filePath", filePath);
            this.document.getRootElement().addContent((Content)element);
            fos = new FileOutputStream(this.barcodePrintModelFilePath);
            XmlUtils.output((Document)this.document, (OutputStream)fos, (boolean)true);
            this.safeClose(fos);
        }
        catch (Throwable throwable) {
            this.safeClose(fos);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delPrintModel(String name, String filePath) throws FileNotFoundException, IOException {
        FileOutputStream fis = null;
        try {
            Element element = this.getModelElementByAttr(this.document.getRootElement(), "name", name);
            boolean result = this.document.getRootElement().removeContent((Content)element);
            fis = new FileOutputStream(this.barcodePrintModelFilePath);
            XmlUtils.output((Document)this.document, (OutputStream)fis, (boolean)false);
            boolean bl = result;
            this.safeClose(fis);
            return bl;
        }
        catch (Throwable throwable) {
            this.safeClose(fis);
            throw throwable;
        }
    }

    public void safeClose(FileOutputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public Element getModelElementByAttr(Element element, String attrName, String atrrValue) {
        List children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element curElement = (Element)children.get(i);
            if (!curElement.getAttribute(attrName).getValue().equals(atrrValue)) continue;
            return curElement;
        }
        return null;
    }

    public void printBarcode(String modelFielPath, String dataFielPath, String isPrintView) {
        ActiveXComponent dllSayHello = new ActiveXComponent("KDBarCodeRuntime.CKBPrint");
        Dispatch o = dllSayHello.getObject();
        if (o != null) {
            Variant variant = Dispatch.call((Dispatch)o, (String)"PrintBarCodeLabel", (Object[])new Object[]{modelFielPath, dataFielPath, isPrintView});
        }
        o = null;
        dllSayHello = null;
    }

    public String getDataSourceID(String barcodeModelPath) {
        ActiveXComponent dllSayHello = new ActiveXComponent("KDBarCodeRuntime.CKBPrint");
        Dispatch o = dllSayHello.getObject();
        String dsName = "";
        String labelName = "";
        Variant result = null;
        if (o != null) {
            result = Dispatch.call((Dispatch)o, (String)"LoadKbc", (Object[])new Object[]{barcodeModelPath, dsName, labelName});
            result = Dispatch.call((Dispatch)o, (String)"DataSrcId");
        }
        o = null;
        dllSayHello = null;
        if (result != null) {
            return result.toString();
        }
        return null;
    }
}

