;/**
;* Project Name : S3C2413 verification project
;*
;* Copyright 2004 by Samsung Electronics, Inc.
;* All rights reserved.
;*
;* Project Description :
;* This software is only for verifying functions of the S3C2413. 
;* Anybody can use this code without our permission.
;*/

;/**
;* File Name    : 2413init.s
;* Description  : S3C2413 startup code
;* Author       : WOOSEOK, OH
;* Dept         : Mobile solution, AP
;* Created Date : 2005.09.7
;* Version      : 0.0
;* History
;*   R0.0 (2005.09.7): WOOSEOK draft
;*/

				GET		Option.inc
				GET		2413addr.inc

				MACRO
$HandlerLabel 	HANDLER		$HandleLabel

$HandlerLabel
				sub		sp,sp,#4        	;decrement sp(to store jump address)
				stmfd	sp!,{r0}        	;PUSH the work register to stack(lr doesnt push because it return to original address)
				ldr     r0,=$HandleLabel	;load the address of HandleXXX to r0
				ldr     r0,[r0]         	;load the contents(service routine start address) of HandleXXX
				str     r0,[sp,#4]      	;store the contents(ISR) of HandleXXX to stack
				ldmfd   sp!,{r0,pc}     	;POP the work register and pc(jump to ISR)

				MEND


				IMPORT	InitMEM
				IMPORT	InitSSMC	

				IMPORT  __main   			; The main entry of mon program 

				AREA    Init,CODE,READONLY

				ENTRY 

				b		ResetHandler	;handler for Reset  
				b		HandlerUndef	;handler for Undefined mode
				b		HandlerSWI		;handler for SWI interrupt
				b		HandlerPabort	;handler for PAbort
				b		HandlerDabort	;handler for DAbort
				b		.				;reserved
			    b		HandlerIRQ		;handler for IRQ interrupt 
				b		HandlerFIQ		;handler for FIQ interrupt
	
HandlerUndef	HANDLER HandleUndef
HandlerSWI		HANDLER HandleSWI
HandlerPabort	HANDLER HandlePabort
HandlerDabort	HANDLER HandleDabort
HandlerIRQ		HANDLER HandleIRQ
HandlerFIQ		HANDLER	HandleFIQ


;=======================================================
;						ENTRY  
;=======================================================

ResetHandler

		;		ldr		r0,=GPBCON			;	led init
		;		ldr		r1,=0x19				;	C2 board only scan ok led Aaron
		;		str		r1,[r0]

		;		ldr		r0,=GPBDN			;	led
		;		mov		r1,#0x5
		;		str		r1,[r0]			

				;ldr		r0,=GPBDAT			;	red led
				;mov		r1,#8
				;str		r1,[r0]


				ldr		r0,=WTCON			;	Disable WatchDog.
				mov		r1,#0
				str		r1,[r0]			

				ldr		r0,=BANK_CFG			;	ebi
				mov		r1,#0x08				;Aaron1214--#0xfc	0x0 or 0x8
				str		r1,[r0]			

				ldr		r0,=CLKDIVN			;	Set Clock Divider
				ldr		r1,[r0]
				bic		r1,r1,#0xf
				ldr		r2,=((Startup_ARMCLKdiv<<3)|(Startup_PCLKdiv<<2)|(Startup_HCLKdiv)) 
				orr		r1,r1,r2
				str		r1,[r0]			
	
				ldr		r0,=MPLLCON			;	Set MPLL
				ldr		r1,=((0<<20)|(Startup_Mdiv<<12)|(Startup_Pdiv<<4)|(Startup_Sdiv))
				str		r1,[r0]			

				ldr		r0,=CLKSRC			;	Select MPLL clock out for SYSCLK
				ldr		r1,[r0]
				orr		r1,r1,#0x10
				str		r1,[r0]			

				ldr		r0,=SMBCR4			;	Add for SRAM initial Aaron
				ldr		r1,=0x30b015
				str		r1,[r0]
				

				;bl		InitMEM
				
				;;===================================
				;ldr		r2,=30000
;Loop3
;				cmp		r2,#0
;				beq		Point3
;				sub		r2,r2,#1				
;				b		Loop3
				
;Point3
				;;===================================

				
				bl		InitSSMC				
				

			   	bl		__main
			   	b		.

				LTORG


			   	ALIGN

			   	AREA IntVector, DATA, READWRITE

				^   _ISR_STARTADDRESS

HandleReset 	#   4
HandleUndef 	#   4
HandleSWI   	#   4
HandlePabort    #   4
HandleDabort    #   4
HandleReserved  #   4
HandleIRQ   	#   4
HandleFIQ   	#   4

		        END
