// Templete.cpp
//

#include "stdafx.h"
#include "Template.h"
#include <stdio.h>

/***********************           Reader           ****************************/
extern "C" int TriggerStatus(void)
{
	return SDK_TriggerStatus();
}

extern "C" void InitScanner1(void)
{
	SDK_InitScanner1();
}

extern "C" int Decode(void)
{
	return SDK_Decode();
}

extern "C" void HaltScanner1(void)
{
	SDK_HaltScanner1();
}

extern "C" BOOL Scanner_Reset(void)
{
	return SDK_Scanner_Reset();
}

extern "C" void Scanner_Config_Start(void)
{
	SDK_Scanner_Config_Start();
}

extern "C" void Scanner_Config_End(void)
{
	SDK_Scanner_Config_End();
}

extern "C" BOOL SCAN_SendCommand(int Command1, int Command2, char *pValue)
{
	return SDK_SCAN_SendCommand(Command1, Command2, pValue);
}

extern "C" BOOL SCAN_QueryStatus(int Command1, int Command2, char *pReturn)
{
	return SDK_SCAN_QueryStatus(Command1, Command2, pReturn);
}

extern "C" BOOL ScannerSetFromFile(char *pssFilePath)
{
	return SDK_ScannerSetFromFile(pssFilePath);
}

extern "C" BOOL Scanner_Version(char* Returnbuf)
{
	return SDK_Scanner_Version(Returnbuf);
}

/***************************      Buzzer      *********************************/
extern "C" int beeper_status(void)
{
	return SDK_beeper_status();
}

extern "C" void off_beeper(void)
{
	SDK_off_beeper();
}

extern "C" void on_beeper(int *sequence)
{
	SDK_on_beeper(sequence);
}

extern "C" void SetBuzzerVol(int slVol)
{
	SDK_SetBuzzerVol(slVol);
}

/**************************      Calendar      ********************************/
extern "C" int DayOfWeek(void)
{
	return SDK_DayOfWeek();
}

extern "C" int get_time(char* time_buf)
{
	return SDK_get_time(time_buf);
}

extern "C" int set_time(char* time_buf)
{
	return SDK_set_time(time_buf);
}

/**********************     File Manipulation:       **************************/
extern "C" int __access(const char *Filename)
{
	return SDK__access(Filename);
}

extern "C" int append(int fd, char* buffer, int count)
{
	return SDK_append(fd, buffer, count);
}

extern "C" int appendln(int fd, char* buffer)
{
	return SDK_appendln(fd, buffer);
}

extern "C" int chsize(int fd, long size)
{
	return SDK_chsize(fd, size);
}

extern "C" int close(int fd)
{
	return SDK_close(fd);
}

extern "C" int delete_top(int fd, int count)
{
	return SDK_delete_top(fd, count);
}

extern "C" int delete_topln(int fd)
{
	return SDK_delete_topln(fd);
}

extern "C" int eof(int fd)
{
	return SDK_eof(fd);
}

extern "C" long filelength(int fd)
{
	return SDK_filelength(fd);
}

extern "C" int filelist(char* file_list)
{
	return SDK_filelist(file_list);
}

extern "C" long lseek(int fd, long offset, int origin)
{
	return SDK_lseek(fd, offset, origin);
}

extern "C" int open(const char* file_name)
{
	return SDK_open(file_name);
}

extern "C" int read(int fd, char* buffer, int count)
{
	return SDK_read(fd, buffer, count);
}

extern "C" int read_error_code(void)
{
	return SDK_read_error_code();
}

extern "C" int readln(int fd, char* buffer, unsigned int max_count)
{
	return SDK_readln(fd, buffer, max_count);
}

extern "C" int _remove(const char* file_name)
{
	return SDK__remove(file_name);
}

extern "C" int _rename(char* old_name,char* new_name)
{
	return SDK__rename(old_name, new_name);
}

extern "C" long tell(int fd)
{
	return SDK_tell(fd);
}

extern "C" int write(int fd, char* buffer, int count)
{
	return SDK_write(fd, buffer, count);
}

extern "C" int writeln(int fd, char* buffer)
{
	return SDK_writeln(fd, buffer);
}

extern "C" int DiskC_format(void)
{
	return SDK_DiskC_format();
}

extern "C" int DiskD_format(void)
{
	return SDK_DiskD_format();
}

extern "C" unsigned int DiskC_totalsize(void)
{
	return SDK_DiskC_totalsize();
}

extern "C" unsigned int DiskD_totalsize(void)
{
	return SDK_DiskD_totalsize();
}

extern "C" unsigned int DiskC_usedsize(void)
{
	return SDK_DiskC_usedsize();
}

extern "C" unsigned int DiskD_usedsize(void)
{
	return SDK_DiskD_usedsize();
}

extern "C" unsigned int DiskC_freesize(void)
{
	return SDK_DiskC_freesize();
}

extern "C" unsigned int DiskD_freesize(void)
{
	return SDK_DiskD_freesize();
}

extern "C" int getDirNum(char *pssPath)
{
	return SDK_getDirNum(pssPath);
}

extern "C" int getFileNum(char *pssPath)
{
	return SDK_getFileNum(pssPath);
}

extern "C" int getDirList(char *pssPath, char *pssBuffer)
{
	return SDK_getDirList(pssPath, pssBuffer);
}

extern "C" int getFileList(char *pssPath, char *pssBuffer)
{
	return SDK_getFileList(pssPath, pssBuffer);
}

extern "C" _TFILE* _fopen(const char*filename, const char *access_mode)
{
	return SDK__fopen(filename, access_mode);
}

extern "C" char* _fopenLookup(char* pssFName, unsigned int* pulSize)
{
	return SDK__fopenLookup(pssFName, pulSize);
}

extern "C" int _fclose(_TFILE* file_pointer)
{
	return SDK__fclose(file_pointer);
}

extern "C" void _fcloseAll(void)
{
	SDK__fcloseAll();
}

extern "C" int _fseek(_TFILE *file_pointer, long offset, int origin)
{
	return SDK__fseek(file_pointer, offset, origin);
}

extern "C" unsigned int _filelength(_TFILE* file_pointer)
{
	return SDK__filelength(file_pointer);
}

extern "C" unsigned int _fread(const void *buffer, U32 size, U32 count, _TFILE *file_pointer)
{
	return SDK__fread(buffer, size, count, file_pointer);
}

extern "C" unsigned int _fwrite(const void *buffer, U32 size, U32 count, _TFILE *file_pointer)
{
	return SDK__fwrite(buffer, size, count, file_pointer);
}

/***************************       DBMS         *******************************/
extern "C" int Ini_Search(_TFILE* filehd,_DBMS* F_Search,unsigned char *pusFielddlt,int record_type,int record_length,int total_field_no,int total_record_no)
{
	return SDK_Ini_Search(filehd, F_Search, pusFielddlt, record_type, record_length, total_field_no, total_record_no);
}

extern "C" int Close_Search(_DBMS* F_Search)
{
	return SDK_Close_Search(F_Search);
}

extern "C" int SearchField(_DBMS* F_Search, char* field, int search_fieldno, int recordno, int flag)
{
	return SDK_SearchField(F_Search, field, search_fieldno, recordno, flag);
}

extern "C" int SearchField_GR(_DBMS* F_Search, char* field, int search_fieldno, int recordno, char* R_Buffer, int flag)
{
	return SDK_SearchField_GR(F_Search, field, search_fieldno, recordno, R_Buffer, flag);
}

extern "C" int SearchField_GF(_DBMS* F_Search, char* field, int search_fieldno, int recordno, int get_field_no, char* F_Buffer, int flag)
{
	return SDK_SearchField_GF(F_Search, field, search_fieldno, recordno, get_field_no, F_Buffer, flag);
}

extern "C" int SearchMultiField_GF(_DBMS* F_Search, char* multi_field, int recordno, int get_field_no, char* F_Buffer, int flag)
{
	return SDK_SearchMultiField_GF(F_Search, multi_field, recordno, get_field_no, F_Buffer, flag);
}

extern "C" long SeekRecord(_DBMS* F_Search, int recordno)
{
	return SDK_SeekRecord(F_Search, recordno);
}

extern "C" int GetRecordNum(_DBMS* F_Search)
{
	return SDK_GetRecordNum(F_Search);
}

extern "C" int DeleteRecord(_DBMS* F_Search, int recordnum)
{
	return SDK_DeleteRecord(F_Search, recordnum);
}

extern "C" int DeleteLastRecord(_DBMS* F_Search)
{
	return SDK_DeleteLastRecord(F_Search);
}

extern "C" int AppendRecord(_DBMS* F_Search, char* record)
{
	return SDK_AppendRecord(F_Search, record);
}

extern "C" int WriteField(_DBMS* F_Search, int recordno, int fieldno, char* field)
{
	return SDK_WriteField(F_Search, recordno, fieldno, field);
}

extern "C" int WriteRecord(_DBMS* F_Search, int recordno, char* record)
{
	return SDK_WriteRecord(F_Search, recordno, record);
}

extern "C" int ReadField(_DBMS* F_Search, int recordno, int fieldno, char* buffer)
{
	return SDK_ReadField(F_Search, recordno, fieldno, buffer);
}

extern "C" int ReadRecord(_DBMS* F_Search, int recordno, char* buffer)
{
	return SDK_ReadRecord(F_Search, recordno, buffer);
}

/*****************************      LED      **********************************/
extern "C" void set_led(int led, int mode, int duration)
{
	SDK_set_led(led, mode, duration);
}

/****************************     Keypad     **********************************/
extern "C" void clr_kb(void)
{
	SDK_clr_kb();
}

extern "C" void dis_alpha(void)
{
	SDK_dis_alpha();
}

extern "C" void en_alpha(void)
{
	SDK_en_alpha();
}

extern "C" int get_alpha_enable_state(void)
{
	return SDK_get_alpha_enable_state();
}

extern "C" int _getchar(void)
{
	return SDK__getchar();
}

extern "C" int GetKeyClick(void)
{
	return SDK_GetKeyClick();
}

extern "C" void SetKeyClick(int status)
{
	SDK_SetKeyClick(status);
}

extern "C" void _scanf_ctrl_ScannerStatus(BOOL bStatus)
{
	SDK__scanf_ctrl_ScannerStatus(bStatus);
}
/*
extern "C" void _scanf_ctrl_ScannerReadConfirm(int nConfirm)
{
	SDK__scanf_ctrl_ScannerReadConfirm(nConfirm);
}
*/
extern "C" void _scanf_ctrl_ScanWithENT(BOOL bScanEnt)
{
	SDK__scanf_ctrl_ScanWithENT(bScanEnt);
}

extern "C" void _scanf_ctrl_AlphaKey(BOOL bAlpha)
{
	SDK__scanf_ctrl_AlphaKey(bAlpha);
}

extern "C" void _scanf_ctrl_password(char ssPassWord)
{
	SDK__scanf_ctrl_password(ssPassWord);
}

extern "C" void _scanf_ctrl_KeypadLock(BOOL bLock)
{
	SDK__scanf_ctrl_KeypadLock(bLock);
}

extern "C" int _scanf_color(int color, const char *format, ...)
{
	//Bz format stringܰʰѼ(Ĥ@ܼƪ})
	va_list arglist;
	char *pssPoint;

	va_start(arglist,format);
	pssPoint = (char*)va_arg(arglist, void*);			//Ĥ@ܼƪ}
	va_end(arglist);

	return SDK__scanf_color(color, format, pssPoint);
}

extern "C" int _scanf_color_DefaultStr(int color, char* assDefaultStr, const char *format, ...)
{
	//Bz format stringܰʰѼ(Ĥ@ܼƪ})
	va_list arglist;
	char *pssPoint;

	va_start(arglist,format);
	pssPoint = (char*)va_arg(arglist, void*);			//Ĥ@ܼƪ}
	va_end(arglist);

	return SDK__scanf_color_DefaultStr(color, assDefaultStr, format, pssPoint);
}

extern "C" void set_alpha_mode_state(int status)
{
	SDK_set_alpha_mode_state(status);
}

extern "C" int get_alpha_mode_state(void)
{
	return SDK_get_alpha_mode_state();
}

extern "C" void set_keypad_BL(BOOL bStatus)
{
	SDK_set_keypad_BL(bStatus);
}

extern "C" BOOL get_keypad_BL(void)
{
	return SDK_get_keypad_BL();
}

extern "C" void set_keypad_BL_Timer(int slTimer)
{
	SDK_set_keypad_BL_Timer(slTimer);
}

extern "C" int get_keypad_BL_Timer(void)
{
	return SDK_get_keypad_BL_Timer();
}

extern "C" void _scanf_ctrl_Vibrate(BOOL bEnable)
{
	SDK__scanf_ctrl_Vibrate(bEnable);
}

extern "C" void _scanf_ctrl_AlphaKey_Mode(int slAlphaMode)
{
	SDK__scanf_ctrl_AlphaKey_Mode(slAlphaMode);
}

extern "C" void FNKey_Reset(void)
{
	SDK_FNKey_Reset();
}

extern "C" char FNKey_GetState(short smKeyNum)
{
	return SDK_FNKey_GetState(smKeyNum);
}

extern "C" char FNKey_SetUserDef(short smKeyNum, void (*pslFunction)(void))
{
	return SDK_FNKey_SetUserDef(smKeyNum, pslFunction);
}

/**************************        LCD       **********************************/
extern "C" void clr_eol(void)
{
	SDK_clr_eol();
}

extern "C" void clr_rect(int left, int top, int width, int height)
{
	SDK_clr_rect(left, top, width, height);
}

extern "C" void clr_scr(void)
{
	SDK_clr_scr();
}

extern "C" void fill_rect(int left, int top, int width, int height)
{
	SDK_fill_rect(left, top, width, height);
}

extern "C" void fill_rect_color(int color, int left, int top, int width, int height)
{
	SDK_fill_rect_color(color, left, top, width, height);
}

extern "C" int Get_Cursor(void)
{
	return SDK_Get_Cursor();
}

extern "C" void Set_Cursor(int status)
{
	SDK_Set_Cursor(status);
}

extern "C" int gotoxy(int x_position, int y_position)
{
	return SDK_gotoxy(x_position, y_position);
}

extern "C" int wherex(void)
{
	return SDK_wherex();
}

extern "C" int wherexy(int* column, int* row)
{
	return SDK_wherexy(column, row);
}

extern "C" int wherey(void)
{
	return SDK_wherey();
}

extern "C" void lcd_backlit_Setlv(int level)
{
	SDK_lcd_backlit_Setlv(level);
}

extern "C" void lcd_backlit_SetTimer(int timer)
{
	SDK_lcd_backlit_SetTimer(timer);
}

extern "C" int lcd_backlit_Getlv(void)
{
	return SDK_lcd_backlit_Getlv();
}

extern "C" int lcd_backlit_GetTimer(void)
{
	return SDK_lcd_backlit_GetTimer();
}

extern "C" int _printf_color(int color, char *format, ...)
{
	//Bz format string,ANGe_printfLX
	va_list ap;
	char string_p[256];

	va_start(ap, format);
    vsprintf(string_p, format, ap);
    va_end(ap);

	return SDK__printf_color(color, string_p);
}

extern "C" int _putchar(char c)
{
	return SDK__putchar(c);
}

extern "C" char _puts(char* string)
{
	return SDK__puts(string);
}

extern "C" char _puts_color(int colorindex, char* string)
{
	return SDK__puts_color(colorindex, string);
}

extern "C" void show_image_bmp(int left, int top, int width, int height, const void *pat)
{
	SDK_show_image_bmp(left, top, width, height, pat);
}

extern "C" int _putchar_color(int color, char c)
{
	return SDK__putchar_color(color, c);
}

/****************************     TextBlock    ********************************/
extern "C" BOOL DefineTextBlock(S32 slBlockNo,S32 slSelFont,S32 slBGType,U32* ulBGData,S32 slColumn,S32 slRow,S32 slXPos,S32 slYPos)
{
	return SDK_DefineTextBlock(slBlockNo, slSelFont, slBGType, ulBGData, slColumn, slRow, slXPos, slYPos);
}

extern "C" BOOL SetTextBlock(S32 slBlockNo,BOOL bSF)
{
	return SDK_SetTextBlock(slBlockNo, bSF);
}

extern "C" void ResetTextBlock(S32 slBlockNo)
{
	SDK_ResetTextBlock(slBlockNo);
}

extern "C" POINT PrintTextBlock(S32 slBlockNo, S32 slColumn, S32 slRow, char* string, U32 ulFontColor)
{
	return SDK_PrintTextBlock(slBlockNo, slColumn, slRow, string, ulFontColor);
}

extern "C" POINT GetTextBlockCur(S32 slBlockNo)
{
	return SDK_GetTextBlockCur(slBlockNo);
}

extern "C" void SetTextBlockCur(S32 slBlockNo,S32 slColumn,S32 slRow)
{
	SDK_SetTextBlockCur(slBlockNo, slColumn, slRow);
}

extern "C" void ShowTextBlockCursor(S32 slBlockNo, BOOL bShow, S32 slType)
{
	SDK_ShowTextBlockCursor(slBlockNo, bShow, slType);
}

/*******************************     Font    **********************************/
extern "C" BOOL DispFont_SetFont(S32 slSelFont, const char *filename)
{
	return SDK_DispFont_SetFont(slSelFont, filename);
}

extern "C" BOOL DispFont_GetFontInfo(S32 slSelFont, S32* slType, S32* slWidth, S32* slHeight)
{
	return SDK_DispFont_GetFontInfo(slSelFont, slType, slWidth, slHeight);
}

extern "C" BOOL DispFont_SetPFont(S32 slSelFont, char* pfile)
{
	return SDK_DispFont_SetPFont(slSelFont, pfile);
}

/**********************     Communication Ports     ***************************/
extern "C" void clear_com(int port)
{
	SDK_clear_com(port);
}

extern "C" int close_com(int port)
{
	return SDK_close_com(port);
}

extern "C" int com_cts(int port)
{
	return SDK_com_cts(port);
}

extern "C" int com_eot(int port)
{
	return SDK_com_eot(port);
}

extern "C" int com_overrun(int port)
{
	return SDK_com_overrun(port);
}

extern "C" void com_rts(int port, int val)
{
	SDK_com_rts(port, val);
}

extern "C" int nwrite_com(int port, char *s, int count)
{
	return SDK_nwrite_com(port, s, count);
}

extern "C" int open_com(int com_port, int setting)
{
	return SDK_open_com(com_port, setting);
}

extern "C" int read_com(int port, char *c)
{
	return SDK_read_com(port, c);
}

extern "C" int write_com(int port, char *s)
{
	return SDK_write_com(port, s);
}

extern "C" void USB_Open(void)
{
	SDK_USB_Open();
}

extern "C" void USB_Close(void)
{
	SDK_USB_Close();
}

extern "C" int USB_Read(unsigned char *rbuf, unsigned int rLength)
{
	return SDK_USB_Read(rbuf, rLength);
}

extern "C" void USB_Write(unsigned char *wbuf, unsigned int wLength)
{
	SDK_USB_Write(wbuf, wLength);
}

/**********************         Remote Link          ***************************/
extern "C" void RemoteLink(void)
{
	SDK_RemoteLink();
}

extern "C" void SetRemoteBaud(int slBaud)
{
	SDK_SetRemoteBaud(slBaud);
}

extern "C" int GetRemoteBaud(void)
{
	return SDK_GetRemoteBaud();
}

extern "C" void SetRemoteInterface(int slInterface)
{
	SDK_SetRemoteInterface(slInterface);
}

extern "C" int GetRemoteInterface(void)
{
	return SDK_GetRemoteInterface();
}

extern "C" void RemoteLink_RealTime(BOOL bStatus)
{
	SDK_RemoteLink_RealTime(bStatus);
}

/***********************           System           ****************************/
extern "C" void SysDelay(unsigned int ulTime)
{
	SDK_SysDelay(ulTime);
}

extern "C" void SysSuspend(void)
{
	SDK_SysSuspend();
}

extern "C" void SetPowerOnState(int slStatus)
{
	SDK_SetPowerOnState(slStatus);
}

extern "C" int GetPowerOnState(void)
{
	return SDK_GetPowerOnState();
}

extern "C" void SetAutoPWOff(int slTimer)
{
	SDK_SetAutoPWOff(slTimer);
}

extern "C" int GetAutoPWOff(void)
{
	return SDK_GetAutoPWOff();
}

extern "C" void SetStatausBAR(int slStatus)
{
	SDK_SetStatausBAR(slStatus);
}

extern "C" int GetStatusBAR(void)
{
	return SDK_GetStatusBAR();
}

extern "C" void SN_Get(char *pssSNBuffer)
{
	SDK_SN_Get(pssSNBuffer);
}

extern "C" void BIOS_SetDefault(void)
{
	SDK_BIOS_SetDefault();
}

extern "C" BOOL Check_AID(char* pssUser, char* pssPassword)
{
	return SDK_Check_AID(pssUser, pssPassword);
}

/***********************           Memory           ****************************/
extern "C" int TotalHeapSize(void)
{
	return SDK_TotalHeapSize();
}

extern "C" int UsedHeapSize(void)
{
	return SDK_UsedHeapSize();
}

extern "C" int FreeHeapSize(void)
{
	return SDK_FreeHeapSize();
}

extern "C" void Tfree(void *mem_address)
{
	SDK_Tfree(mem_address);
}

extern "C" void* Tmalloc(U32 num_bytes)
{
	return SDK_Tmalloc(num_bytes);
}

/***********************           Vibrate          ****************************/
extern "C" void off_vibrator(void)
{
	SDK_off_vibrator();
}

extern "C" void on_vibrator(void)
{
	SDK_on_vibrator();
}

extern "C" void set_vibrator_timer(unsigned char usTimer)
{
	SDK_set_vibrator_timer(usTimer);
}

extern "C" unsigned char get_vibrator_timer(void)
{
	return SDK_get_vibrator_timer();
}

/***************************       Others        *******************************/
extern "C" void prc_menu_color(MENU_COLOR *menu)
{
	SDK_prc_menu_color(menu);
}

/***************************    For Simulator    *******************************/
extern "C" void CopyFileToTerminal(char *pssPCFileName, char *pssPDTFileName)
{
	SDK_CopyFileToTerminal(pssPCFileName, pssPDTFileName);
}

extern "C" void BackupDataFiletoPC(char *pTerminalFile, char *pPCFileName)
{
	SDK_BackupDataFiletoPC(pTerminalFile, pPCFileName);
}

/***************************   Data Conversion   *******************************/
extern "C" char * __itoa (int value, char *string, int radix)
{
	return SDK__itoa(value, string, radix);
}

extern "C" char * __ltoa (long value, char *string, int radix)
{
	return SDK__ltoa(value, string, radix);
}

extern "C" char * __ultoa (unsigned long value, char *string, int radix)
{
	return SDK__ultoa(value, string, radix);
}

/***********************          BlueTooth         ****************************/
extern "C" int BT_Start(void)
{
	return SDK_BT_Start();
}

extern "C" int BT_Stop(void)
{
	return SDK_BT_Stop();
}

extern "C" void BT_SetPWStatus(int slStatus)
{
	SDK_BT_SetPWStatus(slStatus);
}

extern "C" int BT_GetPWStatus(void)
{
	return SDK_BT_GetPWStatus();
}

extern "C" int BT_Open(void)
{
	return SDK_BT_Open();
}

extern "C" int BT_Close(void)
{
	return SDK_BT_Close();
}

extern "C" int BT_Read(char* pssBuf, int slReadSize, int* pslGetSize)
{
	return SDK_BT_Read(pssBuf, slReadSize, pslGetSize);
}

extern "C" int BT_Write(char* pssBuf, int slWriteSize, int* pslPutSize)
{
	return SDK_BT_Write(pssBuf, slWriteSize, pslPutSize);
}

extern "C" int BT_GetLocalInfo(_BT_INFO* stInfo)
{
	return SDK_BT_GetLocalInfo(stInfo);
}

extern "C" int BT_SetLocalSet(_BT_INFO* stSet)
{
	return SDK_BT_SetLocalSet(stSet);
}

extern "C" int BT_Inquiry(_BT_DEVINFO* stBT_DevInfo, BOOL bGetDevName)
{
	return SDK_BT_Inquiry(stBT_DevInfo, bGetDevName);
}

extern "C" int fErrorCode = SDK_fErrorCode;
extern "C" int CodeLen = SDK_CodeLen;
extern "C" char *CodeBuf = SDK_CodeBuf;
extern "C" char *FullCodeBuf = SDK_FullCodeBuf;
extern "C" char *CodeID = SDK_CodeID;
extern "C" char *CodeName = SDK_CodeName;
extern "C" char *Preamble = SDK_Preamble;
extern "C" char *Postamble = SDK_Postamble;
extern "C" char *Terminator = SDK_Terminator;

