/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CompanyTreeBuilder {
    private Map companys;
    private CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
    private CompanyOrgUnitCollection companyColl;
    private Map companyNodes = new HashMap();

    public CompanyTreeBuilder(CompanyOrgUnitCollection companyColl) throws BOSException, EASBizException {
        this.companyColl = companyColl;
        this.companys = this.getCompanys();
    }

    public TreeNode getRoot() throws BOSException {
        int size = this.companyColl.size();
        for (int i = 0; i < size; ++i) {
            CompanyOrgUnitInfo company = this.companyColl.get(i);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)company);
            this.lookForPath(node);
        }
        return (DefaultKingdeeTreeNode)this.companyNodes.get(this.currCompany.getId());
    }

    private void lookForPath(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode father;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)node.getUserObject();
        if (this.companyNodes.containsKey(company.getId())) {
            return;
        }
        this.companyNodes.put(company.getId(), node);
        if (company.getId().equals((Object)this.currCompany.getId()) || company.getParent() == null || this.companys.get(company.getParent().getId()) == null) {
            return;
        }
        if (this.companyNodes.get(company.getParent().getId()) == null) {
            CompanyOrgUnitInfo parent = (CompanyOrgUnitInfo)this.companys.get(company.getParent().getId());
            father = new DefaultKingdeeTreeNode((Object)parent);
            this.lookForPath(father);
        } else {
            father = (DefaultKingdeeTreeNode)this.companyNodes.get(company.getParent().getId());
        }
        father.add((MutableTreeNode)node);
    }

    private Map getCompanys() throws BOSException, EASBizException {
        CompanyOrgUnitCollection companyOrgColl = CompanyOrgUnitFactory.getRemoteInstance().buildByRoot(this.currCompany.getId().toString());
        HashMap<BOSUuid, CompanyOrgUnitInfo> companys = new HashMap<BOSUuid, CompanyOrgUnitInfo>();
        int size = companyOrgColl.size();
        for (int i = 0; i < size; ++i) {
            CompanyOrgUnitInfo tmpCompany = companyOrgColl.get(i);
            companys.put(tmpCompany.getId(), tmpCompany);
        }
        return companys;
    }
}

