/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeCollection;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.AbstractCompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeBuilder;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CompanyTreeSelectUI
extends AbstractCompanyTreeSelectUI {
    private static final long serialVersionUID = 2764192117960663827L;
    private String accountTableId;
    private String periodTypeId;
    private JDialog dialogjjj;
    private FaRptQueryPanel panel = null;

    public CompanyTreeSelectUI(FaRptQueryPanel ui) throws Exception {
        this.panel = ui;
    }

    public CompanyTreeSelectUI(FaRptQueryPanel ui, String accountTableID, String periodTypeID) throws Exception {
        this.panel = ui;
        this.accountTableId = accountTableID;
        this.periodTypeId = periodTypeID;
        this.setBooksModel();
        String selectCompany = ((AcountSchemeInfo)this.kcbBooks.getSelectedItem()).getId().toString();
        CompanyOrgUnitCollection coll = FaListFactory.getRemoteInstance().findCompanyCollection(accountTableID, periodTypeID, selectCompany);
        this.initCompanyTree(coll);
    }

    protected void initCompanyTree(CompanyOrgUnitCollection coll) throws Exception {
        CompanyTreeBuilder treeBuilder = new CompanyTreeBuilder(coll);
        this.initUIContentLayout();
        if (this.treeOrigin == null) {
            return;
        }
        TreeNode root = treeBuilder.getRoot();
        DefaultTreeModel tm = new DefaultTreeModel(root);
        this.treeOrigin.setModel((TreeModel)tm);
        if (root == null) {
            return;
        }
        this.treeOrigin.expandAllNodes(true, root);
    }

    void add() {
        TreePath[] tps = this.treeOrigin.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            DefaultKingdeeTreeNode findNode;
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            DefaultKingdeeTreeNode rightRoot = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
            if (rightRoot != null && (findNode = this.findNode(selectedNode, rightRoot)) != null) {
                DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)findNode.getParent();
                if (parent == null) {
                    ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot(null);
                } else {
                    findNode.removeFromParent();
                }
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)parent);
            }
            if (tp.getPathCount() == 1 && this.treeSelected.getModel().getRoot() == null) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getPathComponent(0);
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)node.clone();
                this.cloneTree(root, node);
                ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot((TreeNode)root);
                continue;
            }
            DefaultKingdeeTreeNode toNode = null;
            for (int j = 0; j < tp.getPathCount(); ++j) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getPathComponent(j);
                DefaultKingdeeTreeNode temp = null;
                if (this.treeSelected.getModel().getRoot() == null) {
                    ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot((TreeNode)node.clone());
                    continue;
                }
                temp = this.findNode(node, (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot());
                if (temp == null) {
                    this.addTo(toNode, tp, j);
                    continue;
                }
                toNode = temp;
            }
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot();
        this.treeSelected.expandAllNodes(true, (TreeNode)root);
    }

    void addTo(DefaultKingdeeTreeNode toNode, TreePath tp, int from) {
        while (from < tp.getPathCount()) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)tp.getPathComponent(from);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            if (from == tp.getPathCount() - 1) {
                this.cloneTree(child, oriChild);
            }
            if (toNode == null) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
                ((KingdeeTreeModel)this.treeSelected.getModel()).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)root, 0);
            } else {
                DefaultKingdeeTreeNode sibling = oriChild;
                DefaultKingdeeTreeNode found = null;
                while ((sibling = (DefaultKingdeeTreeNode)sibling.getNextSibling()) != null && (found = this.findNode(sibling, toNode)) == null) {
                }
                if (found != null) {
                    toNode.insert((MutableTreeNode)child, toNode.getIndex((TreeNode)found));
                } else {
                    toNode.add((MutableTreeNode)child);
                }
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)toNode);
            }
            toNode = child;
            ++from;
        }
    }

    void cloneTree(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode oriRoot) {
        for (int i = 0; i < oriRoot.getChildCount(); ++i) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)oriRoot.getChildAt(i);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            root.add((MutableTreeNode)child);
            this.cloneTree(child, oriChild);
        }
    }

    DefaultKingdeeTreeNode findNode(DefaultKingdeeTreeNode source, DefaultKingdeeTreeNode dest) {
        if (dest == null) {
            return null;
        }
        if (((CompanyOrgUnitInfo)source.getUserObject()).getId().equals((Object)((CompanyOrgUnitInfo)dest.getUserObject()).getId())) {
            return dest;
        }
        for (int i = 0; i < dest.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)dest.getChildAt(i);
            if ((child = this.findNode(source, child)) == null) continue;
            return child;
        }
        return null;
    }

    void delete() {
        TreePath[] tps = this.treeSelected.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            while (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                tp = tp.getParentPath();
                node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            }
            if (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            if (node.equals(this.treeSelected.getModel().getRoot())) {
                ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot(null);
                return;
            }
            ((KingdeeTreeModel)this.treeSelected.getModel()).removeNodeFromParent((MutableTreeNode)node);
        }
        if (((TreeNode)this.treeSelected.getModel().getRoot()).isLeaf()) {
            ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot(null);
        }
    }

    void makeSimpleTree(DefaultMutableTreeNode bigNode, DefaultMutableTreeNode simpleNode, int beginLevel) {
        CompanyOrgUnitInfo userObject = (CompanyOrgUnitInfo)bigNode.getUserObject();
        CompanyOrgUnitInfo newUserObject = new CompanyOrgUnitInfo();
        String companyId = userObject.getId().toString();
        String name = userObject.getName();
        boolean isLeaf = bigNode.isLeaf();
        int level = bigNode.getLevel() - beginLevel;
        newUserObject.setId(BOSUuid.read((String)companyId));
        newUserObject.setName(name);
        newUserObject.setIsLeaf(isLeaf);
        newUserObject.setLevel(level);
        simpleNode.setUserObject(newUserObject);
        Enumeration<TreeNode> childs = bigNode.children();
        while (childs.hasMoreElements()) {
            bigNode = (DefaultMutableTreeNode)childs.nextElement();
            DefaultKingdeeTreeNode simpleNode2 = new DefaultKingdeeTreeNode();
            simpleNode.add((MutableTreeNode)simpleNode2);
            this.makeSimpleTree(bigNode, (DefaultMutableTreeNode)simpleNode2, beginLevel);
        }
    }

    void confirm() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
        if (root == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notSelectCompany"));
            return;
        }
        DefaultKingdeeTreeNode simpleRoot = new DefaultKingdeeTreeNode();
        this.makeSimpleTree((DefaultMutableTreeNode)root, (DefaultMutableTreeNode)simpleRoot, root.getLevel());
        KingdeeTreeModel newValue = new KingdeeTreeModel((TreeNode)simpleRoot, false);
        ArrayList idList = new ArrayList();
        this.buildCompanIdList((TreeNode)simpleRoot, idList);
        Map periodYears = null;
        try {
            periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
            SysUtil.abort();
        }
        Integer maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
        if (maxPeriodYear <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.faSysNoStart"));
            ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot(null);
            return;
        }
        this.firePropertyChange("companyChanged", null, newValue);
        this.panel.setSchemeInfo((AcountSchemeInfo)this.kcbBooks.getSelectedItem());
        this.dialogjjj.setVisible(false);
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    void cancel() {
        this.dialogjjj.setVisible(false);
    }

    @Override
    public void addAction_actionPerformed(ActionEvent e) throws Exception {
        this.add();
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        this.cancel();
    }

    @Override
    public void deleteAction_actionPerformed(ActionEvent e) throws Exception {
        this.delete();
    }

    @Override
    public void oKAction_actionPerformed(ActionEvent e) throws Exception {
        this.confirm();
    }

    public void setDialog(JDialog dialog) {
        this.dialogjjj = dialog;
    }

    public void setBooksModel() throws Exception {
        EventListener[] lister = this.kcbBooks.getListeners(ActionListener.class);
        if (lister != null) {
            for (int i = 0; i < lister.length; ++i) {
                this.kcbBooks.removeActionListener((ActionListener)lister[i]);
            }
        }
        this.kcbBooks.removeAllItems();
        if (BooksUtil.canCreateBook(null)) {
            EntityViewInfo view = new EntityViewInfo();
            SorterItemInfo sorter = new SorterItemInfo("number");
            view.getSorter().add(sorter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("isMaster"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isLock", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("accountTable.id", (Object)this.accountTableId));
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.periodTypeId));
            filter.getFilterItems().add(new FilterItemInfo("isMaster", (Object)new Integer(1)));
            filter.setMaskString(" (#0 and #1 and #2 )or  #3");
            view.setFilter(filter);
            AcountSchemeCollection col = AcountSchemeFactory.getRemoteInstance().getAcountSchemeCollection(view);
            this.kcbBooks.addItems(col.toArray());
            GlUtils.setSelectedItem((KDComboBox)this.kcbBooks, (CoreBaseInfo)BooksUtil.getCurrentBook(null));
        } else {
            this.kcbBooks.addItem((Object)BooksUtil.getCurrentBook(null));
            this.kcbBooks.setEnabled(false);
        }
        if (lister != null) {
            for (int i = 0; i < lister.length; ++i) {
                this.kcbBooks.addActionListener((ActionListener)lister[i]);
            }
        }
    }

    @Override
    protected void kcbBooks_actionPerformed(ActionEvent e) throws Exception {
        this.treeSelected.setSelectionRow(0);
        this.delete();
        AcountSchemeInfo acountScheme = (AcountSchemeInfo)this.kcbBooks.getSelectedItem();
        BooksUtil.setCurrentBook(null, (AcountSchemeInfo)acountScheme);
        if (!acountScheme.isIsMaster()) {
            CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            this.accountTableId = currentCompany.getAccountTable().getId().toString();
            this.periodTypeId = currentCompany.getAccountPeriodType().getId().toString();
        }
        String accountTableIDSelect = this.accountTableId;
        String periodTypeIDSelect = this.periodTypeId;
        String acountSchemeIDSelect = acountScheme.getId().toString();
        AcountSchemeInfo currentScheme = BooksUtil.getCurrentBook(null);
        BooksUtil.setCurrentBook(null, (AcountSchemeInfo)currentScheme);
        CompanyOrgUnitCollection coll = FaListFactory.getRemoteInstance().findCompanyCollection(accountTableIDSelect, periodTypeIDSelect, acountSchemeIDSelect);
        this.initCompanyTree(coll);
    }

    void delete(KDTree tree) {
        TreePath[] tps = tree.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            while (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                tp = tp.getParentPath();
                node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            }
            if (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            if (node.getParent() instanceof DefaultKingdeeTreeNode) {
                ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
                continue;
            }
            KDTreeNode parent = (KDTreeNode)node.getParent();
            if (parent == null) continue;
            ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public KDTree getTreeSelected() {
        return this.treeSelected;
    }
}

