/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaDBUtil;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeBuilder;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FLCompanyTreeSelectUI
extends CompanyTreeSelectUI {
    public FLCompanyTreeSelectUI(FaRptQueryPanel ui) throws Exception {
        super(ui);
        this.setBooksModel();
        this.initCompanyTree();
    }

    @Override
    public void setBooksModel() {
        this.kDLabelContainer1.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"165_FLCompanyTreeSelectUI"));
        this.kcbBooks.removeAllItems();
        this.kcbBooks.setEnabled(false);
        Vector<String> tempCbDatas = new Vector<String>();
        tempCbDatas.addElement(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"166_FLCompanyTreeSelectUI"));
        this.kcbBooks.setModel(new DefaultComboBoxModel(tempCbDatas));
    }

    @Override
    void confirm() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot();
        if (root == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notSelectCompany"));
            return;
        }
        DefaultKingdeeTreeNode simpleRoot = new DefaultKingdeeTreeNode();
        this.makeSimpleTree((DefaultMutableTreeNode)root, (DefaultMutableTreeNode)simpleRoot, root.getLevel());
        KingdeeTreeModel newValue = new KingdeeTreeModel((TreeNode)simpleRoot, false);
        ArrayList idList = new ArrayList();
        this.buildCompanIdList((TreeNode)simpleRoot, idList);
        Map periodYears = null;
        try {
            periodYears = this.findPeriodYears(idList);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
            SysUtil.abort();
        }
        Integer maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
        if (maxPeriodYear <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.faSysNoStart"));
            ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot(null);
            return;
        }
        this.firePropertyChange("companyChanged", null, newValue);
        this.cancel();
    }

    protected void initCompanyTree() throws Exception {
        CompanyOrgUnitCollection coll = this.findCompanyCollection();
        CompanyTreeBuilder treeBuilder = new CompanyTreeBuilder(coll);
        this.initUIContentLayout();
        if (this.treeOrigin == null) {
            return;
        }
        TreeNode root = treeBuilder.getRoot();
        DefaultTreeModel tm = new DefaultTreeModel(root);
        this.treeOrigin.setModel((TreeModel)tm);
        if (root == null) {
            return;
        }
        this.treeOrigin.expandAllNodes(true, root);
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    private CompanyOrgUnitCollection findCompanyCollection() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID ,company.FName_l2 AS COMPANYNAME, company.FParentID AS ParentID");
        sql.append(" FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" LEFT JOIN T_BKS_AcountScheme sche on sche.fid=company.faccountschemeid ");
        sql.append(" WHERE ss.FName = ").append(2001);
        sql.append(" AND  (sche.FIsMaster = 1 ");
        sql.append(" OR  company.faccountschemeid is null) ");
        String inSql = FaDBUtil.getSplitInSql(this.getOrgRange(), "company.fid");
        sql.append(" AND company.fid ").append(inSql);
        sql.append(" ORDER BY company.FLongNumber");
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            while (rs.next()) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)rs.getString("COMPANYID")));
                company.setName(rs.getString("COMPANYNAME"));
                String parentID = rs.getString("ParentID");
                if (parentID != null) {
                    CompanyOrgUnitInfo parent = new CompanyOrgUnitInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    company.setParent(parent);
                }
                coll.add(company);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return coll;
    }

    private String getOrgRange() throws EASBizException, BOSException {
        StringBuffer orgIds = new StringBuffer();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        List orgIdList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType((IObjectPK)new ObjectUuidPK(user.getId()), OrgRangeType.BIZ_ORG_TYPE);
        for (String orgId : orgIdList) {
            orgIds.append("'").append(orgId).append("'");
            orgIds.append(",");
        }
        if (orgIds.length() > 1) {
            orgIds.deleteCharAt(orgIds.length() - 1);
        }
        return orgIds.toString();
    }

    private Map findPeriodYears(List companyIDList) throws BOSException {
        int minPeriodYear = 0;
        int maxPeriodYear = 0;
        int minPeriodNumber = 0;
        int maxPeriodNumber = 0;
        if (companyIDList != null && companyIDList.size() > 0) {
            String operator;
            StringBuffer companyIds = new StringBuffer();
            companyIds.append("'").append(companyIDList.get(0)).append("'");
            int size = companyIDList.size();
            for (int i = 1; i < size; ++i) {
                companyIds.append(",'").append(companyIDList.get(i).toString()).append("'");
            }
            String companys = companyIds.toString();
            if (companyIDList.size() == 1) {
                operator = " = ";
            } else {
                companys = "(" + companys + ")";
                operator = " IN ";
            }
            try {
                String inSql;
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT min(period.FPeriodYear) AS minPeriodYear");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FStartPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                if (" IN ".equals(operator)) {
                    String inSql2 = FaDBUtil.getSplitInSql(companys, "ssc.FCompanyID");
                    sql.append(" Where (ssc.FCompanyID ").append(inSql2).append(")");
                } else {
                    sql.append(" Where ssc.FCompanyID ").append(operator).append(companys);
                }
                sql.append(" AND ss.FName = ").append(2001);
                IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rowSet.next()) {
                    minPeriodYear = rowSet.getInt("minPeriodYear");
                }
                sql = new StringBuffer();
                sql.append("SELECT min(period.FPeriodNumber) AS minPeriodNumber");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FStartPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where period.FPeriodYear = ").append(minPeriodYear);
                if (" IN ".equals(operator)) {
                    inSql = FaDBUtil.getSplitInSql(companys, "ssc.FCompanyID");
                    sql.append(" AND ssc.FCompanyID ").append(inSql);
                } else {
                    sql.append(" AND ssc.FCompanyID ").append(operator).append(companys);
                }
                sql.append(" AND ss.FName = ").append(2001);
                rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rowSet.next()) {
                    minPeriodNumber = rowSet.getInt("minPeriodNumber");
                }
                sql = new StringBuffer();
                sql.append("SELECT max(period.FPeriodYear) AS maxPeriodYear");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                if (" IN ".equals(operator)) {
                    inSql = FaDBUtil.getSplitInSql(companys, "ssc.FCompanyID");
                    sql.append(" Where (ssc.FCompanyID ").append(inSql).append(")");
                } else {
                    sql.append(" Where ssc.FCompanyID ").append(operator).append(companys);
                }
                sql.append(" AND ss.FName = ").append(2001);
                rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rowSet.next()) {
                    maxPeriodYear = rowSet.getInt("maxPeriodYear");
                }
                sql = new StringBuffer();
                sql.append("SELECT max(period.FPeriodNumber) AS maxPeriodNumber");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where period.FPeriodYear = ").append(maxPeriodYear);
                if (" IN ".equals(operator)) {
                    inSql = FaDBUtil.getSplitInSql(companys, "ssc.FCompanyID");
                    sql.append(" AND ssc.FCompanyID ").append(inSql);
                } else {
                    sql.append(" AND ssc.FCompanyID ").append(operator).append(companys);
                }
                sql.append(" AND ss.FName = ").append(2001);
                rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rowSet.next()) {
                    maxPeriodNumber = rowSet.getInt("maxPeriodNumber");
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        HashMap<String, Integer> periodYears = new HashMap<String, Integer>(4);
        periodYears.put("MinPeriodYear", new Integer(minPeriodYear));
        periodYears.put("MaxPeriodYear", new Integer(maxPeriodYear));
        periodYears.put("MinPeriodNumber", new Integer(minPeriodNumber));
        periodYears.put("MaxPeriodNumber", new Integer(maxPeriodNumber));
        return periodYears;
    }
}

