/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaAmountStatConditionUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaDefRptSumOptionUtil;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FaAmountStatConditionUI
extends AbstractFaAmountStatConditionUI {
    private static final long serialVersionUID = 4506920009615231747L;
    private static final String SUM_OPTION = "sumOption";
    private static final String SPEC_LEVEL = "specLevel";
    private static final String SUMMARY = "summary";
    private static final String ITEM = "item";
    private static final String LEVEL = "level";
    private static final String LEVEL_TYPE = "levelType";
    private static final String IS_SUM = "isSum";
    private static final String FIELD_NAME = "fieldName";
    private static final String IS_BY_EVALUE = "isByEvalue";
    private static final String PERIOD_TYPE = "periodType";
    private static final String ACCOUNT_TABLE = "accountTable";
    private static final String COMPANY = "company";
    private static final String BOOKSCHEME = "bookScheme";

    public FaAmountStatConditionUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            evi.setFilter(filterInfo);
            this.prmtAccountTable.setEntityViewInfo(evi);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.prmtAccountTable.setEnabled(false);
            this.prmtPeriodType.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
        }
        this.ctnMain.addButton((JButton)this.wbtMoveUp);
        this.ctnMain.addButton((JButton)this.wbtMoveDown);
        this.wbtMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaAmountStatConditionUI.this.beforeActionPerformed(e);
                FaAmountStatConditionUI.this.wbtMoveUp_actionPerformed(e);
            }
        });
        this.wbtMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaAmountStatConditionUI.this.beforeActionPerformed(e);
                FaAmountStatConditionUI.this.wbtMoveDown_actionPerformed(e);
            }
        });
        this.tblSum.checkParsed();
        this.tblSum.getColumn(ITEM).getStyleAttributes().setLocked(true);
        this.initSumTable();
        this.prmtCompany.setEnabled(false);
    }

    @Override
    protected void addListener() throws Exception {
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaAmountStatConditionUI.this.fireYearChange();
            }
        });
        this.chkInitPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaAmountStatConditionUI.this.fireInitPeriodSelect();
            }
        });
        this.tblSum.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                FaAmountStatConditionUI.this.tblSum_LevelChanged(e);
            }
        });
        this.prmtAccountTable.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaAmountStatConditionUI.this.ctsUI = null;
                    FaAmountStatConditionUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtPeriodType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaAmountStatConditionUI.this.ctsUI = null;
                    FaAmountStatConditionUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaAmountStatConditionUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    protected void companyChanged(Object data) {
        if (data == null) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnYear.setModel((SpinnerModel)tmpModel);
            this.spnMonth.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnYear.setEnabled(!this.chkInitPeriod.isSelected());
            this.spnMonth.setEnabled(!this.chkInitPeriod.isSelected());
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel yearSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPeriodNumber = (Integer)periodYears.get("MaxPeriodNumber");
                yearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                yearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnYear.setModel((SpinnerModel)yearSpinnerNumberModel);
                this.spnYear.setValue((Object)this.maxPeriodYear);
                this.spnMonth.setValue((Object)this.maxPeriodNumber);
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    private void initSumTable() throws Exception {
        this.tblSum.removeRows();
        KDCheckBox kDCheckBox = new KDCheckBox();
        kDCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean selected = ((KDCheckBox)arg0.getSource()).getSelected() == 32;
                FaAmountStatConditionUI.this.tblSum_SummaryChanged(selected);
            }
        });
        this.tblSum.getColumn(SUMMARY).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kDCheckBox));
        KDComboBox kdcLevel = new KDComboBox();
        List list = FaSumLevelEnum.getEnumList();
        Object[] objs = list.toArray();
        kdcLevel.addItems(objs);
        this.tblSum.getColumn(LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevel));
        KDComboBox kdcLevelNotTree = new KDComboBox();
        kdcLevelNotTree.addItem((Object)FaSumLevelEnum.detail);
        KDFormattedTextField txtField = new KDFormattedTextField();
        txtField.setMinimumValue((Comparable)new Integer(1));
        this.tblSum.getColumn(SPEC_LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        IRow rowFaCat = this.tblSum.addRow();
        rowFaCat.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetCat"));
        rowFaCat.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowFaCat.getCell(SPEC_LEVEL).setValue(null);
        rowFaCat.setUserObject((Object)"assetCat");
        IRow rowLocation = this.tblSum.addRow();
        rowLocation.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"storeCity"));
        rowLocation.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowLocation.getCell(SPEC_LEVEL).setValue(null);
        rowLocation.setUserObject((Object)"storeCity");
        ICell euLocCell = rowLocation.getCell(LEVEL);
        euLocCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevelNotTree));
        IRow rowSourceType = this.tblSum.addRow();
        rowSourceType.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"originMethod"));
        rowSourceType.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowSourceType.getCell(SPEC_LEVEL).setValue(null);
        rowSourceType.setUserObject((Object)"originMethod");
        IRow rowUseStatus = this.tblSum.addRow();
        rowUseStatus.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useStatus"));
        rowUseStatus.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowUseStatus.getCell(SPEC_LEVEL).setValue(null);
        rowUseStatus.setUserObject((Object)"useStatus");
        IRow rowDept = this.tblSum.addRow();
        rowDept.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useDepartment"));
        rowDept.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowDept.getCell(SPEC_LEVEL).setValue(null);
        rowDept.setUserObject((Object)"useDepartment");
        this.tblSum.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblSum.getColumn(3).getStyleAttributes().setLocked(true);
        FaDefRptSumOptionUtil.addDefSumOption(this.tblSum);
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe(ACCOUNT_TABLE);
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam("id")));
                accountTable.setName(custAcountTable.getCustomerParam("name"));
                accountTable.setNumber(custAcountTable.getCustomerParam("number"));
                this.prmtAccountTable.setData((Object)accountTable);
                CustomerParams custPeriodType = cond.getMe(PERIOD_TYPE);
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam("id")));
                periodType.setName(custPeriodType.getCustomerParam("name"));
                periodType.setNumber(custPeriodType.getCustomerParam("number"));
                this.prmtPeriodType.setData((Object)periodType);
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
            }
            this.spnYear.setValue((Object)new Integer(cond.getInt("year")));
            this.spnMonth.setValue((Object)new Integer(cond.getInt("month")));
            ArrayList<String> idList = new ArrayList<String>();
            Object data = this.prmtCompany.getData();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.maxPeriodNumber = (Integer)periodYears.get("MaxPeriodNumber");
                if (((Integer)this.spnYear.getValue()).compareTo(this.maxPeriodYear) > 0) {
                    this.spnYear.setValue((Object)this.maxPeriodYear);
                }
                if (((Integer)this.spnYear.getValue()).compareTo(this.maxPeriodYear) == 0 && ((Integer)this.spnMonth.getValue()).compareTo(this.maxPeriodNumber) > 0) {
                    this.spnMonth.setValue((Object)this.maxPeriodNumber);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.chkInitPeriod.setSelected(cond.getBoolean("initperiod"));
            this.chkIsByEvalue.setSelected(cond.getBoolean(IS_BY_EVALUE));
            CustomerParams sumItems = cond.getMe(SUM_OPTION);
            if (sumItems != null) {
                block4: for (int i = 0; i < sumItems.getKeys().size(); ++i) {
                    CustomerParams fso = sumItems.getMe(ITEM + i);
                    int n = this.tblSum.getRowCount();
                    for (int j = 0; j < n; ++j) {
                        if (!this.tblSum.getRow(j).getUserObject().toString().equalsIgnoreCase(fso.getCustomerParam(FIELD_NAME))) continue;
                        IRow row = this.tblSum.getRow(j);
                        if (j != i) {
                            this.tblSum.removeRow(j);
                            this.tblSum.addRow(i, row);
                        }
                        row.getCell(SUMMARY).setValue((Object)fso.getBoolean(IS_SUM));
                        row.getCell(LEVEL).setValue((Object)FaSumLevelEnum.getEnum(fso.getCustomerParam(LEVEL_TYPE)));
                        int specLevel = fso.getInt(LEVEL);
                        row.getCell(SPEC_LEVEL).setValue((Object)(specLevel == 0 ? null : new Integer(specLevel)));
                        continue block4;
                    }
                }
            }
        }
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        String accountTableID = ((AccountTableInfo)this.prmtAccountTable.getData()).getId().toString();
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        this.ctsUI = new CompanyTreeSelectUI(this, accountTableID, periodTypeID);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaAmountStatConditionUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    protected void tblSum_SummaryChanged(boolean isCheck) {
        int rowIndex = this.tblSum.getEditManager().getEditRowIndex();
        if (isCheck) {
            this.tblSum.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            KDComboBox editBox = new KDComboBox();
            ICellEditor editor = this.tblSum.getRow(rowIndex).getCell(2).getEditor();
            if (editor != null) {
                editBox = (KDComboBox)editor.getComponent();
            }
            if (editBox.getItemCount() == 1) {
                this.tblSum.getRow(rowIndex).getCell(2).setValue((Object)FaSumLevelEnum.detail);
            } else {
                this.tblSum.getRow(rowIndex).getCell(2).setValue((Object)FaSumLevelEnum.level);
            }
            FaDefRptSumOptionUtil.onTableSummaryChanged(this.tblSum.getRow(rowIndex));
        } else {
            this.tblSum.getRow(rowIndex).getCell(2).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(3).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.tblSum.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        }
    }

    private void fireYearChange() {
        int periodYear = this.spnYear.getIntegerVlaue();
        try {
            String periodId = this.currCompany.getAccountPeriodType().getId().toString();
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodId);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPeriodNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    protected void tblSum_LevelChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        boolean b = false;
        Object obj = this.tblSum.getCell(rowIndex, 2).getValue();
        if (obj != null && FaSumLevelEnum.class.isInstance(obj)) {
            FaSumLevelEnum level = (FaSumLevelEnum)((Object)obj);
            if (level.getValue() == "3") {
                b = false;
            } else {
                b = true;
                this.tblSum.getRow(rowIndex).getCell(3).setValue(null);
            }
            this.tblSum.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(b);
        }
    }

    protected void wbtMoveUp_actionPerformed(ActionEvent e) {
        int selectRowIndex = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRowIndex > 0) {
            IRow selectRow = this.tblSum.getRow(selectRowIndex);
            this.delSelectLine();
            this.tblSum.addRow(selectRowIndex - 1, selectRow);
            this.tblSum.getSelectManager().select(selectRowIndex - 1, 0);
        }
    }

    protected void wbtMoveDown_actionPerformed(ActionEvent e) {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRpw < this.tblSum.getRowCount() - 1) {
            IRow selectRow = this.tblSum.getRow(selectRpw);
            this.delSelectLine();
            this.tblSum.addRow(selectRpw + 1, selectRow);
            this.tblSum.getSelectManager().select(selectRpw + 1, 0);
        }
    }

    protected void delSelectLine() {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            this.tblSum.removeRow(selectRpw);
        }
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        if (this.isVirCompany) {
            AccountTableInfo accountTable = (AccountTableInfo)this.prmtAccountTable.getData();
            CustomerParams custAcountTable = new CustomerParams();
            custAcountTable.addCustomerParam("id", accountTable.getId().toString());
            custAcountTable.addCustomerParam("name", accountTable.getName());
            custAcountTable.addCustomerParam("number", accountTable.getNumber());
            params.putMe(ACCOUNT_TABLE, custAcountTable);
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.prmtPeriodType.getData();
            CustomerParams custPeriodType = new CustomerParams();
            custPeriodType.addCustomerParam("id", periodType.getId().toString());
            custPeriodType.addCustomerParam("name", periodType.getName());
            custPeriodType.addCustomerParam("number", periodType.getNumber());
            params.putMe(PERIOD_TYPE, custPeriodType);
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
            if (this.getSchemeInfo() != null) {
                CustomerParams custBookScheme = new CustomerParams();
                custBookScheme.addCustomerParam("id", this.getSchemeInfo().getId().toString());
                custBookScheme.addCustomerParam("name", this.getSchemeInfo().getName());
                custBookScheme.addCustomerParam("number", this.getSchemeInfo().getNumber());
                params.putMe(BOOKSCHEME, custBookScheme);
            }
        }
        CustomerParams sumItems = new CustomerParams();
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            CustomerParams fso = new CustomerParams();
            fso.addCustomerParam(FIELD_NAME, (String)row.getUserObject());
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            if (levelType != null) {
                fso.addCustomerParam(LEVEL_TYPE, levelType.getValue());
            }
            int specLevel = row.getCell(SPEC_LEVEL).getValue() == null ? 0 : ((Number)row.getCell(SPEC_LEVEL).getValue()).intValue();
            fso.putInt(LEVEL, specLevel);
            fso.putBoolean(IS_SUM, ((Boolean)row.getCell(SUMMARY).getValue()).booleanValue());
            sumItems.putMe(ITEM + i, fso);
        }
        params.putMe(SUM_OPTION, sumItems);
        params.putBoolean(IS_BY_EVALUE, this.chkIsByEvalue.isSelected());
        params.putBoolean("initperiod", this.chkInitPeriod.isSelected());
        return params;
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        if (this.isVirCompany) {
            customCond.put(ACCOUNT_TABLE, this.prmtAccountTable.getData());
            customCond.put(PERIOD_TYPE, this.prmtPeriodType.getData());
            customCond.put(COMPANY, this.prmtCompany.getData());
            customCond.put(BOOKSCHEME, this.getSchemeInfo());
        }
        ArrayList<FaSumOptnObject> sumItems = new ArrayList<FaSumOptnObject>();
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            if (row == null) continue;
            FaSumOptnObject fso = new FaSumOptnObject();
            String fieldName = (String)row.getUserObject();
            fso.setFieldName(fieldName);
            fso.setColumnKey(FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            fso.setLevelType(levelType);
            int specLevel = row.getCell(SPEC_LEVEL).getValue() == null ? 0 : ((Number)row.getCell(SPEC_LEVEL).getValue()).intValue();
            fso.setLevel(specLevel);
            fso.setOrderNo(i);
            fso.setSum((Boolean)row.getCell(SUMMARY).getValue());
            sumItems.add(fso);
        }
        FaSumOptnObject fso = new FaSumOptnObject();
        fso.setFieldName("measureUnit");
        fso.setColumnKey("measureUnit");
        fso.setLevelType(FaSumLevelEnum.detail);
        fso.setLevel(0);
        fso.setOrderNo(this.tblSum.getRowCount());
        fso.setSum(true);
        sumItems.add(fso);
        customCond.put(SUM_OPTION, sumItems);
        customCond.put(IS_BY_EVALUE, this.chkIsByEvalue.isSelected());
        customCond.put("initperiod", this.chkInitPeriod.isSelected());
        return customCond;
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            Integer specLevel;
            if (!((Boolean)this.tblSum.getRow(i).getCell(SUMMARY).getValue()).booleanValue()) continue;
            Object level = this.tblSum.getRow(i).getCell(LEVEL).getValue();
            if (level == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectSumLevel"));
                return false;
            }
            if (((FaSumLevelEnum)((Object)level)).getValue() != "3" || (specLevel = (Integer)this.tblSum.getRow(i).getCell(SPEC_LEVEL).getValue()) != null && specLevel.compareTo(Integer.valueOf("0")) > 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"specLeveNotNullGreaterZero"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected void setDefaultData() throws Exception {
        this.prmtAccountTable.setData((Object)this.currCompany.getAccountTable());
        this.prmtPeriodType.setData((Object)this.currCompany.getAccountPeriodType());
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
            this.spnYear.setValue((Object)defaultYear);
            this.spnMonth.setValue((Object)defaultNumber);
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            this.tblSum.getCell(i, SUMMARY).setValue((Object)Boolean.FALSE);
            this.tblSum.getCell(i, LEVEL).setValue(null);
            this.tblSum.getCell(i, SPEC_LEVEL).setValue(null);
            this.tblSum.getRow(i).getCell(SPEC_LEVEL).getStyleAttributes().setLocked(true);
            this.tblSum.getRow(i).getCell(LEVEL).getStyleAttributes().setLocked(true);
        }
        this.chkIsByEvalue.setSelected(false);
        this.chkInitPeriod.setSelected(false);
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAccountTable.getData() == null || this.prmtPeriodType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"condBeforeSelectCompany"));
            return;
        }
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }
}

