/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.SumGroupInfo;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaAmountStatUI;
import com.kingdee.eas.fi.fa.rpt.client.FaAmountStatConditionUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public class FaAmountStatUI
extends AbstractFaAmountStatUI {
    private static final long serialVersionUID = -8112553279073450236L;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.hideDefColumn();
    }

    @Override
    protected void initTableColumn(List sumColumnNames) {
        super.initTableColumn(sumColumnNames);
        this.hideDefColumn();
    }

    @Override
    protected void applyData(Map result) throws Exception {
        super.applyData(result);
        this.tblMain.getGroupManager().setGroup(true);
        List columnNames = (List)result.get("sumColumnName");
        for (int i = 0; i < columnNames.size(); ++i) {
            SumGroupInfo group = (SumGroupInfo)columnNames.get(i);
            IColumn col = this.tblMain.getColumn(group.getNumber());
            if (col.getStyleAttributes().isHided()) continue;
            if (columnNames.size() == 3) {
                col.setWidth(150);
                continue;
            }
            if (columnNames.size() != 2) continue;
            col.setWidth(280);
        }
    }

    @Override
    protected void afterFillTableRow(IRow row, int rowIndex) {
        Object measureUnitName = row.getCell("MeasureUnitName").getValue();
        if (measureUnitName == null || SUB_TOTAL.equals(measureUnitName) || TOTAL.equals(measureUnitName)) {
            row.getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
        }
    }

    @Override
    protected void initCommonQueryDialog() throws Exception {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(400);
        this.commonQueryDialog.setWidth(600);
    }

    @Override
    protected void formatData() throws EASBizException, BOSException {
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String)"fassetValue", (String)FaClientUtils.getDecimalFormat((int)this.getCurrencyScale()));
        FaClientUtils.fmtAssetAmt((KDTable)this.tblMain, (String)"fassetAmt");
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaAmountStatConditionUI();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.faAmountStatList");
    }

    @Override
    protected String getQueryName() {
        return "AmountStatQuery";
    }

    @Override
    protected String getDaoClassName() {
        return "FaAmountStatRptDao";
    }

    @Override
    protected boolean isAllowVirtualOrg() {
        return true;
    }
}

