/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaAssetCalculationRptCondUI;
import com.kingdee.eas.fi.fa.rpt.client.FLCompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class FaAssetCalculationRptCondUI
extends AbstractFaAssetCalculationRptCondUI {
    private static final Logger logger = CoreUIObject.getLogger(FaAssetCalculationRptCondUI.class);
    private static final String COMPANY = "company";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String LEASE_BILL_NUMBER = "leaseBillNumber";
    private static final String CURRENCY_ID = "currencyID";

    public FaAssetCalculationRptCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
        }
        this.prmtCompany.setEnabled(false);
        this.prmtCurrency.setRequired(false);
    }

    @Override
    protected void setDefaultData() throws Exception {
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
        }
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        if (this.isVirCompany) {
            customCond.put(COMPANY, this.prmtCompany.getData());
        }
        customCond.put(START_DATE, this.beginDate.getSqlDate());
        customCond.put(END_DATE, this.endDate.getSqlDate());
        customCond.put(LEASE_BILL_NUMBER, this.billNumber.getStringValue());
        customCond.put(CURRENCY_ID, this.prmtCurrency.getValue());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        if (this.isVirCompany) {
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
        }
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe("accountTable");
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam("id")));
                accountTable.setName(custAcountTable.getCustomerParam("name"));
                accountTable.setNumber(custAcountTable.getCustomerParam("number"));
                CustomerParams custPeriodType = cond.getMe("periodType");
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam("id")));
                periodType.setName(custPeriodType.getCustomerParam("name"));
                periodType.setNumber(custPeriodType.getCustomerParam("number"));
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
            }
            ArrayList<String> idList = new ArrayList<String>();
            Object data = this.prmtCompany.getData();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
        }
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        this.ctsUI = new FLCompanyTreeSelectUI(this);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaAssetCalculationRptCondUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    @Override
    public boolean verify() {
        Date endDateTmp;
        Date startDate;
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        if (this.beginDate.getSqlDate() != null && this.endDate.getSqlDate() != null && (startDate = this.beginDate.getSqlDate()).compareTo(endDateTmp = this.endDate.getSqlDate()) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"155_FaAssetCalculationRptCondUI"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected void addListener() throws Exception {
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }
}

