/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaChangeListRptCondUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FaChangeListRptCondUI
extends AbstractFaChangeListRptCondUI {
    private static final long serialVersionUID = 2475581232002885233L;
    protected static final String START_PERIOD_YEAR = "startYear";
    protected static final String START_PERIOD_NUMBER = "startNumber";
    protected static final String END_PERIOD_YEAR = "endYear";
    protected static final String END_PERIOD_NUMBER = "endNumber";
    private static final String IS_SHOW_NOT_AUDIT = "isShowNotAudit";
    protected static final String IS_LIST_ALL = "isListAll";
    private static final String BOOKSCHEME = "bookScheme";
    private static final String NEW = "new";
    private static final String CHANGE = "change";
    private static final String COMPLETECLEAN = "completeclean";
    private static final String PARTCLEAN = "partclean";
    private static final String DEFCOMPANYLEVEL = "defCompanyLevel";
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;

    public FaChangeListRptCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            this.chkIsListByCard.setEnabled(false);
            this.lblDefLevel.setVisible(true);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            evi.setFilter(filterInfo);
            this.prmtAccountTable.setEntityViewInfo(evi);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.prmtAccountTable.setEnabled(false);
            this.prmtPeriodType.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
            this.lblDefLevel.setVisible(false);
        }
        SpinnerNumberModel tmpModel = new SpinnerNumberModel(0, 0, 100, 1);
        this.spnDefLevel.setModel((SpinnerModel)tmpModel);
        this.prmtCompany.setEnabled(false);
    }

    @Override
    protected void addListener() throws Exception {
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaChangeListRptCondUI.this.fireStartYearChange();
                FaChangeListRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaChangeListRptCondUI.this.fireEndYearChange();
                FaChangeListRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnStartNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaChangeListRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaChangeListRptCondUI.this.firePeriodChange(e);
            }
        });
        this.prmtAccountTable.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaChangeListRptCondUI.this.ctsUI = null;
                    FaChangeListRptCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtPeriodType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaChangeListRptCondUI.this.ctsUI = null;
                    FaChangeListRptCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaChangeListRptCondUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    protected void companyChanged(Object data) {
        if (data == null) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnStartYear.setModel((SpinnerModel)tmpModel);
            this.spnStartNumber.setModel((SpinnerModel)tmpModel);
            this.spnEndYear.setModel((SpinnerModel)tmpModel);
            this.spnEndNumber.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnStartYear.setEnabled(true);
            this.spnStartNumber.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnEndNumber.setEnabled(true);
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel startPeriodSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endPeriodSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodStartNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPerioEndNumber = (Integer)periodYears.get("MaxPeriodNumber");
                startYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                startYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
                endYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                endYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
                this.spnStartYear.setValue(periodYears.get("MaxPeriodYear"));
                this.spnEndYear.setValue(periodYears.get("MaxPeriodYear"));
                Map periodNumOfYear = FaListFactory.getRemoteInstance().findMinMaxPeriodsOfYear(this.maxPeriodYear, periodTypeID);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    startPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    startPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                startPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnStartNumber.setModel((SpinnerModel)startPeriodSpinnerNumberModel);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    endPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    endPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                endPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnEndNumber.setModel((SpinnerModel)endPeriodSpinnerNumberModel);
                this.spnStartNumber.setValue(periodYears.get("MaxPeriodNumber"));
                this.spnEndNumber.setValue(periodYears.get("MaxPeriodNumber"));
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        if (this.isVirCompany) {
            AccountTableInfo accountTable = (AccountTableInfo)this.prmtAccountTable.getData();
            CustomerParams custAcountTable = new CustomerParams();
            custAcountTable.addCustomerParam("id", accountTable.getId().toString());
            custAcountTable.addCustomerParam("name", accountTable.getName());
            custAcountTable.addCustomerParam("number", accountTable.getNumber());
            params.putMe("accountTable", custAcountTable);
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.prmtPeriodType.getData();
            CustomerParams custPeriodType = new CustomerParams();
            custPeriodType.addCustomerParam("id", periodType.getId().toString());
            custPeriodType.addCustomerParam("name", periodType.getName());
            custPeriodType.addCustomerParam("number", periodType.getNumber());
            params.putMe("periodType", custPeriodType);
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe("company", companys);
            if (this.getSchemeInfo() != null) {
                CustomerParams custBookScheme = new CustomerParams();
                custBookScheme.addCustomerParam("id", this.getSchemeInfo().getId().toString());
                custBookScheme.addCustomerParam("name", this.getSchemeInfo().getName());
                custBookScheme.addCustomerParam("number", this.getSchemeInfo().getNumber());
                params.putMe(BOOKSCHEME, custBookScheme);
            }
        }
        params.putInt(START_PERIOD_YEAR, this.spnStartYear.getIntegerVlaue().intValue());
        params.putInt(START_PERIOD_NUMBER, this.spnStartNumber.getIntegerVlaue().intValue());
        params.putInt(DEFCOMPANYLEVEL, this.spnDefLevel.getIntegerVlaue() == 0 ? 101 : this.spnDefLevel.getIntegerVlaue());
        params.putInt(END_PERIOD_YEAR, this.spnEndYear.getIntegerVlaue().intValue());
        params.putInt(END_PERIOD_NUMBER, this.spnEndNumber.getIntegerVlaue().intValue());
        params.putBoolean(IS_SHOW_NOT_AUDIT, this.chkIncludeNotAuditCard.isSelected());
        params.putBoolean(IS_LIST_ALL, this.chkIsListAll.isSelected());
        params.putBoolean(NEW, this.chkNew.isSelected());
        params.putBoolean(CHANGE, this.chkChange.isSelected());
        params.putBoolean(COMPLETECLEAN, this.chkCompleteClean.isSelected());
        params.putBoolean(PARTCLEAN, this.chkPartClean.isSelected());
        return params;
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        if (this.isVirCompany) {
            customCond.put("accountTable", this.prmtAccountTable.getData());
            customCond.put("periodType", this.prmtPeriodType.getData());
            customCond.put("company", this.prmtCompany.getData());
            customCond.put(BOOKSCHEME, this.getSchemeInfo());
        }
        customCond.put(START_PERIOD_YEAR, this.spnStartYear.getValue());
        customCond.put(START_PERIOD_NUMBER, this.spnStartNumber.getValue());
        customCond.put(DEFCOMPANYLEVEL, (Integer)this.spnDefLevel.getValue() == 0 ? new Integer(101) : this.spnDefLevel.getValue());
        customCond.put(END_PERIOD_YEAR, this.spnEndYear.getValue());
        customCond.put(END_PERIOD_NUMBER, this.spnEndNumber.getValue());
        customCond.put(IS_SHOW_NOT_AUDIT, this.chkIncludeNotAuditCard.isSelected());
        customCond.put(IS_LIST_ALL, this.chkIsListAll.isSelected());
        customCond.put(NEW, this.chkNew.isSelected());
        customCond.put(CHANGE, this.chkChange.isSelected());
        customCond.put(COMPLETECLEAN, this.chkCompleteClean.isSelected());
        customCond.put(PARTCLEAN, this.chkPartClean.isSelected());
        return customCond;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe("accountTable");
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam("id")));
                accountTable.setName(custAcountTable.getCustomerParam("name"));
                accountTable.setNumber(custAcountTable.getCustomerParam("number"));
                this.prmtAccountTable.setData((Object)accountTable);
                CustomerParams custPeriodType = cond.getMe("periodType");
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam("id")));
                periodType.setName(custPeriodType.getCustomerParam("name"));
                periodType.setNumber(custPeriodType.getCustomerParam("number"));
                this.prmtPeriodType.setData((Object)periodType);
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe("company")));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
            }
            this.spnStartYear.setValue((Object)new Integer(cond.getInt(START_PERIOD_YEAR)));
            this.spnStartNumber.setValue((Object)new Integer(cond.getInt(START_PERIOD_NUMBER)));
            this.spnDefLevel.setValue((Object)new Integer(cond.getInt(DEFCOMPANYLEVEL) == 101 ? 0 : cond.getInt(DEFCOMPANYLEVEL)));
            this.spnEndYear.setValue((Object)new Integer(cond.getInt(END_PERIOD_YEAR)));
            this.spnEndNumber.setValue((Object)new Integer(cond.getInt(END_PERIOD_NUMBER)));
            this.chkIncludeNotAuditCard.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
            this.chkIsListAll.setSelected(cond.getBoolean(IS_LIST_ALL));
            this.chkIsListByCard.setSelected(!cond.getBoolean(IS_LIST_ALL));
            this.chkNew.setSelected(cond.getBoolean(NEW));
            this.chkChange.setSelected(cond.getBoolean(CHANGE));
            this.chkCompleteClean.setSelected(cond.getBoolean(COMPLETECLEAN));
            this.chkPartClean.setSelected(cond.getBoolean(PARTCLEAN));
        }
    }

    @Override
    protected void setDefaultData() throws Exception {
        this.chkNew.setSelected(false);
        this.chkChange.setSelected(false);
        this.chkCompleteClean.setSelected(false);
        this.chkPartClean.setSelected(false);
        this.chkIncludeNotAuditCard.setSelected(false);
        this.chkIsListAll.setSelected(true);
        this.prmtAccountTable.setData((Object)this.currCompany.getAccountTable());
        this.prmtPeriodType.setData((Object)this.currCompany.getAccountPeriodType());
        this.spnDefLevel.setValue((Object)new Integer(1));
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            Integer minYear = new Integer(startPeriodInfo.getPeriodYear());
            Integer maxYear = new Integer(currentPeriodInfo.getPeriodYear());
            SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
            startYearSpinnerNumberModel.setMinimum(minYear);
            startYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
            SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
            endYearSpinnerNumberModel.setMinimum(minYear);
            endYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
            Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
            this.spnStartYear.setValue((Object)defaultYear);
            this.spnEndYear.setValue((Object)defaultYear);
            this.spnStartNumber.setValue((Object)defaultNumber);
            this.spnEndNumber.setValue((Object)defaultNumber);
        }
    }

    private void fireStartYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnStartYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnStartNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnStartNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAccountTable.getData() == null || this.prmtPeriodType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"condBeforeSelectCompany"));
            return;
        }
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        String accountTableID = ((AccountTableInfo)this.prmtAccountTable.getData()).getId().toString();
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        this.ctsUI = new CompanyTreeSelectUI(this, accountTableID, periodTypeID);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaChangeListRptCondUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    private void fireEndYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnEndYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnEndNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnEndNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartNumber) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndNumber.setValue(this.spnStartNumber.getValue());
            } else {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartNumber.setValue(this.spnEndNumber.getValue());
            }
        }
    }
}

