/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaChangeListRptConditionUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaChangeListRptConditionUI
extends AbstractFaChangeListRptConditionUI {
    private static final long serialVersionUID = -895501200612936544L;
    Map periodsMap;
    PeriodInfo startPeriodInfo;
    PeriodInfo currentPeriodInfo;

    public FaChangeListRptConditionUI() throws Exception {
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkIncludeSplitCard.setVisible(false);
        this.periodsMap = new HashMap();
        List<Integer> periods = null;
        Map initDataMap = null;
        try {
            IFaList iFaList = FaListFactory.getRemoteInstance();
            initDataMap = iFaList.findInitData();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        PeriodCollection periodCollection = (PeriodCollection)initDataMap.get("period");
        if (periodCollection == null || periodCollection.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.curCompPeriodNotSet"));
            SysUtil.abort();
        }
        for (PeriodInfo periodInfo : periodCollection) {
            Integer year = new Integer(periodInfo.getPeriodYear());
            Integer period = new Integer(periodInfo.getPeriodNumber());
            if (!this.periodsMap.containsKey(year)) {
                periods = new ArrayList<Integer>(12);
                periods.add(period);
                this.periodsMap.put(year, periods);
                continue;
            }
            periods = (List)this.periodsMap.get(year);
            periods.add(period);
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        this.startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        Integer minYear = new Integer(this.startPeriodInfo.getPeriodYear());
        Integer maxYear = new Integer(this.currentPeriodInfo.getPeriodYear());
        SpinnerNumberModel yearSpinnerNumberModel = new SpinnerNumberModel();
        yearSpinnerNumberModel.setMinimum(minYear);
        yearSpinnerNumberModel.setMaximum(maxYear);
        this.spnYear.setModel((SpinnerModel)yearSpinnerNumberModel);
        this.spnYear.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodYear()));
        this.spnMonth.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodNumber()));
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams customCond = super.getCustParams();
        customCond.addCustomerParam("year", this.spnYear.getValue().toString());
        customCond.addCustomerParam("month", this.spnMonth.getValue().toString());
        customCond.addCustomerParam("includeClnCard", String.valueOf(this.chkIncludeClnCard.isSelected()));
        customCond.addCustomerParam("includeSplitCard", String.valueOf(this.chkIncludeSplitCard.isSelected()));
        customCond.addCustomerParam("includeNotAuditCard", String.valueOf(this.chkIncludeNotAuditCard.isSelected()));
        return customCond;
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        customCond.put("year", this.spnYear.getValue());
        customCond.put("month", this.spnMonth.getValue());
        customCond.put("includeClnCard", new Boolean(this.chkIncludeClnCard.isSelected()));
        customCond.put("includeSplitCard", new Boolean(this.chkIncludeSplitCard.isSelected()));
        customCond.put("includeNotAuditCard", new Boolean(this.chkIncludeNotAuditCard.isSelected()));
        return customCond;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            this.spnYear.setValue((Object)Integer.getInteger(cond.getCustomerParam("year")));
            this.spnMonth.setValue((Object)Integer.getInteger(cond.getCustomerParam("month")));
            this.chkIncludeClnCard.setSelected(cond.getCustomerParam("includeClnCard") == null ? false : Boolean.parseBoolean(cond.getCustomerParam("includeClnCard")));
            this.chkIncludeSplitCard.setSelected(cond.getCustomerParam("includeSplitCard") == null ? false : Boolean.parseBoolean(cond.getCustomerParam("includeSplitCard")));
            this.chkIncludeNotAuditCard.setSelected(cond.getCustomerParam("includeNotAuditCard") == null ? false : Boolean.parseBoolean(cond.getCustomerParam("includeNotAuditCard")));
        }
    }

    protected void initListener() {
        super.initListener();
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaChangeListRptConditionUI.this.fireYearChange();
            }
        });
    }

    private void fireYearChange() {
        Integer year = (Integer)this.spnYear.getValue();
        if (this.periodsMap.containsKey(year)) {
            List periodsOfYear = (List)this.periodsMap.get(year);
            Integer minPeriod = (Integer)periodsOfYear.get(0);
            Integer maxPeriod = (Integer)periodsOfYear.get(periodsOfYear.size() - 1);
            if (year.intValue() == this.startPeriodInfo.getPeriodYear()) {
                minPeriod = new Integer(this.startPeriodInfo.getPeriodNumber());
            }
            if (year.intValue() == this.currentPeriodInfo.getPeriodYear()) {
                maxPeriod = new Integer(this.currentPeriodInfo.getPeriodNumber());
            }
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            Integer month = (Integer)this.spnMonth.getValue();
            if (month.compareTo(minPeriod) < 0 || month.compareTo(maxPeriod) > 0) {
                this.spnMonth.setValue((Object)minPeriod);
            }
        }
    }
}

