/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaSumItemEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumItemEnumX;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaComposingCondUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaDefRptSumOptionUtil;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.StringEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FaComposingCondUI
extends AbstractFaComposingCondUI {
    protected static final long serialVersionUID = -2496754689219193331L;
    protected static final String COMPOSE_MODE = "composeMode";
    protected static final String COLUMN_KEY = "columnKey";
    protected static final String FIELD_NAME = "fieldName";
    protected static final String SUM_OPTION = "sumOption";
    protected static final String LEVEL_TYPE = "levelType";
    protected static final String IS_SUM = "isSum";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    private static final String ID = "id";
    private static final String COMPANY = "company";
    private static final String INITPERIOD = "initperiod";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String PERIOD_TYPE = "periodType";
    private static final String ACCOUNT_TABLE = "accountTable";
    private static final String IS_SHOW_NOCARD_COMPANY = "isShowNoCardCompany";
    private static final String IS_SHOW_NOT_AUDIT = "isShowNotAudit";
    private static final String IS_BY_EVALUE = "isByEvalue";
    private static final String BOOKSCHEME = "bookScheme";
    private static final String DEFCOMPANYLEVEL = "defCompanyLevel";
    private static final BigDecimal MAX_OF_DATA_SELECTED = new BigDecimal("10000.00");
    JDialog dialog;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodNumber;
    private Integer maxPeriodNumber;

    public FaComposingCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
            this.lblDefLevel.setVisible(true);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            evi.setFilter(filterInfo);
            this.prmtAccountTable.setEntityViewInfo(evi);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.prmtAccountTable.setEnabled(false);
            this.prmtPeriodType.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
            this.chkIsShowNoCardCompany.setVisible(false);
            this.lblDefLevel.setVisible(false);
        }
        if (this.isVirCompany) {
            SpinnerNumberModel tmpModel = new SpinnerNumberModel(0, 0, 100, 1);
            this.spnDefLevel.setModel((SpinnerModel)tmpModel);
        }
        this.prmtCompany.setEnabled(false);
        FaDefRptSumOptionUtil.addDefSumOption(this.cbxComposeMode);
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        if (this.isVirCompany) {
            customCond.put(ACCOUNT_TABLE, this.prmtAccountTable.getData());
            customCond.put(PERIOD_TYPE, this.prmtPeriodType.getData());
            customCond.put(COMPANY, this.prmtCompany.getData());
            customCond.put(IS_SHOW_NOCARD_COMPANY, this.chkIsShowNoCardCompany.isSelected());
            customCond.put(BOOKSCHEME, this.getSchemeInfo());
        }
        customCond.put(YEAR, this.spnYear.getValue());
        customCond.put(MONTH, this.spnMonth.getValue());
        customCond.put(DEFCOMPANYLEVEL, (Integer)this.spnDefLevel.getValue() == 0 ? new Integer(101) : this.spnDefLevel.getValue());
        customCond.put(INITPERIOD, this.chkInitPeriod.isSelected());
        customCond.put(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        customCond.put(IS_BY_EVALUE, this.chkIsByEvalue.isSelected());
        customCond.put(COMPOSE_MODE, this.cbxComposeMode.getSelectedItem());
        FaSumOptnObject fso = new FaSumOptnObject();
        StringEnum composeMode = (StringEnum)this.cbxComposeMode.getSelectedItem();
        fso.setFieldName(composeMode.getName());
        fso.setColumnKey(composeMode.getValue());
        if (this.isVirCompany || FaSumItemEnum.storeCity.equals(composeMode) || composeMode instanceof FaSumItemEnumX) {
            fso.setLevelType(FaSumLevelEnum.detail);
            fso.setNode(false);
            if (composeMode instanceof FaSumItemEnumX) {
                customCond.put("composeModeX", composeMode.getName());
            }
        } else {
            fso.setLevelType(FaSumLevelEnum.level);
            fso.setNode(true);
        }
        fso.setSum(true);
        ArrayList<FaSumOptnObject> sumItems = new ArrayList<FaSumOptnObject>();
        sumItems.add(fso);
        customCond.put(SUM_OPTION, sumItems);
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams Params = super.getCustParams();
        if (this.isVirCompany) {
            AccountTableInfo accountTable = (AccountTableInfo)this.prmtAccountTable.getData();
            CustomerParams custAcountTable = new CustomerParams();
            custAcountTable.addCustomerParam(ID, accountTable.getId().toString());
            custAcountTable.addCustomerParam(NAME, accountTable.getName());
            custAcountTable.addCustomerParam(NUMBER, accountTable.getNumber());
            Params.putMe(ACCOUNT_TABLE, custAcountTable);
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.prmtPeriodType.getData();
            CustomerParams custPeriodType = new CustomerParams();
            custPeriodType.addCustomerParam(ID, periodType.getId().toString());
            custPeriodType.addCustomerParam(NAME, periodType.getName());
            custPeriodType.addCustomerParam(NUMBER, periodType.getNumber());
            Params.putMe(PERIOD_TYPE, custPeriodType);
            Params.putBoolean(IS_SHOW_NOCARD_COMPANY, this.chkIsShowNoCardCompany.isSelected());
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            Params.putMe(COMPANY, companys);
            if (this.getSchemeInfo() != null) {
                CustomerParams custBookScheme = new CustomerParams();
                custBookScheme.addCustomerParam(ID, this.getSchemeInfo().getId().toString());
                custBookScheme.addCustomerParam(NAME, this.getSchemeInfo().getName());
                custBookScheme.addCustomerParam(NUMBER, this.getSchemeInfo().getNumber());
                Params.putMe(BOOKSCHEME, custBookScheme);
            }
        }
        Params.putInt(YEAR, this.spnYear.getIntegerVlaue().intValue());
        Params.putInt(MONTH, this.spnMonth.getIntegerVlaue().intValue());
        Params.putInt(DEFCOMPANYLEVEL, this.spnDefLevel.getIntegerVlaue() == 0 ? 101 : this.spnDefLevel.getIntegerVlaue());
        Params.putBoolean(INITPERIOD, this.chkInitPeriod.isSelected());
        Params.putBoolean(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        Params.putBoolean(IS_BY_EVALUE, this.chkIsByEvalue.isSelected());
        StringEnum composeMode = (StringEnum)this.cbxComposeMode.getSelectedItem();
        if (composeMode instanceof FaSumItemEnumX) {
            Params.addCustomerParam(COMPOSE_MODE, composeMode.getName());
        } else {
            Params.addCustomerParam(COMPOSE_MODE, composeMode.getValue());
        }
        return Params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe(ACCOUNT_TABLE);
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam(ID)));
                accountTable.setName(custAcountTable.getCustomerParam(NAME));
                accountTable.setNumber(custAcountTable.getCustomerParam(NUMBER));
                this.prmtAccountTable.setData((Object)accountTable);
                CustomerParams custPeriodType = cond.getMe(PERIOD_TYPE);
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam(ID)));
                periodType.setName(custPeriodType.getCustomerParam(NAME));
                periodType.setNumber(custPeriodType.getCustomerParam(NUMBER));
                this.prmtPeriodType.setData((Object)periodType);
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
                this.chkIsShowNoCardCompany.setSelected(cond.getBoolean(IS_SHOW_NOCARD_COMPANY));
                this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
                this.chkIsByEvalue.setSelected(cond.getBoolean(IS_BY_EVALUE));
            }
            this.spnYear.setValue((Object)new Integer(cond.getInt(YEAR)));
            this.spnMonth.setValue((Object)new Integer(cond.getInt(MONTH)));
            this.spnDefLevel.setValue((Object)new Integer(cond.getInt(DEFCOMPANYLEVEL) == 101 ? 0 : cond.getInt(DEFCOMPANYLEVEL)));
            this.chkInitPeriod.setSelected(cond.getBoolean(INITPERIOD));
            this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
            this.chkIsByEvalue.setSelected(cond.getBoolean(IS_BY_EVALUE));
            FaSumItemEnum em = FaSumItemEnum.getEnum(cond.getCustomerParam(COMPOSE_MODE));
            if (em == null) {
                String mode = cond.getCustomerParam(COMPOSE_MODE);
                for (int i = 0; i < this.cbxComposeMode.getItemCount(); ++i) {
                    StringEnum cur = (StringEnum)this.cbxComposeMode.getItemAt(i);
                    if (!cur.getName().equals(mode)) continue;
                    this.cbxComposeMode.setSelectedIndex(i);
                    break;
                }
            } else {
                this.cbxComposeMode.setSelectedItem((Object)em);
            }
        }
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return;
        }
    }

    @Override
    protected void addListener() throws Exception {
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaComposingCondUI.this.fireYearChange();
            }
        });
        this.chkInitPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaComposingCondUI.this.fireInitPeriodSelect();
            }
        });
        this.prmtAccountTable.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaComposingCondUI.this.ctsUI = null;
                    FaComposingCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtPeriodType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaComposingCondUI.this.ctsUI = null;
                    FaComposingCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaComposingCondUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    private void fireYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPeriodNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void fireInitPeriodSelect() {
        if (this.chkInitPeriod.isSelected()) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
        } else if (this.prmtCompany.getData() != null) {
            this.spnYear.setEnabled(true);
            this.spnMonth.setEnabled(true);
        }
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAccountTable.getData() == null || this.prmtPeriodType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"condBeforeSelectCompany"));
            return;
        }
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        String accountTableID = ((AccountTableInfo)this.prmtAccountTable.getData()).getId().toString();
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        this.ctsUI = new CompanyTreeSelectUI(this, accountTableID, periodTypeID);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaComposingCondUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    protected void companyChanged(Object data) {
        if (data == null) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnYear.setModel((SpinnerModel)tmpModel);
            this.spnMonth.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnYear.setEnabled(!this.chkInitPeriod.isSelected());
            this.spnMonth.setEnabled(!this.chkInitPeriod.isSelected());
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel yearSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPeriodNumber = (Integer)periodYears.get("MaxPeriodNumber");
                yearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                yearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnYear.setModel((SpinnerModel)yearSpinnerNumberModel);
                this.spnYear.setValue((Object)this.maxPeriodYear);
                this.spnMonth.setValue((Object)this.maxPeriodNumber);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    @Override
    protected void setDefaultData() throws Exception {
        this.prmtAccountTable.setData((Object)this.currCompany.getAccountTable());
        this.prmtPeriodType.setData((Object)this.currCompany.getAccountPeriodType());
        this.spnDefLevel.setValue((Object)new Integer(1));
        if (this.isVirCompany) {
            this.chkIsShowNoCardCompany.setSelected(false);
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
            this.spnYear.setValue((Object)defaultYear);
            this.spnMonth.setValue((Object)defaultNumber);
        }
        this.chkInitPeriod.setSelected(false);
        this.chkIsShowNotAudit.setSelected(false);
        this.chkIsByEvalue.setSelected(false);
        this.cbxComposeMode.setSelectedIndex(0);
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        }
    }
}

