/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaUserDefinedSortFactory;
import com.kingdee.eas.fi.fa.manage.IFaUserDefinedSort;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaDeprDistCondUI;
import com.kingdee.eas.fi.fa.rpt.client.FaDefRptSumOptionUtil;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FaDeprDistCondUI
extends AbstractFaDeprDistCondUI {
    private static final long serialVersionUID = 8406660231252446584L;
    private static final Logger logger = Logger.getLogger(FaDeprDistCondUI.class);
    protected static final String COLUMN_KEY = "columnKey";
    protected static final String FIELD_NAME = "fieldName";
    protected static final String SUM_OPTION = "sumOption";
    protected static final String LEVEL_TYPE = "levelType";
    protected static final String LEVEL = "level";
    protected static final String IS_SUM = "isSum";
    private FACommonProcessor process;
    private static final String IS_USE_DEFINE_SORT = "IsUserDefineSort";
    private static final String USER_DEFINE = "userDefineName";
    Map periodsMap;
    PeriodInfo startPeriodInfo;
    PeriodInfo currentPeriodInfo;
    private HashMap hmParam;

    public FaDeprDistCondUI(FACommonProcessor process) throws Exception {
        this.process = process;
        this.init();
    }

    public void onLoad() throws Exception {
        String isShowEvalInfo;
        super.onLoad();
        this.initWorkButton();
        this.periodsMap = new HashMap();
        List<Integer> periods = null;
        Map initDataMap = null;
        try {
            IFaList iFaList = FaListFactory.getRemoteInstance();
            initDataMap = iFaList.findInitData();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        PeriodCollection periodCollection = (PeriodCollection)initDataMap.get("period");
        if (periodCollection == null || periodCollection.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)".curCompPeriodNotSet"));
            SysUtil.abort();
        }
        for (PeriodInfo periodInfo : periodCollection) {
            Integer year = new Integer(periodInfo.getPeriodYear());
            Integer period = new Integer(periodInfo.getPeriodNumber());
            if (!this.periodsMap.containsKey(year)) {
                periods = new ArrayList<Integer>(12);
                periods.add(period);
                this.periodsMap.put(year, periods);
                continue;
            }
            periods = (List)this.periodsMap.get(year);
            periods.add(period);
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        this.startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        Integer minYear = new Integer(this.startPeriodInfo.getPeriodYear());
        Integer maxYear = new Integer(this.currentPeriodInfo.getPeriodYear());
        SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
        startYearSpinnerNumberModel.setMinimum(minYear);
        startYearSpinnerNumberModel.setMaximum(maxYear);
        this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
        SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
        endYearSpinnerNumberModel.setMinimum(minYear);
        endYearSpinnerNumberModel.setMaximum(maxYear);
        this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
        this.spnStartYear.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodYear()));
        this.spnStartMonth.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodNumber()));
        this.spnEndYear.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodYear()));
        this.spnEndMonth.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodNumber()));
        if (this.hmParam == null) {
            this.hmParam = FaManageUtils.getFAParameter((BOSUuid)aCompanyOrgUnitInfo.getId());
        }
        if ((isShowEvalInfo = (String)this.hmParam.get("FA_021")) == null || "".equals(isShowEvalInfo) || !new Boolean(isShowEvalInfo).booleanValue()) {
            this.chkDisEvalData.setEnabled(false);
        } else {
            this.chkDisEvalData.setEnabled(true);
        }
        this.chkIsUserDefineSort.setSelected(false);
        this.initTable();
    }

    private void initWorkButton() {
        if (this.ctnMain.getButtons().length == 0) {
            this.ctnMain.addButton((JButton)this.wbtMoveUp);
            this.ctnMain.addButton((JButton)this.wbtMoveDown);
            this.wbtMoveUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FaDeprDistCondUI.this.beforeActionPerformed(e);
                    try {
                        FaDeprDistCondUI.this.wbtMoveUp_actionPerformed(e);
                    }
                    catch (Exception exc) {
                        FaDeprDistCondUI.this.handUIException(exc);
                    }
                    finally {
                        FaDeprDistCondUI.this.afterActionPerformed(e);
                    }
                }
            });
            this.wbtMoveDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FaDeprDistCondUI.this.beforeActionPerformed(e);
                    try {
                        FaDeprDistCondUI.this.wbtMoveDown_actionPerformed(e);
                    }
                    catch (Exception exc) {
                        FaDeprDistCondUI.this.handUIException(exc);
                    }
                    finally {
                        FaDeprDistCondUI.this.afterActionPerformed(e);
                    }
                }
            });
        }
    }

    protected void wbtMoveUp_actionPerformed(ActionEvent e) throws Exception {
        int selectRowIndex = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRowIndex > 0) {
            IRow selectRow = this.tblSum.getRow(selectRowIndex);
            this.delSelectLine();
            this.tblSum.addRow(selectRowIndex - 1, selectRow);
            this.tblSum.getSelectManager().select(selectRowIndex - 1, 0);
        }
    }

    protected void wbtMoveDown_actionPerformed(ActionEvent e) throws Exception {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRpw < this.tblSum.getRowCount() - 1) {
            IRow selectRow = this.tblSum.getRow(selectRpw);
            this.delSelectLine();
            this.tblSum.addRow(selectRpw + 1, selectRow);
            this.tblSum.getSelectManager().select(selectRpw + 1, 0);
        }
    }

    protected void delSelectLine() throws Exception {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            this.tblSum.removeRow(selectRpw);
        }
    }

    private void initTable() throws Exception {
        this.tblSum.removeRows();
        this.tblSum.checkParsed();
        this.tblSum.getColumn("item").getStyleAttributes().setLocked(true);
        KDCheckBox kDCheckBox = new KDCheckBox();
        kDCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    boolean selected = ((KDCheckBox)arg0.getSource()).getSelected() == 32;
                    FaDeprDistCondUI.this.tblSum_SummaryChanged(selected);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
        this.tblSum.getColumn("summary").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kDCheckBox));
        KDComboBox kdcLevel = new KDComboBox();
        List list = FaSumLevelEnum.getEnumList();
        Object[] objs = list.toArray();
        kdcLevel.addItems(objs);
        this.tblSum.getColumn(LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevel));
        KDComboBox kdcLevelNotTree = new KDComboBox();
        kdcLevelNotTree.addItem((Object)FaSumLevelEnum.detail);
        KDFormattedTextField txtField = new KDFormattedTextField();
        txtField.setMinimumValue((Comparable)new Integer(1));
        this.tblSum.getColumn("specLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        IRow rowFaCat = this.tblSum.addRow();
        rowFaCat.getCell("item").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetCat"));
        rowFaCat.setUserObject((Object)"assetCat");
        IRow rowEcnomyUsage = this.tblSum.addRow();
        rowEcnomyUsage.getCell("item").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"economicPurp"));
        rowEcnomyUsage.getCell("summary").setValue((Object)Boolean.FALSE);
        rowEcnomyUsage.setUserObject((Object)"economicPurp");
        IRow rowUseStatus = this.tblSum.addRow();
        rowUseStatus.getCell("item").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useStatus"));
        rowUseStatus.getCell("summary").setValue((Object)Boolean.FALSE);
        rowUseStatus.setUserObject((Object)"useStatus");
        IRow rowLocation = this.tblSum.addRow();
        rowLocation.getCell("item").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"storeCity"));
        rowLocation.getCell("summary").setValue((Object)Boolean.FALSE);
        rowLocation.setUserObject((Object)"storeCity");
        ICell euLocCell = rowLocation.getCell(LEVEL);
        euLocCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevelNotTree));
        IRow rowSourceType = this.tblSum.addRow();
        rowSourceType.getCell("item").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"originMethod"));
        rowSourceType.getCell("summary").setValue((Object)Boolean.FALSE);
        rowSourceType.setUserObject((Object)"originMethod");
        IRow rowDepartment = this.tblSum.addRow();
        rowDepartment.getCell("item").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"asstActItem"));
        rowDepartment.getCell("summary").setValue((Object)Boolean.FALSE);
        rowDepartment.setUserObject((Object)"asstActItem");
        this.tblSum.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblSum.getColumn(3).getStyleAttributes().setLocked(true);
        rowFaCat.getCell("summary").setValue((Object)Boolean.FALSE);
        FaDefRptSumOptionUtil.addDefSumOption(this.tblSum);
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        customCond.put("startYear", this.spnStartYear.getValue());
        customCond.put("startNumber", this.spnStartMonth.getValue());
        customCond.put("endYear", this.spnEndYear.getValue());
        customCond.put("endNumber", this.spnEndMonth.getValue());
        customCond.put("displayEvalData", this.chkDisEvalData.isSelected());
        ArrayList<FaSumOptnObject> sumItems = new ArrayList<FaSumOptnObject>();
        if (this.chkIsUserDefineSort.isSelected()) {
            FaSumOptnObject fso = new FaSumOptnObject();
            fso.setFieldName(USER_DEFINE);
            fso.setColumnKey(USER_DEFINE);
            fso.setLevelType(FaSumLevelEnum.detail);
            fso.setLevel(0);
            fso.setOrderNo(0);
            fso.setSum(true);
            sumItems.add(fso);
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            FaSumOptnObject fso = new FaSumOptnObject();
            String fieldName = (String)row.getUserObject();
            fso.setFieldName(fieldName);
            fso.setColumnKey(FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            fso.setLevelType(levelType);
            int specLevel = row.getCell("specLevel").getValue() == null ? 0 : ((Number)row.getCell("specLevel").getValue()).intValue();
            fso.setLevel(specLevel);
            fso.setOrderNo(i);
            fso.setSum((Boolean)row.getCell("summary").getValue());
            sumItems.add(fso);
        }
        customCond.put(SUM_OPTION, sumItems);
        customCond.put(IS_USE_DEFINE_SORT, this.chkIsUserDefineSort.isSelected());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        params.putInt("startYear", this.spnStartYear.getIntegerVlaue().intValue());
        params.putInt("startNumber", this.spnStartMonth.getIntegerVlaue().intValue());
        params.putInt("endYear", this.spnEndYear.getIntegerVlaue().intValue());
        params.putInt("endNumber", this.spnEndMonth.getIntegerVlaue().intValue());
        params.putBoolean("displayEvalData", this.chkDisEvalData.isSelected());
        CustomerParams sumItems = new CustomerParams();
        if (this.chkIsUserDefineSort.isSelected()) {
            CustomerParams dustFso = new CustomerParams();
            dustFso.addCustomerParam(FIELD_NAME, USER_DEFINE);
            dustFso.addCustomerParam(COLUMN_KEY, USER_DEFINE);
            dustFso.addCustomerParam(LEVEL_TYPE, "2");
            dustFso.putInt(LEVEL, 0);
            dustFso.putBoolean(IS_SUM, true);
            sumItems.putMe("sum", dustFso);
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            CustomerParams custFso = new CustomerParams();
            String fieldName = (String)row.getUserObject();
            custFso.addCustomerParam(FIELD_NAME, fieldName);
            custFso.addCustomerParam(COLUMN_KEY, FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            if (levelType != null) {
                custFso.addCustomerParam(LEVEL_TYPE, levelType.getValue());
            }
            int specLevel = row.getCell("specLevel").getValue() == null ? 0 : ((Number)row.getCell("specLevel").getValue()).intValue();
            custFso.putInt(LEVEL, specLevel);
            custFso.putBoolean(IS_SUM, ((Boolean)row.getCell("summary").getValue()).booleanValue());
            sumItems.putMe("sum" + i, custFso);
        }
        params.putMe("sum", sumItems);
        params.putBoolean(IS_USE_DEFINE_SORT, this.chkIsUserDefineSort.isSelected());
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null && !cond.getValues().isEmpty()) {
            this.spnStartYear.setValue((Object)new Integer(cond.getInt("startYear")));
            this.spnStartMonth.setValue((Object)new Integer(cond.getInt("startNumber")));
            this.spnEndYear.setValue((Object)new Integer(cond.getInt("endYear")));
            this.spnEndMonth.setValue((Object)new Integer(cond.getInt("endNumber")));
            this.chkIsUserDefineSort.setSelected(cond.getBoolean(IS_USE_DEFINE_SORT));
            this.chkDisEvalData.setSelected(cond.getBoolean("displayEvalData"));
            CustomerParams sumItems = cond.getMe("sum");
            if (sumItems != null) {
                block0: for (int i = 0; i < sumItems.getKeys().size(); ++i) {
                    CustomerParams element = sumItems.getMe("sum" + i);
                    for (int j = 0; j < this.tblSum.getRowCount(); ++j) {
                        Object tmp = this.tblSum.getRow(j).getUserObject();
                        if (tmp == null || !tmp.equals(element.getCustomerParam(FIELD_NAME))) continue;
                        IRow row = this.tblSum.getRow(j);
                        if (j != i) {
                            this.tblSum.removeRow(j);
                            this.tblSum.addRow(i, row);
                        }
                        row.getCell("summary").setValue((Object)element.getBoolean(IS_SUM));
                        row.getCell(LEVEL).setValue((Object)FaSumLevelEnum.getEnum(element.getCustomerParam(LEVEL_TYPE)));
                        int level = element.getInt(LEVEL);
                        row.getCell("specLevel").setValue((Object)(level == 0 ? null : new Integer(level)));
                        continue block0;
                    }
                }
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            Object specLevel;
            if (!((Boolean)this.tblSum.getRow(i).getCell("summary").getValue()).booleanValue()) continue;
            Object level = this.tblSum.getRow(i).getCell(LEVEL).getValue();
            if (level == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectSumLevel"));
                return;
            }
            if (((FaSumLevelEnum)((Object)level)).getValue() != "3" || (specLevel = this.tblSum.getRow(i).getCell("specLevel").getValue()) != null && ((Integer)specLevel).compareTo(Integer.valueOf("0")) > 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"specLeveNotNullGreaterZero"));
            return;
        }
    }

    @Override
    public boolean verify() {
        int numPeriod;
        int startYear = (Integer)this.spnStartYear.getValue();
        int endYear = (Integer)this.spnEndYear.getValue();
        int startMonth = (Integer)this.spnStartMonth.getValue();
        int endMonth = (Integer)this.spnEndMonth.getValue();
        PeriodInfo period = this.getAdjustPeriod();
        if (period != null && (numPeriod = period.getPeriodYear() * 100 + period.getPeriodNumber()) > startYear * 100 + startMonth && numPeriod < endYear * 100 + endMonth) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"includeAdjustPeriod"));
            return false;
        }
        if (startYear > endYear || startYear == endYear && startMonth > endMonth) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"startPeriodNotGreatThanEnd"));
            return false;
        }
        if (this.chkIsUserDefineSort.isSelected()) {
            try {
                IFaUserDefinedSort iUserDefine = FaUserDefinedSortFactory.getRemoteInstance();
                FilterInfo filter = new FilterInfo();
                FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
                filter.getFilterItems().add(companyFilterItemInfo);
                if (!iUserDefine.exists(filter)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"NoUserDefineSort"));
                    return false;
                }
            }
            catch (Exception e1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"NoUserDefineSort"));
                return false;
            }
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            Object specLevel;
            if (!((Boolean)this.tblSum.getRow(i).getCell("summary").getValue()).booleanValue()) continue;
            Object level = this.tblSum.getRow(i).getCell(LEVEL).getValue();
            if (level == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectSumLevel"));
                return false;
            }
            if (((FaSumLevelEnum)((Object)level)).getValue() != "3" || (specLevel = this.tblSum.getRow(i).getCell("specLevel").getValue()) != null && ((Integer)specLevel).compareTo(Integer.valueOf("0")) > 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"specLeveNotNullGreaterZero"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    private PeriodInfo getAdjustPeriod() {
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        view.setFilter(filter);
        int i = 0;
        FilterItemInfo isAdjustPeriod = new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE);
        items.add(isAdjustPeriod);
        sbFormula.append(" (#" + i++ + ")");
        FilterItemInfo periodType = new FilterItemInfo("periodType.id", (Object)this.currCompany.getAccountPeriodType().getId().toString());
        items.add(periodType);
        sbFormula.append(" and (#" + i++ + ")");
        FilterItemInfo greaterStartYear = new FilterItemInfo("periodYear", (Object)new Integer(this.spnStartYear.getValue().toString()), CompareType.GREATER);
        items.add(greaterStartYear);
        FilterItemInfo equalsStartYear = new FilterItemInfo("periodYear", (Object)new Integer(this.spnStartYear.getValue().toString()), CompareType.EQUALS);
        items.add(equalsStartYear);
        FilterItemInfo startPeriod = new FilterItemInfo("periodNumber", (Object)new Integer(this.spnStartMonth.getValue().toString()), CompareType.GREATER_EQUALS);
        items.add(startPeriod);
        sbFormula.append(" and (#" + i++ + " or ( #" + i++ + " and #" + i++ + "))");
        FilterItemInfo greaterendYear = new FilterItemInfo("periodYear", (Object)new Integer(this.spnEndYear.getValue().toString()), CompareType.LESS);
        items.add(greaterendYear);
        FilterItemInfo equalsendYear = new FilterItemInfo("periodYear", (Object)new Integer(this.spnEndYear.getValue().toString()), CompareType.EQUALS);
        items.add(equalsendYear);
        FilterItemInfo endPeriod = new FilterItemInfo("periodNumber", (Object)new Integer(this.spnEndMonth.getValue().toString()), CompareType.LESS_EQUALS);
        items.add(endPeriod);
        sbFormula.append(" and (#" + i++ + " or ( #" + i++ + " and #" + i++ + "))");
        filter.setMaskString(sbFormula.toString());
        try {
            PeriodCollection periods = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
            if (periods == null || periods.size() > 0) {
                return periods.get(0);
            }
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
        return null;
    }

    public int getSumItemCount() {
        CustomerParams items = this.getCustParams().getMe("sum");
        if (items == null) {
            return 0;
        }
        int count = 0;
        for (CustomerParams element : items.getValues()) {
            if (!element.getBoolean(IS_SUM)) continue;
            ++count;
        }
        return count;
    }

    protected void initListener() {
        super.initListener();
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprDistCondUI.this.fireStartYearChange();
                FaDeprDistCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprDistCondUI.this.fireEndYearChange();
                FaDeprDistCondUI.this.firePeriodChange(e);
                FaDeprDistCondUI.this.process.setPeriodYear(FaDeprDistCondUI.this.spnEndYear.getIntegerVlaue().intValue());
            }
        });
        this.spnStartMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprDistCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprDistCondUI.this.firePeriodChange(e);
                FaDeprDistCondUI.this.process.setPeriodNumber(FaDeprDistCondUI.this.spnEndMonth.getIntegerVlaue().intValue());
            }
        });
        this.tblSum.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    FaDeprDistCondUI.this.tblSum_LevelChanged(e);
                }
                catch (Exception ex) {
                    FaDeprDistCondUI.this.handUIException(ex);
                }
            }
        });
    }

    protected void tblSum_SummaryChanged(boolean isCheck) {
        int rowIndex = this.tblSum.getEditManager().getEditRowIndex();
        if (isCheck) {
            this.tblSum.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            KDComboBox editBox = new KDComboBox();
            ICellEditor editor = this.tblSum.getRow(rowIndex).getCell(2).getEditor();
            if (editor != null) {
                editBox = (KDComboBox)editor.getComponent();
            }
            if (editBox.getItemCount() == 1) {
                this.tblSum.getRow(rowIndex).getCell(2).setValue((Object)FaSumLevelEnum.detail);
            } else {
                this.tblSum.getRow(rowIndex).getCell(2).setValue((Object)FaSumLevelEnum.level);
            }
            FaDefRptSumOptionUtil.onTableSummaryChanged(this.tblSum.getRow(rowIndex));
        } else {
            this.tblSum.getRow(rowIndex).getCell(2).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(3).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.tblSum.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        }
    }

    protected void tblSum_LevelChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        boolean b = false;
        Object obj = this.tblSum.getCell(rowIndex, 2).getValue();
        if (obj != null && FaSumLevelEnum.class.isInstance(obj)) {
            FaSumLevelEnum level = (FaSumLevelEnum)((Object)obj);
            if (level.getValue() == "3") {
                b = false;
            } else {
                b = true;
                this.tblSum.getRow(rowIndex).getCell(3).setValue(null);
            }
            this.tblSum.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(b);
        }
    }

    protected void tblSum_editValueChanged(KDTEditEvent e) {
        Object obj;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 1) {
            try {
                boolean isCheck = (Boolean)this.tblSum.getCell(rowIndex, colIndex).getValue();
                boolean b = false;
                if (isCheck) {
                    b = false;
                } else {
                    b = true;
                    this.tblSum.getRow(rowIndex).getCell(2).setValue(null);
                    this.tblSum.getRow(rowIndex).getCell(3).setValue(null);
                }
                this.tblSum.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(b);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
        } else if (colIndex == 2 && (obj = this.tblSum.getCell(rowIndex, colIndex).getValue()) != null) {
            boolean b = false;
            FaSumLevelEnum level = (FaSumLevelEnum)((Object)obj);
            if (level.getValue() == "3") {
                b = false;
            } else {
                b = true;
                this.tblSum.getRow(rowIndex).getCell(3).setValue(null);
            }
            this.tblSum.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(b);
        }
    }

    private void fireStartYearChange() {
        Integer year = (Integer)this.spnStartYear.getValue();
        if (this.periodsMap.containsKey(year)) {
            List periodsOfYear = (List)this.periodsMap.get(year);
            Integer minPeriod = (Integer)periodsOfYear.get(0);
            Integer maxPeriod = (Integer)periodsOfYear.get(periodsOfYear.size() - 1);
            if (year.intValue() == this.startPeriodInfo.getPeriodYear()) {
                minPeriod = new Integer(this.startPeriodInfo.getPeriodNumber());
            }
            if (year.intValue() == this.currentPeriodInfo.getPeriodYear()) {
                maxPeriod = new Integer(this.currentPeriodInfo.getPeriodNumber());
            }
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnStartMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            Integer startMonth = (Integer)this.spnStartMonth.getValue();
            if (startMonth.compareTo(minPeriod) < 0 || startMonth.compareTo(maxPeriod) > 0) {
                this.spnStartMonth.setValue((Object)minPeriod);
            }
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartMonth.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndMonth.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartMonth) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndMonth.setValue(this.spnStartMonth.getValue());
            } else {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartMonth.setValue(this.spnEndMonth.getValue());
            }
        }
    }

    private void fireEndYearChange() {
        Integer year = (Integer)this.spnEndYear.getValue();
        if (this.periodsMap.containsKey(year)) {
            List periodsOfYear = (List)this.periodsMap.get(year);
            Integer minPeriod = (Integer)periodsOfYear.get(0);
            Integer maxPeriod = (Integer)periodsOfYear.get(periodsOfYear.size() - 1);
            if (year.intValue() == this.startPeriodInfo.getPeriodYear()) {
                minPeriod = new Integer(this.startPeriodInfo.getPeriodNumber());
            }
            if (year.intValue() == this.currentPeriodInfo.getPeriodYear()) {
                maxPeriod = new Integer(this.currentPeriodInfo.getPeriodNumber());
            }
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnEndMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            Integer endMonth = (Integer)this.spnEndMonth.getValue();
            if (endMonth.compareTo(minPeriod) < 0 || endMonth.compareTo(maxPeriod) > 0) {
                this.spnEndMonth.setValue((Object)minPeriod);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.spnStartYear.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodYear()));
        this.spnStartMonth.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodNumber()));
        this.spnEndYear.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodYear()));
        this.spnEndMonth.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodNumber()));
        this.chkIsUserDefineSort.setSelected(false);
        for (int i = 1; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            if ("faCat".equals(this.tblSum.getRow(i).getUserObject())) {
                row.getCell("summary").setValue((Object)Boolean.TRUE);
                row.getCell(LEVEL).setValue((Object)FaSumLevelEnum.level);
            } else {
                row.getCell("summary").setValue((Object)Boolean.FALSE);
                row.getCell(LEVEL).setValue(null);
            }
            row.getCell("specLevel").setValue(null);
        }
    }
}

