/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaDeprRptCondUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaDefRptSumOptionUtil;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FaDeprRptCondUI
extends AbstractFaDeprRptCondUI {
    private static final long serialVersionUID = 5832873287782863565L;
    protected static final String USER_DEFINE = "userDefineName";
    protected static final String SUM_OPTION = "sumOption";
    protected static final String COLUMN_KEY = "columnKey";
    protected static final String FIELD_NAME = "fieldName";
    protected static final String PARTCLEAN = "partclean";
    protected static final String COMPLETECLEAN = "completeclean";
    protected static final String LEVEL_TYPE = "levelType";
    protected static final String IS_SUM = "isSum";
    protected static final String CHANGE = "change";
    protected static final String NEW = "new";
    protected static final String INITPERIOD = "initperiod";
    protected static final String START_PERIOD_YEAR = "startYear";
    protected static final String START_PERIOD_NUMBER = "startNumber";
    protected static final String END_PERIOD_YEAR = "endYear";
    protected static final String END_PERIOD_NUMBER = "endNumber";
    protected static final String IS_SHOW_NOCARD_COMPANY = "isShowNoCardCompany";
    protected static final String IS_SHOW_NOT_AUDIT = "isShowNotAudit";
    protected static final String COMPANY = "company";
    protected static final String LEVEL = "level";
    protected static final String SPEC_LEVEL = "specLevel";
    protected static final String SUMMARY = "summary";
    protected static final String ITEM = "item";
    protected static final String DISPLAYEVALDATA = "displayEvalData";
    private static final String DEFCOMPANYLEVEL = "defCompanyLevel";
    protected static final String DISPLAYDEPMULTIPDATA = "displayDepMultipData";
    private boolean isLoadData = false;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;
    private static final String BOOKSCHEME = "bookScheme";
    private int lastPeriodYear = -1;
    private String lastPeriodTypeID = "";
    private int lastPeriodNum = 0;

    public FaDeprRptCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnStartYear.setEnabled(false);
            this.spnStartMonth.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndMonth.setEnabled(false);
            this.lblDefLevel.setVisible(true);
            this.chkDisDepMultipData.setVisible(false);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            evi.setFilter(filterInfo);
            this.prmtAccountTable.setEntityViewInfo(evi);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.prmtAccountTable.setEnabled(false);
            this.prmtPeriodType.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
            this.lblDefLevel.setVisible(false);
        }
        this.ctnMain.addButton((JButton)this.wbtMoveUp);
        this.ctnMain.addButton((JButton)this.wbtMoveDown);
        this.wbtMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaDeprRptCondUI.this.beforeActionPerformed(e);
                FaDeprRptCondUI.this.wbtMoveUp_actionPerformed(e);
            }
        });
        this.wbtMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaDeprRptCondUI.this.beforeActionPerformed(e);
                FaDeprRptCondUI.this.wbtMoveDown_actionPerformed(e);
            }
        });
        this.tblSum.checkParsed();
        this.tblSum.getColumn(ITEM).getStyleAttributes().setLocked(true);
        this.initSumTable();
        this.prmtCompany.setEnabled(false);
    }

    @Override
    protected void setDefaultData() throws Exception {
        this.setShowFilterLoadData(true);
        if (this.isShowFilterLoadData()) {
            this.initInfo = FaListFactory.getRemoteInstance().getQueryInfo(this.currCompany, null, null);
        }
        this.prmtAccountTable.setData((Object)this.currCompany.getAccountTable());
        this.prmtPeriodType.setData((Object)this.currCompany.getAccountPeriodType());
        this.spnDefLevel.setValue((Object)new Integer(1));
        if (!this.isVirCompany) {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = null;
            PeriodInfo startPeriodInfo = null;
            if (this.isShowFilterLoadData() && this.initInfo != null) {
                currentPeriodInfo = (PeriodInfo)this.initInfo.get("currentPeriod");
                startPeriodInfo = (PeriodInfo)this.initInfo.get("startPeriod");
            } else {
                currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
                startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            }
            Integer minYear = new Integer(startPeriodInfo.getPeriodYear());
            Integer maxYear = new Integer(currentPeriodInfo.getPeriodYear());
            SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
            startYearSpinnerNumberModel.setMinimum(minYear);
            startYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
            SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
            endYearSpinnerNumberModel.setMinimum(minYear);
            endYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
            Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
            this.spnStartYear.setValue((Object)defaultYear);
            this.spnEndYear.setValue((Object)defaultYear);
            this.spnStartMonth.setValue((Object)defaultNumber);
            this.spnEndMonth.setValue((Object)defaultNumber);
        }
        this.rbnDetailStyle.setSelected(true);
        if (!this.isVirCompany) {
            this.rbnSumStyle.setEnabled(false);
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            Object item = this.tblSum.getRow(i).getCell(ITEM).getValue();
            if (EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"faCat").equals(item)) {
                this.tblSum.getRow(i).getCell(SUMMARY).setValue((Object)Boolean.TRUE);
                this.tblSum.getRow(i).getCell(LEVEL).setValue((Object)FaSumLevelEnum.level);
                this.tblSum.getRow(i).getCell(LEVEL).getStyleAttributes().setLocked(false);
                continue;
            }
            this.tblSum.getCell(i, SUMMARY).setValue((Object)Boolean.FALSE);
            this.tblSum.getCell(i, LEVEL).setValue(null);
            this.tblSum.getCell(i, SPEC_LEVEL).setValue(null);
            this.tblSum.getRow(i).getCell(SPEC_LEVEL).getStyleAttributes().setLocked(true);
            this.tblSum.getRow(i).getCell(LEVEL).getStyleAttributes().setLocked(true);
        }
        this.chkDeprZeroCard.setSelected(false);
        this.chkCleanCard.setSelected(false);
        this.chkAllCleanCard.setSelected(false);
        this.setShowFilterLoadData(false);
        this.initInfo = null;
    }

    @Override
    protected void addListener() {
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprRptCondUI.this.fireStartYearChange();
                FaDeprRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprRptCondUI.this.fireEndYearChange();
                FaDeprRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnStartMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDeprRptCondUI.this.firePeriodChange(e);
            }
        });
        this.prmtAccountTable.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaDeprRptCondUI.this.ctsUI = null;
                    FaDeprRptCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtPeriodType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaDeprRptCondUI.this.ctsUI = null;
                    FaDeprRptCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaDeprRptCondUI.this.companyChanged(eventObj.getNewValue());
            }
        });
        this.tblSum.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                Object obj = FaDeprRptCondUI.this.tblSum.getCell(rowIndex, FaDeprRptCondUI.LEVEL).getValue();
                if (obj != null && FaSumLevelEnum.class.isInstance(obj)) {
                    boolean isDetail = false;
                    FaSumLevelEnum level = (FaSumLevelEnum)((Object)obj);
                    if (level.getValue() == "3") {
                        isDetail = false;
                    } else {
                        isDetail = true;
                        FaDeprRptCondUI.this.tblSum.getRow(rowIndex).getCell(FaDeprRptCondUI.SPEC_LEVEL).setValue(null);
                    }
                    FaDeprRptCondUI.this.tblSum.getRow(rowIndex).getCell(FaDeprRptCondUI.SPEC_LEVEL).getStyleAttributes().setLocked(isDetail);
                }
            }
        });
    }

    private void initSumTable() throws Exception {
        this.tblSum.removeRows();
        KDCheckBox kDCheckBox = new KDCheckBox();
        kDCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                boolean isCheck = ((KDCheckBox)evt.getSource()).getSelected() == 32;
                FaDeprRptCondUI.this.tblSum_SummaryChanged(isCheck);
            }
        });
        this.tblSum.getColumn(ITEM).setWidth(150);
        this.tblSum.getColumn(SUMMARY).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kDCheckBox));
        this.tblSum.getColumn(SUMMARY).setRenderer((IBasicRender)new CellCheckBoxRenderer());
        KDComboBox kdcLevel = new KDComboBox();
        List list = FaSumLevelEnum.getEnumList();
        Object[] objs = list.toArray();
        kdcLevel.addItems(objs);
        this.tblSum.getColumn(LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevel));
        KDComboBox kdcLevelNotTree = new KDComboBox();
        kdcLevelNotTree.addItem((Object)FaSumLevelEnum.detail);
        KDFormattedTextField txtField = new KDFormattedTextField();
        txtField.setMinimumValue((Comparable)new Integer(1));
        this.tblSum.getColumn(SPEC_LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        IRow rowFaCat = this.tblSum.addRow();
        rowFaCat.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetCat"));
        rowFaCat.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowFaCat.getCell(SPEC_LEVEL).setValue(null);
        rowFaCat.setUserObject((Object)"assetCat");
        IRow rowEcnomyUsage = this.tblSum.addRow();
        rowEcnomyUsage.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"economicPurp"));
        rowEcnomyUsage.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowEcnomyUsage.getCell(SPEC_LEVEL).setValue(null);
        rowEcnomyUsage.setUserObject((Object)"economicPurp");
        IRow rowUseStatus = this.tblSum.addRow();
        rowUseStatus.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useStatus"));
        rowUseStatus.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowUseStatus.getCell(SPEC_LEVEL).setValue(null);
        rowUseStatus.setUserObject((Object)"useStatus");
        IRow rowLocation = this.tblSum.addRow();
        rowLocation.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"storeCity"));
        rowLocation.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowLocation.getCell(SPEC_LEVEL).setValue(null);
        rowLocation.setUserObject((Object)"storeCity");
        ICell euLocCell = rowLocation.getCell(LEVEL);
        euLocCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevelNotTree));
        IRow rowSourceType = this.tblSum.addRow();
        rowSourceType.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"originMethod"));
        rowSourceType.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowSourceType.getCell(SPEC_LEVEL).setValue(null);
        rowSourceType.setUserObject((Object)"originMethod");
        IRow rowUseDepartment = this.tblSum.addRow();
        rowUseDepartment.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useDepartment"));
        rowUseDepartment.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowUseDepartment.getCell(SPEC_LEVEL).setValue(null);
        rowUseDepartment.setUserObject((Object)"useDepartment");
        IRow rowDepartment = this.tblSum.addRow();
        rowDepartment.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"asstActItem"));
        rowDepartment.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowDepartment.setUserObject((Object)"asstActItem");
        this.tblSum.getColumn(LEVEL).getStyleAttributes().setLocked(true);
        this.tblSum.getColumn(SPEC_LEVEL).getStyleAttributes().setLocked(true);
        FaDefRptSumOptionUtil.addDefSumOption(this.tblSum);
    }

    protected void tblSum_SummaryChanged(boolean isCheck) {
        int rowIndex = this.tblSum.getEditManager().getEditRowIndex();
        if (isCheck) {
            this.tblSum.getRow(rowIndex).getCell(LEVEL).getStyleAttributes().setLocked(false);
            KDComboBox editBox = new KDComboBox();
            ICellEditor editor = this.tblSum.getRow(rowIndex).getCell(LEVEL).getEditor();
            if (editor != null) {
                editBox = (KDComboBox)editor.getComponent();
            }
            if (editBox.getItemCount() == 1) {
                this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue((Object)FaSumLevelEnum.detail);
            } else {
                this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue((Object)FaSumLevelEnum.level);
            }
            FaDefRptSumOptionUtil.onTableSummaryChanged(this.tblSum.getRow(rowIndex));
        } else {
            this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(SPEC_LEVEL).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(LEVEL).getStyleAttributes().setLocked(true);
            this.tblSum.getRow(rowIndex).getCell(SPEC_LEVEL).getStyleAttributes().setLocked(true);
        }
        if (this.isVirCompany) {
            return;
        }
        boolean isSumStyle = false;
        if (isCheck) {
            isSumStyle = true;
        } else {
            int size = this.tblSum.getRowCount();
            for (int i = 0; i < size && !isSumStyle; ++i) {
                if (i == rowIndex) continue;
                Object summary = this.tblSum.getRow(i).getCell(SUMMARY).getValue();
                isSumStyle = isSumStyle || summary == null ? false : (Boolean)summary;
            }
        }
        this.rbnSumStyle.setEnabled(isSumStyle);
        if (!isSumStyle) {
            this.rbnDetailStyle.setSelected(true);
        }
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        customCond.put(START_PERIOD_YEAR, this.spnStartYear.getValue());
        customCond.put(START_PERIOD_NUMBER, this.spnStartMonth.getValue());
        customCond.put(DEFCOMPANYLEVEL, (Integer)this.spnDefLevel.getValue() == 0 ? new Integer(101) : this.spnDefLevel.getValue());
        customCond.put(END_PERIOD_YEAR, this.spnEndYear.getValue());
        customCond.put(END_PERIOD_NUMBER, this.spnEndMonth.getValue());
        customCond.put("sumstyle", this.rbnSumStyle.isSelected());
        customCond.put("detailstyle", this.rbnDetailStyle.isSelected());
        customCond.put("deprZeroCard", this.chkDeprZeroCard.isSelected());
        customCond.put("cleanCard", this.chkCleanCard.isSelected());
        customCond.put("allCleanCard", this.chkAllCleanCard.isSelected());
        customCond.put(IS_SHOW_NOT_AUDIT, this.chkHasUnAuditData.isSelected());
        customCond.put(DISPLAYEVALDATA, this.chkDisEvalData.isSelected());
        customCond.put(DISPLAYDEPMULTIPDATA, this.chkDisDepMultipData.isSelected());
        if (this.isVirCompany) {
            customCond.put("accountTable", this.prmtAccountTable.getData());
            customCond.put("periodType", this.prmtPeriodType.getData());
            customCond.put(COMPANY, this.prmtCompany.getData());
            customCond.put(BOOKSCHEME, this.getSchemeInfo());
        }
        ArrayList<FaSumOptnObject> sumItems = new ArrayList<FaSumOptnObject>();
        FaSumOptnObject fsoPeriod = new FaSumOptnObject();
        fsoPeriod.setFieldName("Period");
        fsoPeriod.setColumnKey("Period");
        fsoPeriod.setLevelType(FaSumLevelEnum.detail);
        fsoPeriod.setLevel(0);
        fsoPeriod.setOrderNo(0);
        fsoPeriod.setSum(true);
        sumItems.add(fsoPeriod);
        for (int i = 1; i <= this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i - 1);
            FaSumOptnObject fso = new FaSumOptnObject();
            String fieldName = (String)row.getUserObject();
            fso.setFieldName(fieldName);
            fso.setColumnKey(FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            fso.setLevelType(levelType);
            int specLevel = row.getCell(SPEC_LEVEL).getValue() == null ? 0 : ((Number)row.getCell(SPEC_LEVEL).getValue()).intValue();
            fso.setLevel(specLevel);
            fso.setOrderNo(i);
            fso.setSum((Boolean)row.getCell(SUMMARY).getValue());
            sumItems.add(fso);
        }
        customCond.put(SUM_OPTION, sumItems);
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        params.putInt(START_PERIOD_YEAR, this.spnStartYear.getIntegerVlaue().intValue());
        params.putInt(START_PERIOD_NUMBER, this.spnStartMonth.getIntegerVlaue().intValue());
        params.putInt(DEFCOMPANYLEVEL, this.spnDefLevel.getIntegerVlaue() == 0 ? 101 : this.spnDefLevel.getIntegerVlaue());
        params.putInt(END_PERIOD_YEAR, this.spnEndYear.getIntegerVlaue().intValue());
        params.putInt(END_PERIOD_NUMBER, this.spnEndMonth.getIntegerVlaue().intValue());
        params.putBoolean("sumstyle", this.rbnSumStyle.isSelected());
        params.putBoolean("detailstyle", this.rbnDetailStyle.isSelected());
        params.putBoolean("deprZeroCard", this.chkDeprZeroCard.isSelected());
        params.putBoolean("cleanCard", this.chkCleanCard.isSelected());
        params.putBoolean("allCleanCard", this.chkAllCleanCard.isSelected());
        params.putBoolean(IS_SHOW_NOT_AUDIT, this.chkHasUnAuditData.isSelected());
        params.putBoolean(DISPLAYEVALDATA, this.chkDisEvalData.isSelected());
        params.putBoolean(DISPLAYDEPMULTIPDATA, this.chkDisDepMultipData.isSelected());
        if (this.isVirCompany) {
            AccountTableInfo accountTable = (AccountTableInfo)this.prmtAccountTable.getData();
            CustomerParams custAcountTable = new CustomerParams();
            custAcountTable.addCustomerParam("id", accountTable.getId().toString());
            custAcountTable.addCustomerParam("name", accountTable.getName());
            custAcountTable.addCustomerParam("number", accountTable.getNumber());
            params.putMe("accountTable", custAcountTable);
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.prmtPeriodType.getData();
            CustomerParams custPeriodType = new CustomerParams();
            custPeriodType.addCustomerParam("id", periodType.getId().toString());
            custPeriodType.addCustomerParam("name", periodType.getName());
            custPeriodType.addCustomerParam("number", periodType.getNumber());
            params.putMe("periodType", custPeriodType);
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
            if (this.getSchemeInfo() != null) {
                CustomerParams custBookScheme = new CustomerParams();
                custBookScheme.addCustomerParam("id", this.getSchemeInfo().getId().toString());
                custBookScheme.addCustomerParam("name", this.getSchemeInfo().getName());
                custBookScheme.addCustomerParam("number", this.getSchemeInfo().getNumber());
                params.putMe(BOOKSCHEME, custBookScheme);
            }
        }
        CustomerParams sumItems = new CustomerParams();
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            CustomerParams fso = new CustomerParams();
            String fieldName = (String)row.getUserObject();
            fso.addCustomerParam(FIELD_NAME, fieldName);
            fso.addCustomerParam(COLUMN_KEY, FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            if (levelType != null) {
                fso.addCustomerParam(LEVEL_TYPE, levelType.getValue());
            }
            int specLevel = row.getCell(SPEC_LEVEL).getValue() == null ? 0 : ((Number)row.getCell(SPEC_LEVEL).getValue()).intValue();
            fso.putInt(LEVEL, specLevel);
            Object summary = this.tblSum.getRow(i).getCell(SUMMARY).getValue();
            fso.putBoolean(IS_SUM, summary == null ? false : (Boolean)summary);
            sumItems.putMe("sum" + i, fso);
        }
        params.putMe(SUM_OPTION, sumItems);
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.isLoadData = true;
        CustomerParams cond = this.getCustomerParams();
        if (cond != null && !cond.getValues().isEmpty()) {
            int i;
            this.rbnSumStyle.setSelected(cond.getBoolean("sumstyle"));
            this.rbnDetailStyle.setSelected(cond.getBoolean("detailstyle"));
            this.chkDeprZeroCard.setSelected(cond.getBoolean("deprZeroCard"));
            this.chkCleanCard.setSelected(cond.getBoolean("cleanCard"));
            this.chkAllCleanCard.setSelected(cond.getBoolean("allCleanCard"));
            this.chkHasUnAuditData.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
            this.chkDisEvalData.setSelected(cond.getBoolean(DISPLAYEVALDATA));
            this.chkDisDepMultipData.setSelected(cond.getBoolean(DISPLAYDEPMULTIPDATA));
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe("accountTable");
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam("id")));
                accountTable.setName(custAcountTable.getCustomerParam("name"));
                accountTable.setNumber(custAcountTable.getCustomerParam("number"));
                this.prmtAccountTable.setData((Object)accountTable);
                CustomerParams custPeriodType = cond.getMe("periodType");
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam("id")));
                periodType.setName(custPeriodType.getCustomerParam("name"));
                periodType.setNumber(custPeriodType.getCustomerParam("number"));
                this.prmtPeriodType.setData((Object)periodType);
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
            }
            String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
            this.spnDefLevel.setValue((Object)new Integer(cond.getInt(DEFCOMPANYLEVEL) == 101 ? 0 : cond.getInt(DEFCOMPANYLEVEL)));
            ArrayList<String> idList = new ArrayList<String>();
            Object data = this.prmtCompany.getData();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            Map periodYears = null;
            try {
                periodYears = this.isShowFilterLoadData() && this.initInfo != null ? (Map)this.initInfo.get("findPeriodYears") : FaListFactory.getRemoteInstance().findPeriodYears(idList);
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.maxPerioEndNumber = (Integer)periodYears.get("MaxPeriodNumber");
                if (cond.getInt(START_PERIOD_YEAR) == 0) {
                    this.spnStartYear.setValue((Object)this.maxPeriodYear);
                } else {
                    this.spnStartYear.setValue((Object)new Integer(cond.getInt(START_PERIOD_YEAR)));
                }
                if (cond.getInt(START_PERIOD_NUMBER) == 0) {
                    this.spnStartMonth.setValue((Object)this.maxPerioEndNumber);
                } else {
                    this.spnStartMonth.setValue((Object)new Integer(cond.getInt(START_PERIOD_NUMBER)));
                }
                if (cond.getInt(END_PERIOD_YEAR) == 0) {
                    this.spnEndYear.setValue((Object)this.maxPeriodYear);
                } else {
                    this.spnEndYear.setValue((Object)new Integer(cond.getInt(END_PERIOD_YEAR)));
                }
                if (cond.getInt(END_PERIOD_NUMBER) == 0) {
                    this.spnEndMonth.setValue((Object)this.maxPerioEndNumber);
                } else {
                    this.spnEndMonth.setValue((Object)new Integer(cond.getInt(END_PERIOD_NUMBER)));
                }
                if (((Integer)this.spnStartYear.getValue()).compareTo(this.maxPeriodYear) > 0) {
                    this.spnStartYear.setValue((Object)this.maxPeriodYear);
                }
                if (((Integer)this.spnStartYear.getValue()).compareTo(this.maxPeriodYear) == 0 && ((Integer)this.spnStartMonth.getValue()).compareTo(this.maxPerioEndNumber) > 0) {
                    this.spnStartMonth.setValue((Object)this.maxPerioEndNumber);
                }
                if (((Integer)this.spnEndYear.getValue()).compareTo(this.maxPeriodYear) > 0) {
                    this.spnEndYear.setValue((Object)this.maxPeriodYear);
                }
                if (((Integer)this.spnEndYear.getValue()).compareTo(this.maxPeriodYear) == 0 && ((Integer)this.spnEndMonth.getValue()).compareTo(this.maxPerioEndNumber) > 0) {
                    this.spnEndMonth.setValue((Object)this.maxPerioEndNumber);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            boolean isSumStyle = false;
            CustomerParams sumItems = cond.getMe(SUM_OPTION);
            if (sumItems != null) {
                for (i = 0; i < sumItems.getKeys().size(); ++i) {
                    CustomerParams fso = sumItems.getMe("sum" + i);
                    int n = this.tblSum.getRowCount();
                    for (int j = 0; j < n; ++j) {
                        if (!this.tblSum.getRow(j).getUserObject().toString().equalsIgnoreCase(fso.getCustomerParam(FIELD_NAME))) continue;
                        IRow row = this.tblSum.getRow(j);
                        if (j != i) {
                            this.tblSum.removeRow(j);
                            this.tblSum.addRow(i, row);
                        }
                        row.getCell(SUMMARY).setValue((Object)fso.getBoolean(IS_SUM));
                        row.getCell(LEVEL).setValue((Object)FaSumLevelEnum.getEnum(fso.getCustomerParam(LEVEL_TYPE)));
                        int specLevel = fso.getInt(LEVEL);
                        row.getCell(SPEC_LEVEL).setValue((Object)(specLevel == 0 ? null : new Integer(specLevel)));
                        break;
                    }
                    isSumStyle = isSumStyle || fso.getBoolean(IS_SUM);
                }
            }
            int size = this.tblSum.getRowCount();
            for (i = 0; i < size; ++i) {
                if (Boolean.TRUE.equals(this.tblSum.getRow(i).getCell(SUMMARY).getValue())) {
                    this.tblSum.getRow(i).getCell(LEVEL).getStyleAttributes().setLocked(false);
                }
                if (!FaSumLevelEnum.specified.equals(this.tblSum.getRow(i).getCell(LEVEL).getValue())) continue;
                this.tblSum.getRow(i).getCell(SPEC_LEVEL).getStyleAttributes().setLocked(false);
            }
            if (!this.isVirCompany) {
                this.rbnSumStyle.setEnabled(isSumStyle);
                if (!isSumStyle) {
                    this.rbnDetailStyle.setSelected(true);
                }
            }
        }
        this.isLoadData = false;
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            Object specLevel;
            Object summary = this.tblSum.getRow(i).getCell(SUMMARY).getValue();
            if (summary == null || !((Boolean)summary).booleanValue()) continue;
            Object level = this.tblSum.getRow(i).getCell(LEVEL).getValue();
            if (level == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectSumLevel"));
                return false;
            }
            if (((FaSumLevelEnum)((Object)level)).getValue() != "3" || (specLevel = this.tblSum.getRow(i).getCell(SPEC_LEVEL).getValue()) != null && ((Integer)specLevel).compareTo(Integer.valueOf("0")) > 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"specLeveNotNullGreaterZero"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return super.verify();
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAccountTable.getData() == null || this.prmtPeriodType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"condBeforeSelectCompany"));
            return;
        }
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    private void fireStartYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnStartYear.getIntegerVlaue();
        try {
            int periodNum = this.getPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnStartMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnStartMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void fireEndYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnEndYear.getIntegerVlaue();
        try {
            int periodNum = this.getPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnEndMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnEndMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartMonth.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndMonth.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartMonth) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndMonth.setValue(this.spnStartMonth.getValue());
            } else if (!this.isLoadData) {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartMonth.setValue(this.spnEndMonth.getValue());
            }
        }
    }

    protected void companyChanged(Object data) {
        if (data == null) {
            this.spnStartYear.setEnabled(false);
            this.spnStartMonth.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndMonth.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnStartYear.setModel((SpinnerModel)tmpModel);
            this.spnStartMonth.setModel((SpinnerModel)tmpModel);
            this.spnEndYear.setModel((SpinnerModel)tmpModel);
            this.spnEndMonth.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnStartYear.setEnabled(true);
            this.spnStartMonth.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnEndMonth.setEnabled(true);
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
                if (this.isShowFilterLoadData() && this.initInfo == null && this.isVirCompany) {
                    this.initInfo = FaListFactory.getRemoteInstance().getQueryInfo(null, idList, periodTypeID);
                }
                Map periodYears = null;
                periodYears = this.isShowFilterLoadData() && this.initInfo != null ? (Map)this.initInfo.get("findPeriodYears") : FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel startPeriodSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endPeriodSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodStartNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPerioEndNumber = (Integer)periodYears.get("MaxPeriodNumber");
                startYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                startYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
                endYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                endYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
                this.spnStartYear.setValue(periodYears.get("MaxPeriodYear"));
                this.spnEndYear.setValue(periodYears.get("MaxPeriodYear"));
                Map periodNumOfYear = null;
                periodNumOfYear = this.isShowFilterLoadData() && this.initInfo != null ? (Map)this.initInfo.get("minMaxPeriodYear") : FaListFactory.getRemoteInstance().findMinMaxPeriodsOfYear(this.maxPeriodYear, periodTypeID);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    startPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    startPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                startPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnStartMonth.setModel((SpinnerModel)startPeriodSpinnerNumberModel);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    endPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    endPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                endPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnEndMonth.setModel((SpinnerModel)endPeriodSpinnerNumberModel);
                this.spnStartMonth.setValue(periodYears.get("MaxPeriodNumber"));
                this.spnEndMonth.setValue(periodYears.get("MaxPeriodNumber"));
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        String accountTableID = ((AccountTableInfo)this.prmtAccountTable.getData()).getId().toString();
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        this.ctsUI = new CompanyTreeSelectUI(this, accountTableID, periodTypeID);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaDeprRptCondUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    protected void wbtMoveUp_actionPerformed(ActionEvent e) {
        int selectRowIndex = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRowIndex > 0) {
            IRow selectRow = this.tblSum.getRow(selectRowIndex);
            this.delSelectLine();
            this.tblSum.addRow(selectRowIndex - 1, selectRow);
            this.tblSum.getSelectManager().select(selectRowIndex - 1, 0);
        }
    }

    protected void wbtMoveDown_actionPerformed(ActionEvent e) {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRpw < this.tblSum.getRowCount() - 1) {
            IRow selectRow = this.tblSum.getRow(selectRpw);
            this.delSelectLine();
            this.tblSum.addRow(selectRpw + 1, selectRow);
            this.tblSum.getSelectManager().select(selectRpw + 1, 0);
        }
    }

    protected void delSelectLine() {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            this.tblSum.removeRow(selectRpw);
        }
    }

    private int getPeriodNum(int periodYear, String periodTypeID) throws BOSException {
        if (this.lastPeriodYear != -1 && periodYear == this.lastPeriodYear && this.lastPeriodTypeID.trim().length() > 0 && this.lastPeriodTypeID.equals(periodTypeID)) {
            return this.lastPeriodNum;
        }
        if (this.isShowFilterLoadData() && this.initInfo != null && this.initInfo.get("periodNum") != null) {
            this.lastPeriodNum = (Integer)this.initInfo.get("periodNum");
            this.lastPeriodYear = periodYear;
            this.lastPeriodTypeID = periodTypeID;
        } else {
            this.lastPeriodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            this.lastPeriodYear = periodYear;
            this.lastPeriodTypeID = periodTypeID;
        }
        return this.lastPeriodNum;
    }

    @Override
    public void clear() {
        super.clear();
        this.chkHasUnAuditData.setSelected(false);
        this.chkDisEvalData.setSelected(false);
    }
}

