/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaEvaluateRptCondUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FaEvaluateRptCondUI
extends AbstractFaEvaluateRptCondUI {
    private static final long serialVersionUID = -409874644382767440L;
    private static final Logger logger = Logger.getLogger(FaEvaluateRptCondUI.class);
    protected static final String ITEM = "item";
    protected static final String SUMMARY = "summary";
    protected static final String LEVEL = "level";
    protected static final String IS_SUM = "isSum";
    protected static final String SPECLEVEL = "specLevel";
    protected static final String COLUMN_KEY = "columnKey";
    protected static final String FIELD_NAME = "fieldName";
    protected static final String LEVEL_TYPE = "levelType";

    public FaEvaluateRptCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.txtEvalTimeStart.setSupportedEmpty(false);
        this.txtEvalTimeEnd.setSupportedEmpty(false);
        this.tblSum.checkParsed();
        this.tblSum.getColumn(ITEM).getStyleAttributes().setLocked(true);
        this.initTable();
    }

    @Override
    protected void addListener() {
        this.rbnByBenchmarkDate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FaEvaluateRptCondUI.this.lblStartTime.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"benchmarkDateBegin"));
                    FaEvaluateRptCondUI.this.lblEndTime.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"benchmarkDateEnd"));
                } else if (e.getStateChange() == 2) {
                    FaEvaluateRptCondUI.this.lblStartTime.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"adjustDateBegin"));
                    FaEvaluateRptCondUI.this.lblEndTime.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"adjustDateEnd"));
                }
            }
        });
        this.txtEvalTimeStart.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (FaEvaluateRptCondUI.this.txtEvalTimeStart.getValue() != null && ((Date)FaEvaluateRptCondUI.this.txtEvalTimeEnd.getValue()).compareTo((Date)FaEvaluateRptCondUI.this.txtEvalTimeStart.getValue()) < 0) {
                    FaEvaluateRptCondUI.this.txtEvalTimeEnd.setValue(FaEvaluateRptCondUI.this.txtEvalTimeStart.getValue());
                }
            }
        });
        this.txtEvalTimeEnd.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (FaEvaluateRptCondUI.this.txtEvalTimeEnd.getValue() != null && ((Date)FaEvaluateRptCondUI.this.txtEvalTimeEnd.getValue()).compareTo((Date)FaEvaluateRptCondUI.this.txtEvalTimeStart.getValue()) < 0) {
                    FaEvaluateRptCondUI.this.txtEvalTimeStart.setValue(FaEvaluateRptCondUI.this.txtEvalTimeEnd.getValue());
                }
            }
        });
    }

    @Override
    protected void setDefaultData() throws Exception {
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        this.rbnByBenchmarkDate.setSelected(true);
        this.txtEvalTimeStart.setValue((Object)today);
        this.txtEvalTimeEnd.setValue((Object)today);
    }

    private void initTable() throws Exception {
        this.tblSum.removeRows();
        KDCheckBox kDCheckBox = new KDCheckBox();
        kDCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean selected = ((KDCheckBox)arg0.getSource()).getSelected() == 32;
                FaEvaluateRptCondUI.this.tblSum_SummaryChanged(selected);
            }
        });
        this.tblSum.getColumn(SUMMARY).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kDCheckBox));
        KDComboBox kdcLevel = new KDComboBox();
        List list = FaSumLevelEnum.getEnumList();
        Object[] objs = list.toArray();
        kdcLevel.addItems(objs);
        this.tblSum.getColumn(LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevel));
        KDComboBox kdcLevelNotTree = new KDComboBox();
        kdcLevelNotTree.addItem((Object)FaSumLevelEnum.detail);
        KDFormattedTextField txtField = new KDFormattedTextField();
        txtField.setMinimumValue((Comparable)new Integer(1));
        this.tblSum.getColumn(SPECLEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        IRow rowFaCat = this.tblSum.addRow();
        rowFaCat.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetCat"));
        rowFaCat.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowFaCat.getCell(SPECLEVEL).setValue(null);
        rowFaCat.setUserObject((Object)"assetCat");
        this.tblSum.getColumn(LEVEL).getStyleAttributes().setLocked(true);
        this.tblSum.getColumn(SPECLEVEL).getStyleAttributes().setLocked(true);
        rowFaCat.getCell(SUMMARY).setValue((Object)Boolean.TRUE);
        rowFaCat.getCell(LEVEL).setValue((Object)FaSumLevelEnum.level);
        rowFaCat.getCell(LEVEL).getStyleAttributes().setLocked(false);
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            boolean byBenchmarkDate = cond.getBoolean("byBenchmarkDate");
            this.rbnByBenchmarkDate.setSelected(byBenchmarkDate);
            this.rbnByAdjustDate.setSelected(!byBenchmarkDate);
            long startTime = cond.getLong("startDate");
            long endTime = cond.getLong("endDate");
            this.txtEvalTimeStart.setValue((Object)new Date(startTime));
            this.txtEvalTimeEnd.setValue((Object)new Date(endTime));
            CustomerParams fso = cond.getMe("sumOption");
            if (fso != null && fso.getValues().size() > 0) {
                CustomerParams faSumOption = (CustomerParams)fso.getValues().iterator().next();
                IRow row = this.tblSum.getRow(0);
                row.getCell(ITEM).setUserObject((Object)faSumOption.getCustomerParam(FIELD_NAME));
                row.getCell(SUMMARY).setValue((Object)faSumOption.getBoolean(IS_SUM));
                row.getCell(LEVEL).setValue((Object)FaSumLevelEnum.getEnum(faSumOption.getCustomerParam(LEVEL_TYPE)));
                int specLevel = faSumOption.getInt(LEVEL);
                if (specLevel == 0) {
                    row.getCell(SPECLEVEL).setValue(null);
                } else {
                    row.getCell(SPECLEVEL).setValue((Object)new Integer(specLevel));
                }
                if ("3".equals(faSumOption.getCustomerParam(LEVEL_TYPE))) {
                    row.getCell(SPECLEVEL).getStyleAttributes().setLocked(false);
                }
            }
        }
    }

    protected void tblSum_SummaryChanged(boolean isCheck) {
        int rowIndex = this.tblSum.getEditManager().getEditRowIndex();
        if (isCheck) {
            this.tblSum.getRow(rowIndex).getCell(LEVEL).getStyleAttributes().setLocked(false);
            KDComboBox editBox = new KDComboBox();
            ICellEditor editor = this.tblSum.getRow(rowIndex).getCell(LEVEL).getEditor();
            if (editor != null) {
                editBox = (KDComboBox)editor.getComponent();
            }
            if (editBox.getItemCount() == 1) {
                this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue((Object)FaSumLevelEnum.detail);
            } else {
                this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue((Object)FaSumLevelEnum.level);
            }
        } else {
            this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(SPECLEVEL).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(LEVEL).getStyleAttributes().setLocked(true);
            this.tblSum.getRow(rowIndex).getCell(SPECLEVEL).getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.tblSum.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    FaEvaluateRptCondUI.this.tblSum_LevelChanged(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    protected void tblSum_LevelChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        boolean b = false;
        Object obj = this.tblSum.getCell(rowIndex, LEVEL).getValue();
        if (obj != null && FaSumLevelEnum.class.isInstance(obj)) {
            FaSumLevelEnum level = (FaSumLevelEnum)((Object)obj);
            if (level.getValue() == "3") {
                b = false;
            } else {
                b = true;
                this.tblSum.getRow(rowIndex).getCell(SPECLEVEL).setValue(null);
            }
            this.tblSum.getRow(rowIndex).getCell(SPECLEVEL).getStyleAttributes().setLocked(b);
        }
    }

    protected void delSelectLine() throws Exception {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            this.tblSum.removeRow(selectRpw);
        }
    }

    @Override
    protected Map getCustomCond() {
        HashMap<String, Object> customCond = new HashMap<String, Object>();
        customCond.put("byBenchmarkDate", new Boolean(this.rbnByBenchmarkDate.isSelected()));
        customCond.put("startDate", this.txtEvalTimeStart.getValue());
        customCond.put("endDate", this.txtEvalTimeEnd.getValue());
        ArrayList<FaSumOptnObject> sumItems = new ArrayList<FaSumOptnObject>();
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            FaSumOptnObject fso = new FaSumOptnObject();
            String fieldName = (String)row.getUserObject();
            fso.setFieldName(fieldName);
            fso.setColumnKey(FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            fso.setLevelType(levelType);
            int specLevel = row.getCell(SPECLEVEL).getValue() == null ? 0 : Integer.valueOf(row.getCell(SPECLEVEL).getValue().toString());
            fso.setLevel(specLevel);
            fso.setSum((Boolean)row.getCell(SUMMARY).getValue());
            sumItems.add(fso);
        }
        customCond.put("sumOption", sumItems);
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        params.putBoolean("byBenchmarkDate", this.rbnByBenchmarkDate.isSelected());
        params.putLong("startDate", ((Date)this.txtEvalTimeStart.getValue()).getTime());
        params.putLong("endDate", ((Date)this.txtEvalTimeEnd.getValue()).getTime());
        CustomerParams sumItems = new CustomerParams();
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            CustomerParams fso = new CustomerParams();
            String fieldName = (String)row.getUserObject();
            fso.addCustomerParam(FIELD_NAME, fieldName);
            fso.addCustomerParam(COLUMN_KEY, FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            if (levelType != null) {
                fso.addCustomerParam(LEVEL_TYPE, levelType.getValue());
            }
            int specLevel = row.getCell(SPECLEVEL).getValue() == null ? 0 : Integer.valueOf(row.getCell(SPECLEVEL).getValue().toString());
            fso.putInt(LEVEL, specLevel);
            fso.putBoolean(IS_SUM, ((Boolean)row.getCell(SUMMARY).getValue()).booleanValue());
            sumItems.putMe("sum" + i, fso);
        }
        params.putMe("sumOption", sumItems);
        return params;
    }

    @Override
    public boolean verify() {
        if (this.txtEvalTimeStart.getValue() == null || this.txtEvalTimeEnd.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notEvalDatePeriod"));
            return false;
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            Object specLevel;
            if (!((Boolean)this.tblSum.getRow(i).getCell(SUMMARY).getValue()).booleanValue()) continue;
            Object level = this.tblSum.getRow(i).getCell(LEVEL).getValue();
            if (level == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.selectSumLevel"));
                return false;
            }
            if (((FaSumLevelEnum)((Object)level)).getValue() != "3" || (specLevel = this.tblSum.getRow(i).getCell(SPECLEVEL).getValue()) != null && Integer.valueOf(specLevel.toString()).compareTo(Integer.valueOf("0")) > 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.specLeveNotNullGreaterZero"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            this.tblSum.getRow(i).getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        }
    }
}

