/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaFacilityListConditionUI;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaFacilityListConditionUI
extends AbstractFaFacilityListConditionUI {
    private static final long serialVersionUID = 1734553324418700594L;
    private static final String IS_SHOW_NOT_AUDIT = "isShowNotAudit";

    public FaFacilityListConditionUI() throws Exception {
        this.init();
    }

    @Override
    protected void addListener() throws Exception {
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaFacilityListConditionUI.this.fireYearChange();
            }
        });
    }

    private void fireYearChange() {
        String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.spnYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPeriodNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        customCond.put(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        params.putBoolean(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        return params;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
        }
    }

    @Override
    protected void setDefaultData() throws Exception {
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
        Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
        Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
        this.spnYear.setValue((Object)defaultYear);
        this.spnMonth.setValue((Object)defaultNumber);
        this.chkIsShowNotAudit.setSelected(false);
    }
}

