/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.fa.basedata.client.FaContractCatPromptBox;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaLeaseLiabilitiesRptCondUI;
import com.kingdee.eas.fi.fa.rpt.client.FLCompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class FaLeaseLiabilitiesRptCondUI
extends AbstractFaLeaseLiabilitiesRptCondUI {
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseLiabilitiesRptCondUI.class);
    private static final String COMPANY = "company";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String CONTRACT_TYPE = "contractType";
    private static final String LEASE_BILL_NUMBER = "leaseBillNumber";
    private static final String CONTRACT_NUMBER = "contractNumber";
    private static final String RPT_DATA_TYPE = "rptDataType";
    private static final String AMOUNT_DISPLAY_TYPE = "amountDisplayType";
    private static final String IS_BY_COMPANY = "isByCompany";
    private static final String IS_BY_CURRENCY = "isByCurrency";
    private static final String IS_BY_PERSON_TYPE = "isByPersonType";
    private static final String IS_BY_PERSON = "isByPerson";
    protected static final String START_PERIOD_YEAR = "startYear";
    protected static final String START_PERIOD_NUMBER = "startNumber";
    protected static final String END_PERIOD_YEAR = "endYear";
    protected static final String END_PERIOD_NUMBER = "endNumber";
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;
    private DataChangeListener pkStartDateListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            if (e.getNewValue() == null) {
                FaLeaseLiabilitiesRptCondUI.this.kDStartDatePicker.setValue((Object)new java.util.Date());
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"156_FaLeaseLiabilitiesRptCondUI"));
                SysUtil.abort();
            }
        }
    };
    private DataChangeListener pkEndDateListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            if (e.getNewValue() == null) {
                FaLeaseLiabilitiesRptCondUI.this.kDEndDatePicker.setValue((Object)new java.util.Date());
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"157_FaLeaseLiabilitiesRptCondUI"));
                SysUtil.abort();
            }
        }
    };

    public FaLeaseLiabilitiesRptCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.spnStartYear.setEnabled(true);
            this.spnStartNumber.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnEndNumber.setEnabled(true);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
        }
        this.prmtCompany.setEnabled(false);
        this.checkBoxByCompany.setSelected(true);
        this.kDStartDatePicker.addDataChangeListener(this.pkStartDateListener);
        this.kDEndDatePicker.addDataChangeListener(this.pkEndDateListener);
        this.pmtContractType.setValue(null);
        FaContractCatPromptBox faContractCatPromptBox = new FaContractCatPromptBox((CoreUIObject)this);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurrentCompany().getId().toString()));
        view.setFilter(filter);
        this.pmtContractType.setSelector((KDPromptSelector)faContractCatPromptBox);
        this.pmtContractType.setEntityViewInfo(view);
        this.RadioExemptALL.setSelected(true);
    }

    @Override
    protected void setDefaultData() throws Exception {
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
            PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
            Integer minYear = startPeriodInfo.getPeriodYear();
            Integer maxYear = currentPeriodInfo.getPeriodYear();
            SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
            startYearSpinnerNumberModel.setMinimum(minYear);
            startYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
            SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
            endYearSpinnerNumberModel.setMinimum(minYear);
            endYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
            Integer defaultYear = currentPeriodInfo.getPeriodYear();
            Integer defaultNumber = currentPeriodInfo.getPeriodNumber();
            this.spnStartYear.setValue((Object)defaultYear);
            this.spnEndYear.setValue((Object)defaultYear);
            this.spnStartNumber.setValue((Object)defaultNumber);
            this.spnEndNumber.setValue((Object)defaultNumber);
        }
        this.includeTerminateBill.setSelected(false);
        this.includeChangeBill.setSelected(false);
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        if (this.isVirCompany) {
            customCond.put(COMPANY, this.prmtCompany.getData());
        }
        customCond.put(START_DATE, this.kDStartDatePicker.getSqlDate());
        customCond.put(END_DATE, this.kDEndDatePicker.getSqlDate());
        customCond.put(CONTRACT_TYPE, this.pmtContractType.getData());
        customCond.put(LEASE_BILL_NUMBER, this.txtFaLeaseBillNumber.getStringValue());
        customCond.put(CONTRACT_NUMBER, this.txtContractNumber.getStringValue());
        customCond.put(RPT_DATA_TYPE, this.combfaleaseRptDataType.getSelectedItem());
        customCond.put(AMOUNT_DISPLAY_TYPE, this.combAmountDisplayType.getSelectedItem());
        customCond.put(IS_BY_COMPANY, this.checkBoxByCompany.isSelected());
        customCond.put(IS_BY_CURRENCY, this.checkBoxByCurrency.isSelected());
        customCond.put(IS_BY_PERSON_TYPE, this.checkBoxByPersonType.isSelected());
        customCond.put(IS_BY_PERSON, this.checkBoxByPerson.isSelected());
        customCond.put("includeTerminateBill", this.includeTerminateBill.isSelected());
        customCond.put("includeChangeBill", this.includeChangeBill.isSelected());
        customCond.put("beginDateFrom", this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue());
        customCond.put("beginDateTo", this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue());
        customCond.put("exempted", this.RadioExempt.isSelected());
        customCond.put("exemptNG", this.RadioExemptNG.isSelected());
        customCond.put("exemptALL", this.RadioExemptALL.isSelected());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        if (this.isVirCompany) {
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
        }
        params.putBoolean("includeTerminateBill", Boolean.valueOf(this.includeTerminateBill.isSelected()).booleanValue());
        params.putBoolean("includeChangeBill", Boolean.valueOf(this.includeChangeBill.isSelected()).booleanValue());
        int dateBeginFrom = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        int dateBeginTo = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue();
        params.addCustomerParam("dateBeginFrom", String.valueOf(dateBeginFrom));
        params.addCustomerParam("dateBeginTo", String.valueOf(dateBeginTo));
        params.putBoolean("exempted", Boolean.valueOf(this.RadioExempt.isSelected()).booleanValue());
        params.putBoolean("exemptNG", Boolean.valueOf(this.RadioExemptNG.isSelected()).booleanValue());
        params.putBoolean("exemptALL", Boolean.valueOf(this.RadioExemptALL.isSelected()).booleanValue());
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe("accountTable");
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam("id")));
                accountTable.setName(custAcountTable.getCustomerParam("name"));
                accountTable.setNumber(custAcountTable.getCustomerParam("number"));
                CustomerParams custPeriodType = cond.getMe("periodType");
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam("id")));
                periodType.setName(custPeriodType.getCustomerParam("name"));
                periodType.setNumber(custPeriodType.getCustomerParam("number"));
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
                this.spnStartYear.setValue((Object)cond.getInt(START_PERIOD_YEAR));
                this.spnStartNumber.setValue((Object)cond.getInt(START_PERIOD_NUMBER));
                this.spnEndYear.setValue((Object)cond.getInt(END_PERIOD_YEAR));
                this.spnEndNumber.setValue((Object)cond.getInt(END_PERIOD_NUMBER));
            }
            ArrayList<String> idList = new ArrayList<String>();
            Object data = this.prmtCompany.getData();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            if (cond.getCustomerParam("dateBeginFrom") != null) {
                this.spnStartYear.setValue((Object)(Integer.parseInt(cond.getCustomerParam("dateBeginFrom")) / 100));
                this.spnStartNumber.setValue((Object)(Integer.parseInt(cond.getCustomerParam("dateBeginFrom")) % 100));
            }
            if (cond.getCustomerParam("dateBeginTo") != null) {
                this.spnEndYear.setValue((Object)(Integer.parseInt(cond.getCustomerParam("dateBeginTo")) / 100));
                this.spnEndNumber.setValue((Object)(Integer.parseInt(cond.getCustomerParam("dateBeginTo")) % 100));
            }
            this.includeTerminateBill.setSelected(cond.getBoolean("includeTerminateBill"));
            this.includeChangeBill.setSelected(cond.getBoolean("includeChangeBill"));
            this.RadioExempt.setSelected(cond.getBoolean("exempted"));
            this.RadioExemptNG.setSelected(cond.getBoolean("exemptNG"));
            this.RadioExemptALL.setSelected(cond.getBoolean("exemptALL"));
        }
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        this.ctsUI = new FLCompanyTreeSelectUI(this);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaLeaseLiabilitiesRptCondUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    @Override
    public boolean verify() {
        Date endDate;
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        Date startDate = this.kDStartDatePicker.getSqlDate();
        if (startDate.compareTo(endDate = this.kDEndDatePicker.getSqlDate()) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"155_FaAssetCalculationRptCondUI"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected void addListener() throws Exception {
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaLeaseLiabilitiesRptCondUI.this.fireStartYearChange();
                FaLeaseLiabilitiesRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaLeaseLiabilitiesRptCondUI.this.fireEndYearChange();
                FaLeaseLiabilitiesRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnStartNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaLeaseLiabilitiesRptCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaLeaseLiabilitiesRptCondUI.this.firePeriodChange(e);
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaLeaseLiabilitiesRptCondUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    private void companyChanged(Object data) {
        if (data == null) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnStartYear.setModel((SpinnerModel)tmpModel);
            this.spnStartNumber.setModel((SpinnerModel)tmpModel);
            this.spnEndYear.setModel((SpinnerModel)tmpModel);
            this.spnEndNumber.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnStartYear.setEnabled(true);
            this.spnStartNumber.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnEndNumber.setEnabled(true);
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel startPeriodSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endPeriodSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodStartNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPerioEndNumber = this.minPeriodYear == this.maxPeriodYear ? (Integer)periodYears.get("MaxPeriodNumber") : Integer.valueOf(13);
                startYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                startYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
                endYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                endYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
                this.spnStartYear.setValue(periodYears.get("MaxPeriodYear"));
                this.spnEndYear.setValue(periodYears.get("MaxPeriodYear"));
                Map periodNumOfYear = FaListFactory.getRemoteInstance().findMinMaxPeriodsOfYear(this.maxPeriodYear, periodTypeID);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    startPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    startPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                startPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnStartNumber.setModel((SpinnerModel)startPeriodSpinnerNumberModel);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    endPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    endPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                endPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnEndNumber.setModel((SpinnerModel)endPeriodSpinnerNumberModel);
                this.spnStartNumber.setValue(periodYears.get("MaxPeriodNumber"));
                this.spnEndNumber.setValue(periodYears.get("MaxPeriodNumber"));
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private void fireStartYearChange() {
        String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.spnStartYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnStartNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnStartNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void fireEndYearChange() {
        String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.spnEndYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnEndNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnEndNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartNumber) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndNumber.setValue(this.spnStartNumber.getValue());
            } else {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartNumber.setValue(this.spnEndNumber.getValue());
            }
        }
    }
}

