/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaUserDefinedSortFactory;
import com.kingdee.eas.fi.fa.manage.IFaUserDefinedSort;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaListRptConditionUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaDefRptSumOptionUtil;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FaListRptConditionUI
extends AbstractFaListRptConditionUI {
    private static final long serialVersionUID = -7177764734900601526L;
    private static final String PERIOD_TYPE = "periodType";
    private static final String ACCOUNT_TABLE = "accountTable";
    private static final String IS_USE_DEFINE_SORT = "IsUserDefineSort";
    private static final String IS_INCLUDE_ALL_CLEAR = "isIncludeAllClear";
    private static final String SUM_OPTION = "sumOption";
    private static final String USER_DEFINE = "userDefineName";
    private static final String IS_SUM_STYLE = "isSumStyle";
    protected static final String COLUMN_KEY = "columnKey";
    protected static final String FIELD_NAME = "fieldName";
    private static final String PARTCLEAN = "partclean";
    private static final String COMPLETECLEAN = "completeclean";
    protected static final String LEVEL_TYPE = "levelType";
    protected static final String IS_SUM = "isSum";
    private static final String CHANGE = "change";
    private static final String NEW = "new";
    private static final String INITPERIOD = "initperiod";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String IS_SHOW_NOCARD_COMPANY = "isShowNoCardCompany";
    private static final String IS_SHOW_NOT_AUDIT = "isShowNotAudit";
    private static final String COMPANY = "company";
    private static final String LEVEL = "level";
    private static final String SPEC_LEVEL = "specLevel";
    private static final String SUMMARY = "summary";
    private static final String ITEM = "item";
    private static final String DEFCOMPANYLEVEL = "defCompanyLevel";
    private static final String BOOKSCHEME = "bookScheme";
    private CompanyTreeSelectUI ctsUI;
    private JDialog dialog;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodNumber;
    private Integer maxPeriodNumber;

    public FaListRptConditionUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.chkIsUserDefineSort.setEnabled(false);
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
            this.lblDefLevel.setVisible(true);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            evi.setFilter(filterInfo);
            this.prmtAccountTable.setEntityViewInfo(evi);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
            this.chkIsShowNoCardCompany.setVisible(false);
            this.lblDefLevel.setVisible(false);
        }
        SpinnerNumberModel tmpModel = new SpinnerNumberModel(0, 0, 100, 1);
        this.spnDefLevel.setModel((SpinnerModel)tmpModel);
        this.ctnMain.addButton((JButton)this.wbtMoveUp);
        this.ctnMain.addButton((JButton)this.wbtMoveDown);
        this.wbtMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaListRptConditionUI.this.beforeActionPerformed(e);
                FaListRptConditionUI.this.wbtMoveUp_actionPerformed(e);
            }
        });
        this.wbtMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaListRptConditionUI.this.beforeActionPerformed(e);
                FaListRptConditionUI.this.wbtMoveDown_actionPerformed(e);
            }
        });
        this.tblSum.checkParsed();
        this.tblSum.getColumn(ITEM).getStyleAttributes().setLocked(true);
        this.initSumTable();
        this.prmtCompany.setEnabled(false);
    }

    @Override
    protected void setDefaultData() throws Exception {
        this.prmtAccountTable.setData((Object)this.currCompany.getAccountTable());
        this.prmtPeriodType.setData((Object)this.currCompany.getAccountPeriodType());
        if (this.isVirCompany) {
            this.chkIsShowNoCardCompany.setSelected(false);
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
            this.spnYear.setValue((Object)defaultYear);
            this.spnMonth.setValue((Object)defaultNumber);
        }
        this.spnDefLevel.setValue((Object)new Integer(1));
        this.chkIsSumStyle.setEnabled(this.isVirCompany);
        this.chkInitPeriod.setSelected(false);
        this.chkNew.setSelected(false);
        this.chkChange.setSelected(false);
        this.chkCompleteClean.setSelected(false);
        this.chkPartClean.setSelected(false);
        this.chkIsUserDefineSort.setSelected(false);
        this.chkIsSumStyle.setSelected(false);
        this.chkIsShowNotAudit.setSelected(false);
        this.chkIncludeClear.setSelected(false);
    }

    protected void wbtMoveUp_actionPerformed(ActionEvent e) {
        int selectRowIndex = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRowIndex > 0) {
            IRow selectRow = this.tblSum.getRow(selectRowIndex);
            this.delSelectLine();
            this.tblSum.addRow(selectRowIndex - 1, selectRow);
            this.tblSum.getSelectManager().select(selectRowIndex - 1, 0);
        }
    }

    protected void wbtMoveDown_actionPerformed(ActionEvent e) {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectRowFirst"));
            return;
        }
        if (selectRpw < this.tblSum.getRowCount() - 1) {
            IRow selectRow = this.tblSum.getRow(selectRpw);
            this.delSelectLine();
            this.tblSum.addRow(selectRpw + 1, selectRow);
            this.tblSum.getSelectManager().select(selectRpw + 1, 0);
        }
    }

    protected void delSelectLine() {
        int selectRpw = this.tblSum.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            this.tblSum.removeRow(selectRpw);
        }
    }

    private void initSumTable() throws Exception {
        this.tblSum.removeRows();
        KDCheckBox kDCheckBox = new KDCheckBox();
        kDCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                boolean isCheck = ((KDCheckBox)evt.getSource()).getSelected() == 32;
                FaListRptConditionUI.this.tblSum_SummaryChanged(isCheck);
            }
        });
        this.tblSum.getColumn(SUMMARY).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kDCheckBox));
        KDComboBox kdcLevel = new KDComboBox();
        List list = FaSumLevelEnum.getEnumList();
        Object[] objs = list.toArray();
        kdcLevel.addItems(objs);
        this.tblSum.getColumn(LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevel));
        KDComboBox kdcLevelNotTree = new KDComboBox();
        kdcLevelNotTree.addItem((Object)FaSumLevelEnum.detail);
        KDFormattedTextField txtField = new KDFormattedTextField();
        txtField.setMinimumValue((Comparable)new Integer(1));
        this.tblSum.getColumn(SPEC_LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        IRow rowFaCat = this.tblSum.addRow();
        rowFaCat.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetCat"));
        rowFaCat.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowFaCat.getCell(SPEC_LEVEL).setValue(null);
        rowFaCat.setUserObject((Object)"assetCat");
        IRow rowEcnomyUsage = this.tblSum.addRow();
        rowEcnomyUsage.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"economicPurp"));
        rowEcnomyUsage.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowEcnomyUsage.getCell(SPEC_LEVEL).setValue(null);
        rowEcnomyUsage.setUserObject((Object)"economicPurp");
        IRow rowUseStatus = this.tblSum.addRow();
        rowUseStatus.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useStatus"));
        rowUseStatus.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowUseStatus.getCell(SPEC_LEVEL).setValue(null);
        rowUseStatus.setUserObject((Object)"useStatus");
        if (!this.isVirCompany) {
            IRow rowLocation = this.tblSum.addRow();
            rowLocation.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"storeCity"));
            rowLocation.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
            rowLocation.getCell(SPEC_LEVEL).setValue(null);
            rowLocation.setUserObject((Object)"storeCity");
            ICell euLocCell = rowLocation.getCell(LEVEL);
            euLocCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevelNotTree));
        }
        IRow rowSourceType = this.tblSum.addRow();
        rowSourceType.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"originMethod"));
        rowSourceType.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowSourceType.getCell(SPEC_LEVEL).setValue(null);
        rowSourceType.setUserObject((Object)"originMethod");
        IRow rowCostCenter = this.tblSum.addRow();
        rowCostCenter.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useDepartment"));
        rowCostCenter.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowCostCenter.getCell(SPEC_LEVEL).setValue(null);
        rowCostCenter.setUserObject((Object)"useDepartment");
        IRow rowDepartment = this.tblSum.addRow();
        rowDepartment.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"asstActItem"));
        rowDepartment.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowDepartment.setUserObject((Object)"asstActItem");
        this.tblSum.getColumn(LEVEL).getStyleAttributes().setLocked(true);
        this.tblSum.getColumn(SPEC_LEVEL).getStyleAttributes().setLocked(true);
        IRow rowACNTASSET = this.tblSum.addRow();
        rowACNTASSET.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetAccount"));
        rowACNTASSET.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowACNTASSET.getCell(SPEC_LEVEL).setValue(null);
        rowACNTASSET.setUserObject((Object)"assetAccount");
        IRow rowACNTACCDEPR = this.tblSum.addRow();
        rowACNTACCDEPR.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"accDeprAccount"));
        rowACNTACCDEPR.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowACNTACCDEPR.getCell(SPEC_LEVEL).setValue(null);
        rowACNTACCDEPR.setUserObject((Object)"accDeprAccount");
        IRow rowACNTDECVAL = this.tblSum.addRow();
        rowACNTDECVAL.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"decAccount"));
        rowACNTDECVAL.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowACNTDECVAL.getCell(SPEC_LEVEL).setValue(null);
        rowACNTDECVAL.setUserObject((Object)"decAccount");
        this.tblSum.getColumn(LEVEL).getStyleAttributes().setLocked(true);
        this.tblSum.getColumn(SPEC_LEVEL).getStyleAttributes().setLocked(true);
        IRow rowDept = this.tblSum.addRow();
        rowDept.getCell(ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"dept"));
        rowDept.getCell(SUMMARY).setValue((Object)Boolean.FALSE);
        rowDept.getCell(SPEC_LEVEL).setValue(null);
        rowDept.setUserObject((Object)"dept");
        FaDefRptSumOptionUtil.addDefSumOption(this.tblSum);
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        if (this.isVirCompany) {
            customCond.put(ACCOUNT_TABLE, this.prmtAccountTable.getData());
            customCond.put(PERIOD_TYPE, this.prmtPeriodType.getData());
            customCond.put(COMPANY, this.prmtCompany.getData());
            customCond.put(IS_SHOW_NOCARD_COMPANY, this.chkIsShowNoCardCompany.isSelected());
            customCond.put(BOOKSCHEME, this.getSchemeInfo());
        }
        customCond.put(YEAR, this.spnYear.getValue());
        customCond.put(MONTH, this.spnMonth.getValue());
        customCond.put(DEFCOMPANYLEVEL, (Integer)this.spnDefLevel.getValue() == 0 ? new Integer(101) : this.spnDefLevel.getValue());
        customCond.put(INITPERIOD, this.chkInitPeriod.isSelected());
        customCond.put(NEW, this.chkNew.isSelected());
        customCond.put(CHANGE, this.chkChange.isSelected());
        customCond.put(COMPLETECLEAN, this.chkCompleteClean.isSelected());
        customCond.put(PARTCLEAN, this.chkPartClean.isSelected());
        customCond.put(IS_SUM_STYLE, this.chkIsSumStyle.isSelected());
        customCond.put(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        ArrayList<FaSumOptnObject> sumItems = new ArrayList<FaSumOptnObject>();
        if (this.chkIsUserDefineSort.isSelected()) {
            FaSumOptnObject fso = new FaSumOptnObject();
            fso.setFieldName(USER_DEFINE);
            fso.setColumnKey(USER_DEFINE);
            fso.setLevelType(FaSumLevelEnum.detail);
            fso.setLevel(0);
            fso.setOrderNo(0);
            fso.setSum(true);
            sumItems.add(fso);
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            FaSumOptnObject fso = new FaSumOptnObject();
            String fieldName = (String)row.getUserObject();
            fso.setFieldName(fieldName);
            fso.setColumnKey(FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            fso.setLevelType(levelType);
            int specLevel = row.getCell(SPEC_LEVEL).getValue() == null ? 0 : ((Number)row.getCell(SPEC_LEVEL).getValue()).intValue();
            fso.setLevel(specLevel);
            fso.setOrderNo(i);
            fso.setSum((Boolean)row.getCell(SUMMARY).getValue());
            sumItems.add(fso);
        }
        customCond.put(SUM_OPTION, sumItems);
        customCond.put(IS_USE_DEFINE_SORT, this.chkIsUserDefineSort.isSelected());
        customCond.put(IS_INCLUDE_ALL_CLEAR, this.chkIncludeClear.isSelected());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        if (this.isVirCompany) {
            AccountTableInfo accountTable = (AccountTableInfo)this.prmtAccountTable.getData();
            CustomerParams custAcountTable = new CustomerParams();
            custAcountTable.addCustomerParam("id", accountTable.getId().toString());
            custAcountTable.addCustomerParam("name", accountTable.getName());
            custAcountTable.addCustomerParam("number", accountTable.getNumber());
            params.putMe(ACCOUNT_TABLE, custAcountTable);
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.prmtPeriodType.getData();
            CustomerParams custPeriodType = new CustomerParams();
            custPeriodType.addCustomerParam("id", periodType.getId().toString());
            custPeriodType.addCustomerParam("name", periodType.getName());
            custPeriodType.addCustomerParam("number", periodType.getNumber());
            params.putMe(PERIOD_TYPE, custPeriodType);
            params.putBoolean(IS_SHOW_NOCARD_COMPANY, this.chkIsShowNoCardCompany.isSelected());
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
            if (this.getSchemeInfo() != null) {
                CustomerParams custBookScheme = new CustomerParams();
                custBookScheme.addCustomerParam("id", this.getSchemeInfo().getId().toString());
                custBookScheme.addCustomerParam("name", this.getSchemeInfo().getName());
                custBookScheme.addCustomerParam("number", this.getSchemeInfo().getNumber());
                params.putMe(BOOKSCHEME, custBookScheme);
            }
        }
        params.putInt(YEAR, this.spnYear.getIntegerVlaue().intValue());
        params.putInt(MONTH, this.spnMonth.getIntegerVlaue().intValue());
        params.putInt(DEFCOMPANYLEVEL, this.spnDefLevel.getIntegerVlaue() == 0 ? 101 : this.spnDefLevel.getIntegerVlaue());
        params.putBoolean(INITPERIOD, this.chkInitPeriod.isSelected());
        params.putBoolean(NEW, this.chkNew.isSelected());
        params.putBoolean(CHANGE, this.chkChange.isSelected());
        params.putBoolean(COMPLETECLEAN, this.chkCompleteClean.isSelected());
        params.putBoolean(PARTCLEAN, this.chkPartClean.isSelected());
        params.putBoolean(IS_SUM_STYLE, this.chkIsSumStyle.isSelected());
        params.putBoolean(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        CustomerParams sumItems = new CustomerParams();
        if (this.chkIsUserDefineSort.isSelected()) {
            CustomerParams dustFso = new CustomerParams();
            dustFso.addCustomerParam(FIELD_NAME, USER_DEFINE);
            dustFso.addCustomerParam(COLUMN_KEY, USER_DEFINE);
            dustFso.addCustomerParam(LEVEL_TYPE, "2");
            dustFso.putInt(LEVEL, 0);
            dustFso.putBoolean(IS_SUM, true);
            sumItems.putMe("sum", dustFso);
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            IRow row = this.tblSum.getRow(i);
            CustomerParams dustFso = new CustomerParams();
            String fieldName = (String)row.getUserObject();
            dustFso.addCustomerParam(FIELD_NAME, fieldName);
            dustFso.addCustomerParam(COLUMN_KEY, FaRptUIUtils.getColumnKeyByFieldName(fieldName));
            FaSumLevelEnum levelType = (FaSumLevelEnum)((Object)row.getCell(LEVEL).getValue());
            if (levelType != null) {
                dustFso.addCustomerParam(LEVEL_TYPE, levelType.getValue());
            }
            int specLevel = row.getCell(SPEC_LEVEL).getValue() == null ? 0 : ((Number)row.getCell(SPEC_LEVEL).getValue()).intValue();
            dustFso.putInt(LEVEL, specLevel);
            dustFso.putBoolean(IS_SUM, ((Boolean)row.getCell(SUMMARY).getValue()).booleanValue());
            sumItems.putMe("sum" + i, dustFso);
        }
        params.putMe(SUM_OPTION, sumItems);
        params.putBoolean(IS_USE_DEFINE_SORT, this.chkIsUserDefineSort.isSelected());
        params.putBoolean(IS_INCLUDE_ALL_CLEAR, this.chkIncludeClear.isSelected());
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            int i;
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe(ACCOUNT_TABLE);
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam("id")));
                accountTable.setName(custAcountTable.getCustomerParam("name"));
                accountTable.setNumber(custAcountTable.getCustomerParam("number"));
                this.prmtAccountTable.setData((Object)accountTable);
                CustomerParams custPeriodType = cond.getMe(PERIOD_TYPE);
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam("id")));
                periodType.setName(custPeriodType.getCustomerParam("name"));
                periodType.setNumber(custPeriodType.getCustomerParam("number"));
                this.prmtPeriodType.setData((Object)periodType);
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
                this.chkIsShowNoCardCompany.setSelected(cond.getBoolean(IS_SHOW_NOCARD_COMPANY));
                this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
            }
            this.spnYear.setValue((Object)new Integer(cond.getInt(YEAR)));
            this.spnMonth.setValue((Object)new Integer(cond.getInt(MONTH)));
            this.spnDefLevel.setValue((Object)new Integer(cond.getInt(DEFCOMPANYLEVEL) == 101 ? 0 : cond.getInt(DEFCOMPANYLEVEL)));
            ArrayList<String> idList = new ArrayList<String>();
            Object data = this.prmtCompany.getData();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.maxPeriodNumber = (Integer)periodYears.get("MaxPeriodNumber");
                if (((Integer)this.spnYear.getValue()).compareTo(this.maxPeriodYear) > 0) {
                    this.spnYear.setValue((Object)this.maxPeriodYear);
                }
                if (((Integer)this.spnYear.getValue()).compareTo(this.maxPeriodYear) == 0 && ((Integer)this.spnMonth.getValue()).compareTo(this.maxPeriodNumber) > 0) {
                    this.spnMonth.setValue((Object)this.maxPeriodNumber);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.chkInitPeriod.setSelected(cond.getBoolean(INITPERIOD));
            this.chkNew.setSelected(cond.getBoolean(NEW));
            this.chkChange.setSelected(cond.getBoolean(CHANGE));
            this.chkCompleteClean.setSelected(cond.getBoolean(COMPLETECLEAN));
            this.chkPartClean.setSelected(cond.getBoolean(PARTCLEAN));
            this.chkIsSumStyle.setSelected(cond.getBoolean(IS_SUM_STYLE));
            this.chkIsUserDefineSort.setSelected(cond.getBoolean(IS_USE_DEFINE_SORT));
            this.chkIncludeClear.setSelected(cond.getBoolean(IS_INCLUDE_ALL_CLEAR));
            this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
            KDComboBox kdcLevel = new KDComboBox();
            List list = FaSumLevelEnum.getEnumList();
            Object[] objs = list.toArray();
            kdcLevel.addItems(objs);
            this.tblSum.getColumn(LEVEL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdcLevel));
            boolean isSumStyle = false;
            CustomerParams sumItems = cond.getMe(SUM_OPTION);
            if (sumItems != null) {
                for (i = 0; i < sumItems.getKeys().size(); ++i) {
                    CustomerParams fso = sumItems.getMe("sum" + Integer.toString(i));
                    if (fso == null) continue;
                    int n = this.tblSum.getRowCount();
                    for (int j = 0; j < n; ++j) {
                        if (!this.tblSum.getRow(j).getUserObject().toString().equalsIgnoreCase(fso.getCustomerParam(FIELD_NAME))) continue;
                        IRow row = this.tblSum.getRow(j);
                        if (j != i) {
                            this.tblSum.removeRow(j);
                            this.tblSum.addRow(i, row);
                        }
                        row.getCell(SUMMARY).setValue((Object)fso.getBoolean(IS_SUM));
                        row.getCell(LEVEL).setValue((Object)FaSumLevelEnum.getEnum(fso.getCustomerParam(LEVEL_TYPE)));
                        int specLevel = fso.getInt(LEVEL);
                        row.getCell(SPEC_LEVEL).setValue((Object)(specLevel == 0 ? null : new Integer(specLevel)));
                        break;
                    }
                    isSumStyle = isSumStyle || fso.getBoolean(IS_SUM);
                }
            }
            int size = this.tblSum.getRowCount();
            for (i = 0; i < size; ++i) {
                if (Boolean.TRUE.equals(this.tblSum.getRow(i).getCell(SUMMARY).getValue())) {
                    this.tblSum.getRow(i).getCell(LEVEL).getStyleAttributes().setLocked(false);
                }
                if (!FaSumLevelEnum.specified.equals(this.tblSum.getRow(i).getCell(LEVEL).getValue())) continue;
                this.tblSum.getRow(i).getCell(SPEC_LEVEL).getStyleAttributes().setLocked(false);
            }
            this.chkIsSumStyle.setEnabled(isSumStyle || this.isVirCompany);
            if (!isSumStyle) {
                this.chkIsSumStyle.setSelected(false);
            }
        }
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        String accountTableID = ((AccountTableInfo)this.prmtAccountTable.getData()).getId().toString();
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        this.ctsUI = new CompanyTreeSelectUI(this, accountTableID, periodTypeID);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaListRptConditionUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        if (this.chkIsUserDefineSort.isSelected()) {
            try {
                IFaUserDefinedSort iUserDefine = FaUserDefinedSortFactory.getRemoteInstance();
                FilterInfo filter = new FilterInfo();
                FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
                filter.getFilterItems().add(companyFilterItemInfo);
                if (!iUserDefine.exists(filter)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"NoUserDefineSort"));
                    return false;
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"NoUserDefineSort"));
                return false;
            }
        }
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            Object specLevel;
            if (!((Boolean)this.tblSum.getRow(i).getCell(SUMMARY).getValue()).booleanValue()) continue;
            Object level = this.tblSum.getRow(i).getCell(LEVEL).getValue();
            if (level == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"selectSumLevel"));
                return false;
            }
            if (((FaSumLevelEnum)((Object)level)).getValue() != "3" || (specLevel = this.tblSum.getRow(i).getCell(SPEC_LEVEL).getValue()) != null && ((Integer)specLevel).compareTo(Integer.valueOf("0")) > 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"specLeveNotNullGreaterZero"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected void addListener() throws Exception {
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaListRptConditionUI.this.fireYearChange();
            }
        });
        this.chkInitPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaListRptConditionUI.this.fireInitPeriodSelect();
            }
        });
        this.tblSum.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                Object obj = FaListRptConditionUI.this.tblSum.getCell(rowIndex, FaListRptConditionUI.LEVEL).getValue();
                if (obj != null && FaSumLevelEnum.class.isInstance(obj)) {
                    boolean isDetail = false;
                    FaSumLevelEnum level = (FaSumLevelEnum)((Object)obj);
                    if (level.getValue() == "3") {
                        isDetail = false;
                    } else {
                        isDetail = true;
                        FaListRptConditionUI.this.tblSum.getRow(rowIndex).getCell(FaListRptConditionUI.SPEC_LEVEL).setValue(null);
                    }
                    FaListRptConditionUI.this.tblSum.getRow(rowIndex).getCell(FaListRptConditionUI.SPEC_LEVEL).getStyleAttributes().setLocked(isDetail);
                }
            }
        });
        this.prmtAccountTable.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ((eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) && FaListRptConditionUI.this.isVirCompany) {
                    FaListRptConditionUI.this.ctsUI = null;
                    FaListRptConditionUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtPeriodType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ((eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) && FaListRptConditionUI.this.isVirCompany) {
                    FaListRptConditionUI.this.ctsUI = null;
                    FaListRptConditionUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaListRptConditionUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    protected void tblSum_SummaryChanged(boolean isCheck) {
        int rowIndex = this.tblSum.getEditManager().getEditRowIndex();
        if (isCheck) {
            this.tblSum.getRow(rowIndex).getCell(LEVEL).getStyleAttributes().setLocked(false);
            KDComboBox editBox = new KDComboBox();
            ICellEditor editor = this.tblSum.getRow(rowIndex).getCell(LEVEL).getEditor();
            if (editor != null) {
                editBox = (KDComboBox)editor.getComponent();
            }
            if (editBox.getItemCount() == 1) {
                this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue((Object)FaSumLevelEnum.detail);
            } else {
                this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue((Object)FaSumLevelEnum.level);
            }
            FaDefRptSumOptionUtil.onTableSummaryChanged(this.tblSum.getRow(rowIndex));
        } else {
            this.tblSum.getRow(rowIndex).getCell(LEVEL).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(SPEC_LEVEL).setValue(null);
            this.tblSum.getRow(rowIndex).getCell(LEVEL).getStyleAttributes().setLocked(true);
            this.tblSum.getRow(rowIndex).getCell(SPEC_LEVEL).getStyleAttributes().setLocked(true);
        }
        if (this.isVirCompany) {
            return;
        }
        boolean isSumStyle = false;
        if (isCheck) {
            isSumStyle = true;
        } else {
            int size = this.tblSum.getRowCount();
            for (int i = 0; i < size; ++i) {
                if (i == rowIndex) continue;
                isSumStyle = isSumStyle || (Boolean)this.tblSum.getRow(i).getCell(SUMMARY).getValue() != false;
            }
        }
        this.chkIsSumStyle.setEnabled(isSumStyle || this.isVirCompany);
        if (!isSumStyle) {
            this.chkIsSumStyle.setSelected(false);
            this.chkIsSumStyle.setEnabled(false);
        }
    }

    private void fireInitPeriodSelect() {
        if (this.chkInitPeriod.isSelected()) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
            this.chkChange.setSelected(false);
            this.chkChange.setEnabled(false);
            this.chkCompleteClean.setSelected(false);
            this.chkCompleteClean.setEnabled(false);
            this.chkNew.setSelected(false);
            this.chkNew.setEnabled(false);
            this.chkPartClean.setSelected(false);
            this.chkPartClean.setEnabled(false);
        } else {
            if (this.prmtCompany.getData() != null) {
                this.spnYear.setEnabled(true);
                this.spnMonth.setEnabled(true);
            }
            this.chkChange.setEnabled(true);
            this.chkCompleteClean.setEnabled(true);
            this.chkNew.setEnabled(true);
            this.chkPartClean.setEnabled(true);
        }
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAccountTable.getData() == null || this.prmtPeriodType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"condBeforeSelectCompany"));
            return;
        }
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    protected void companyChanged(Object data) {
        if (data == null) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnYear.setModel((SpinnerModel)tmpModel);
            this.spnMonth.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnYear.setEnabled(!this.chkInitPeriod.isSelected());
            this.spnMonth.setEnabled(!this.chkInitPeriod.isSelected());
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel yearSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPeriodNumber = (Integer)periodYears.get("MaxPeriodNumber");
                yearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                yearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnYear.setModel((SpinnerModel)yearSpinnerNumberModel);
                this.spnYear.setValue((Object)this.maxPeriodYear);
                this.spnMonth.setValue((Object)this.maxPeriodNumber);
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private void fireYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPeriodNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this.tblSum.getRowCount(); ++i) {
            this.tblSum.getCell(i, SUMMARY).setValue((Object)Boolean.FALSE);
            this.tblSum.getCell(i, LEVEL).setValue(null);
            this.tblSum.getCell(i, SPEC_LEVEL).setValue(null);
        }
    }
}

