/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaContrastCaclFactory;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaProcessAssetsFilterUI;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FaProcessAssetsFilterUI
extends AbstractFaProcessAssetsFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FaProcessAssetsFilterUI.class);
    private Map zipData = null;
    private PeriodInfo currPeriod = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initPeriodYear(final PeriodInfo startPeriod, final PeriodInfo curPeriod) {
        SpinnerNumberModel syearModel = (SpinnerNumberModel)this.spStartY.getModel();
        syearModel.setMinimum(new Integer(startPeriod.getPeriodYear()));
        syearModel.setMaximum(new Integer(curPeriod.getPeriodYear()));
        SpinnerNumberModel eyearModel = (SpinnerNumberModel)this.spEndY.getModel();
        eyearModel.setMinimum(new Integer(startPeriod.getPeriodYear()));
        eyearModel.setMaximum(new Integer(curPeriod.getPeriodYear()));
        this.spStartY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaProcessAssetsFilterUI.this.changePeriodsYear(startPeriod, curPeriod);
                FaProcessAssetsFilterUI.this.firePeriodChange(e);
            }
        });
        this.spEndY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaProcessAssetsFilterUI.this.changePeriodeeYear(startPeriod, curPeriod);
                FaProcessAssetsFilterUI.this.firePeriodChange(e);
            }
        });
        this.spStartM.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaProcessAssetsFilterUI.this.firePeriodChange(e);
            }
        });
        this.spEndM.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaProcessAssetsFilterUI.this.firePeriodChange(e);
            }
        });
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        params.putInt("startYear", this.spStartY.getIntegerVlaue().intValue());
        params.putInt("startNumber", this.spStartM.getIntegerVlaue().intValue());
        params.putInt("endYear", this.spEndY.getIntegerVlaue().intValue());
        params.putInt("endNumber", this.spEndM.getIntegerVlaue().intValue());
        return params;
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        customCond.put("startYear", this.spStartY.getIntegerVlaue());
        customCond.put("startNumber", this.spStartM.getIntegerVlaue());
        customCond.put("endYear", this.spEndY.getIntegerVlaue());
        customCond.put("endNumber", this.spEndM.getIntegerVlaue());
        return customCond;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            this.spStartY.setValue((Object)new Integer(cond.getInt("startYear")));
            this.spStartM.setValue((Object)new Integer(cond.getInt("startNumber")));
            this.spEndY.setValue((Object)new Integer(cond.getInt("endYear")));
            this.spEndM.setValue((Object)new Integer(cond.getInt("endNumber")));
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ArrayList<CompanyOrgUnitInfo> params = new ArrayList<CompanyOrgUnitInfo>();
        params.add(SysContext.getSysContext().getCurrentFIUnit());
        this.zipData = FaContrastCaclFactory.getRemoteInstance().getZipDataForRPC(params);
        PeriodInfo startPeriod = (PeriodInfo)this.zipData.get("startPeriod");
        this.currPeriod = (PeriodInfo)this.zipData.get("currPeriod");
        this.initPeriodYear(startPeriod, this.currPeriod);
        this.fillPeriodComponent(this.currPeriod);
    }

    private void fillPeriodComponent(PeriodInfo periodInfo) {
        if (periodInfo != null) {
            this.spStartY.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spStartM.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
            this.spEndY.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spEndM.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        }
    }

    @Override
    public void clear() {
        this.fillPeriodComponent(this.currPeriod);
    }

    private void changePeriodsYear(PeriodInfo startPeriodInfo, PeriodInfo curPeriodInfo) {
        if (startPeriodInfo == null || curPeriodInfo == null) {
            return;
        }
        Integer startYear = (Integer)this.spStartY.getValue();
        SpinnerNumberModel startNumberModel = (SpinnerNumberModel)this.spStartM.getModel();
        try {
            int maxPeriod = (Integer)this.zipData.get("maxNumber" + startYear);
            int minPeriod = (Integer)this.zipData.get("minNumber" + startYear);
            startNumberModel.setMaximum(new Integer(maxPeriod));
            startNumberModel.setMinimum(new Integer(minPeriod));
            if (startPeriodInfo.getPeriodYear() == startYear.intValue()) {
                startNumberModel.setMinimum(new Integer(startPeriodInfo.getPeriodNumber()));
            }
            if (startPeriodInfo.getPeriodYear() > startYear) {
                this.spStartY.setValue((Object)new Integer(startPeriodInfo.getPeriodYear()));
            }
            if (startYear.intValue() == curPeriodInfo.getPeriodYear()) {
                startNumberModel.setMaximum(new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.spStartM.setValue(startNumberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void changePeriodeeYear(PeriodInfo startPeriodInfo, PeriodInfo curPeriodInfo) {
        if (startPeriodInfo == null || curPeriodInfo == null) {
            return;
        }
        Integer endYear = (Integer)this.spEndY.getValue();
        SpinnerNumberModel endNumberModel = (SpinnerNumberModel)this.spEndM.getModel();
        try {
            int maxPeriod = (Integer)this.zipData.get("maxNumber" + endYear);
            int minPeriod = (Integer)this.zipData.get("minNumber" + endYear);
            endNumberModel.setMaximum(new Integer(maxPeriod));
            endNumberModel.setMinimum(new Integer(minPeriod));
            if (startPeriodInfo.getPeriodYear() == endYear.intValue()) {
                endNumberModel.setMinimum(new Integer(startPeriodInfo.getPeriodNumber()));
            }
            if (startPeriodInfo.getPeriodYear() > endYear) {
                this.spEndY.setValue((Object)new Integer(startPeriodInfo.getPeriodYear()));
            }
            if (endYear.intValue() == curPeriodInfo.getPeriodYear()) {
                endNumberModel.setMaximum(new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.spEndM.setValue(endNumberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public boolean verify() {
        int endPeriod;
        int startPeriod = this.spStartY.getIntegerVlaue() * 100 + this.spStartM.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spEndY.getIntegerVlaue() * 100 + this.spEndM.getIntegerVlaue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"2_FaProcessAssetsFilterUI"));
            return false;
        }
        if (this.currPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"3_FaProcessAssetsFilterUI"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spStartY.getIntegerVlaue() * 100 + this.spStartM.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spEndY.getIntegerVlaue() * 100 + this.spEndM.getIntegerVlaue())) {
            if (e.getSource() == this.spStartY || e.getSource() == this.spStartM) {
                this.spEndY.setValue(this.spStartY.getValue());
                this.spEndM.setValue(this.spStartM.getValue());
            } else {
                this.spStartY.setValue(this.spEndY.getValue());
                this.spStartM.setValue(this.spEndM.getValue());
            }
        }
    }

    public RequestContext prepareSetFilterInfo(FilterInfo filterInfo) {
        return super.prepareSetFilterInfo(filterInfo);
    }

    public Set getYearSet() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(this.spStartY.getIntegerVlaue());
        set.add(this.spEndY.getIntegerVlaue());
        return set;
    }

    public Set getMonthSet() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(this.spStartM.getIntegerVlaue());
        set.add(this.spEndM.getIntegerVlaue());
        return set;
    }

    private Date getMaxDate(PeriodCollection cols) {
        Timestamp result = null;
        for (int i = 0; i < cols.size(); ++i) {
            PeriodInfo info = cols.get(i);
            if (result == null) {
                result = info.getEndDate();
                continue;
            }
            if (((Date)result).compareTo(info.getEndDate()) == 1) continue;
            result = info.getEndDate();
        }
        return result;
    }

    private Date getMinDate(PeriodCollection cols) {
        Date result = null;
        for (int i = 0; i < cols.size(); ++i) {
            PeriodInfo info = cols.get(i);
            if (result == null) {
                result = info.getBeginDate();
                continue;
            }
            if (result.compareTo(info.getBeginDate()) != 1) continue;
            result = info.getBeginDate();
        }
        return result;
    }

    private PeriodInfo getMaxPeriod(PeriodCollection cols) {
        Timestamp result = null;
        PeriodInfo rP = null;
        for (int i = 0; i < cols.size(); ++i) {
            PeriodInfo info = cols.get(i);
            if (result == null) {
                result = info.getEndDate();
                rP = info;
                continue;
            }
            if (((Date)result).compareTo(info.getEndDate()) == 1) continue;
            result = info.getEndDate();
            rP = info;
        }
        return rP;
    }

    private PeriodInfo getMinPeriod(PeriodCollection cols) {
        Date result = null;
        PeriodInfo rP = null;
        for (int i = 0; i < cols.size(); ++i) {
            PeriodInfo info = cols.get(i);
            if (result == null) {
                result = info.getBeginDate();
                rP = info;
                continue;
            }
            if (result.compareTo(info.getBeginDate()) != 1) continue;
            result = info.getBeginDate();
            rP = info;
        }
        return rP;
    }

    @Override
    public FilterInfo getFilterInfo() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("periodYear", (Object)this.getYearSet(), CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)this.getMonthSet(), CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("periodType", (Object)this.currPeriod.getPeriodType().getId().toString()));
        view.setFilter(f);
        Date start = null;
        Date end = null;
        try {
            PeriodCollection cols = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
            start = this.getMinDate(cols);
            end = this.getMaxDate(cols);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        end.setHours(23);
        end.setMinutes(60);
        FilterInfo fiter = new FilterInfo();
        fiter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)end, CompareType.LESS));
        fiter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)start, CompareType.GREATER_EQUALS));
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company != null) {
            fiter.getFilterItems().add(new FilterItemInfo("companyid", (Object)company.getId().toString()));
        }
        this.setCustomerParams(this.getCustParams());
        return fiter;
    }
}

