/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.FaBizBillTypeEnum;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaProcessAssetsListUI;
import com.kingdee.eas.fi.fa.rpt.client.FaProcessAssetsFilterUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.fi.fa.rpt.client.IDNode;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaProcessAssetsListUI
extends AbstractFaProcessAssetsListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaProcessAssetsListUI.class);
    private PeriodInfo currPeriod = null;

    protected void addDefaultFilterForQuery(EntityViewInfo ev) {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company != null) {
            FilterInfo f = ev.getFilter();
            if (f == null || f.getFilterItems().size() == 0) {
                f = new FilterInfo();
                ev.setFilter(f);
                try {
                    if (this.currPeriod != null) {
                        Date start = this.currPeriod.getBeginDate();
                        Timestamp end = this.currPeriod.getEndDate();
                        end.setHours(23);
                        end.setMinutes(60);
                        f.getFilterItems().add(new FilterItemInfo("bizDate", (Object)end, CompareType.LESS));
                        f.getFilterItems().add(new FilterItemInfo("bizDate", (Object)start, CompareType.GREATER_EQUALS));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            f.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
            f.getFilterItems().add(new FilterItemInfo("companyid", (Object)company.getId().toString()));
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
    }

    @Override
    protected void displayPeriodInfo() {
        this.lblPeriodValue.setVisible(true);
        String year = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"periodYear");
        String month = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"periodNumber");
        String strNo = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"ordinal");
        Map customCond = this.getCustomCond();
        String period = "";
        if (!customCond.isEmpty()) {
            Integer starty = (Integer)customCond.get("startYear");
            Integer startm = (Integer)customCond.get("startNumber");
            Integer endy = (Integer)customCond.get("endYear");
            Integer endm = (Integer)customCond.get("endNumber");
            period = starty.intValue() == endy.intValue() && startm.intValue() == endm.intValue() ? MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), starty.toString(), startm.toString()) : MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayTerm"), starty.toString(), startm.toString(), endy.toString(), endm.toString());
        } else {
            if (this.currPeriod == null) {
                this.lblPeriodValue.setVisible(false);
                return;
            }
            Integer currYear = new Integer(this.currPeriod.getPeriodYear());
            Integer currMonth = new Integer(this.currPeriod.getPeriodNumber());
            period = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), currYear.toString(), currMonth.toString());
        }
        this.lblPeriodValue.setText(period);
    }

    @Override
    protected void handleFirstLoadData(int start, int length) throws BOSException, Exception {
        IRowSet rowSet;
        IFaList manager = FaListFactory.getRemoteInstance();
        if (this.getTreeColumn() != null) {
            int topLevel = this.getTreeColumn().getTopLevel();
            rowSet = manager.getTreeDataForFirst(this.resultSql, length, topLevel);
        } else {
            rowSet = manager.getDataForFirst(this.resultSql, length);
        }
        this.onGetRowSet(rowSet);
        this.tblMain.addRows(rowSet.size());
        this.fillDataToTable(rowSet, start);
        if (rowSet.size() == length || this.getTreeColumn() != null) {
            this.getAllDataOfId();
        }
    }

    public String getRowSet(String str) {
        if ("1".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.ADD.getAlias();
        }
        if ("2".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.CHANGE.getAlias();
        }
        if ("3".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.CLEAR.getAlias();
        }
        if ("4".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.IN.getAlias();
        }
        if ("5".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.OUT.getAlias();
        }
        if ("6".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.SPLIT.getAlias();
        }
        if ("7".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.COMBIN.getAlias();
        }
        if ("8".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.REQUISITION.getAlias();
        }
        if ("9".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.REFUNDING.getAlias();
        }
        if ("9.1".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.BORROW.getAlias();
        }
        if ("9.2".equalsIgnoreCase(str)) {
            return FaBizBillTypeEnum.RETURN.getAlias();
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"10_FaProcessAssetsListUI");
    }

    @Override
    protected Map findData(EntityViewInfo ev) throws EASBizException, BOSException {
        this.dropTempTable();
        IFaList manager = FaListFactory.getRemoteInstance();
        long currTime = System.currentTimeMillis();
        this.addDefaultFilterForQuery(ev);
        Map map = manager.buildData(ev, "com.kingdee.eas.fi.fa.rpt.app.dao." + this.getDaoClassName());
        logger.info((Object)("take time: " + (System.currentTimeMillis() - currTime) / 1000L));
        return map;
    }

    @Override
    protected boolean isShowFilter() {
        return true;
    }

    @Override
    protected boolean isShowSorter() {
        return false;
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaProcessAssetsFilterUI();
    }

    @Override
    protected String getDaoClassName() {
        return "FaProcessAssetsDao";
    }

    @Override
    protected String getQueryName() {
        return "FaCurCardForAllQuery";
    }

    @Override
    protected void fillDataToTable(IRowSet rows, int start) throws Exception {
        if (rows == null) {
            return;
        }
        KDTColumns cols = this.tblMain.getColumns();
        int k = 0;
        int rowIndex = start;
        rows.beforeFirst();
        while (rows.next()) {
            int i;
            IRow row = this.tblMain.getRow2(rowIndex);
            if (row == null) {
                row = this.tblMain.addRow(rowIndex);
            }
            int n = cols.size();
            for (i = 0; i < n; ++i) {
                String key = cols.getColumnKey(i);
                if (this.getTreeColumn() != null && key.equalsIgnoreCase(this.getTreeColumn().getColumnName())) continue;
                if ("type".equalsIgnoreCase(key)) {
                    row.getCell(key).setValue((Object)this.getRowSet(rows.getString("type")));
                    continue;
                }
                row.getCell(key).setValue(rows.getObject(key));
            }
            if (this.getTreeColumn() != null) {
                int level = rows.getInt("SumLevel");
                int topLevel = this.getTreeColumn().getTopLevel();
                String topNode = this.getTreeColumn().getType() + topLevel + "Name";
                if (level > topLevel - 1) {
                    if (SUB_TOTAL.equals(rows.getString(topNode))) {
                        row.getCell(this.getTreeColumn().getColumnName()).setValue((Object)SUB_TOTAL);
                    } else {
                        String nodeName = rows.getString(this.getTreeColumn().getType() + level + "Name");
                        if (!SUB_TOTAL.equals(nodeName)) {
                            IDNode node = null;
                            if (rows.getInt("isSum") == 1) {
                                if (this.treeIdList != null) {
                                    node = this.treeIdList.getIDNode(rowIndex);
                                }
                                if (node == null) {
                                    node = new IDNode();
                                    node.setLeaf(false);
                                    node.setLevel(level);
                                    node.setOpen(false);
                                    this.setProperNodeOpen(node);
                                }
                                node.setName(nodeName);
                            }
                            row.getCell(this.getTreeColumn().getColumnName()).setUserObject(node);
                            row.getCell(this.getTreeColumn().getColumnName()).setValue((Object)node);
                        }
                    }
                } else {
                    row.getCell(this.getTreeColumn().getColumnName()).setValue((Object)rows.getString(topNode));
                }
            }
            if (this.hideColumn != null) {
                for (i = this.hideColumn.size() - 1; i >= 0; --i) {
                    int index = (Integer)this.hideColumn.get(i) + k;
                    if (!SUB_TOTAL.equals(row.getCell(index).getValue()) || row.getCell(index + 1).getValue() != null) continue;
                    row.getCell(index + 1).setValue((Object)SUB_TOTAL);
                }
            }
            this.afterFillTableRow(row, rowIndex);
            this.setSumRowColor(rows, row);
            ++rowIndex;
        }
    }

    @Override
    protected CommonQueryProcessor getProperCommonProcessor() throws EASBizException, BOSException {
        return new CommonQueryProcessor(){
            private Object editor = null;

            public void process() throws Exception {
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if (fieldProperty == null || fieldProperty.trim().length() == 0) {
                    return;
                }
                CoreUI parent = new CoreUI();
                if (this.get("parentDialog") != null) {
                    parent = ((CommonQueryDialog)this.get("parentDialog")).getWindow().getUIObject();
                }
                this.editor = this.get("CURRENT_EDITOR");
                if (fieldProperty.equalsIgnoreCase("faCatname") && this.editor instanceof KDBizPromptBox) {
                    KDBizPromptBox f7 = (KDBizPromptBox)this.editor;
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
                    view.setFilter(filter);
                    view.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
                    f7.setEntityViewInfo(view);
                    f7.setDefaultF7UIName("com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox");
                    FaCatPromptBox catf7 = new FaCatPromptBox((CoreUIObject)parent, false);
                    f7.setSelector((KDPromptSelector)catf7);
                }
            }
        };
    }

    @Override
    protected void formatData() throws EASBizException, BOSException {
        FaClientUtils.fmtDate((KDTable)this.tblMain, (String)"bizDate");
    }
}

