/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaRptAddDecrSumCondUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FaRptAddDecrSumCondUI
extends AbstractFaRptAddDecrSumCondUI {
    private static final long serialVersionUID = -3864316896892068803L;
    private static final String IS_SHOW_NOCARD_COMPANY = "isShowNoCardCompany";
    private static final String IS_SHOW_BY_PERIOD = "isShowByPeriod";
    private static final String IS_SHOW_NOT_AUDIT = "isShowNotAudit";
    private static final String IS_SHOW_DETAIL = "isShowDetail";
    private static final String IS_SHOW_CAT = "isShowCat";
    protected static final String START_PERIOD_YEAR = "startYear";
    protected static final String START_PERIOD_NUMBER = "startNumber";
    protected static final String END_PERIOD_YEAR = "endYear";
    protected static final String END_PERIOD_NUMBER = "endNumber";
    protected static final String PERIOD_TYPE = "periodType";
    protected static final String ACCOUNT_TABLE = "accountTable";
    protected static final String COLUMN_KEY = "columnKey";
    protected static final String FIELD_NAME = "fieldName";
    private static final String COMPANY = "company";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String ID = "id";
    private static final String BOOKSCHEME = "bookScheme";
    private static final String DEFCOMPANYLEVEL = "defCompanyLevel";
    private CompanyTreeSelectUI ctsUI;
    private JDialog dialog;
    private boolean isLoadData = false;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodNumber;
    private Integer maxPeriodNumber;
    private List companyList;

    public FaRptAddDecrSumCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnStartYear.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            this.lblDefLevel.setVisible(true);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            evi.setFilter(filterInfo);
            this.prmtAccountTable.setEntityViewInfo(evi);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
            this.spnCatLevel.setVisible(false);
            this.lblCatLevel.setVisible(false);
            this.chkIsShowCat.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (FaRptAddDecrSumCondUI.this.chkIsShowCat.isSelected()) {
                        FaRptAddDecrSumCondUI.this.spnCatLevel.setVisible(true);
                        FaRptAddDecrSumCondUI.this.lblCatLevel.setVisible(true);
                        FaRptAddDecrSumCondUI.this.spnCatLevel.setValue((Object)new Integer(1));
                    } else {
                        FaRptAddDecrSumCondUI.this.spnCatLevel.setVisible(false);
                        FaRptAddDecrSumCondUI.this.lblCatLevel.setVisible(false);
                    }
                }
            });
        } else {
            this.prmtAccountTable.setEnabled(false);
            this.prmtPeriodType.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
            this.chkIsShowNoCardCompany.setVisible(false);
            this.lblDefLevel.setVisible(false);
        }
        SpinnerNumberModel tmpModel = new SpinnerNumberModel(0, 0, 100, 1);
        this.spnDefLevel.setModel((SpinnerModel)tmpModel);
        this.chkIsShowCat.setEnabled(true);
        this.prmtCompany.setEnabled(false);
        this.lblCatLevel.setVisible(false);
    }

    @Override
    protected void setDefaultData() throws Exception {
        this.prmtAccountTable.setData((Object)this.currCompany.getAccountTable());
        this.prmtPeriodType.setData((Object)this.currCompany.getAccountPeriodType());
        this.spnDefLevel.setValue((Object)new Integer(1));
        this.chkIsShowDetail.setSelected(false);
        this.chkIsShowNotAudit.setSelected(false);
        this.chkByPeriod.setSelected(false);
        if (this.isVirCompany) {
            this.chkIsShowNoCardCompany.setSelected(false);
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            Integer defaultYear = new Integer(currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(currentPeriodInfo.getPeriodNumber());
            this.spnStartYear.setValue((Object)defaultYear);
            this.spnStartNumber.setValue((Object)defaultNumber);
            this.spnEndYear.setValue((Object)defaultYear);
            this.spnEndNumber.setValue((Object)defaultNumber);
        }
    }

    @Override
    protected Map getCustomCond() {
        HashMap<String, Object> customCond = new HashMap<String, Object>();
        if (this.isVirCompany) {
            customCond.put(ACCOUNT_TABLE, this.prmtAccountTable.getData());
            customCond.put(PERIOD_TYPE, this.prmtPeriodType.getData());
            customCond.put(COMPANY, this.prmtCompany.getData());
            customCond.put(IS_SHOW_NOCARD_COMPANY, this.chkIsShowNoCardCompany.isSelected());
            customCond.put(BOOKSCHEME, this.getSchemeInfo());
            customCond.put("defCatLevel", this.spnCatLevel.getValue());
            customCond.put("companyListByVir", this.companyList);
        }
        customCond.put(IS_SHOW_BY_PERIOD, this.chkByPeriod.isSelected());
        customCond.put(START_PERIOD_YEAR, this.spnStartYear.getValue());
        customCond.put(DEFCOMPANYLEVEL, (Integer)this.spnDefLevel.getValue() == 0 ? new Integer(101) : this.spnDefLevel.getValue());
        customCond.put(START_PERIOD_NUMBER, this.spnStartNumber.getValue());
        customCond.put(END_PERIOD_YEAR, this.spnEndYear.getValue());
        customCond.put(END_PERIOD_NUMBER, this.spnEndNumber.getValue());
        customCond.put(IS_SHOW_DETAIL, this.chkIsShowDetail.isSelected());
        customCond.put(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        customCond.put(IS_SHOW_CAT, this.chkIsShowCat.isSelected());
        if (this.chkIsShowCat.isSelected() && !this.isVirCompany) {
            ArrayList<FaSumOptnObject> sumItems = new ArrayList<FaSumOptnObject>();
            FaSumOptnObject fso = new FaSumOptnObject();
            fso.setFieldName("assetCat");
            fso.setLevelType(FaSumLevelEnum.level);
            fso.setSum(true);
            fso.setNode(true);
            sumItems.add(fso);
            customCond.put("sumOption", sumItems);
        }
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        if (this.isVirCompany) {
            AccountTableInfo accountTable = (AccountTableInfo)this.prmtAccountTable.getData();
            CustomerParams custAcountTable = new CustomerParams();
            custAcountTable.addCustomerParam(ID, accountTable.getId().toString());
            custAcountTable.addCustomerParam(NAME, accountTable.getName());
            custAcountTable.addCustomerParam(NUMBER, accountTable.getNumber());
            params.putMe(ACCOUNT_TABLE, custAcountTable);
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.prmtPeriodType.getData();
            CustomerParams custPeriodType = new CustomerParams();
            custPeriodType.addCustomerParam(ID, periodType.getId().toString());
            custPeriodType.addCustomerParam(NAME, periodType.getName());
            custPeriodType.addCustomerParam(NUMBER, periodType.getNumber());
            params.putMe(PERIOD_TYPE, custPeriodType);
            params.putBoolean(IS_SHOW_NOCARD_COMPANY, this.chkIsShowNoCardCompany.isSelected());
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
            if (this.getSchemeInfo() != null) {
                CustomerParams custBookScheme = new CustomerParams();
                custBookScheme.addCustomerParam(ID, this.getSchemeInfo().getId().toString());
                custBookScheme.addCustomerParam(NAME, this.getSchemeInfo().getName());
                custBookScheme.addCustomerParam(NUMBER, this.getSchemeInfo().getNumber());
                params.putMe(BOOKSCHEME, custBookScheme);
            }
        }
        params.putBoolean(IS_SHOW_BY_PERIOD, this.chkByPeriod.isSelected());
        params.putInt(START_PERIOD_YEAR, this.spnStartYear.getIntegerVlaue().intValue());
        params.putInt(START_PERIOD_NUMBER, this.spnStartNumber.getIntegerVlaue().intValue());
        params.putInt(DEFCOMPANYLEVEL, this.spnDefLevel.getIntegerVlaue() == 0 ? 101 : this.spnDefLevel.getIntegerVlaue());
        params.putInt(END_PERIOD_YEAR, this.spnEndYear.getIntegerVlaue().intValue());
        params.putInt(END_PERIOD_NUMBER, this.spnEndNumber.getIntegerVlaue().intValue());
        params.putBoolean(IS_SHOW_DETAIL, this.chkIsShowDetail.isSelected());
        params.putBoolean(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        params.putBoolean(IS_SHOW_CAT, this.chkIsShowCat.isSelected());
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.isLoadData = true;
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe(ACCOUNT_TABLE);
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam(ID)));
                accountTable.setName(custAcountTable.getCustomerParam(NAME));
                accountTable.setNumber(custAcountTable.getCustomerParam(NUMBER));
                this.prmtAccountTable.setData((Object)accountTable);
                CustomerParams custPeriodType = cond.getMe(PERIOD_TYPE);
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam(ID)));
                periodType.setName(custPeriodType.getCustomerParam(NAME));
                periodType.setNumber(custPeriodType.getCustomerParam(NUMBER));
                this.prmtPeriodType.setData((Object)periodType);
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
                this.chkIsShowNoCardCompany.setSelected(cond.getBoolean(IS_SHOW_NOCARD_COMPANY));
                this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
                this.chkByPeriod.setSelected(cond.getBoolean(IS_SHOW_BY_PERIOD));
            }
            this.spnStartYear.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnDefLevel.setValue((Object)new Integer(cond.getInt(DEFCOMPANYLEVEL) == 101 ? 0 : cond.getInt(DEFCOMPANYLEVEL)));
            this.spnStartNumber.setEnabled(true);
            this.spnEndNumber.setEnabled(true);
            this.spnStartYear.setValue((Object)new Integer(cond.getInt(START_PERIOD_YEAR)));
            this.spnStartNumber.setValue((Object)new Integer(cond.getInt(START_PERIOD_NUMBER)));
            this.spnEndYear.setValue((Object)new Integer(cond.getInt(END_PERIOD_YEAR)));
            this.spnEndNumber.setValue((Object)new Integer(cond.getInt(END_PERIOD_NUMBER)));
            this.chkIsShowDetail.setSelected(cond.getBoolean(IS_SHOW_DETAIL));
            this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
            this.chkIsShowCat.setSelected(cond.getBoolean(IS_SHOW_CAT));
            this.chkByPeriod.setSelected(cond.getBoolean(IS_SHOW_BY_PERIOD));
        }
        this.isLoadData = false;
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        String accountTableID = ((AccountTableInfo)this.prmtAccountTable.getData()).getId().toString();
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        this.ctsUI = new CompanyTreeSelectUI(this, accountTableID, periodTypeID);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaRptAddDecrSumCondUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected void addListener() throws Exception {
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptAddDecrSumCondUI.this.fireYearChange(e);
                FaRptAddDecrSumCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptAddDecrSumCondUI.this.fireYearChange(e);
                FaRptAddDecrSumCondUI.this.firePeriodChange(e);
            }
        });
        this.spnStartNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptAddDecrSumCondUI.this.firePeriodChange(e);
            }
        });
        this.spnEndNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptAddDecrSumCondUI.this.firePeriodChange(e);
            }
        });
        this.prmtAccountTable.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaRptAddDecrSumCondUI.this.ctsUI = null;
                    FaRptAddDecrSumCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtPeriodType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaRptAddDecrSumCondUI.this.ctsUI = null;
                    FaRptAddDecrSumCondUI.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaRptAddDecrSumCondUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAccountTable.getData() == null || this.prmtPeriodType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"condBeforeSelectCompany"));
            return;
        }
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    protected void companyChanged(Object data) {
        ArrayList<String> idList = new ArrayList<String>();
        if (data == null) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnStartYear.setModel((SpinnerModel)tmpModel);
            this.spnStartNumber.setModel((SpinnerModel)tmpModel);
            this.spnEndYear.setModel((SpinnerModel)tmpModel);
            this.spnEndNumber.setModel((SpinnerModel)tmpModel);
        } else {
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel startYear = new SpinnerNumberModel();
                SpinnerNumberModel endYear = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPeriodNumber = (Integer)periodYears.get("MaxPeriodNumber");
                startYear.setMinimum(this.minPeriodYear);
                startYear.setMaximum(this.maxPeriodYear);
                endYear.setMinimum(this.minPeriodYear);
                endYear.setMaximum(this.maxPeriodYear);
                this.spnStartYear.setModel((SpinnerModel)startYear);
                this.spnEndYear.setModel((SpinnerModel)endYear);
                this.spnStartYear.setValue((Object)this.maxPeriodYear);
                this.spnEndYear.setValue((Object)this.maxPeriodYear);
                this.spnStartNumber.setValue((Object)this.maxPeriodNumber);
                this.spnEndNumber.setValue((Object)this.maxPeriodNumber);
                this.spnStartYear.setEnabled(true);
                this.spnEndYear.setEnabled(true);
                this.spnStartNumber.setEnabled(true);
                this.spnEndNumber.setEnabled(true);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        this.companyList = idList;
    }

    private void fireYearChange(ChangeEvent e) {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = e.getSource() == this.spnStartYear ? this.spnStartYear.getIntegerVlaue().intValue() : this.spnEndYear.getIntegerVlaue().intValue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPeriodNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            if (e.getSource() == this.spnStartYear) {
                this.spnStartNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
                this.spnStartNumber.setValue((Object)minPeriod);
            } else {
                this.spnEndNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
                this.spnEndNumber.setValue((Object)minPeriod);
            }
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartNumber) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndNumber.setValue(this.spnStartNumber.getValue());
            } else if (!this.isLoadData) {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartNumber.setValue(this.spnEndNumber.getValue());
            }
        }
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }
}

