/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FaRptCardSublegerPrint
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(FaRptCardSublegerPrint.class);
    JdbcRowSet rowSet;
    DynamicRowSet dRowSet;
    DynamicRowSet oldRowSet;
    String rptPeriod;
    String companyName;
    String header;
    String cardNumber;
    String cardName;
    String[] colNames = new String[]{"bizDate", "brief", "bizNumber", "vouchernumber", "assetnumber", "oldernumber", "assetname", "unit", "assetAmt", "currency", "FexRate", "FOriginAmt", "FAddons", "FassetValue", "valueDebit", "valueCredit", "valueBal", "deprDebit", "deprCredit", "deprBal", "netValue", "devalueDebit", "devalueCredit", "devalueBal", "netAmount", "cardNumber", "cardName", "ADMINNUM", "ADMINDEPARTMENT", "abstract", "FACURCARDID"};
    String[] title = new String[]{"companyName", "period", "header", "useYears"};
    String[] amountCols = new String[]{"FOriginAmt", "FAddons", "FassetValue", "valueDebit", "valueCredit", "valueBal", "deprDebit", "deprCredit", "deprBal", "netValue", "devalueDebit", "devalueCredit", "devalueBal", "netAmount"};
    String[] normalCols = new String[]{"brief", "bizNumber", "vouchernumber", "assetnumber", "oldernumber", "assetname", "unit", "currency", "ADMINNUM", "ADMINDEPARTMENT", "abstract"};
    BigDecimal lastValueBal;
    BigDecimal lastDeprBal;
    BigDecimal lastDevalueBal;
    int basePrecision = 2;

    public FaRptCardSublegerPrint(IRowSet rowSet, String rptPeriod, String companyName, String title) {
        this.oldRowSet = (DynamicRowSet)rowSet;
        this.rptPeriod = rptPeriod;
        this.companyName = companyName;
        this.header = title;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        this.dealRowSet();
        return this.dRowSet;
    }

    private void dealRowSet() {
        try {
            int i;
            this.basePrecision = FaClientUtils.getCurrencyScale();
            HashMap faParameter = FaClientUtils.getFAParameter((BOSUuid)SysContext.getSysContext().getCurrentFIUnit().getId());
            int quantityScale = Integer.valueOf(faParameter.get("FA_008") == null ? "0" : (String)faParameter.get("FA_008"));
            this.dRowSet = new DynamicRowSet(this.colNames.length + this.title.length);
            for (i = 1; i <= this.colNames.length; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.colNames[i - 1];
                ci.nullable = 1;
                this.dRowSet.setColInfo(i, ci);
            }
            i = this.colNames.length + 1;
            for (int j = 0; j < this.title.length; ++j) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.title[j];
                ci.nullable = 1;
                this.dRowSet.setColInfo(i, ci);
                ++i;
            }
            this.oldRowSet.beforeFirst();
            HashSet<String> curCardIDSet = new HashSet<String>();
            while (this.oldRowSet.next()) {
                String cardID = this.oldRowSet.getString("FACURCARDID");
                if (cardID == null || cardID.trim().length() <= 0) continue;
                curCardIDSet.add(cardID);
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("number"));
            evi.getSelector().add(new SelectorItemInfo("useYears"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("id", curCardIDSet, CompareType.INCLUDE));
            evi.setFilter(filter);
            FaCurCardCollection cardColl = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection(evi);
            this.dRowSet.beforeFirst();
            this.oldRowSet.beforeFirst();
            int oldRsCount = 0;
            while (!this.oldRowSet.isLast()) {
                this.dRowSet.moveToInsertRow();
                FaRptCardSublegerPrint.clearRow((IRowSet)this.dRowSet);
                this.oldRowSet.next();
                this.dRowSet.updateString("companyName", this.companyName);
                this.dRowSet.updateString("period", this.rptPeriod);
                this.dRowSet.updateString("header", this.header);
                this.dRowSet.updateString("cardNumber", this.oldRowSet.getString("cardNumber"));
                this.dRowSet.updateString("cardName", this.oldRowSet.getString("cardName"));
                this.dRowSet.updateString("FACURCARDID", this.oldRowSet.getString("FACURCARDID"));
                int size = cardColl.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    FaCurCardInfo card = cardColl.get(i2);
                    if (!card.getId().toString().equals(this.oldRowSet.getString("FACURCARDID"))) continue;
                    this.dRowSet.updateString("useYears", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"11_FaRptCardSublegerPrint"), card.getUseYears()));
                }
                for (int j = 0; j < this.colNames.length; ++j) {
                    int i3;
                    for (i3 = 0; i3 < this.amountCols.length; ++i3) {
                        if (!this.colNames[j].equals(this.amountCols[i3]) || this.oldRowSet.getObject(this.colNames[j]) == null) continue;
                        BigDecimal amount = new BigDecimal(this.oldRowSet.getObject(this.colNames[j]).toString());
                        amount = amount.setScale(this.basePrecision, 4);
                        this.dRowSet.updateString(this.colNames[j], FaRptCardSublegerPrint.transBigDecimalToStr(amount));
                    }
                    if ("assetAmt".equals(this.colNames[j]) && this.oldRowSet.getObject(this.colNames[j]) != null) {
                        BigDecimal quantity = new BigDecimal(this.oldRowSet.getObject(this.colNames[j]).toString());
                        quantity = quantity.setScale(quantityScale, 4);
                        this.dRowSet.updateString(this.colNames[j], FaRptCardSublegerPrint.transBigDecimalToStr(quantity));
                    }
                    if ("FexRate".equals(this.colNames[j]) && this.oldRowSet.getObject(this.colNames[j]) != null) {
                        BigDecimal exRate = new BigDecimal(this.oldRowSet.getObject(this.colNames[j]).toString());
                        exRate = exRate.setScale((int)new Integer(this.oldRowSet.getObject("Fcurrencypre").toString()), 4);
                        this.dRowSet.updateString(this.colNames[j], FaRptCardSublegerPrint.transBigDecimalToStr(exRate));
                    }
                    if ("bizDate".equals(this.colNames[j]) && this.oldRowSet.getObject(this.colNames[j]) != null) {
                        Date bizDate = this.oldRowSet.getDate(this.colNames[j]);
                        this.dRowSet.updateString(this.colNames[j], FaRptCardSublegerPrint.transDateToStr(bizDate));
                    }
                    for (i3 = 0; i3 < this.normalCols.length; ++i3) {
                        if (!this.colNames[j].equals(this.normalCols[i3]) && this.oldRowSet.getObject(this.colNames[j]) != null) continue;
                        this.dRowSet.updateString(this.colNames[j], this.oldRowSet.getObject(this.colNames[j]) == null ? "" : this.oldRowSet.getObject(this.colNames[j]).toString());
                    }
                }
                this.setAmtFields(this.oldRowSet, this.dRowSet);
                if (this.oldRowSet.getObject("BILLID") == null) {
                    this.dRowSet.updateString("assetnumber", null);
                    this.dRowSet.updateString("assetname", null);
                } else {
                    this.dRowSet.updateString("cardNumber", this.dRowSet.getString("assetnumber"));
                    this.dRowSet.updateString("cardName", this.dRowSet.getString("assetname"));
                }
                this.dRowSet.insertRow();
                ++oldRsCount;
            }
            this.dRowSet.beforeFirst();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void setAmtFields(DynamicRowSet rowSet, DynamicRowSet dRowSet) throws SQLException {
        BigDecimal valueBal = new BigDecimal(-1);
        BigDecimal deprBal = new BigDecimal(-1);
        BigDecimal devalueBal = new BigDecimal(-1);
        if (!rowSet.isFirst() && rowSet.getObject("BILLID") != null) {
            BigDecimal valueDebit = new BigDecimal(rowSet.getObject("valueDebit").toString());
            BigDecimal valueCredit = new BigDecimal(rowSet.getObject("valueCredit").toString());
            dRowSet.updateString("valueBal", FaRptCardSublegerPrint.transBigDecimalToStr(this.lastValueBal.add(valueDebit).subtract(valueCredit).setScale(this.basePrecision, 4)));
            valueBal = this.lastValueBal.add(valueDebit).subtract(valueCredit);
            BigDecimal deprDebit = new BigDecimal(rowSet.getObject("deprDebit").toString());
            BigDecimal deprCredit = new BigDecimal(rowSet.getObject("deprCredit").toString());
            dRowSet.updateString("deprBal", FaRptCardSublegerPrint.transBigDecimalToStr(this.lastDeprBal.add(deprCredit).subtract(deprDebit).setScale(this.basePrecision, 4)));
            deprBal = this.lastDeprBal.add(deprCredit).subtract(deprDebit);
            BigDecimal devalueDebit = new BigDecimal(rowSet.getObject("devalueDebit").toString());
            BigDecimal devalueCredit = new BigDecimal(rowSet.getObject("devalueCredit").toString());
            dRowSet.updateString("devalueBal", FaRptCardSublegerPrint.transBigDecimalToStr(this.lastDevalueBal.add(devalueCredit).subtract(devalueDebit).setScale(this.basePrecision, 4)));
            devalueBal = this.lastDevalueBal.add(devalueCredit).subtract(devalueDebit);
        }
        if (rowSet.getObject("valueBal") != null) {
            BigDecimal bigDecimal = valueBal = new BigDecimal(-1).compareTo(valueBal) == 0 ? new BigDecimal(rowSet.getObject("valueBal").toString()) : valueBal;
        }
        if (rowSet.getObject("deprBal") != null) {
            BigDecimal bigDecimal = deprBal = new BigDecimal(-1).compareTo(deprBal) == 0 ? new BigDecimal(rowSet.getObject("deprBal").toString()) : deprBal;
        }
        if (rowSet.getObject("devalueBal") != null) {
            devalueBal = new BigDecimal(-1).compareTo(devalueBal) == 0 ? new BigDecimal(rowSet.getObject("devalueBal").toString()) : devalueBal;
        }
        this.lastValueBal = valueBal;
        this.lastDeprBal = deprBal;
        this.lastDevalueBal = devalueBal;
        if (valueBal.compareTo(new BigDecimal(-1)) != 0 || deprBal.compareTo(new BigDecimal(-1)) != 0 || devalueBal.compareTo(new BigDecimal(-1)) != 0) {
            dRowSet.updateString("netValue", FaRptCardSublegerPrint.transBigDecimalToStr(valueBal.subtract(deprBal).setScale(this.basePrecision, 4)));
            dRowSet.updateString("netAmount", FaRptCardSublegerPrint.transBigDecimalToStr(valueBal.subtract(deprBal).subtract(devalueBal).setScale(this.basePrecision, 4)));
        }
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private static String transBigDecimalToStr(BigDecimal val) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        int scale = val.scale();
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }

    private static String transDateToStr(java.util.Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)CtrlFormatUtilities.getDateFormat();
        return dateFormat.format(date);
    }
}

