/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaRptComposingUI;
import com.kingdee.eas.fi.fa.rpt.client.FaComposingCondUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptBaseUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.fi.fa.rpt.client.IDNode;
import com.kingdee.eas.fi.fa.rpt.client.TreeColumn;
import com.kingdee.eas.fi.fa.rpt.client.TreeIdsList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.StringEnum;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaRptComposingUI
extends AbstractFaRptComposingUI {
    private static final long serialVersionUID = -6556245103805410056L;
    private BigDecimal totalAssetValue;
    private static BigDecimal HUNDRED = new BigDecimal("100.00");
    protected static final String SUM_OPTION = "sumOption";
    private GetIdThreadForSpec getAllIdThread = null;
    private static final Logger logger = CoreUIObject.getLogger(FaRptComposingUI.class);
    private BigDecimal lastTotal = new BigDecimal(0.0);

    public FaRptComposingUI() throws Exception {
        this.btnViewCard.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.menuItemViewCard.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.actionViewCard.setEnabled(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.hideDefColumn();
    }

    @Override
    protected void initCommonQueryDialog() throws Exception {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(330);
        this.commonQueryDialog.setWidth(540);
    }

    @Override
    protected void applyData(Map result) throws Exception {
        this.totalAssetValue = (BigDecimal)result.get("totalAssetValue");
        super.applyData(result);
    }

    @Override
    protected void popFilterDialog() throws Exception {
        super.popFilterDialog();
        this.setTabHeader();
    }

    @Override
    protected void initTable() {
        super.initTable();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                boolean isSelelcted = FaRptComposingUI.this.tblMain.getSelectManager().get() != null;
                int selectRow = FaRptComposingUI.this.tblMain.getSelectManager().get().getBeginRow();
                boolean bl = isSelelcted = isSelelcted && selectRow != -1;
                if (FaRptComposingUI.this.tblMain.getRow(selectRow) == null) {
                    return;
                }
                ICell cardIdCell = FaRptComposingUI.this.tblMain.getRow(selectRow).getCell("CardID");
                ICell companyIdCell = FaRptComposingUI.this.tblMain.getRow(selectRow).getCell("COMPANY_ID");
                isSelelcted = isSelelcted && cardIdCell != null && cardIdCell.getValue() != null && companyIdCell != null && companyIdCell.getValue() != null;
                FaRptComposingUI.this.actionViewCard.setEnabled(isSelelcted);
            }
        });
    }

    @Override
    protected void initTableColumn(List sumColumnNames) {
        super.initTableColumn(sumColumnNames);
        this.tblMain.getColumn("cardNum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("cardNum").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)this.getQuantityScale()));
        this.tblMain.getColumn("typeRate").setWidth(120);
        if (!this.isVirCompany) {
            this.tblMain.getColumn(0).setWidth(140);
            this.tblMain.getColumn("ASSETNUMBER").setWidth(140);
            this.tblMain.getColumn("ASSETNAME").setWidth(140);
        }
        this.hideDefColumn();
    }

    @Override
    protected void afterFillTableRow(IRow row, int rowIndex) {
        boolean noTree = false;
        if (this.getCustomCond().get(SUM_OPTION) != null) {
            FaSumOptnObject so = (FaSumOptnObject)((List)this.getCustomCond().get(SUM_OPTION)).get(0);
            boolean bl = noTree = "storeCity".equals(so.getFieldName()) || so.getFieldName().startsWith("def_");
        }
        if (this.isVirCompany || noTree) {
            BigDecimal assetValue = (BigDecimal)row.getCell("assetValue").getValue();
            if (assetValue == null) {
                assetValue = new BigDecimal("0");
            }
            if (TOTAL.equals(row.getCell(0).getValue())) {
                row.getCell("typeRate").setValue(null);
            } else {
                BigDecimal sumAssetValue = (BigDecimal)row.getCell("typeRate").getValue();
                if (sumAssetValue == null) {
                    sumAssetValue = new BigDecimal("0");
                }
                if (sumAssetValue.doubleValue() == 0.0) {
                    row.getCell("typeRate").setValue((Object)(HUNDRED + "%"));
                } else {
                    row.getCell("typeRate").setValue((Object)(assetValue.multiply(HUNDRED).divide(sumAssetValue, 2, 4) + "%"));
                }
            }
            if (this.totalAssetValue != null) {
                if (this.totalAssetValue.doubleValue() == 0.0) {
                    row.getCell("rate").setValue((Object)(HUNDRED + "%"));
                } else {
                    row.getCell("rate").setValue((Object)(assetValue.multiply(HUNDRED).divide(this.totalAssetValue, 2, 4) + "%"));
                }
            }
        } else {
            BigDecimal assetValue;
            IRow fatherRow = null;
            IDNode curNode = (IDNode)row.getCell(this.getTreeColumn().getColumnName()).getUserObject();
            if (curNode != null) {
                BigDecimal assetValue2;
                if (curNode.getFather() != null) {
                    for (int i = rowIndex; i > 0; --i) {
                        IDNode tempNode;
                        if (this.tblMain.getRow2(i) == null || (tempNode = (IDNode)this.tblMain.getRow(i).getCell(this.getTreeColumn().getColumnName()).getUserObject()) == null || !curNode.getFather().getFID().equals(tempNode.getFID())) continue;
                        fatherRow = this.tblMain.getRow(i);
                        break;
                    }
                }
                BigDecimal fatherAssetValue = new BigDecimal(-1);
                if (fatherRow != null) {
                    fatherAssetValue = (BigDecimal)fatherRow.getCell("assetValue").getValue();
                }
                if ((assetValue2 = (BigDecimal)row.getCell("assetValue").getValue()) == null) {
                    assetValue2 = new BigDecimal("0");
                }
                if (TOTAL.equals(row.getCell(0).getValue())) {
                    row.getCell("typeRate").setValue(null);
                } else if (new BigDecimal(-1).compareTo(fatherAssetValue) == 0) {
                    row.getCell("typeRate").setValue(null);
                } else {
                    row.getCell("typeRate").setValue((Object)(assetValue2.multiply(HUNDRED).divide(fatherAssetValue, 2, 4) + "%"));
                }
                int isSum = 0;
                if (row.getCell("isSum").getValue() instanceof BigDecimal) {
                    isSum = ((BigDecimal)row.getCell("isSum").getValue()).intValue();
                } else if (row.getCell("isSum").getValue() instanceof Integer) {
                    isSum = (Integer)row.getCell("isSum").getValue();
                }
                if (isSum == 1) {
                    this.lastTotal = (BigDecimal)row.getCell("assetValue").getValue();
                }
            } else {
                assetValue = (BigDecimal)row.getCell("assetValue").getValue();
                if (assetValue == null) {
                    assetValue = new BigDecimal("0");
                }
                if (TOTAL.equals(row.getCell(0).getValue())) {
                    row.getCell("typeRate").setValue(null);
                } else {
                    if (this.lastTotal == null) {
                        this.lastTotal = new BigDecimal("0");
                    }
                    if (this.lastTotal.doubleValue() == 0.0) {
                        row.getCell("typeRate").setValue((Object)(HUNDRED + "%"));
                    } else {
                        row.getCell("typeRate").setValue((Object)(assetValue.multiply(HUNDRED).divide(this.lastTotal, 2, 4) + "%"));
                    }
                }
            }
            if (this.totalAssetValue != null) {
                assetValue = (BigDecimal)row.getCell("assetValue").getValue();
                if (assetValue == null) {
                    assetValue = new BigDecimal("0");
                }
                if (this.totalAssetValue.doubleValue() == 0.0) {
                    row.getCell("rate").setValue((Object)(HUNDRED + "%"));
                } else {
                    row.getCell("rate").setValue((Object)(assetValue.multiply(HUNDRED).divide(this.totalAssetValue, 2, 4) + "%"));
                }
            }
        }
    }

    private void setTabHeader() {
        String typeRate = ((StringEnum)((FaComposingCondUI)this.conditionPanel).cbxComposeMode.getSelectedItem()).getAlias();
        String inThis = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"inThis"), typeRate);
        this.tblMain.getHeadRow(0).getCell("typeRate").setValue((Object)inThis);
    }

    @Override
    protected void formatData() throws EASBizException, BOSException {
        String[] fmtColumnNames = new String[]{"assetValue"};
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])fmtColumnNames, (String)FaClientUtils.getDecimalFormat((int)this.getCurrencyScale()));
        FaClientUtils.fmtAssetAmt((KDTable)this.tblMain, (String)"ASSETAMT");
    }

    @Override
    public void actionViewCard_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().get() == null) {
            return;
        }
        int selectRow = this.tblMain.getSelectManager().get().getBeginRow();
        if (selectRow == -1) {
            return;
        }
        ICell cardIdCell = this.tblMain.getRow(selectRow).getCell("CardID");
        ICell companyIdCell = this.tblMain.getRow(selectRow).getCell("COMPANY_ID");
        if (cardIdCell == null || cardIdCell.getValue() == null || companyIdCell == null || companyIdCell.getValue() == null) {
            return;
        }
        String cardId = cardIdCell.getValue().toString();
        String companyId = companyIdCell.getValue().toString();
        if (cardId != null && !cardId.trim().equals("")) {
            try {
                this.viewCardUI(cardId, companyId);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    @Override
    protected TreeColumn getTreeColumn() {
        TreeColumn treeColumn = null;
        if (this.isVirCompany) {
            String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"orgArchitecture");
            treeColumn = new TreeColumn(0, "orgArchitecture", title);
        } else if (this.getCustomCond().get(SUM_OPTION) != null) {
            FaSumOptnObject sumOptnObj = (FaSumOptnObject)((List)this.getCustomCond().get(SUM_OPTION)).get(0);
            if ("assetCat".equals(sumOptnObj.getFieldName())) {
                String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetCat");
                treeColumn = new TreeColumn(0, "assetCat", title, "assetCat", 0);
            } else if ("asstActItem".equals(sumOptnObj.getFieldName())) {
                String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"asstActItem");
                treeColumn = new TreeColumn(0, "asstActItem", title, "asstActItem", 0);
            } else if ("useStatus".equals(sumOptnObj.getFieldName())) {
                String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useStatus");
                treeColumn = new TreeColumn(0, "useStatus", title, "useStatus", 0);
            } else if ("useDepartment".equals(sumOptnObj.getFieldName())) {
                String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useDepartment");
                treeColumn = new TreeColumn(0, "useDepartment", title, "useDepartment", 0);
            } else if ("economicPurp".equals(sumOptnObj.getFieldName())) {
                String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"economicPurp");
                treeColumn = new TreeColumn(0, "economicPurp", title, "economicPurp", 0);
            } else if ("originMethod".equals(sumOptnObj.getFieldName())) {
                String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"originMethod");
                treeColumn = new TreeColumn(0, "originMethod", title, "originMethod", 0);
            }
        }
        return treeColumn;
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"faComposingRpt");
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaComposingCondUI();
    }

    @Override
    protected boolean isShowFilter() {
        return false;
    }

    @Override
    protected boolean isShowSorter() {
        return false;
    }

    @Override
    protected boolean isAllowVirtualOrg() {
        return true;
    }

    @Override
    protected String getQueryName() {
        return "FaListNewQuery";
    }

    @Override
    protected String getDaoClassName() {
        return "FaComposingDao";
    }

    @Override
    protected void handleFirstLoadData(int start, int length) throws BOSException, Exception {
        IRowSet rowSet;
        IFaList manager = FaListFactory.getRemoteInstance();
        if (this.getTreeColumn() != null) {
            int topLevel = this.getTreeColumn().getTopLevel();
            int specLevel = (Integer)this.getCustomCond().get("defCompanyLevel") - 1;
            rowSet = manager.getTreeDataForFirstSpec(this.resultSql, length, topLevel, specLevel);
        } else {
            rowSet = manager.getDataForFirst(this.resultSql, length);
        }
        if (this.getTreeColumn() != null) {
            int specLevel = (Integer)this.getCustomCond().get("defCompanyLevel") - 1;
            this.treeIdList = new TreeIdsList(this.getTreeColumn().getTopLevel());
            this.treeIdList.initNode(this.resultSql, specLevel);
            this.tblMain.setRowCount(this.treeIdList.getViewRowCount());
        }
        this.tblMain.addRows(rowSet.size());
        this.fillDataToTable(rowSet, start);
        if (rowSet.size() == length || this.getTreeColumn() != null) {
            this.getAllDataOfId();
        }
    }

    @Override
    protected void getAllDataOfId() {
        this.getAllIdThread = new GetIdThreadForSpec(this);
        this.getAllIdThread.setDaemon(true);
        this.getAllIdThread.start();
        Date nowEnd = new Date();
        logger.debug((Object)("getAllDataOfId end at : " + nowEnd));
    }

    @Override
    protected void setProperNodeOpen(IDNode node) {
        int specLevel = (Integer)this.getCustomCond().get("defCompanyLevel") - 1;
        if (node.getLevel() <= specLevel + this.getTreeColumn().getTopLevel() - 1) {
            node.setOpen(true);
        }
    }

    class GetIdThreadForSpec
    extends Thread {
        FaRptBaseUI baseUi;

        public GetIdThreadForSpec(FaRptBaseUI baseUI) {
            this.baseUi = baseUI;
        }

        @Override
        public void run() {
            try {
                int specLevel = (Integer)FaRptComposingUI.this.getCustomCond().get("defCompanyLevel") - 1;
                if (FaRptComposingUI.this.tempTableName == null || !FaRptComposingUI.this.tempTableName.equals(FaRptComposingUI.this.resultSql.getFrom())) {
                    return;
                }
                if (FaRptComposingUI.this.getTreeColumn() != null) {
                    FaRptComposingUI.this.treeIdList = new TreeIdsList(FaRptComposingUI.this.getTreeColumn().getTopLevel());
                    FaRptComposingUI.this.treeIdList.initNode(FaRptComposingUI.this.resultSql, specLevel);
                    FaRptComposingUI.this.tblMain.setRowCount(FaRptComposingUI.this.treeIdList.getViewRowCount());
                } else {
                    FaRptComposingUI.this.allIdList = new ArrayList();
                    if (FaRptComposingUI.this.tempTableName != null) {
                        IFaList manager = FaListFactory.getRemoteInstance();
                        IRowSet ids = manager.getIdList(FaRptComposingUI.this.resultSql);
                        while (ids != null && ids.next()) {
                            FaRptComposingUI.this.allIdList.add(ids.getString("FId"));
                        }
                    }
                    if (FaRptComposingUI.this.allIdList != null) {
                        FaRptComposingUI.this.tblMain.setRowCount(FaRptComposingUI.this.allIdList.size());
                    }
                }
                FaRptComposingUI.this.setButtonEnabled(true);
            }
            catch (Exception ex) {
                FaRptComposingUI.this.setButtonEnabled(true);
                this.baseUi.handUIExceptionAndAbort(ex);
            }
        }
    }
}

