/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaRptDeprDpmtUI;
import com.kingdee.eas.fi.fa.rpt.client.FaDeprDpmtRptCondUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public class FaRptDeprDpmtUI
extends AbstractFaRptDeprDpmtUI {
    private static final long serialVersionUID = -5129122029651236636L;
    private static final String[] localAmtColumns = new String[]{"RealBeginBalanceFor", "DepreBeginBalanceFor", "beginNetvalue", "DecValueBeginBalanceFor", "beginNetAmount", "OriginDif", "AccuDeprChg", "DecValueChg", "ShouldDepre", "Depreciation", "AddUpYearDepre", "RealEndBalanceFor", "DepreEndBalanceFor", "endNetValue", "DecValueEndBalanceFor", "endNetAmount"};

    @Override
    protected void initTable() {
        super.initTable();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    int start = e.getFirstRow();
                    int end = e.getLastRow();
                    if (((Boolean)FaRptDeprDpmtUI.this.getCustomCond().get("detailstyle")).booleanValue()) {
                        FaRptDeprDpmtUI.this.setCellFormat("USETERMCOUNT", start, end);
                        FaRptDeprDpmtUI.this.setCellFormat("DEPRTERMCOUNT", start, end);
                    }
                }
                catch (Exception ex) {
                    FaRptDeprDpmtUI.this.handUIException(ex);
                }
            }
        });
    }

    @Override
    protected void initCommonQueryDialog() throws Exception {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setWidth(520);
        this.commonQueryDialog.setHeight(400);
    }

    @Override
    protected void initTableColumn(List sumColumnNames) {
        super.initTableColumn(sumColumnNames);
        boolean detailstyle = (Boolean)this.getCustomCond().get("detailstyle");
        this.setTableHeader(this.tblMain);
        if (!detailstyle) {
            this.tblMain.removeColumn(this.tblMain.getColumn("ASSETCAT_NAME").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("ASSETNUMBER").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("oldNumber").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("GROUPNUMBER").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("assetname").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("SPECS").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("USETERMCOUNT").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("DEPRTERMCOUNT").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("DEPRMETHOD_NAME").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("DEPRMETHOD_NUMBER").getColumnIndex());
            this.tblMain.removeColumn(this.tblMain.getColumn("MonthDepreRate").getColumnIndex());
        } else if (this.sumOption.isHasFaCatSum()) {
            this.tblMain.removeColumn(this.tblMain.getColumn("ASSETCAT_NAME").getColumnIndex());
        }
    }

    private void setTableHeader(KDTable tblMain) {
        boolean displayEvalData = (Boolean)this.getCustomCond().get("displayEvalData");
        boolean detailstyle = (Boolean)this.getCustomCond().get("detailstyle");
        if (displayEvalData) {
            for (int i = tblMain.getColumnIndex("RealBeginBalanceFor"); i < tblMain.getColumnCount() - 1; ++i) {
                String headName = tblMain.getHead().getRow(0).getCell(i).getValue().toString();
                tblMain.getHead().getRow(0).getCell(i).setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"evalHead"), headName));
            }
            if (detailstyle) {
                String headName = tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("DEPRMETHOD_NAME")).getValue().toString();
                tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("DEPRMETHOD_NAME")).setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"evalHead"), headName));
                headName = tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("MonthDepreRate")).getValue().toString();
                tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("MonthDepreRate")).setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"evalHead"), headName));
            }
        } else {
            for (int i = tblMain.getColumnIndex("RealBeginBalanceFor"); i < tblMain.getColumnCount() - 1; ++i) {
                String headName = tblMain.getHead().getRow(0).getCell(i).getValue().toString();
                tblMain.getHead().getRow(0).getCell(i).setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"accountHead"), headName));
            }
            if (detailstyle) {
                String headName = tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("DEPRMETHOD_NAME")).getValue().toString();
                tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("DEPRMETHOD_NAME")).setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"accountHead"), headName));
                headName = tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("MonthDepreRate")).getValue().toString();
                tblMain.getHead().getRow(0).getCell(tblMain.getColumnIndex("MonthDepreRate")).setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"accountHead"), headName));
            }
        }
    }

    @Override
    protected void formatData() throws EASBizException, BOSException {
        if (((Boolean)this.getCustomCond().get("detailstyle")).booleanValue()) {
            this.tblMain.getColumn("USETERMCOUNT").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("DEPRTERMCOUNT").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("MonthDepreRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("MonthDepreRate").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)this.getDeprScale()));
        }
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])localAmtColumns, (String)FaClientUtils.getDecimalFormat((int)this.getCurrencyScale()));
    }

    @Override
    protected void afterFillTableRow(IRow row, int rowIndex) {
        Object objBasePrec = row.getCell("BASEPREC").getValue();
        if (objBasePrec != null && objBasePrec.toString().trim().length() > 0) {
            String strFormat = FaClientUtils.getDecimalFormat((int)Integer.parseInt(objBasePrec.toString().trim()));
            for (int i = 0; i < localAmtColumns.length; ++i) {
                row.getCell(localAmtColumns[i]).getStyleAttributes().setNumberFormat(strFormat);
            }
        }
    }

    @Override
    protected void execute(boolean refresh) throws Exception {
        super.execute(refresh);
        if (Boolean.TRUE.equals(this.result.get("hasNoAudit"))) {
            MsgBox.showInfo((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"alreadyDepr"));
        }
    }

    private void setCellFormat(String columnName, int start, int end) {
        for (int i = start; i <= end; ++i) {
            int scale = 0;
            Object methodNumber = this.tblMain.getRow(i).getCell("DEPRMETHOD_NUMBER").getValue();
            if ("002".equals(methodNumber)) {
                scale = 2;
            }
            this.tblMain.getRow(i).getCell(columnName).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)scale));
        }
    }

    @Override
    protected void displayPeriodInfo() {
        String year = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"periodYear");
        String month = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"periodNumber");
        String strNo = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"ordinal");
        Map customCond = this.getCustomCond();
        String period = customCond.get("startNumber").equals(customCond.get("endNumber")) && customCond.get("startYear").equals(customCond.get("endYear")) ? MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), customCond.get("startYear"), customCond.get("startNumber")) : MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayTerm"), customCond.get("startYear"), customCond.get("startNumber"), customCond.get("endYear"), customCond.get("endNumber"));
        this.lblPeriodValue.setText(period);
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"93_FaRptDeprDpmtUI");
    }

    @Override
    protected int getTableHeadRowCounts() {
        return 2;
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaDeprDpmtRptCondUI();
    }

    @Override
    protected String getQueryName() {
        return "DeprRptQuery";
    }

    @Override
    protected String getDaoClassName() {
        return "FaDeprDepartDao";
    }

    @Override
    protected boolean isAllowVirtualOrg() {
        return false;
    }
}

