/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.fi.fa.basedata.FaContractCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaContractCatInfo;
import com.kingdee.eas.fi.fa.basedata.client.FaContractCatPromptBox;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaRptLeaseInNewStatusConditionUI;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FLCompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class FaRptLeaseInNewStatusConditionUI
extends AbstractFaRptLeaseInNewStatusConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(FaRptLeaseInNewStatusConditionUI.class);
    private static final String COMPANY = "company";
    private CompanyTreeSelectUI ctsUI;
    protected static final String START_PERIOD_YEAR = "startYear";
    protected static final String START_PERIOD_NUMBER = "startNumber";
    protected static final String END_PERIOD_YEAR = "endYear";
    protected static final String END_PERIOD_NUMBER = "endNumber";
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;

    public FaRptLeaseInNewStatusConditionUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            this.boxCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.spnStartYear.setEnabled(true);
            this.spnStartNumber.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnEndNumber.setEnabled(true);
            this.btnCompany.setVisible(false);
            this.boxCompany.setData((Object)this.currCompany.getName());
            this.boxCompany.setEnabled(false);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FaContractCatPromptBox faContractCatPromptBox = new FaContractCatPromptBox((CoreUIObject)this);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurrentCompany().getId().toString()));
            view.setFilter(filter);
            this.boxContractCat.setSelector((KDPromptSelector)faContractCatPromptBox);
            this.boxContractCat.setEntityViewInfo(view);
            NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
            costCenterF7.setNeedAddOrgRange(true);
            this.boxCostCenter.setSelector((KDPromptSelector)costCenterF7);
            NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
            this.boxUseDepartment.setSelector((KDPromptSelector)adminF7);
        }
        this.boxCompany.setEnabled(false);
    }

    @Override
    protected void setDefaultData() throws Exception {
        if (this.isVirCompany) {
            this.boxCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.boxCompany.setData((Object)this.currCompany.getName());
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
            PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
            Integer minYear = startPeriodInfo.getPeriodYear();
            Integer maxYear = currentPeriodInfo.getPeriodYear();
            SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
            startYearSpinnerNumberModel.setMinimum(minYear);
            startYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
            SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
            endYearSpinnerNumberModel.setMinimum(minYear);
            endYearSpinnerNumberModel.setMaximum(maxYear);
            this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
            Integer defaultYear = currentPeriodInfo.getPeriodYear();
            Integer defaultNumber = currentPeriodInfo.getPeriodNumber();
            this.spnStartYear.setValue((Object)defaultYear);
            this.spnEndYear.setValue((Object)defaultYear);
            this.spnStartNumber.setValue((Object)defaultNumber);
            this.spnEndNumber.setValue((Object)defaultNumber);
        }
        this.RadioExpire.setSelected(false);
        this.RadioExpireNG.setSelected(false);
        this.RadioExpireALL.setSelected(true);
        this.RadioExempt.setSelected(false);
        this.RadioExemptNG.setSelected(false);
        this.RadioExemptALL.setSelected(true);
        this.RadioCompany.setSelected(true);
        this.includeTerminateBill.setSelected(false);
        this.includeChangeBill.setSelected(false);
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    @Override
    protected Map<String, Object> getCustomCond() {
        HashMap<String, Object> customCond = new HashMap<String, Object>();
        if (this.isVirCompany) {
            customCond.put(COMPANY, this.boxCompany.getData());
        }
        customCond.put("beginDateFrom", this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue());
        customCond.put("beginDateTo", this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue());
        customCond.put("contractCat", this.boxContractCat.getData());
        customCond.put("costCenter", this.boxCostCenter.getData());
        customCond.put("useDepartment", this.boxUseDepartment.getData());
        customCond.put("expired", this.RadioExpire.isSelected());
        customCond.put("expireNG", this.RadioExpireNG.isSelected());
        customCond.put("expireALL", this.RadioExpireALL.isSelected());
        customCond.put("exempted", this.RadioExempt.isSelected());
        customCond.put("exemptNG", this.RadioExemptNG.isSelected());
        customCond.put("exemptALL", this.RadioExemptALL.isSelected());
        customCond.put("companyGroup", this.RadioCompany.isSelected());
        customCond.put("currencyGroup", this.RadioCurrency.isSelected());
        customCond.put("lessorTypeGroup", this.RadioLessorType.isSelected());
        customCond.put("lessorGroup", this.RadioLessor.isSelected());
        customCond.put("includeTerminateBill", this.includeTerminateBill.isSelected());
        customCond.put("includeChangeBill", this.includeChangeBill.isSelected());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = new CustomerParams();
        if (this.isVirCompany) {
            TreeNode treeNode = (TreeNode)this.boxCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
        }
        int dateBeginFrom = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        int dateBeginTo = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue();
        FaContractCatInfo catInfo = (FaContractCatInfo)this.boxContractCat.getData();
        CostCenterOrgUnitInfo ccInfo = (CostCenterOrgUnitInfo)this.boxCostCenter.getData();
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.boxUseDepartment.getData();
        params.addCustomerParam("dateBeginFrom", String.valueOf(dateBeginFrom));
        params.addCustomerParam("dateBeginTo", String.valueOf(dateBeginTo));
        if (catInfo != null) {
            params.addCustomerParam("contractCat.id", catInfo.getId().toString());
            params.addCustomerParam("contractCat.name", catInfo.getName().toString());
        }
        if (ccInfo != null) {
            params.addCustomerParam("costCenter.id", ccInfo.getId().toString());
            params.addCustomerParam("costCenter.name", ccInfo.getName());
        }
        if (adminInfo != null) {
            params.addCustomerParam("useDepartment.id", adminInfo.getId().toString());
            params.addCustomerParam("useDepartment.name", adminInfo.getName());
        }
        params.putBoolean("expired", Boolean.valueOf(this.RadioExpire.isSelected()).booleanValue());
        params.putBoolean("expireNG", Boolean.valueOf(this.RadioExpireNG.isSelected()).booleanValue());
        params.putBoolean("expireALL", Boolean.valueOf(this.RadioExpireALL.isSelected()).booleanValue());
        params.putBoolean("exempted", Boolean.valueOf(this.RadioExempt.isSelected()).booleanValue());
        params.putBoolean("exemptNG", Boolean.valueOf(this.RadioExemptNG.isSelected()).booleanValue());
        params.putBoolean("exemptALL", Boolean.valueOf(this.RadioExemptALL.isSelected()).booleanValue());
        params.putBoolean("companyGroup", Boolean.valueOf(this.RadioCompany.isSelected()).booleanValue());
        params.putBoolean("currencyGroup", Boolean.valueOf(this.RadioCurrency.isSelected()).booleanValue());
        params.putBoolean("lessorTypeGroup", Boolean.valueOf(this.RadioLessorType.isSelected()).booleanValue());
        params.putBoolean("lessorGroup", Boolean.valueOf(this.RadioLessor.isSelected()).booleanValue());
        params.putBoolean("includeTerminateBill", Boolean.valueOf(this.includeTerminateBill.isSelected()).booleanValue());
        params.putBoolean("includeChangeBill", Boolean.valueOf(this.includeChangeBill.isSelected()).booleanValue());
        return params;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams customCond = this.getCustomerParams();
        if (customCond != null) {
            SelectorItemCollection sic;
            if (this.isVirCompany) {
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.boxCompany.setData((Object)this.resumeCompanyTree(customCond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.boxCompany.getData());
                if (this.boxCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.boxCompany.getData());
                }
                this.spnStartYear.setValue((Object)customCond.getInt(START_PERIOD_YEAR));
                this.spnStartNumber.setValue((Object)customCond.getInt(START_PERIOD_NUMBER));
                this.spnEndYear.setValue((Object)customCond.getInt(END_PERIOD_YEAR));
                this.spnEndNumber.setValue((Object)customCond.getInt(END_PERIOD_NUMBER));
            }
            ArrayList<String> idList = new ArrayList<String>();
            Object data = this.boxCompany.getData();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            if (customCond.getCustomerParam("dateBeginFrom") != null) {
                this.spnStartYear.setValue((Object)(Integer.parseInt(customCond.getCustomerParam("dateBeginFrom")) / 100));
                this.spnStartNumber.setValue((Object)(Integer.parseInt(customCond.getCustomerParam("dateBeginFrom")) % 100));
            }
            if (customCond.getCustomerParam("dateBeginTo") != null) {
                this.spnEndYear.setValue((Object)(Integer.parseInt(customCond.getCustomerParam("dateBeginTo")) / 100));
                this.spnEndNumber.setValue((Object)(Integer.parseInt(customCond.getCustomerParam("dateBeginTo")) % 100));
            }
            if (customCond.getCustomerParam("contractCat.id") != null) {
                FaContractCatInfo catInfo = null;
                ObjectUuidPK catPk = new ObjectUuidPK(customCond.getCustomerParam("contractCat.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                try {
                    catInfo = FaContractCatFactory.getRemoteInstance().getFaContractCatInfo((IObjectPK)catPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.boxContractCat.setData((Object)catInfo);
            } else {
                this.boxContractCat.setData(null);
            }
            if (customCond.getCustomerParam("costCenter.id") != null) {
                CostCenterOrgUnitInfo ccInfo = null;
                ObjectUuidPK ccPk = new ObjectUuidPK(customCond.getCustomerParam("costCenter.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                try {
                    ccInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)ccPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.boxCostCenter.setData((Object)ccInfo);
            } else {
                this.boxCostCenter.setData(null);
            }
            if (customCond.getCustomerParam("useDepartment.id") != null) {
                AdminOrgUnitInfo adminInfo = null;
                ObjectUuidPK adminPk = new ObjectUuidPK(customCond.getCustomerParam("useDepartment.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                try {
                    adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)adminPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.boxUseDepartment.setData((Object)adminInfo);
            } else {
                this.boxUseDepartment.setData(null);
            }
            this.RadioExpire.setSelected(customCond.getBoolean("expired"));
            this.RadioExpireNG.setSelected(customCond.getBoolean("expireNG"));
            this.RadioExpireALL.setSelected(customCond.getBoolean("expireALL"));
            this.RadioExempt.setSelected(customCond.getBoolean("exempted"));
            this.RadioExemptNG.setSelected(customCond.getBoolean("exemptNG"));
            this.RadioExemptALL.setSelected(customCond.getBoolean("exemptALL"));
            this.RadioCompany.setSelected(customCond.getBoolean("companyGroup"));
            this.RadioCurrency.setSelected(customCond.getBoolean("currencyGroup"));
            this.RadioLessorType.setSelected(customCond.getBoolean("lessorTypeGroup"));
            this.RadioLessor.setSelected(customCond.getBoolean("lessorGroup"));
            this.includeTerminateBill.setSelected(customCond.getBoolean("includeTerminateBill"));
            this.includeChangeBill.setSelected(customCond.getBoolean("includeChangeBill"));
        }
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    @Override
    protected void addListener() throws Exception {
        this.RadioExpire.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaRptLeaseInNewStatusConditionUI.this.RadioExpire.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpireNG.setSelected(false);
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpireALL.setSelected(false);
                } else if (!FaRptLeaseInNewStatusConditionUI.this.RadioExpireNG.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpireALL.setSelected(true);
                }
            }
        });
        this.RadioExpireNG.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaRptLeaseInNewStatusConditionUI.this.RadioExpireNG.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpire.setSelected(false);
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpireALL.setSelected(false);
                } else if (!FaRptLeaseInNewStatusConditionUI.this.RadioExpire.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpireALL.setSelected(true);
                }
            }
        });
        this.RadioExpireALL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaRptLeaseInNewStatusConditionUI.this.RadioExpireALL.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpireNG.setSelected(false);
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpire.setSelected(false);
                } else if (!FaRptLeaseInNewStatusConditionUI.this.RadioExpire.isSelected() && !FaRptLeaseInNewStatusConditionUI.this.RadioExpireNG.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExpireALL.setSelected(true);
                }
            }
        });
        this.RadioExempt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaRptLeaseInNewStatusConditionUI.this.RadioExempt.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExemptNG.setSelected(false);
                    FaRptLeaseInNewStatusConditionUI.this.RadioExemptALL.setSelected(false);
                } else if (!FaRptLeaseInNewStatusConditionUI.this.RadioExemptNG.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExemptALL.setSelected(true);
                }
            }
        });
        this.RadioExemptNG.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaRptLeaseInNewStatusConditionUI.this.RadioExemptNG.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExempt.setSelected(false);
                    FaRptLeaseInNewStatusConditionUI.this.RadioExemptALL.setSelected(false);
                } else if (!FaRptLeaseInNewStatusConditionUI.this.RadioExempt.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExemptALL.setSelected(true);
                }
            }
        });
        this.RadioExemptALL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaRptLeaseInNewStatusConditionUI.this.RadioExemptALL.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExemptNG.setSelected(false);
                    FaRptLeaseInNewStatusConditionUI.this.RadioExempt.setSelected(false);
                } else if (!FaRptLeaseInNewStatusConditionUI.this.RadioExempt.isSelected() && !FaRptLeaseInNewStatusConditionUI.this.RadioExemptNG.isSelected()) {
                    FaRptLeaseInNewStatusConditionUI.this.RadioExemptALL.setSelected(true);
                }
            }
        });
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewStatusConditionUI.this.fireStartYearChange();
                FaRptLeaseInNewStatusConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewStatusConditionUI.this.fireEndYearChange();
                FaRptLeaseInNewStatusConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnStartNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewStatusConditionUI.this.firePeriodChange(e);
            }
        });
        this.spnEndNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaRptLeaseInNewStatusConditionUI.this.firePeriodChange(e);
            }
        });
        this.boxCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaRptLeaseInNewStatusConditionUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        this.ctsUI = new FLCompanyTreeSelectUI(this);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.boxCompany.getData());
        if (this.boxCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.boxCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaRptLeaseInNewStatusConditionUI.this.boxCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.boxCompany.getData() == null || !(this.boxCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    private void companyChanged(Object data) {
        if (data == null) {
            this.spnStartYear.setEnabled(false);
            this.spnStartNumber.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndNumber.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnStartYear.setModel((SpinnerModel)tmpModel);
            this.spnStartNumber.setModel((SpinnerModel)tmpModel);
            this.spnEndYear.setModel((SpinnerModel)tmpModel);
            this.spnEndNumber.setModel((SpinnerModel)tmpModel);
        } else {
            this.spnStartYear.setEnabled(true);
            this.spnStartNumber.setEnabled(true);
            this.spnEndYear.setEnabled(true);
            this.spnEndNumber.setEnabled(true);
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel startPeriodSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endPeriodSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodStartNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPerioEndNumber = this.minPeriodYear == this.maxPeriodYear ? (Integer)periodYears.get("MaxPeriodNumber") : Integer.valueOf(13);
                startYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                startYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
                endYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                endYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
                this.spnStartYear.setValue(periodYears.get("MaxPeriodYear"));
                this.spnEndYear.setValue(periodYears.get("MaxPeriodYear"));
                Map periodNumOfYear = FaListFactory.getRemoteInstance().findMinMaxPeriodsOfYear(this.maxPeriodYear, periodTypeID);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    startPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    startPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                startPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnStartNumber.setModel((SpinnerModel)startPeriodSpinnerNumberModel);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    endPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    endPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                endPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnEndNumber.setModel((SpinnerModel)endPeriodSpinnerNumberModel);
                this.spnStartNumber.setValue(periodYears.get("MaxPeriodNumber"));
                this.spnEndNumber.setValue(periodYears.get("MaxPeriodNumber"));
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private void fireStartYearChange() {
        String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.spnStartYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnStartNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnStartNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void fireEndYearChange() {
        String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.spnEndYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnEndNumber.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnEndNumber.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartNumber.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndNumber.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartNumber) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndNumber.setValue(this.spnStartNumber.getValue());
            } else {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartNumber.setValue(this.spnEndNumber.getValue());
            }
        }
    }
}

