/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaPayModeEnum;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseInEditUI;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaRptLeaseStatusUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptLeaseStatusCondUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public class FaRptLeaseStatusUI
extends AbstractFaRptLeaseStatusUI {
    private static final long serialVersionUID = 7324971200062498695L;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuItemViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    protected void initCommonQueryDialog() throws Exception {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(360);
        this.commonQueryDialog.setWidth(520);
    }

    @Override
    protected void initTableColumn(List sumColumnNames) {
        super.initTableColumn(sumColumnNames);
        if (this.sumOption == null) {
            return;
        }
        if (this.sumOption.isHasFaCatSum()) {
            this.tblMain.removeColumn(this.tblMain.getColumn("ASSETCAT_NAME").getColumnIndex());
        }
        if (this.sumOption.isSum("bargainNum")) {
            this.tblMain.removeColumn(this.tblMain.getColumn("bargainNum").getColumnIndex());
        }
        if (this.sumOption.isSum("lessor")) {
            this.tblMain.removeColumn(this.tblMain.getColumn("lessor").getColumnIndex());
        }
        if (this.sumOption.isSum("lessee")) {
            this.tblMain.removeColumn(this.tblMain.getColumn("lessee").getColumnIndex());
        }
    }

    @Override
    protected void initTable() {
        super.initTable();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                boolean isSelelcted = FaRptLeaseStatusUI.this.tblMain.getSelectManager().get() != null;
                int selectRow = FaRptLeaseStatusUI.this.tblMain.getSelectManager().get().getBeginRow();
                boolean bl = isSelelcted = isSelelcted && selectRow != -1;
                if (FaRptLeaseStatusUI.this.tblMain.getRow(selectRow) == null) {
                    return;
                }
                ICell cardIdCell = FaRptLeaseStatusUI.this.tblMain.getRow(selectRow).getCell("billID");
                ICell companyIdCell = FaRptLeaseStatusUI.this.tblMain.getRow(selectRow).getCell("disc");
                isSelelcted = isSelelcted && cardIdCell != null && cardIdCell.getValue() != null && companyIdCell != null && companyIdCell.getValue() != null;
                FaRptLeaseStatusUI.this.btnViewBill.setEnabled(isSelelcted);
                FaRptLeaseStatusUI.this.menuItemViewBill.setEnabled(isSelelcted);
            }
        });
    }

    @Override
    protected void displayPeriodInfo() {
    }

    @Override
    protected void formatData() throws EASBizException, BOSException {
        String[] fmtColumnNames = new String[]{"hireOriginAmt", "hireLocalAmt"};
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])fmtColumnNames, (String)FaClientUtils.getDecimalFormat((int)this.getCurrencyScale()));
        String[] dateColumnKeys = new String[]{"signatureDate", "beginDate", "endDate", "deliverDate"};
        FaRptUIUtils.fmtDate((KDTable)this.tblMain, (String[])dateColumnKeys);
        FaClientUtils.fmtAssetAmt((KDTable)this.tblMain, (String)"leaseAmt");
        String[] columnNames = new String[]{"bargainTime", "leasedTime", "remainTime"};
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])columnNames, (String)FaClientUtils.getDecimalFormat((int)0));
    }

    @Override
    protected void afterFillTableRow(IRow row, int rowIndex) {
        Object hireCurPre;
        Object payMode = row.getCell("payMode").getValue();
        if (payMode != null) {
            row.getCell("payMode").setValue((Object)FaPayModeEnum.getEnum((int)Integer.parseInt(payMode.toString())).getAlias());
        }
        DateUnitEnum measureUnit = null;
        if (row.getCell("measureUnit").getValue() != null) {
            measureUnit = DateUnitEnum.getEnum((int)Integer.parseInt(row.getCell("measureUnit").getValue().toString()));
            row.getCell("measureUnit").setValue((Object)measureUnit.getAlias());
        }
        if ((hireCurPre = row.getCell("hireCurPre").getValue()) != null) {
            String format = FaClientUtils.getDecimalFormat((int)new BigDecimal(hireCurPre.toString()).intValue());
            row.getCell("hireOriginAmt").getStyleAttributes().setNumberFormat(format);
        }
        BigDecimal bargainTime = (BigDecimal)row.getCell("bargainTime").getValue();
        Date beginDate = (Date)row.getCell("beginDate").getValue();
        Date endDate = (Date)row.getCell("endDate").getValue();
        ICell cellLeasedTime = row.getCell("leasedTime");
        ICell cellRemainTime = row.getCell("remainTime");
        if (beginDate != null && endDate != null && measureUnit != null) {
            BigDecimal leasedTime = FaClientUtils.calLeasedTime((Date)beginDate, (Date)endDate, (BigDecimal)bargainTime, (DateUnitEnum)measureUnit);
            cellLeasedTime.setValue((Object)leasedTime);
            cellRemainTime.setValue((Object)bargainTime.subtract(leasedTime));
        }
    }

    @Override
    protected void tableMouseEvent(KDTMouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.tblMain.getRow(e.getRowIndex()) == null) {
                return;
            }
            Object billID = this.tblMain.getRow(e.getRowIndex()).getCell("billID").getValue();
            Object disc = this.tblMain.getRow(e.getRowIndex()).getCell("disc").getValue();
            if (billID == null || billID.toString().length() == 0 || disc == null) {
                return;
            }
            try {
                this.viewCardUI(billID.toString(), Integer.parseInt(disc.toString()));
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    protected void viewCardUI(String billID, int disc) throws EASBizException, BOSException {
        FaLeaseInBillInfo leaseBillInfo;
        String uiClassName;
        if (billID == null) {
            return;
        }
        this.setCursorOfWair();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)billID);
        uiContext.put((Object)"Link", (Object)Boolean.TRUE);
        uiContext.put((Object)"COMPANY_ID", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        if (disc == 0) {
            uiClassName = FaLeaseInEditUI.class.getName();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entry.*"));
            sic.add(new SelectorItemInfo("leaseType.name"));
            sic.add(new SelectorItemInfo("subsCurrency.name"));
            sic.add(new SelectorItemInfo("hireCurrency.name"));
            sic.add(new SelectorItemInfo("settlType.name"));
            sic.add(new SelectorItemInfo("entry.assetCat.name"));
            sic.add(new SelectorItemInfo("entry.measureUnit.name"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("auditor.name"));
            sic.add(new SelectorItemInfo("leaseType.number"));
            sic.add(new SelectorItemInfo("subsCurrency.number"));
            sic.add(new SelectorItemInfo("hireCurrency.number"));
            sic.add(new SelectorItemInfo("settlType.number"));
            sic.add(new SelectorItemInfo("entry.assetCat.number"));
            sic.add(new SelectorItemInfo("entry.measureUnit.number"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("auditor.number"));
            sic.add(new SelectorItemInfo("subsCurrency.precision"));
            sic.add(new SelectorItemInfo("hireCurrency.precision"));
            sic.add(new SelectorItemInfo("entry.faCurCard.id"));
            sic.add(new SelectorItemInfo("entry.faCurCard.number"));
            sic.add(new SelectorItemInfo("entry.faCurCard.assetName"));
            sic.add(new SelectorItemInfo("entry.faCurCard.specs"));
            sic.add(new SelectorItemInfo("entry.faCurCard.assetCat.number"));
            sic.add(new SelectorItemInfo("entry.faCurCard.assetCat.name"));
            sic.add(new SelectorItemInfo("entry.faCurCard.measureUnit.name"));
            sic.add(new SelectorItemInfo("balanceEntry.id"));
            sic.add(new SelectorItemInfo("balanceEntry.seq"));
            sic.add(new SelectorItemInfo("balanceEntry.measureUnit"));
            sic.add(new SelectorItemInfo("balanceEntry.shouldPayment"));
            leaseBillInfo = FaLeaseInBillFactory.getRemoteInstance().getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(billID), sic);
            uiContext.put((Object)"InitDataObject", (Object)leaseBillInfo);
        } else {
            uiClassName = FaLeaseBillEditUI.class.getName();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.*"));
            sic.add(new SelectorItemInfo("faLeaseType.name"));
            sic.add(new SelectorItemInfo("subsCurrency.name"));
            sic.add(new SelectorItemInfo("hireCurrency.name"));
            sic.add(new SelectorItemInfo("hireBalanceType.name"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.assetCat.name"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.measureUnit.name"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("auditor.name"));
            sic.add(new SelectorItemInfo("faLeaseType.number"));
            sic.add(new SelectorItemInfo("subsCurrency.number"));
            sic.add(new SelectorItemInfo("hireCurrency.number"));
            sic.add(new SelectorItemInfo("hireBalanceType.number"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.assetCat.number"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.measureUnit.number"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("auditor.number"));
            sic.add(new SelectorItemInfo("subsCurrency.precision"));
            sic.add(new SelectorItemInfo("hireCurrency.precision"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.faBizCard.id"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.faBizCard.assetCat.name"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.faBizCard.number"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.faBizCard.assetName"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.faBizCard.specs"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.faBizCard.measureUnit.name"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.faBizCard.assetAmt"));
            sic.add(new SelectorItemInfo("balanceEntry.id"));
            sic.add(new SelectorItemInfo("balanceEntry.seq"));
            sic.add(new SelectorItemInfo("balanceEntry.measureUnit"));
            sic.add(new SelectorItemInfo("balanceEntry.shouldPayment"));
            leaseBillInfo = FaLeaseBillFactory.getRemoteInstance().getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(billID), sic);
            uiContext.put((Object)"InitDataObject", (Object)leaseBillInfo);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.setCursorOfDefault();
    }

    @Override
    public void viewBillAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        Object billID = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("billID").getValue();
        Object disc = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("disc").getValue();
        if (billID == null || billID.toString().length() == 0 || disc == null) {
            return;
        }
        try {
            this.viewCardUI(billID.toString(), Integer.parseInt(disc.toString()));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    @Override
    protected boolean isShowSorter() {
        return true;
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaRptLeaseStatusCondUI();
    }

    @Override
    protected String getQueryName() {
        return "FaRptLeaseStatusQuery";
    }

    @Override
    protected String getDaoClassName() {
        return "FaLeaseStatusDao";
    }

    @Override
    public RequestContext prepareViewBillAction(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("COMPANY", (Object)SysContext.getSysContext().getCurrentFIUnit());
            request.put("USERINFO", (Object)SysContext.getSysContext().getCurrentUserInfo());
        }
        return request;
    }

    @Override
    public boolean isPrepareViewBillAction() {
        return true;
    }
}

