/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaRptSublegerPrint
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(FaRptSublegerPrint.class);
    JdbcRowSet rowSet;
    DynamicRowSet dRowSet;
    String rptPeriod;
    String companyName;
    String header;
    String[] colNames = new String[]{"bizDate", "bizNumber", "voucherNumber", "groupNumber", "brief", "assetnumber", "assetname", "unit", "assetAmt", "currency", "FexRate", "FOriginAmt", "FAddons", "FassetValue", "valueDebit", "valueCredit", "valueBal", "deprDebit", "deprCredit", "deprBal", "netValue", "devalueDebit", "devalueCredit", "devalueBal", "netAmount", "abstract"};
    String[] title = new String[]{"companyName", "period", "header", "assetAdmin"};
    String[] amountCols = new String[]{"FOriginAmt", "FAddons", "FassetValue", "valueDebit", "valueCredit", "valueBal", "deprDebit", "deprCredit", "deprBal", "netValue", "devalueDebit", "devalueCredit", "devalueBal", "netAmount"};
    String[] normalCols = new String[]{"bizNumber", "voucherNumber", "groupNumber", "brief", "assetnumber", "assetname", "unit", "currency", "abstract"};
    BigDecimal lastValueBal;
    BigDecimal lastDeprBal;
    BigDecimal lastDevalueBal;
    int basePrecision = 2;
    Map attachData;

    public FaRptSublegerPrint(IRowSet rowSet, String rptPeriod, String companyName, String title, Map attachData) {
        this.rowSet = (JdbcRowSet)rowSet;
        this.rptPeriod = rptPeriod;
        this.companyName = companyName;
        this.header = title;
        this.attachData = attachData;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        this.dealRowSet();
        return this.dRowSet;
    }

    private void dealRowSet() {
        try {
            int i;
            this.basePrecision = FaClientUtils.getCurrencyScale();
            HashMap faParameter = FaClientUtils.getFAParameter((BOSUuid)SysContext.getSysContext().getCurrentFIUnit().getId());
            int quantityScale = Integer.valueOf(faParameter.get("FA_008") == null ? "0" : (String)faParameter.get("FA_008"));
            this.dRowSet = new DynamicRowSet(this.colNames.length + this.title.length);
            for (i = 1; i <= this.colNames.length; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.colNames[i - 1];
                ci.nullable = 1;
                this.dRowSet.setColInfo(i, ci);
            }
            i = this.colNames.length + 1;
            for (int j = 0; j < this.title.length; ++j) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.title[j];
                ci.nullable = 1;
                this.dRowSet.setColInfo(i, ci);
                ++i;
            }
            this.dRowSet.beforeFirst();
            this.rowSet.beforeFirst();
            while (!this.rowSet.isLast()) {
                this.dRowSet.moveToInsertRow();
                FaRptSublegerPrint.clearRow((IRowSet)this.dRowSet);
                this.rowSet.next();
                this.dRowSet.updateString("companyName", this.companyName);
                if (this.attachData != null && this.attachData.get("assetAdmin") != null) {
                    this.dRowSet.updateString("assetAdmin", this.attachData.get("assetAdmin").toString());
                } else {
                    this.dRowSet.updateString("assetAdmin", "");
                }
                this.dRowSet.updateString("period", this.rptPeriod);
                this.dRowSet.updateString("header", this.header);
                for (int j = 0; j < this.colNames.length; ++j) {
                    int i2;
                    for (i2 = 0; i2 < this.amountCols.length; ++i2) {
                        if (!this.colNames[j].equals(this.amountCols[i2]) || this.rowSet.getObject(this.colNames[j]) == null) continue;
                        BigDecimal amount = (BigDecimal)this.rowSet.getObject(this.colNames[j]);
                        amount = amount.setScale(this.basePrecision, 4);
                        this.dRowSet.updateString(this.colNames[j], FaRptSublegerPrint.transBigDecimalToStr(amount));
                    }
                    if ("assetAmt".equals(this.colNames[j]) && this.rowSet.getObject(this.colNames[j]) != null) {
                        BigDecimal quantity = (BigDecimal)this.rowSet.getObject(this.colNames[j]);
                        quantity = quantity.setScale(quantityScale, 4);
                        this.dRowSet.updateString(this.colNames[j], FaRptSublegerPrint.transBigDecimalToStr(quantity));
                    }
                    if ("FexRate".equals(this.colNames[j]) && this.rowSet.getObject(this.colNames[j]) != null) {
                        BigDecimal exRate = (BigDecimal)this.rowSet.getObject(this.colNames[j]);
                        exRate = exRate.setScale((int)new Integer(this.rowSet.getObject("Fcurrencypre").toString()), 4);
                        this.dRowSet.updateString(this.colNames[j], FaRptSublegerPrint.transBigDecimalToStr(exRate));
                    }
                    if ("bizDate".equals(this.colNames[j]) && this.rowSet.getObject(this.colNames[j]) != null) {
                        Date bizDate = this.rowSet.getDate(this.colNames[j]);
                        this.dRowSet.updateString(this.colNames[j], FaRptSublegerPrint.transDateToStr(bizDate));
                    }
                    for (i2 = 0; i2 < this.normalCols.length; ++i2) {
                        if (!this.colNames[j].equals(this.normalCols[i2]) && this.rowSet.getObject(this.colNames[j]) != null) continue;
                        this.dRowSet.updateString(this.colNames[j], this.rowSet.getObject(this.colNames[j]) == null ? "" : this.rowSet.getObject(this.colNames[j]).toString());
                    }
                }
                this.setAmtFields(this.rowSet, this.dRowSet);
                this.dRowSet.insertRow();
            }
            this.dRowSet.beforeFirst();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void setAmtFields(JdbcRowSet rowSet, DynamicRowSet dRowSet) throws SQLException {
        BigDecimal valueBal = new BigDecimal(-1);
        BigDecimal deprBal = new BigDecimal(-1);
        BigDecimal devalueBal = new BigDecimal(-1);
        if (!rowSet.isFirst() && rowSet.getObject("BILLID") != null) {
            BigDecimal valueDebit = (BigDecimal)rowSet.getObject("valueDebit");
            BigDecimal valueCredit = (BigDecimal)rowSet.getObject("valueCredit");
            dRowSet.updateString("valueBal", FaRptSublegerPrint.transBigDecimalToStr(this.lastValueBal.add(valueDebit).subtract(valueCredit).setScale(this.basePrecision, 4)));
            valueBal = this.lastValueBal.add(valueDebit).subtract(valueCredit);
            BigDecimal deprDebit = (BigDecimal)rowSet.getObject("deprDebit");
            BigDecimal deprCredit = (BigDecimal)rowSet.getObject("deprCredit");
            dRowSet.updateString("deprBal", FaRptSublegerPrint.transBigDecimalToStr(this.lastDeprBal.add(deprCredit).subtract(deprDebit).setScale(this.basePrecision, 4)));
            deprBal = this.lastDeprBal.add(deprCredit).subtract(deprDebit);
            BigDecimal devalueDebit = (BigDecimal)rowSet.getObject("devalueDebit");
            BigDecimal devalueCredit = (BigDecimal)rowSet.getObject("devalueCredit");
            dRowSet.updateString("devalueBal", FaRptSublegerPrint.transBigDecimalToStr(this.lastDevalueBal.add(devalueCredit).subtract(devalueDebit).setScale(this.basePrecision, 4)));
            devalueBal = this.lastDevalueBal.add(devalueCredit).subtract(devalueDebit);
        }
        valueBal = new BigDecimal(-1).compareTo(valueBal) == 0 ? (BigDecimal)rowSet.getObject("valueBal") : valueBal;
        deprBal = new BigDecimal(-1).compareTo(deprBal) == 0 ? (BigDecimal)rowSet.getObject("deprBal") : deprBal;
        devalueBal = new BigDecimal(-1).compareTo(devalueBal) == 0 ? (BigDecimal)rowSet.getObject("devalueBal") : devalueBal;
        this.lastValueBal = valueBal;
        this.lastDeprBal = deprBal;
        this.lastDevalueBal = devalueBal;
        dRowSet.updateString("netValue", FaRptSublegerPrint.transBigDecimalToStr(valueBal.subtract(deprBal).setScale(this.basePrecision, 4)));
        dRowSet.updateString("netAmount", FaRptSublegerPrint.transBigDecimalToStr(valueBal.subtract(deprBal).subtract(devalueBal).setScale(this.basePrecision, 4)));
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private static String transBigDecimalToStr(BigDecimal val) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        int scale = val.scale();
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }

    private static String transDateToStr(java.util.Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)CtrlFormatUtilities.getDateFormat();
        return dateFormat.format(date);
    }
}

