/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaSubLedgerCond;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FaSubLedgerCond
extends AbstractFaSubLedgerCond {
    private static final long serialVersionUID = 5687604529578589631L;
    protected static final String END_NUMBER = "endNumber";
    protected static final String END_YEAR = "endYear";
    protected static final String START_NUMBER = "startNumber";
    protected static final String START_YEAR = "startYear";
    private static final String IS_SHOW_NOT_AUDIT = "isShowNotAudit";
    private static final String IS_BY_EVALUE = "isByEvalue";
    private static final String PERIOD_TYPE = "periodType";
    private static final String ACCOUNT_TABLE = "accountTable";
    private static final String COMPANY = "company";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String ID = "id";
    private CompanyTreeSelectUI ctsUI;
    private JDialog dialog;
    private static final String BOOKSCHEME = "bookScheme";
    private static final String DEFCOMPANYLEVEL = "defCompanyLevel";
    private boolean isLoadData = false;
    Map periodsMap;
    PeriodInfo startPeriodInfo;
    PeriodInfo currentPeriodInfo;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;
    private static final String IS_GROUP_BY_DEP = "isGroupByDep";
    private static final String IS_GROUP_BY_ASSETTYPE = "isGroupByAssetType";
    protected static final String IS_BY_CARD = "isGroupByCard";
    protected static final String IS_SHOW_NOINCURREDAMT_CARD = "isShowNoIncurredAmtCard";

    public FaSubLedgerCond() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.spnStartYear.setEnabled(false);
            this.spnStartMonth.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndMonth.setEnabled(false);
            this.lblDefLevel.setVisible(true);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            evi.setFilter(filterInfo);
            this.prmtAccountTable.setEntityViewInfo(evi);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
            this.chkIsByEvalue.setEnabled(false);
            this.chkIsGroupbyAssetType.setEnabled(false);
        } else {
            this.prmtAccountTable.setEnabled(false);
            this.prmtPeriodType.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
            this.lblDefLevel.setVisible(false);
        }
        SpinnerNumberModel tmpModel = new SpinnerNumberModel(0, 0, 100, 1);
        this.spnDefLevel.setModel((SpinnerModel)tmpModel);
        this.prmtCompany.setEnabled(false);
    }

    @Override
    protected void setDefaultData() {
        this.prmtAccountTable.setData((Object)this.currCompany.getAccountTable());
        this.prmtPeriodType.setData((Object)this.currCompany.getAccountPeriodType());
        this.spnDefLevel.setValue((Object)new Integer(1));
        if (this.isVirCompany) {
            this.chkIsGroupByCard.setEnabled(false);
            this.chkIsShowNoIncurredAmt.setVisible(false);
        } else {
            this.chkIsGroupByCard.setEnabled(true);
        }
        if (!this.isVirCompany) {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            try {
                this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
                this.startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
                Integer minYear = new Integer(this.startPeriodInfo.getPeriodYear());
                Integer maxYear = new Integer(this.currentPeriodInfo.getPeriodYear());
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                startYearSpinnerNumberModel.setMinimum(minYear);
                startYearSpinnerNumberModel.setMaximum(maxYear);
                this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                endYearSpinnerNumberModel.setMinimum(minYear);
                endYearSpinnerNumberModel.setMaximum(maxYear);
                this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
                Integer defaultYear = new Integer(this.currentPeriodInfo.getPeriodYear());
                Integer defaultNumber = new Integer(this.currentPeriodInfo.getPeriodNumber());
                this.spnStartYear.setValue((Object)defaultYear);
                this.spnEndYear.setValue((Object)defaultYear);
                this.spnStartMonth.setValue((Object)defaultNumber);
                this.spnEndMonth.setValue((Object)defaultNumber);
                this.chkIsGroupByCard.setSelected(false);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            if (this.chkIsGroupByCard.isSelected()) {
                this.chkIsShowNoIncurredAmt.setVisible(true);
            } else {
                this.chkIsShowNoIncurredAmt.setVisible(false);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkIsGroupByCard.setEnabled(true);
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = new CustomerParams();
        params.putInt(START_YEAR, this.spnStartYear.getIntegerVlaue().intValue());
        params.putInt(START_NUMBER, this.spnStartMonth.getIntegerVlaue().intValue());
        params.putInt(DEFCOMPANYLEVEL, this.spnDefLevel.getIntegerVlaue() == 0 ? 101 : this.spnDefLevel.getIntegerVlaue());
        params.putInt(END_YEAR, this.spnEndYear.getIntegerVlaue().intValue());
        params.putInt(END_NUMBER, this.spnEndMonth.getIntegerVlaue().intValue());
        params.putBoolean(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        params.putBoolean(IS_BY_EVALUE, this.chkIsByEvalue.isSelected());
        params.putBoolean(IS_GROUP_BY_ASSETTYPE, this.chkIsGroupbyAssetType.isSelected());
        params.putBoolean(IS_GROUP_BY_DEP, this.chkIsGrouprByDep.isSelected());
        params.putBoolean(IS_BY_CARD, this.chkIsGroupByCard.isSelected());
        params.putBoolean(IS_SHOW_NOINCURREDAMT_CARD, this.chkIsShowNoIncurredAmt.isSelected());
        if (this.isVirCompany) {
            AccountTableInfo accountTable = (AccountTableInfo)this.prmtAccountTable.getData();
            CustomerParams custAcountTable = new CustomerParams();
            custAcountTable.addCustomerParam(ID, accountTable.getId().toString());
            custAcountTable.addCustomerParam(NAME, accountTable.getName());
            custAcountTable.addCustomerParam(NUMBER, accountTable.getNumber());
            params.putMe(ACCOUNT_TABLE, custAcountTable);
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.prmtPeriodType.getData();
            CustomerParams custPeriodType = new CustomerParams();
            custPeriodType.addCustomerParam(ID, periodType.getId().toString());
            custPeriodType.addCustomerParam(NAME, periodType.getName());
            custPeriodType.addCustomerParam(NUMBER, periodType.getNumber());
            params.putMe(PERIOD_TYPE, custPeriodType);
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
            if (this.getSchemeInfo() != null) {
                CustomerParams custBookScheme = new CustomerParams();
                custBookScheme.addCustomerParam(ID, this.getSchemeInfo().getId().toString());
                custBookScheme.addCustomerParam(NAME, this.getSchemeInfo().getName());
                custBookScheme.addCustomerParam(NUMBER, this.getSchemeInfo().getNumber());
                params.putMe(BOOKSCHEME, custBookScheme);
            }
        }
        return params;
    }

    @Override
    protected Map getCustomCond() {
        HashMap<String, Object> customCond = new HashMap<String, Object>();
        customCond.put(START_YEAR, this.spnStartYear.getValue());
        customCond.put(START_NUMBER, this.spnStartMonth.getValue());
        customCond.put(DEFCOMPANYLEVEL, (Integer)this.spnDefLevel.getValue() == 0 ? new Integer(101) : this.spnDefLevel.getValue());
        customCond.put(END_YEAR, this.spnEndYear.getValue());
        customCond.put(END_NUMBER, this.spnEndMonth.getValue());
        customCond.put(IS_SHOW_NOT_AUDIT, this.chkIsShowNotAudit.isSelected());
        customCond.put(IS_BY_EVALUE, this.chkIsByEvalue.isSelected());
        customCond.put(IS_GROUP_BY_DEP, this.chkIsGrouprByDep.isSelected());
        customCond.put(IS_GROUP_BY_ASSETTYPE, this.chkIsGroupbyAssetType.isSelected());
        customCond.put(IS_BY_EVALUE, this.chkIsByEvalue.isSelected());
        customCond.put(IS_BY_CARD, this.chkIsGroupByCard.isSelected());
        customCond.put(IS_SHOW_NOINCURREDAMT_CARD, this.chkIsShowNoIncurredAmt.isSelected());
        if (this.isVirCompany) {
            customCond.put(ACCOUNT_TABLE, this.prmtAccountTable.getData());
            customCond.put(PERIOD_TYPE, this.prmtPeriodType.getData());
            customCond.put(COMPANY, this.prmtCompany.getData());
            customCond.put(BOOKSCHEME, this.getSchemeInfo());
        }
        return customCond;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.isLoadData = true;
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe(ACCOUNT_TABLE);
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam(ID)));
                accountTable.setName(custAcountTable.getCustomerParam(NAME));
                accountTable.setNumber(custAcountTable.getCustomerParam(NUMBER));
                this.prmtAccountTable.setData((Object)accountTable);
                CustomerParams custPeriodType = cond.getMe(PERIOD_TYPE);
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam(ID)));
                periodType.setName(custPeriodType.getCustomerParam(NAME));
                periodType.setNumber(custPeriodType.getCustomerParam(NUMBER));
                this.prmtPeriodType.setData((Object)periodType);
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
                this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
                this.chkIsGroupByCard.setEnabled(false);
                this.chkIsShowNoIncurredAmt.setSelected(false);
                this.chkIsShowNoIncurredAmt.setVisible(false);
            }
            this.spnStartYear.setValue((Object)new Integer(cond.getInt(START_YEAR)));
            this.spnStartMonth.setValue((Object)new Integer(cond.getInt(START_NUMBER)));
            this.spnDefLevel.setValue((Object)new Integer(cond.getInt(DEFCOMPANYLEVEL) == 101 ? 0 : cond.getInt(DEFCOMPANYLEVEL)));
            this.spnEndYear.setValue((Object)new Integer(cond.getInt(END_YEAR)));
            this.spnEndMonth.setValue((Object)new Integer(cond.getInt(END_NUMBER)));
            this.chkIsShowNotAudit.setSelected(cond.getBoolean(IS_SHOW_NOT_AUDIT));
            this.chkIsByEvalue.setSelected(cond.getBoolean(IS_BY_EVALUE));
            this.chkIsGroupbyAssetType.setSelected(cond.getBoolean(IS_GROUP_BY_ASSETTYPE));
            this.chkIsGrouprByDep.setSelected(cond.getBoolean(IS_GROUP_BY_DEP));
            this.chkIsGroupByCard.setSelected(cond.getBoolean(IS_BY_CARD));
            if (this.chkIsGroupByCard.isSelected()) {
                this.chkIsShowNoIncurredAmt.setVisible(true);
                this.chkIsShowNoIncurredAmt.setSelected(cond.getBoolean(IS_SHOW_NOINCURREDAMT_CARD));
            } else {
                this.chkIsShowNoIncurredAmt.setVisible(false);
            }
        }
        this.isLoadData = false;
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        String accountTableID = ((AccountTableInfo)this.prmtAccountTable.getData()).getId().toString();
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        this.ctsUI = new CompanyTreeSelectUI(this, accountTableID, periodTypeID);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaSubLedgerCond.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    @Override
    public boolean verify() {
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        int startYear = (Integer)this.spnStartYear.getValue();
        int endYear = (Integer)this.spnEndYear.getValue();
        int startMonth = (Integer)this.spnStartMonth.getValue();
        int endMonth = (Integer)this.spnEndMonth.getValue();
        if (startYear > endYear || startYear == endYear && startMonth > endMonth) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.startPeriodNotGreatThanEnd"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected void addListener() {
        this.spnStartYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSubLedgerCond.this.fireStartYearChange();
                FaSubLedgerCond.this.firePeriodChange(e);
            }
        });
        this.spnEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSubLedgerCond.this.fireEndYearChange();
                FaSubLedgerCond.this.firePeriodChange(e);
            }
        });
        this.spnStartMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSubLedgerCond.this.firePeriodChange(e);
            }
        });
        this.spnEndMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaSubLedgerCond.this.firePeriodChange(e);
            }
        });
        this.prmtAccountTable.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaSubLedgerCond.this.ctsUI = null;
                    FaSubLedgerCond.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtPeriodType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || !eventObj.getNewValue().equals(eventObj.getOldValue())) {
                    FaSubLedgerCond.this.ctsUI = null;
                    FaSubLedgerCond.this.prmtCompany.setData(null);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaSubLedgerCond.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    protected void companyChanged(Object data) {
        if (data == null) {
            this.spnStartYear.setEnabled(false);
            this.spnStartMonth.setEnabled(false);
            this.spnEndYear.setEnabled(false);
            this.spnEndMonth.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.spnStartYear.setModel((SpinnerModel)tmpModel);
            this.spnStartMonth.setModel((SpinnerModel)tmpModel);
            this.spnEndYear.setModel((SpinnerModel)tmpModel);
            this.spnEndMonth.setModel((SpinnerModel)tmpModel);
        } else {
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.spnStartYear.setEnabled(true);
                this.spnStartMonth.setEnabled(true);
                this.spnEndYear.setEnabled(true);
                this.spnEndMonth.setEnabled(true);
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
                Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel startPeriodSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endPeriodSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodStartNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPerioEndNumber = (Integer)periodYears.get("MaxPeriodNumber");
                startYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                startYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnStartYear.setModel((SpinnerModel)startYearSpinnerNumberModel);
                endYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                endYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.spnEndYear.setModel((SpinnerModel)endYearSpinnerNumberModel);
                this.spnStartYear.setValue(periodYears.get("MaxPeriodYear"));
                this.spnEndYear.setValue(periodYears.get("MaxPeriodYear"));
                Map periodNumOfYear = FaListFactory.getRemoteInstance().findMinMaxPeriodsOfYear(this.maxPeriodYear, periodTypeID);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    startPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    startPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                startPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnStartMonth.setModel((SpinnerModel)startPeriodSpinnerNumberModel);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    endPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    endPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                endPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.spnEndMonth.setModel((SpinnerModel)endPeriodSpinnerNumberModel);
                this.spnStartMonth.setValue(periodYears.get("MaxPeriodNumber"));
                this.spnEndMonth.setValue(periodYears.get("MaxPeriodNumber"));
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    private void fireStartYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnStartYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear == null) {
                this.minPeriodYear = this.spnStartYear.getIntegerVlaue();
            }
            if (this.maxPeriodYear == null) {
                this.maxPeriodYear = this.spnStartYear.getIntegerVlaue();
            }
            if (periodYear == this.minPeriodYear) {
                Integer n = minPeriod = this.minPeriodStartNumber == null ? new Integer(0) : this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber == null ? new Integer(0) : this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnStartMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnStartMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.spnStartYear.getIntegerVlaue() * 100 + this.spnStartMonth.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.spnEndYear.getIntegerVlaue() * 100 + this.spnEndMonth.getIntegerVlaue())) {
            if (e.getSource() == this.spnStartYear || e.getSource() == this.spnStartMonth) {
                this.spnEndYear.setValue(this.spnStartYear.getValue());
                this.spnEndMonth.setValue(this.spnStartMonth.getValue());
            } else if (!this.isLoadData) {
                this.spnStartYear.setValue(this.spnEndYear.getValue());
                this.spnStartMonth.setValue(this.spnEndMonth.getValue());
            }
        }
    }

    private void fireEndYearChange() {
        String periodTypeID = ((PeriodTypeInfo)this.prmtPeriodType.getData()).getId().toString();
        int periodYear = this.spnEndYear.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear == null) {
                this.minPeriodYear = this.spnStartYear.getIntegerVlaue();
            }
            if (this.maxPeriodYear == null) {
                this.maxPeriodYear = this.spnStartYear.getIntegerVlaue();
            }
            if (periodYear == this.minPeriodYear) {
                Integer n = minPeriod = this.minPeriodStartNumber == null ? new Integer(0) : this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber == null ? new Integer(0) : this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.spnEndMonth.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.spnEndMonth.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.spnStartYear.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodYear()));
            this.spnEndYear.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodYear()));
            this.spnStartMonth.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodNumber()));
            this.spnEndMonth.setValue((Object)new Integer(this.currentPeriodInfo.getPeriodNumber()));
        }
        this.chkIsShowNotAudit.setSelected(false);
        this.chkIsByEvalue.setSelected(false);
        this.chkIsGroupByCard.setSelected(false);
        this.chkIsGrouprByDep.setSelected(false);
        this.chkIsGroupbyAssetType.setSelected(false);
        this.chkIsShowNoIncurredAmt.setSelected(false);
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAccountTable.getData() == null || this.prmtPeriodType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"condBeforeSelectCompany"));
            return;
        }
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    @Override
    public void actionCardSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionCardSelected_actionPerformed(e);
        if (this.chkIsGroupByCard.isSelected()) {
            this.chkIsGrouprByDep.setSelected(false);
            this.chkIsGroupbyAssetType.setSelected(false);
            this.chkIsShowNoIncurredAmt.setVisible(true);
            this.chkIsShowNoIncurredAmt.setSelected(false);
        } else {
            this.chkIsShowNoIncurredAmt.setVisible(false);
            this.chkIsShowNoIncurredAmt.setSelected(false);
        }
    }

    @Override
    public void actionAssetSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssetSelected_actionPerformed(e);
        if (this.chkIsGroupbyAssetType.isSelected()) {
            this.chkIsGrouprByDep.setSelected(false);
            this.chkIsGroupByCard.setSelected(false);
            this.chkIsShowNoIncurredAmt.setVisible(false);
            this.chkIsShowNoIncurredAmt.setSelected(false);
        }
    }

    @Override
    public void actionDepSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionDepSelected_actionPerformed(e);
        if (this.chkIsGrouprByDep.isSelected()) {
            this.chkIsGroupbyAssetType.setSelected(false);
            this.chkIsGroupByCard.setSelected(false);
            this.chkIsShowNoIncurredAmt.setVisible(false);
            this.chkIsShowNoIncurredAmt.setSelected(false);
        }
    }
}

